/** @file
  Tcss Initialization Fru Library for TcssInitLib.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification
**/

#include <Library/DebugLib.h>
#include <Library/BaseLib.h>
#include <Library/CpuPlatformLib.h>
#include <Register/IomRegs.h>

/**
  This function execute override IomTypeC Configure 1 register setting.

  @param[in]       IomTypecConfigValue    IOM_TYPEC_SW_CONFIGURATION_1 register setting

  @retval          UIBT32                 IOM_TYPEC_SW_CONFIGURATION_1 override setting
**/
UINT32
TcssIomConfig1RegOverride (
  IN  UINT32                    IomTypecConfigValue
  )
{
  //
  // Allow IOM to shut down the PHY completely on S3/S4 entry and rely on PCH replaying the connections.
  //
  if ((GetCpuStepping () < EnumTglB0) && (GetCpuGeneration () == EnumTglCpu)) {
    //
    // Read IOM_TYPEC_SW_CONFIGURATION_1
    //
    IomTypecConfigValue |= BIOS_EC_REPLAY_CONNECTION_S4S5 | BIOS_EC_REPLAY_CONNECTION_S3;
  }
  return IomTypecConfigValue;
}

/**
  This function execute override PMC replay setting.

  @param[in]       PmcReplay    PmcReplay setting

  @retval          UINT8        PmcReplay override setting
**/
UINT8
TcssPmcReplayOverride (
  IN  UINT8                    PmcReplay
  )
{
  //
  // Allow IOM to shut down the PHY completely on S3/S4 entry and rely on PCH replaying the connections.
  //
  if ((GetCpuStepping () < EnumTglB0) && (GetCpuGeneration () == EnumTglCpu)) {
    //
    // Read IOM_TYPEC_SW_CONFIGURATION_1
    //
    PmcReplay |= 0x01;
  }
  return PmcReplay;
}

/**
  Return Number of DP-In Cpu Port Available.

  @retval DP-In Port Count if supported or 0 if not supported
**/
UINT8
GetDpInCpuPortCount (
  VOID
  )
{
  CPU_FAMILY                         CpuFamilyId;
  UINT8                              DpInPortCount;

  CpuFamilyId        = GetCpuFamily ();

  //
  // Initialize DpInPortCount based on CPU Family.
  //
  switch (CpuFamilyId) {
    case EnumCpuTglDtHalo:  // TGL-H CPU Family Id.
      DpInPortCount = 4; // Maximun External Gfx DpIn Port supported by CPU
      break;

    default:
      DpInPortCount = 0; // Maximun External Gfx DpIn Port supported by CPU
      break;
  }

  return DpInPortCount;
}
