/** @file
  DXE Flu Library to initialize Vtd

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include <Base.h>
#include <Library/UefiLib.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/DebugLib.h>
#include <Protocol/SaNvsArea.h>
#include <Library/DxeSaPolicyLib.h>
#include <Library/CpuPlatformLib.h>
#include <Library/HobLib.h>
#include <Library/VtdInitFruLib.h>
#include <TcssDataHob.h>

/**
  For device that specified by Device Num and Function Num,
  mDevEnMap is used to check device presence.
  0x80 means use Device ID to detemine presence
  0x8F means force to update

  The structure is used to check if device scope is valid when update DMAR table
**/
UINT16  mDevEnMap[][2] = {{0x0200, 0x80}, {0x0500, 0x80}, {0x1400, 0x80}, {0x1401, 0x80}, {0x0700, 0x80}, {0x0701, 0x80}, {0x0702, 0x80}, {0x0703, 0x80}, {0x1302, 0x8F}, {0x1303, 0x8F}};
UINTN   mDevEnMapSize = sizeof (mDevEnMap) / (sizeof (UINT16) * 2);

/**
  Update Silicon TCSS NVS variables
**/
VOID
UpdateSiTcssNvs (
  VOID
  )
{
  EFI_STATUS  Status;
  EFI_PHYSICAL_ADDRESS  MemAddress;
  UINTN                 MemPages;
  UINTN                 TcssDmaCount;
  UINTN                 Index;
  TCSS_DATA_HOB         *TcssHob;
  CPU_FAMILY            CpuFamily;
  CPU_STEPPING          CpuSteppingId;
  SYSTEM_AGENT_NVS_AREA_PROTOCOL   *SaNvsAreaProtocol;

  Status = gBS->LocateProtocol (&gSaNvsAreaProtocolGuid, NULL, (VOID **) &SaNvsAreaProtocol);
  if (Status != EFI_SUCCESS) {
    DEBUG ((DEBUG_ERROR, "SA NVS protocol is not found in UpdateSiTcssNvs!\n"));
    return;
  }

  SaNvsAreaProtocol->Area->TcssDma0RmrrAddr = 0;
  SaNvsAreaProtocol->Area->TcssDma1RmrrAddr = 0;

  ///
  /// Locate HOB for TCSS Data
  ///
  TcssHob = (TCSS_DATA_HOB *) GetFirstGuidHob (&gTcssHobGuid);
  if (TcssHob == NULL) {
    DEBUG ((DEBUG_ERROR, "SA TSCC Data HOB not found\n"));
    return;
  }

  CpuFamily     = GetCpuFamily ();
  CpuSteppingId = GetCpuStepping ();

  if ((CpuFamily != EnumCpuTglUltUlx) && (CpuFamily != EnumCpuTglDtHalo)) {
    return;
  }

  for (TcssDmaCount = 0, Index = 0; Index < MAX_HOST_ITBT_DMA_NUMBER; Index++) {
    if (TcssHob->TcssData.ItbtDmaEn[Index] == 0) {
      break;
    }
    TcssDmaCount++;
  }

  if (TcssDmaCount == 0) {
    return;
  }

  MemPages    = EFI_SIZE_TO_PAGES (RMRR_TCSS_DMA_SIZE);
  MemAddress  = MAX_UINT32;

  Status = (gBS->AllocatePages) (
                    AllocateMaxAddress,
                    EfiReservedMemoryType,
                    MemPages * TcssDmaCount,
                    &MemAddress
                  );
  ASSERT_EFI_ERROR (Status);

  DEBUG ((DEBUG_INFO, "TcssDmaCount = %d\n", TcssDmaCount));

  SaNvsAreaProtocol->Area->TcssDma0RmrrAddr = (UINT32) MemAddress;
  if (TcssDmaCount > 1) {
    SaNvsAreaProtocol->Area->TcssDma1RmrrAddr = (UINT32) (MemAddress + EFI_PAGES_TO_SIZE (MemPages));
  }

  DEBUG ((DEBUG_INFO, "TcssDma0RmrrAddr = %08X\n", SaNvsAreaProtocol->Area->TcssDma0RmrrAddr));
  DEBUG ((DEBUG_INFO, "TcssDma1RmrrAddr = %08X\n", SaNvsAreaProtocol->Area->TcssDma1RmrrAddr));
}
