/** @file
  Header file for FIA Mux Policy.

@copyright
 INTEL CONFIDENTIAL

 Copyright (c) 2018 - 2020 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _FIA_MUX_POLICY_H_
#define _FIA_MUX_POLICY_H_

#include <Library/MeFiaMuxLib.h>

/**
  Sets pointer in ME_FIA_CONFIG to buffer relative to FiaMuxConfig parameter

  @param [in] FiaMuxConfig   pointer to ME_FIA_CONFIG

  @retval EFI_INVALID_PARAMETER  Passed pointer is not valid
  @retval EFI_SUCCESS            Pointer has been set
**/
typedef
EFI_STATUS
(EFIAPI *FIA_MUX_SET_BUFFER_POINTERS) (
  IN ME_FIA_CONFIG     *FiaMuxConfig
  );

#pragma pack(1)

// Global FIA MUX configure structure
typedef struct {
  UINT8                         FiaMuxOverrideRequired;
  FIA_MUX_SET_BUFFER_POINTERS   SetFiaMuxBufferPointers;
  ME_FIA_CONFIG                 FiaMuxConfig;     // FIA MUX override configuration
} FIA_MUX_GLOBAL_POLICY;

#pragma pack()

#endif // _FIA_MUX_POLICY_H_
