/** @file
  Header file for Fusa Private Lib Internal functions.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _FUSA_E2E_CTC_LIB_INTERNAL_H_
#define _FUSA_E2E_CTC_LIB_INTERNAL_H_

#include "PeiFusaResultReportingLib.h"

/**
  Perform Core IDI Parity Error E2E CTC.
  The test targets all active unique core. For core not
  detected, their test result is updated to
  FUSA_TEST_DEVICE_NOTAVAILABLE

  @note The test expects to be run within  Memory Type =
        Writeback (MTRR Encoding = 06h), which is the usual
        case of the memory type covering the code/data region
        of the bootloader.

  @param[out] pFusaTestResult - pointer to test result
                         buffer for test from FusaTestNumCpu0Idi
                         to FusaTestNumCpu7Idi

**/
VOID
FspDxCheckCoreIdi (
  OUT FUSA_TEST_RESULT *pFusaTestResult
  );

/**
  Perform LLC ECC Error E2E CTC.
  The test targets all active unique CBO (which in turn maps to
  unique core). For CBO/core not detected, their test result is
  updated to FUSA_TEST_DEVICE_NOTAVAILABLE

  @note The test expects to be run within Memory Type =
        Writeback (MTRR Encoding = 06h), which is the usual
        case of the memory type covering the code/data region
        of the bootloader.

  @param[out] pFusaTestResult - pointer to test result
                         buffer for test from
                         FusaTestNumCboSlice0Ingress to
                         FusaTestNumCboSlice7Ingress

**/
VOID
FspDxCheckLlc (
  OUT FUSA_TEST_RESULT *pFusaTestResult
  );

/**
  Perform OPI Link Data Parity Error E2E CTC.
  The test targets OPI Link Data path.

  @note The test assumes MchBar and DmiBar have been set up
        with 32 bit addressing and being enabled.

  @param[out] pFusaTestResult - pointer to test result
                         buffer for test
                         FusaTestNumOpiLinkIosfData

**/
VOID
FspDxCheckOpiLink (
  OUT FUSA_TEST_RESULT *pFusaTestResult
  );

/**
  Perform IO Port Parity Error E2E CTC.
  The test targets IO Port multiple interfaces.

  @note The test assumes MchBar, GmBar and HpetBase have been
        set up with 32 bit addressing and being enabled.

  @param[out] pFusaTestResult - pointer to test result
                         buffer for test FusaTestNumIop

**/
VOID
FspDxCheckIoPort (
  OUT FUSA_TEST_RESULT *pFusaTestResult
  );

/**
  Perform Display Isoch Port (DIP) Parity Error E2E CTC. The
  test targets DIP multiple interfaces.

  @note The test assumes MchBar and GttMmBar have been set up
        with 32 bit addressing and being enabled.

  @param[out] pFusaTestResult - pointer to test result
                         buffer for test FusaTestNumDip

**/
VOID
FspDxCheckDip (
  OUT FUSA_TEST_RESULT *pFusaTestResult
  );

/**
  Perform MBIST Test on CPU array

  @param[out] pFusaTestResult - pointer to test result
                         buffer for test from
                         FusaTestNumCpu0Mbist to
                         FusaTestNumCpu7Mbist
  @param[in] PeiServices    Pointer to PEI Services Table
**/
VOID
FspDxCheckCoreArrayMbist (
  OUT FUSA_TEST_RESULT *pFusaTestResult,
  IN  CONST EFI_PEI_SERVICES  **PeiServices
  );

/**
  Extract Memory SubSystem MBIST result which resided within
  registers, where the MBIST has been performed within the MRC
  stage and yet for some reason not able to populate the result
  HOB at the point of time.

  @note The test assumes MchBar has been set up with 32 bit
        addressing and being enabled.

  @param[out] pFusaTestResult - pointer to test result
                         buffer for test from
                         FusaTestNumMc0Mbist to
                         FusaTestNumIbecc1Mbist
**/
VOID
FspDxCheckMemoryMbist (
  OUT FUSA_TEST_RESULT *pFusaTestResult
  );

#define MAX_TGL_CORE_COUNT 8

/**
  To retrieve  mUniqueCoreList

  @retval mUniqueCoreList
**/
CONST UINT32 *
UniqueCoreListGet (
  VOID
  );

/**
  The function prototype for invoking a function on an Application Processor.

  @param[in,out] Buffer  The pointer to private data buffer.
**/
typedef
VOID
(*AP_PROCEDURE)(
  IN OUT VOID  *Buffer
  );

/**
  To execute routine "Routine" with paramters "Param" at AP
  indicated by ProcessorNumber, in blocking mode.

  @param[in] Routine - routine to be executed
  @param[in] ProcessorNumber - target AP processor number
                         enumerated by the MP services
  @param[in] Param - parameters to be used by the said routine

**/
VOID
RunAtAp (
  IN AP_PROCEDURE Routine,
  IN UINT32       ProcessorNumber,
  IN VOID         *Param
  );

#endif // _FUSA_E2E_CTC_LIB_INTERNAL_H_
