/** @file
  ME BIOS Payload Data implementation.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include <PiPei.h>
#include <PchHsio.h>
#include <MeBiosPayloadHob.h>
#include <Ppi/SiPolicy.h>
#include <Library/PeiServicesLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/PeiMeLib.h>
#include <Library/PreSiliconEnvDetectLib.h>
#include <Library/DebugLib.h>
#include <Library/MeTypeLib.h>
#include <Library/MeUefiFwHealthStatusLib.h>


/**
  Prepare MbpData Hob for SPS.

  @param[in] MbpHob             Pointer to Mbp Hob
  @param[in] MbpSensitivePpi    Pointer to Mbp Sensitive Ppi

  @retval    EFI_SUCCESS        The function completed successfully.
  @retval    EFI_UNSUPPORTED    MBP Hob creation skipped
  @retval    Other              Failed to create MBP Hob
**/
EFI_STATUS
PrepareSpsMeBiosPayload (
  IN ME_BIOS_PAYLOAD                     *MbpData,
  IN ME_BIOS_PAYLOAD_SENSITIVE           *MbpSensitiveData
  )
{
  EFI_STATUS                          Status;

  Status = EFI_SUCCESS;

  if (!MeTypeIsClient ()) {
    PCH_HSIO_VER_INFO       *CsmeChipsetInitVerInfoPtr;

    DEBUG ((DEBUG_INFO, "[SPS] Create MBP HOB for non WS firmware\n"));
    if (MbpData == NULL) {
      ASSERT_EFI_ERROR (EFI_INVALID_PARAMETER);
      return EFI_INVALID_PARAMETER;
    }
    if (MbpSensitiveData != NULL) {
      ZeroMem (MbpSensitiveData, sizeof (ME_BIOS_PAYLOAD_SENSITIVE));
    }
    ZeroMem (MbpData, sizeof (ME_BIOS_PAYLOAD));

    DEBUG ((DEBUG_INFO, "[SPS] Read ChipsetInit Binary from CSME\n"));
    CsmeChipsetInitVerInfoPtr = (PCH_HSIO_VER_INFO *)MbpData->MphyData.ChipsetInitVer;
    if (IsSimicsEnvironment ()) {
      SI_PREMEM_POLICY_PPI    *SiPreMemPolicyPpi;
      PCH_HSIO_PREMEM_CONFIG  *HsioPreMemConfig;

      Status = PeiServicesLocatePpi (
          &gSiPreMemPolicyPpiGuid,
          0,
          NULL,
          (VOID **) &SiPreMemPolicyPpi
          );
      ASSERT_EFI_ERROR (Status);
      if (!EFI_ERROR (Status)) {
        Status = GetConfigBlock ((VOID *) SiPreMemPolicyPpi, &gHsioPreMemConfigGuid, (VOID *) &HsioPreMemConfig);
        ASSERT_EFI_ERROR (Status);
      }
      if (!EFI_ERROR (Status) && (HsioPreMemConfig->ChipsetInitMessage == 0)) {
        DEBUG ((DEBUG_INFO, "[SPS] For SIMICS use debug mode.\n"));
        CsmeChipsetInitVerInfoPtr->DebugMode = 1;
      }
    }
    if (CsmeChipsetInitVerInfoPtr->DebugMode == 0) {
      PCH_HSIO_VER_INFO  *ChipsetInitTblPtr;
      UINT32             ChipsetInitTblLen;

      ChipsetInitTblLen = sizeof (PCH_HSIO_VER_INFO);
      ChipsetInitTblPtr = (PCH_HSIO_VER_INFO *) AllocateZeroPool (ChipsetInitTblLen *2);
      ASSERT (ChipsetInitTblPtr != NULL);
      if (ChipsetInitTblPtr != NULL) {
        Status = PeiHeciReadChipsetInitMsg ((UINT8 *)ChipsetInitTblPtr, &ChipsetInitTblLen);
        if (!EFI_ERROR (Status)) {
          CsmeChipsetInitVerInfoPtr->BaseCrc = ChipsetInitTblPtr->BaseCrc;
          CsmeChipsetInitVerInfoPtr->OemCrc = ChipsetInitTblPtr->OemCrc;
          CsmeChipsetInitVerInfoPtr->BaseCrcValid = ChipsetInitTblPtr->BaseCrcValid;
          CsmeChipsetInitVerInfoPtr->OemCrcValid = ChipsetInitTblPtr->OemCrcValid;
        } else {
          DEBUG ((DEBUG_WARN, "[SPS] WARNING: Can't read HSIO,"\
                "skip HSIO handshake as don't have version information\n"));
          CsmeChipsetInitVerInfoPtr->DebugMode = 1;
        }
        FreePool (ChipsetInitTblPtr);
      }
    }
  }

  return Status;
}

/**
  Function sets value of determined field in MeUefiFwHealthStatus HOB.

  @param[in] Status                Mbp Uefi Status, EFI_SUCCESS, or any error

  @retval    EFI_SUCCESS           The function completed successfully.
  @retval    EFI_OUT_OF_RESOURCES  HOB creation failed
**/
EFI_STATUS
ReportMeUefiFwMbpHealthStatus (
  IN EFI_STATUS   Status
  )
{
  ME_UEFI_FW_HEALTH_STATUS FwHealthStatus;

  if (EFI_ERROR (Status)) {
    FwHealthStatus = StatusError;
  } else {
    FwHealthStatus = StatusOk;
  }

  return SetMeUefiFwHealthStatus (BiosPayloadForWsReceivingStatus, FwHealthStatus);

}
