/** @file
  Implementation of the memory controller hardware abstraction layer.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2013 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
//
// Include files
//
#include "McAddress.h"
#include "MrcMcRegisterMacro.h"
#include "MrcInterface.h"
#include "MrcCommon.h"
#include "MrcReadReceiveEnable.h"

/**
  Program MCHBAR_CHx_CR_SC_IO_LATENCY register using Host data.

  @param[in] MrcData  - Include all MRC global data.
  @param[in] Channel  - Channel to work on.
**/
void
MrcHalSetIoLatency (
  IN MrcParameters *const MrcData,
  IN const UINT32         Channel
  )
{
  const MrcChannelOut                 *ChannelOut;
  const UINT8                         *IoLatency;
  MCHBAR_CH0_CR_SC_IO_LATENCY_STRUCT  ScIoLatency;
  UINT32                              Offset;

  ChannelOut = &MrcData->Outputs.Controller[0].Channel[Channel];
  IoLatency = ChannelOut->IoLatency;

  ScIoLatency.Data = 0;
  ScIoLatency.Bits.Rank_0_flyby = MIN (IoLatency[0], MCHBAR_CH0_CR_SC_IO_LATENCY_Rank_0_flyby_MAX);
  ScIoLatency.Bits.Rank_1_flyby = MIN (IoLatency[1], MCHBAR_CH0_CR_SC_IO_LATENCY_Rank_1_flyby_MAX);
  ScIoLatency.Bits.Rank_2_flyby = MIN (IoLatency[2], MCHBAR_CH0_CR_SC_IO_LATENCY_Rank_2_flyby_MAX);
  ScIoLatency.Bits.Rank_3_flyby = MIN (IoLatency[3], MCHBAR_CH0_CR_SC_IO_LATENCY_Rank_3_flyby_MAX);
  ScIoLatency.Bits.IO_Latency_offset = MIN (ChannelOut->RTIoComp, MCHBAR_CH0_CR_SC_IO_LATENCY_IO_Latency_offset_MAX);
  ScIoLatency.Bits.RFR_delay = HW_RFR_DELAY;

  Offset = OFFSET_CALC_CH (MCHBAR_CH0_CR_SC_IO_LATENCY_REG, MCHBAR_CH1_CR_SC_IO_LATENCY_REG, Channel);
  MrcWriteCR (MrcData, Offset, ScIoLatency.Data);
}

/**
  Program MCHBAR_CHx_CR_SC_ROUNDTRIP_LATENCY register using Host data.

  @param[in] MrcData  - Include all MRC global data.
  @param[in] Channel  - Channel to work on.
**/
void
MrcHalSetRoundtripLatency (
  IN MrcParameters *const MrcData,
  IN const UINT32         Channel
  )
{
  const UINT8                               *RtLatency;
  MCHBAR_CH0_CR_SC_ROUNDTRIP_LATENCY_STRUCT ScRoundtripLatency;
  UINT32                                    Offset;

  RtLatency = MrcData->Outputs.Controller[0].Channel[Channel].RTLatency;

  ScRoundtripLatency.Data = 0;
  ScRoundtripLatency.Bits.Rank_0_latency = MIN (RtLatency[0], MCHBAR_CH0_CR_SC_ROUNDTRIP_LATENCY_Rank_0_latency_MAX);
  ScRoundtripLatency.Bits.Rank_1_latency = MIN (RtLatency[1], MCHBAR_CH0_CR_SC_ROUNDTRIP_LATENCY_Rank_1_latency_MAX);
  ScRoundtripLatency.Bits.Rank_2_latency = MIN (RtLatency[2], MCHBAR_CH0_CR_SC_ROUNDTRIP_LATENCY_Rank_2_latency_MAX);
  ScRoundtripLatency.Bits.Rank_3_latency = MIN (RtLatency[3], MCHBAR_CH0_CR_SC_ROUNDTRIP_LATENCY_Rank_3_latency_MAX);

  Offset = OFFSET_CALC_CH (MCHBAR_CH0_CR_SC_ROUNDTRIP_LATENCY_REG, MCHBAR_CH1_CR_SC_ROUNDTRIP_LATENCY_REG, Channel);
  MrcWriteCR (MrcData, Offset, ScRoundtripLatency.Data);
}

/**
  Read MCHBAR_CHx_CR_SC_ROUNDTRIP_LATENCY register value.

  @param[in] MrcData  - Include all MRC global data.
  @param[in] Channel  - Channel to work on.

  @retval The value read from the register.
**/
UINT32
MrcHalGetRoundtripLatency (
  IN MrcParameters *const MrcData,
  IN const UINT32         Channel
  )
{
  return (
    MrcReadCR (
      MrcData,
      OFFSET_CALC_CH (MCHBAR_CH0_CR_SC_ROUNDTRIP_LATENCY_REG, MCHBAR_CH1_CR_SC_ROUNDTRIP_LATENCY_REG, Channel)
      )
    );
}
