/** @file
  Build time limits of PCH resources.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2013 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:

@par Glossary:
 - CDF - Cedar Fork
**/
#ifndef _PCH_LIMITS_H_
#define _PCH_LIMITS_H_

#include "MrcOemPlatform.h"

//
// PCIe limits
//
#define PCH_MAX_PCIE_ROOT_PORTS             CNL_PCH_H_PCIE_MAX_ROOT_PORTS
#define CNL_PCH_H_PCIE_MAX_ROOT_PORTS       24
#define PCH_LP_PCIE_MAX_ROOT_PORTS          16

#define PCH_PCIE_CONTROLLER_PORTS           4u
#define PCH_MAX_PCIE_CONTROLLERS            PCH_H_PCIE_MAX_CONTROLLERS
#define PCH_H_PCIE_MAX_CONTROLLERS          (CNL_PCH_H_PCIE_MAX_ROOT_PORTS / PCH_PCIE_CONTROLLER_PORTS)
#define PCH_LP_PCIE_MAX_CONTROLLERS         (PCH_LP_PCIE_MAX_ROOT_PORTS / PCH_PCIE_CONTROLLER_PORTS)
//
// PCIe clocks limits
//
#define PCH_LP_PCIE_MAX_CLK_REQ             6
#define PCH_H_PCIE_MAX_CLK_REQ              16
#define PCH_PCIE_MAX_CLK_REQ                PCH_H_PCIE_MAX_CLK_REQ

//
// DMI lanes
//
#define PCH_MAX_DMI_LANES                   8

//
// RST PCIe Storage Cycle Router limits
//
#define PCH_MAX_RST_PCIE_STORAGE_CR         3

//
// SATA limits
//
#define SATA_1_CONTROLLER_INDEX             0
#define SATA_2_CONTROLLER_INDEX             1
#define SATA_3_CONTROLLER_INDEX             2
#define CDF_PCH_SATA_CONTROLLER_MAX         3       ///< Max number of SATA controller in CDF PCH
#define CLIENT_PCH_SATA_CONTROLLER_MAX      1       ///< Max number of SATA controller in client PCH
#define PCH_SATA_CONTROLLER_MAX             CDF_PCH_SATA_CONTROLLER_MAX ///< Max number of SATA controller
#define PCH_MAX_SATA_PORTS                  PCH_H_AHCI_MAX_PORTS
#define PCH_H_AHCI_MAX_PORTS                8       ///< Max number of sata ports in CNL PCH H
#define PCH_LP_AHCI_MAX_PORTS               3       ///< Max number of sata ports in CNL PCH LP
#define PCH_SATA_MAX_DEVICES_PER_PORT       1       ///< Max support device numner per port, Port Multiplier is not support.

//
// USB limits
//
#define PCH_MAX_USB2_PORTS                  PCH_H_XHCI_MAX_USB2_PORTS

#define PCH_H_XHCI_MAX_USB2_PHYSICAL_PORTS  14      ///< Max Physical Connector XHCI, not counting virtual ports like USB-R.
#define PCH_LP_XHCI_MAX_USB2_PHYSICAL_PORTS 10      ///< Max Physical Connector XHCI, not counting virtual ports like USB-R.

#define PCH_H_XHCI_MAX_USB2_PORTS           16      ///< 14 High Speed lanes + Including two ports reserved for USBr
#define PCH_LP_XHCI_MAX_USB2_PORTS          12      ///< 10 High Speed lanes + Including two ports reserved for USBr

#define PCH_MAX_USB3_PORTS                  PCH_H_XHCI_MAX_USB3_PORTS

#define PCH_H_XHCI_MAX_USB3_PORTS           10      ///< 10 Super Speed lanes
#define PCH_LP_XHCI_MAX_USB3_PORTS          6       ///< 6 Super Speed lanes

#define PCH_USB_OC_PINS_MAX                 PCH_H_USB_OC_PINS_MAX  ///< Number of USB Over Current pins
#define PCH_H_USB_OC_PINS_MAX               8
#define PCH_LP_USB_OC_PINS_MAX              4

#define PCH_PWRM_BASE_ADDRESS 0xFE000000

//
// SerialIo limits
//
#define PCH_SERIALIO_MAX_CONTROLLERS         12  ///< Number of SerialIo controllers, this includes I2C, SPI and UART
#define PCH_SERIALIO_MAX_SPI_CONTROLLERS      3  ///< Number of SerialIo SPI controllers
#define PCH_SERIALIO_MAX_I2C_CONTROLLERS      6  ///< Number of SerialIo I2C controllers
#define PCH_LP_SERIALIO_MAX_I2C_CONTROLLERS   6  ///< Number of SerialIo I2C controllers for PCH-LP
#define PCH_H_SERIALIO_MAX_I2C_CONTROLLERS    4  ///< Number of SerialIo I2C controllers for PCH-H
#define PCH_SERIALIO_MAX_UART_CONTROLLERS     3  ///< Number of SerialIo UART controllers
#define PCH_ISH_PINS_PER_I2C_CONTROLLER       2
#define PCH_ISH_PINS_PER_UART_CONTROLLER      4
#define PCH_ISH_PINS_PER_SPI_CONTROLLER       4
#define PCH_SCS_SD_CARD_PINS                  9
#define PCH_SCS_EMMC_PINS                     12
#define PCH_GPIO_HDA_LINK_NUMBER_OF_PINS      6
#define CNL_PCH_LP_GPIO_GROUP_MAX             15
#define CNL_PCH_H_GPIO_GROUP_MAX              17

//
// ISH limits
//
#define PCH_ISH_MAX_GP_PINS                   8
#define PCH_ISH_MAX_UART_CONTROLLERS          2
#define PCH_ISH_MAX_I2C_CONTROLLERS           6
#define PCH_ISH_MAX_SPI_CONTROLLERS           1

//
// SCS limits
//
#define PCH_SCS_MAX_CONTROLLERS            3  ///< Number of Storage and Communication Subsystem controllers, this includes eMMC, SDIO, SDCARD

//
// HDAudio limits
//
#define PCH_HDA_DMIC_MAX_INTERFACES        2  ///< Number of HDAudio DMIC interfaces
#define PCH_HDA_SSP_MAX_INTERFACES         3  ///< Number of HDAudio I2S/SSP interfaces
#define PCH_HDA_SNDW_MAX_INTERFACES        4  ///< Number of HDAudio SoundWire interfaces

//
// Flash Protection Range Register
//
#define PCH_FLASH_PROTECTED_RANGES         5

//
// Number of eSPI slaves
//
#define PCH_ESPI_MAX_SLAVE_ID              2

#endif // _PCH_LIMITS_H_

