/** @file
  Source code file for CometLake MemoryInit PPI Installation

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification
**/

#include <Library/DebugLib.h>
#include <Library/PeiServicesLib.h>
#include <CompatibilitySupportProdLib.h>
#include <Library/CpuPlatformLib.h>
#include <Library/MemoryInitLib.h>
#include <Library/PeiMemPolicyLib.h>

INSTALL_MEMORY_INIT_FUNC mCmlMrc = {
  InstallMrcCallback,
  LoadMemConfigNoCrcDefault,
  LoadMemConfigDefault,
  SaLoadSamplePolicyPreMem
};

/**
  X-compatible MRC support module entry point

  The module register CometLake Memory Init functions if CPUID matches

  @param[in]  FileHandle           Pointer to image file handle
  @param[in]  PeiServices          Pointer to PEI Services Table

  @return     EFI_SUCCESS
**/
EFI_STATUS
EFIAPI
CompatibleMrcEntryPoint (
  IN       EFI_PEI_FILE_HANDLE  FileHandle,
  IN CONST EFI_PEI_SERVICES     **PeiServices
  )
{
  if (!IsRklCpu()) {
    DEBUG ((DEBUG_INFO, "CometLake CPU is detected. CometLake MRC will run \n"));
    RegisterMemoryInit (&mCmlMrc);
  }
  return EFI_SUCCESS;
}
