/** @file
  Source code file for Compatibility Support PPI Producer Library

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification
**/
#include <Library/DebugLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/PeiServicesLib.h>
#include <CompatibilitySupportProdLib.h>

/**
  Registers MRC functions PPI
  This call support X-compatibility module to installs Compatibility Memory Init PPI.

  @param[in]  CompatibleMemoryInit   A pointer to a function of type INSTALL_MEMORY_INIT_FUNC
                                     that is going to be installed runtime if CPUID matches
  @retval     EFI_SUCCESS            The function was successfully registered.
*/
EFI_STATUS
EFIAPI
RegisterMemoryInit (
  IN INSTALL_MEMORY_INIT_FUNC  *CompatibleMemoryInit
  )
{
  EFI_STATUS                 Status;
  EFI_PEI_PPI_DESCRIPTOR     *PpiListMrc;

  PpiListMrc = AllocatePool (sizeof(EFI_PEI_PPI_DESCRIPTOR));
  ASSERT (PpiListMrc != NULL);

  PpiListMrc->Flags = (EFI_PEI_PPI_DESCRIPTOR_PPI | EFI_PEI_PPI_DESCRIPTOR_TERMINATE_LIST);
  PpiListMrc->Guid  = &gCompatibleMemoryInitPpiGuid;
  PpiListMrc->Ppi   = CompatibleMemoryInit;

  Status = PeiServicesInstallPpi (PpiListMrc);
  ASSERT_EFI_ERROR(Status);
  return EFI_SUCCESS;
}
