/** @file
  Compatibility Support PPI Producer Library header file

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification
**/

#ifndef __COMPATIBILITY_SUPPORT_PROD_LIB_H__
#define __COMPATIBILITY_SUPPORT_PROD_LIB_H__

/**
  Entry point of MemoryInit library
  This function invokes main memory detection code.

**/
typedef
EFI_STATUS
(EFIAPI *INSTALL_MRC_CALLBACK) (
  VOID
  );


/**
  Load Config block default

  @param[in] ConfigBlockPointer         The pointer for memory config block

**/
typedef
VOID
(EFIAPI *LOAD_MEMCONFIG_DEFAULT) (
  IN VOID    *ConfigBlockPointer
  );

/**
  Load some policy default of SA for reference board

  @param[in] ConfigBlockTableAddress    The pointer for SA config blocks

**/
typedef
VOID
(EFIAPI *SA_LOAD_SAMPLE_POLICY_PREMEM) (
  IN VOID    *ConfigBlockTableAddress
  );

/**
  Structure for the functions to be installed on Memory Init PPI gCompatibleMemoryInitPpiGuid

**/
typedef struct {
  INSTALL_MRC_CALLBACK          CompatibleInstallMrcCallback;
  LOAD_MEMCONFIG_DEFAULT        CompatibleLoadMemConfigNoCrcDefault;
  LOAD_MEMCONFIG_DEFAULT        CompatibleLoadMemConfigDefault;
  SA_LOAD_SAMPLE_POLICY_PREMEM  CompatibleSaLoadSamplePolicyPreMem;
} INSTALL_MEMORY_INIT_FUNC;


/**
  Registers MRC functions PPI
  This call support X-compatibility module to install Compatibility Memory Init PPI.

  @param[in]  CompatibleMemoryInit   A pointer to a function of type INSTALL_MEMORY_INIT_FUNC
                                     that is going to be installed runtime if CPUID matches
  @retval     EFI_SUCCESS            The function was successfully registered.
**/
EFI_STATUS
EFIAPI
RegisterMemoryInit (
  IN INSTALL_MEMORY_INIT_FUNC  *CompatibleMemoryInit
  );

#endif // __COMPATIBILITY_SUPPORT_PROD_LIB_H__
