/** @file
  The PEI DPIN Init Library Implements After Memory PEIM

@copyright
  INTEL CONFIDENTIAL
  Copyright 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#include <Library/PeiServicesLib.h>
#include <Library/ConfigBlockLib.h>
#include <Ppi/SiPolicy.h>
#include <DpInPreMemConfig.h>

/**
  This function return CPU specific Private Data to Dp-In PreMem Pei Config Structure.

  @retval 0                       The Dp-In is not supported by CPU.
  @retval Others                  Return the Maximum number of ports supported by Silicon.
**/
UINT8
EFIAPI
GetDpInPrivateCpuData (
  VOID
  )
{
  return 0;
}

/**
  This function performs set/update for Dp-In Policy in IOM SW registers.

  @param[in]  DpInPreMemConfig             Pointer to Dp-In PreMem Pei Config Structure
  @param[in]  DpInPortConnectMap           External DpIn Port Connect Map
**/
VOID
EFIAPI
DpInPolicyInitPreMem (
  IN DPIN_PREMEM_CONFIG          *DpInPreMemConfig,
  IN UINT8                       DpInPortConnectMap
  )
{
  return;
}

/**
  This function check if any Platform Data Error Status found for Dp-In Policy.

  @param[in]   DpInPreMemConfig          Pointer to Dp-In PreMem Pei Config Structure
  @param[in]   MaxDpInExtPortCpuSupport  Maximum DP-In External Port supported by CPU.

  @retval     TRUE          Error found in Platform Data. Because of which External DP-In will not work.
  @retval     FALSE         No Error found in Platform Data.
**/
BOOLEAN
EFIAPI
DpInPlatformDataErrorLogging (
  IN  DPIN_PREMEM_CONFIG              *DpInPreMemConfig,
  IN  UINT8                           MaxDpInExtPortCpuSupport
  )
{
  return FALSE;
}

/**
  This function performs basic initialization for Dp-In Policy in PEI phase after PEG Graphics Detected at Pre-Mem phase.

  @param[in]  DpInPreMemConfig                 Pointer to Dp-In PreMem Pei Config Structure
  @param[in]  MaxDpInExtPortCpuSupport         Maximum DP-In External Port Sopported by CPU

  @retval EFI_SUCCESS           The DP-In Status HOB was successfully Updated.
  @retval EFI_NOT_FOUND         The Dp-In Hob Not found.
  @retval EFI_ABORTED           DP-In policy is set to Internal only forcefully.
  @retval EFI_ACCESS_DENIED     DP-In External Support not available by CPU.
  @retval EFI_UNSUPPORTED       The Dp-In External Policy is not Supported.
  **/
EFI_STATUS
EFIAPI
DpInPostGfxInit (
  IN DPIN_PREMEM_CONFIG               *DpInPreMemConfig,
  IN UINT8                            MaxDpInExtPortCpuSupport
  )
{
  return EFI_UNSUPPORTED;
}

/**
  This function performs basic initialization for DPIN in PEI phase after Policy produced at Pre-Mem phase.

  @param[in]  SiPreMemPolicyPpi              Pointer to Si PreMem Policy Ppi
**/
VOID
EFIAPI
DpInPreMemInit (
  IN  SI_PREMEM_POLICY_PPI            *SiPreMemPolicyPpi
  )
{
  return;
}
