/** @file
  This file provides services for DPIN PreMem policy function

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include <Library/DebugLib.h>
#include <Library/SiConfigBlockLib.h>
#include <Library/ConfigBlockLib.h>
#include <Ppi/SiPolicy.h>
#include <DpInPreMemConfig.h>

/**
  Print DPIN_PREMEM_CONFIG and serial out.

  @param[in] SiPreMemPolicyPpi            Pointer to a SI_PREMEM_POLICY_PPI
**/
VOID
DpInPrintConfigPreMem (
  IN SI_PREMEM_POLICY_PPI     *SiPreMemPolicyPpi
  )
{
  EFI_STATUS               Status;
  DPIN_PREMEM_CONFIG   *DpInPreMemConfig;

  Status = GetConfigBlock ((VOID *) SiPreMemPolicyPpi, &gDpInPreMemConfigGuid, (VOID *) &DpInPreMemConfig);
  ASSERT_EFI_ERROR (Status);

  DEBUG ((DEBUG_INFO, "----------------------- DPIN_PREMEM_CONFIG -----------------\n"));
  DEBUG ((DEBUG_INFO, " Revision : %d\n", DpInPreMemConfig->Header.Revision));
  ASSERT (DpInPreMemConfig->Header.Revision == DPIN_PREMEM_CONFIG_REVISION);
  DEBUG ((DEBUG_INFO, " DPIN DPin External Connection Policy : %01d\n",
                                                      DpInPreMemConfig->DpInExternalEn));
  DEBUG ((DEBUG_INFO, " DPIN NumberOfDpInPort : 0x%x\n",
                                                      DpInPreMemConfig->NumberOfDpInPort));
  DEBUG ((DEBUG_INFO, " DPIN DpInPortConnectMap : 0x%x\n",
                                                      DpInPreMemConfig->DpInPortConnectMap));
}

/**
  Load Config block default

  @param[in] ConfigBlockPointer         Pointer to config block
**/
VOID
DpInLoadConfigPreMemDefault (
  IN VOID          *ConfigBlockPointer
  )
{
  DPIN_PREMEM_CONFIG      *DpInPreMemConfig;

  DpInPreMemConfig = (DPIN_PREMEM_CONFIG *)ConfigBlockPointer;

  DEBUG ((DEBUG_INFO, "DpInPreMemConfig->Header.GuidHob.Name = %g\n", &DpInPreMemConfig->Header.GuidHob.Name));
  DEBUG ((DEBUG_INFO, "DpInPreMemConfig->Header.GuidHob.Header.HobLength = 0x%x\n", DpInPreMemConfig->Header.GuidHob.Header.HobLength));

  // Default for the DPIN IPs device enabling
  DpInPreMemConfig->DpInExternalEn = FALSE; // Default Disable the Dp-In feature.
  DpInPreMemConfig->NumberOfDpInPort = 0; // Default value 0.
  DpInPreMemConfig->DpInPortConnectMap = 0; // Default value 0.
}

STATIC COMPONENT_BLOCK_ENTRY  mDpInBlocksPreMem = {
  &gDpInPreMemConfigGuid,
  sizeof (DPIN_PREMEM_CONFIG),
  DPIN_PREMEM_CONFIG_REVISION,
  DpInLoadConfigPreMemDefault
};

/**
  Get DPIN PreMem config block table size.

  @retval      Size of config block
**/
UINT16
DpInGetConfigBlockTotalSizePreMem (
  VOID
  )
{
  return mDpInBlocksPreMem.Size;
}

/**
  Add DPIN PreMem ConfigBlock.

  @param[in] ConfigBlockTableAddress    The pointer to config block table

  @retval EFI_SUCCESS                   The policy default is initialized.
  @retval EFI_OUT_OF_RESOURCES          Insufficient resources to create buffer
**/
EFI_STATUS
DpInAddConfigBlockPreMem (
  IN VOID           *ConfigBlockTableAddress
  )
{
  return AddComponentConfigBlocks (ConfigBlockTableAddress, &mDpInBlocksPreMem, 1);
}
