/** @file

  This code provides Initialization of BZM Interface table for 2LM.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#include "BzmDxe.h"
#include <Library/UefiBootServicesTableLib.h>
#include <Protocol/AcpiTable.h>
#include <Protocol/AcpiSystemDescriptionTable.h>
#include <Uefi/UefiSpec.h>
#include <Library/PeiDxeSmmTwoLmLib.h>
#include <Library/DebugLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/BaseLib.h>
#include <Library/HobLib.h>


EFI_BZMI_TABLE BzmiTable = {

    SIGNATURE_32('B', 'Z', 'M', 'I'),      // Signature
    sizeof (EFI_BZMI_TABLE),               // Length
    1,                                     // Revision  [01]
    0,                                     // Checksum
    { 'I', 'N', 'T', 'E', 'L', ' ' },      // OEM Id
    0x20202020324B4445,                    // OemTblId "EDK2"?
    0x00,                                  // OemRevision
    SIGNATURE_32('I', 'N', 'T', 'L'),      // CreatorId
    0x01,                                  // CreatorRev
    1,                                     // BzmDomains
    0,                                     // Reserved
    0x1                                    // BZM Domain-0 Identifier, Bits [55:0] - BZM Domain-0 Domain Handle,  Bits [61:56] Reserved
};

/**
  This function installs BZM interface table

  @param[in] ImageHandle             Handle for the image of this driver
  @param[in] SystemTable             Pointer to the EFI System Table

  @retval EFI_SUCCESS             The function completed successfully
  @retval EFI_OUT_OF_RESOURCES    No enough buffer to allocate
**/
EFI_STATUS
EFIAPI
BzmEntryPoint (
  IN EFI_HANDLE         ImageHandle,
  IN EFI_SYSTEM_TABLE   *SystemTable
  )
{
  EFI_STATUS                      Status;
  UINTN                           AcpiTableHandle;
  EFI_ACPI_TABLE_PROTOCOL         *AcpiTable;

  AcpiTable     = NULL;


  // Check BZM status
  Status = IsBzmEnabled();
  if (Status !=  EFI_SUCCESS) {
    return Status;
  }
  ///
  /// Locate ACPI support protocol
  ///
  Status = gBS->LocateProtocol (&gEfiAcpiTableProtocolGuid, NULL, (VOID **) &AcpiTable);
  if (EFI_ERROR (Status)) {
    return EFI_NOT_FOUND;
  }

  ///
  /// Update the Bzm Interface table in the ACPI tables.
  ///
  AcpiTableHandle = 0;
  if (&BzmiTable != NULL) {
    Status = AcpiTable->InstallAcpiTable (
                          AcpiTable,
                          &BzmiTable,
                          BzmiTable.Length,
                          &AcpiTableHandle
                          );
  }
  return EFI_SUCCESS;
}
