/** @file
  Header file for the NVDIMM CACHE Hob

@copyright
  INTEL CONFIDENTIAL
  Copyright 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef NVDIMM_CACHE_INFO_HOB_LIB_H_
#define NVDIMM_CACHE_INFO_HOB_LIB_H_

#include <Base.h>
#include <Uefi.h>
#include <Library/HobLib.h>


//
// Extern the GUID for Hob users.
//
extern EFI_GUID         gNvdimmCacheInfoHobGuid;

//
// NVDIMM Cache Information Structure
//
typedef struct _NVDIMM_CACHE_INFO {
  UINT8                 Revision;                         // Value 1. Other values are reserved.
  UINT8                 Reserved[7];                      // Reserved to created 64 bit alignment.
  UINT64                NvdimmCacheBaseAddress;           // Host physical address of Persistent Memory region that has been reserved for RST.
  UINT64                NvdimmCacheLength;                // Length of Persistent Memory region in bytes that has been reserved for RST.
  UINT64                DeepFlushRegister;                // Physical address of the register used to configure the start address of the flush request. Value of 0 indicates Deep Flush is not supported and DeepFlushSizeRegister, DeepFlushStatusRegister, MaxDeepFlushSize fields should be ignored.
  UINT64                DeepFlushSizeRegister;            // Physical address of the register used to configure the size of the flush request.  Should be less than the Max Deep Flush Size.
  UINT64                DeepFlushStatusRegister;          // Physical address of the register used to query the status of deep flush. Should be less than the Max Deep Flush Request Size.
  UINT64                MaxDeepFlushSize;                 // Maximum size of the deep flush supported.
} NVDIMM_CACHE_INFO;

//
// NVDIMM Cache Information HOB
//
typedef struct {
  EFI_HOB_GUID_TYPE       EfiHobGuidType;
  NVDIMM_CACHE_INFO       NvdimmCacheInfo;
} NVDIMM_CACHE_HOB;

#endif /* NVDIMM_CACHE_INFO_HOB_LIB_H_ */
