/** @file
  Header file for the NVDIMM CACHE PPI

@copyright
  INTEL CONFIDENTIAL
  Copyright 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef NVDIMM_CACHE_INFO_LIB_H_
#define NVDIMM_CACHE_INFO_LIB_H_

#include <TwoLmConfig.h>
#include <Register/TwoLmRegs.h>
#include <Library/PeiServicesLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/PeiServicesTablePointerLib.h>
#include <Library/PeiDxeSmmTwoLmLib.h>
#include <Library/DebugLib.h>
#include <Library/ItbtPcieRpInitLib.h>
#include <Library/PciSegmentLib.h>
#include <Register/SaRegsHostBridge.h>
#include <Library/IoLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/NvdimmCacheInfoHob.h>


#define NVDIMM_CACHE_INFO_REVISION 0x01

typedef struct _EFI_NVDIMM_CACHE_PPI EFI_NVDIMM_CACHE_PPI;

//
// Extern the GUID for PPI users.
//
extern EFI_GUID         gNvdimmCachePpiGuid;
extern EFI_GUID         gTwoLmPreMemConfigGuid;

/**
  Get the Nvdimm Cache Information Structure

  @param  This                  The Nvdimm Cache Information PPI.
  @param  NvdimmCacheInfo       Populates information in the Nvdimm Cache Information Structure pointer.

  @retval EFI_SUCCESS            The function completed successfully.
  @retval EFI_UNSUPPORTED        Unable to retrive TwoLmHob or PmemSize is zero.
  @retval Others                 Fails to return the Nvdimm Cache Information.
**/
typedef
EFI_STATUS
(EFIAPI *EFI_GET_NVMDIMM_CACHE_INFO) (
  IN CONST EFI_NVDIMM_CACHE_PPI   *This,
  IN NVDIMM_CACHE_INFO            *NvdimmCacheInfo
  );

//
// NVDIMM Cache Information PPI.
//
struct _EFI_NVDIMM_CACHE_PPI {
  EFI_GET_NVMDIMM_CACHE_INFO  GetNvdimmCacheInfo;
};

EFI_STATUS
EFIAPI
NvdimmCacheInfoPpiHobInstall (
  VOID
);

#endif /* NVDIMM_CACHE_INFO_LIB_H_ */
