/** @file
  This file implements NV DIMM Root device DSMs for Power Fail Persistence and
  Durability support.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2019-2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#define  CAPABILITY                                    VAR0
#define  PADDING                                       VAR1
#define  MMIO_TIME_ALL_PERSIST                         VAR2
#define  MMIO_NEXT_TIME_ALL_PERSIST                    VAR3
#define  MMIO_DEEP_FLUSH_TASK_REG0                     VAR4
#define  MMIO_DEEP_FLUSH_TASK_REG1                     VAR5
#define  MMIO_DEEP_FLUSH_STATUS                        VAR6
#define  MAX_DEEP_FLUSH_REQ_SIZE                       VAR7

#define DSM_STATUS_SUCCESS                                  0x0000
#define DSM_STATUS_FUNCTION_NOT_SUPPORTED                   0x0001
#define DSM_STATUS_NONEXISTING_MEMORY_DEVICE                0x0002
#define DSM_STATUS_INVALID_INPUT_PARAMS                     0x0003
#define DSM_STATUS_HW_ERROR                                 0x0004
#define DSM_STATUS_TIMEOUT_MAILBOX_NOT_READY                0x0005
#define DSM_STATUS_UNKNOWN_REASON                           0x0006
#define DSM_STATUS_SPECIFIC_ERROR                           0x0007
#define DSM_STATUS_OUT_OF_RESOURCES                         0x0008
#define DSM_STATUS_HW_NOT_READY                             0x0009
#define DSM_STATUS_INVALID_SECURITY_STATE                   0x000A
#define DSM_STATUS_INVALIS_CURRENT_PASSPHRASE_SUPLIED       0x000B



  //
  // Durability DSMs
  //
  // Arg0 - UUID - 1923E4D4-0E54-4726-9BE2-9883AD4F3DDD
  // Arg1 - Revision Id = 1
  // Arg2: Integer Function Index
  //  0 Query implemented functions per ACPI Specification.
  //  1 Get Power Fail Persistence Capability
  //  2 Set Durability Mode
  //  3 Get Durability Mode


      switch(ToInteger(Arg2))
      {
        case(0)
        {
            switch(ToInteger(Arg1))
            {
            case(0) {Return (0x00)}
            case(1) {Return (0x0F)}  // 0 to 3 functions are supported
            default {Return (0x00)}
          }
        }
        case(1)
        {
          Name(PFCS, Package() {Buffer (60) {}})
          CreateWordField (DerefOf(Index(PFCS, 0)), 0, RTS)
          CreateWordField (DerefOf(Index(PFCS, 0)), 2, ERTS)
          CreateDWordField (DerefOf(Index(PFCS, 0)), 4,  CAPABILITY)
          CreateDWordField (DerefOf(Index(PFCS, 0)), 8,  PADDING)
          CreateQWordField (DerefOf(Index(PFCS, 0)), 12,  MMIO_TIME_ALL_PERSIST)
          CreateQWordField (DerefOf(Index(PFCS, 0)), 20, MMIO_NEXT_TIME_ALL_PERSIST)
          CreateQWordField (DerefOf(Index(PFCS, 0)), 28, MMIO_DEEP_FLUSH_TASK_REG0)
          CreateQWordField (DerefOf(Index(PFCS, 0)), 36, MMIO_DEEP_FLUSH_TASK_REG1)
          CreateQWordField (DerefOf(Index(PFCS, 0)), 44, MMIO_DEEP_FLUSH_STATUS)
          CreateQWordField (DerefOf(Index(PFCS, 0)), 52, MAX_DEEP_FLUSH_REQ_SIZE)

          Store (DSM_STATUS_SUCCESS, RTS)
          Store (DSM_STATUS_SUCCESS, ERTS)
          Store (0xF, CAPABILITY)
          Store (0x0, PADDING)
          Store (Add(EDRM(), (ASTRO_OFFSET + R_ASTRO_TIME_ALL_PERSIST)),      MMIO_TIME_ALL_PERSIST)
          Store (Add(EDRM(), (ASTRO_OFFSET + R_ASTRO_NEXT_TIME_ALL_PERSIST)), MMIO_NEXT_TIME_ALL_PERSIST)
          Store (Add(EDRM(), (ASTRO_OFFSET + R_ASTRO_DEEP_FLUSH_TASK_REG0)),  MMIO_DEEP_FLUSH_TASK_REG0)
          Store (Add(EDRM(), (ASTRO_OFFSET + R_ASTRO_DEEP_FLUSH_TASK_REG1)),  MMIO_DEEP_FLUSH_TASK_REG1)
          Store (Add(EDRM(), (ASTRO_OFFSET + R_ASTRO_DEEP_FLUSH_STATUS)),     MMIO_DEEP_FLUSH_STATUS)
          Store ((0x100000000-0x1000), MAX_DEEP_FLUSH_REQ_SIZE)  //4GB-4K

          Return (PFCS)
        }
        case(2)
        {
            switch(ToInteger(DerefOf(Index(Arg3, 0))))
            {
              case(0)
              {
                SETM(PERFORMANCE_MODE)
              }
              case(1)
              {
                SETM(DURABILITY_MODE)
              }
              default {Return (Buffer () {DSM_STATUS_INVALID_INPUT_PARAMS, DSM_STATUS_INVALID_INPUT_PARAMS})}
            }
          Store (ToInteger(DerefOf(Index(Arg3, 0))), SCUB)  // Store to value for S3 resume
          Return (Buffer () {DSM_STATUS_SUCCESS, DSM_STATUS_SUCCESS})
        }
        case(3)
        {
          Name(MODE, Package() {Buffer (6) {}})
          CreateWordField (DerefOf(Index(MODE, 0)), 0, RT)
          CreateWordField (DerefOf(Index(MODE, 0)), 2, ERT)
          CreateWordField (DerefOf(Index(MODE, 0)), 4, RV)
          store (0, RT)
          store (0, ERT)
          store (GETM(), RV)
          Return(MODE)
        }
      } // end of switch
