/** @file
  This file implements NV DIMM Root device DSM support.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/



        Name (INDX, 0)
        Switch(ToInteger(Arg2)) {
          Case(0)
          {
            Return(Buffer(){0x1F})  //0 to 4 functuons are supported
          }
          Case(1)
          {
            Store(21, FISF)
            ToBuffer (DeRefOf (Index (Arg3, 0)), Local6)
            // read input payload of size 16 bytes from Arg3
            ToBuffer (DeRefOf (Index (Arg3, 0)), BUFF)
            Mid (BUFF, 0,  16, Local0) //Local0 has read buffer
            Store (0, INDX)
            While(LLess(INDX, 16)) {
              Store(DeRefOf(Index(Local0,INDX)), Local7)
              Increment(INDX)
            }
            //
            // Triggle the SMI interrupt
            //
            Store (FISS, IOB2)
            //CreateField (FIS1, 0, BITS (2), RSTS)
            if (LEqual ((FIS1 & 0xFF), 0)) {
              //copy data from Buff starting at 0 and of length 12 bytes to Local0
              Mid (BUFF, 0, 12, Local0) //Local0 has read buffer
              //create Local1 of size (4 + 12)
              Store (Buffer (Add (4, 12)) {}, Local1)
              //In Local1, define DW field RS21 from offset 0
              CreateDWordField (Local1, 0, RS21)
              Store(FIS1, RS21)
              //create field RD21 in Local1 from offset 32bits and size 12
              CreateField (Local1, BITS (4), BITS (12), RD21)
              Store(Local0, RD21)

              Store (0, INDX)
              While(LLess(INDX, 16)) {
                Store(DeRefOf(Index(Local1,INDX)), Local7)
                Increment(INDX)
              }
              Store(Local1, Debug)
              Return(Local1)
            }
            Else
            {
              //Return (Buffer (16) {FIS1, 0})
              //Return (Buffer () {4, 0, 0, 0})
              Store (Buffer (Add (4, 12)) {}, Local4)
              //In Local2, define DW field RS21 from offset 0
              CreateDWordField (Local4, 0, RSTS)
              Store(FIS1, RSTS)
              //create field RD21 in Local1 from offset 32bits and size 12
              CreateField (Local4, BITS (4), BITS (12), RDTQ)
              Store(0, RDTQ)
              Return(Local4)
            }
          }
          Case(2) {
            Store(22, FISF)
            // read input payload of size 24 bytes from Arg3
            ToBuffer(DeRefOf(Index(Arg3, 0)), BUFF)
            Mid (BUFF, 0,  24, Local0) //Local0 has read buffer
            ToBuffer (DeRefOf (Index (Arg3, 0)), Local6)
            Store (0, INDX)
            While(LLess(INDX, 24)) {
              Store(DeRefOf(Index(Local0,INDX)), Local7)
              Increment(INDX)
            }
            //
            // Triggle the SMI interrupt
            //
            Store (FISS, IOB2)
            if (LEqual (FIS1, 0)) {
              Store(FIS2, Local0) //store estimated time in Local0
              //create Local1 of size (4 + 4)
              Store (Buffer (Add (4, 4)) {}, Local1)
              //In Local1, define DW field RS22 from offset 0
              CreateDWordField (Local1, 0, RS22)
              Store(0, RS22)
              //create field RD22 in Local1 from offset 32bits and size 4 bytes
              CreateField (Local1, BITS (4), BITS (4), RD22)
              Store(Local0, RD22)

              Store (0, INDX)
              Store(8, Local6)
              While(LLess(INDX, Local6)) {
                Store(DeRefOf(Index(Local1,INDX)), Local7)
                Increment(INDX)
              }
              Return(Local1)
            }
            Else
            {
              Return (FIS1)
            }
          }
          Case(3) {
            Store(23, FISF)
            Store (FISS, IOB2)
            if (LEqual ((FIS1 & 0xFF), 0)) {
              Store(FIS2, Local3) //store return length in Local3
              //copy data from Buff starting at 0 and of length Local3 to Local0
              Mid (BUFF, 0,  Local3, Local0) //Local0 has read buffer
              //create Local1 of size (Local3 + 4) = (124+4)
              Store (Buffer (Add (Local3, 4)) {}, Local1)
              //In Local1, define DW field RSTS from offset 0
              CreateDWordField (Local1, 0, RS23)
              Store(FIS1, RS23)
              //create field RDTA in Local1 from offset 32bits and size Local3
              CreateField (Local1, BITS (4), BITS (Local3), RDTA)
              Store(Local0, RDTA)

              Store(0, INDX)
              Store(Add (FIS2, 4), Local6)
              While(LLess(INDX, Local6)) {
                Store(DeRefOf(Index(Local1,INDX)), Local7)
                Increment(INDX)
              }
              Store(Local1, Debug)
              Return(Local1)
            }
            Else
            {
              Store(FIS2, Local3) //store return length in Local3
              //create Local4 of size (Local3 + 4) = (124+4)
              Store (Buffer (Add (Local3, 4)) {}, Local4)
              //In Local4, define DW field RSTS from offset 0
              CreateDWordField (Local4, 0, FS23)
              Store(FIS1, FS23)
              //create field RDTA in Local1 from offset 32bits and size Local3
              CreateField (Local4, BITS (4), BITS (Local3), FD23)
              Store(0, FD23)
              Return(Local4)
            }
          }
          Case(4) {
            Store(24, FISF)
            ToBuffer(DeRefOf(Index(Arg3, 0)), BUFF)
            Mid (BUFF, 0,  16, Local0) //Local0 has read buffer
            //
            // Triggle the SMI interrupt
            //
            Store (FISS, IOB2)
            if (LEqual (FIS1, 0)) {
              Mid (BUFF, 0, 16, Local0) //Local0 has input
              CreateQWordField (Local0, 0, ADDR)
              CreateQWordField (Local0, 8, LENG)
              // Clear addr rang to 0
              Store(0, INDX)
              While(LLess(INDX, LENG)) {
                CLAR(ADDR)
                Increment(ADDR)
                Increment(INDX)
              }
              Store (Buffer (16) {}, Local4)
              CreateDWordField (Local4, 0, RS24)
              Store(0, RS24)
              CreateDWordField (Local4, 4, RSVD)
              Store(0, RSVD)
              CreateQWordField (Local4, 8, RD24)
              Store(LENG, RD24)
              Return(Local4)
            }
            Else
            {
              Return (0x02) //Invalid input
            }
          } //end of case
        }// end of switch
