/** @file
  This file load VR deafults and config block.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include <Library/PeiServicesLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/DebugLib.h>
#include <Library/SiConfigBlockLib.h>
#include <Library/ConfigBlockLib.h>
#include <Library/CpuPolicyLib.h>
#include <Ppi/SiPolicy.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/PeiVrLib.h>
#include <Library/PeiVrDomainLib.h>


/**
  Print CPU_POWER_MGMT_VR_CONFIG and serial out.

  @param[in] SiPolicyPpi  Instance of SI_POLICY_PPI
**/
VOID
CpuPowerMgmtVrConfigPrint (
  IN  SI_POLICY_PPI       *SiPolicyPpi
  )
{
  EFI_STATUS  Status;
  CPU_POWER_MGMT_VR_CONFIG  *CpuPowerMgmtVrConfig;
  UINT16                            MaxNumVrs;

  Status = GetConfigBlock ((VOID *) SiPolicyPpi, &gCpuPowerMgmtVrConfigGuid, (VOID *) &CpuPowerMgmtVrConfig);
  ASSERT_EFI_ERROR(Status);

  ///
  /// Define Maximum Number of Voltage Regulator Domains.
  ///
  MaxNumVrs = GetMaxNumVrs ();

  UINT32 Index = 0;
  DEBUG ((DEBUG_INFO, "------------------ CPU Power Mgmt VR Config ------------------\n"));

  for (Index = 0; Index < MaxNumVrs; Index++) {
    DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : VrConfigEnable[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->VrConfigEnable[Index]));
    if (CpuPowerMgmtVrConfig->VrConfigEnable[Index] == 1) {
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : TdcCurrentLimit[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->TdcCurrentLimit[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : AcLoadline[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->AcLoadline[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : DcLoadline[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->DcLoadline[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : Psi1Threshold[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->Psi1Threshold[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : Psi2Threshold[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->Psi2Threshold[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : Psi3Threshold[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->Psi3Threshold[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : Psi3Enable[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->Psi3Enable[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : Psi4Enable[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->Psi4Enable[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : ImonSlope[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->ImonSlope[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : ImonOffset[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->ImonOffset[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : IccMax[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->IccMax[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : VrVoltageLimit[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->VrVoltageLimit[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : TdcEnable[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->TdcEnable[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : TdcTimeWindow[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->TdcTimeWindow1[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : TdcLock[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->TdcLock[Index]));
      DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : Irms[%X] : 0x%X\n", Index, CpuPowerMgmtVrConfig->Irms[Index]));
    }
    DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG:: FastPkgCRampDisable for Index = %d : 0x%X\n", Index, CpuPowerMgmtVrConfig->FastPkgCRampDisable[Index]));
    DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG:: SlowSlewRate for Index = %d : 0x%X\n", Index, CpuPowerMgmtVrConfig->SlowSlewRate[Index]));
  }
  DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : PsysSlope : 0x%X\n", CpuPowerMgmtVrConfig->PsysSlope));
  DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : PsysOffset : 0x%X\n", CpuPowerMgmtVrConfig->PsysOffset));
  DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : AcousticNoiseMitigation : 0x%X\n", CpuPowerMgmtVrConfig->AcousticNoiseMitigation));
  DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG:: SendVrMbxCmd : 0x%X\n", CpuPowerMgmtVrConfig->SendVrMbxCmd));
  DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : FivrRfiFrequency : 0x%X\n", CpuPowerMgmtVrConfig->FivrRfiFrequency));
  DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : FivrSpreadSpectrum : 0x%X\n", CpuPowerMgmtVrConfig->FivrSpreadSpectrum));
  DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : EnableMinVoltageOverride : 0x%X\n", CpuPowerMgmtVrConfig->EnableMinVoltageOverride));
  if (CpuPowerMgmtVrConfig->EnableMinVoltageOverride == 1) {
    DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : MinVoltageRuntime : 0x%X\n", CpuPowerMgmtVrConfig->MinVoltageRuntime));
    DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : MinVoltageC8 : 0x%X\n", CpuPowerMgmtVrConfig->MinVoltageC8));
  }
  DEBUG ((DEBUG_INFO, " CPU_POWER_MGMT_VR_CONFIG : RfiMitigation : 0x%X\n", CpuPowerMgmtVrConfig->RfiMitigation));
}
/**
  Load Config block default

  @param[IN,OUT] ConfigBlockPointer         Pointer to config block

**/
VOID
LoadCpuPowerMgmtVrConfigDefault (
  IN OUT VOID          *ConfigBlockPointer
  )
{
  CPU_POWER_MGMT_VR_CONFIG  *CpuPowerMgmtVrConfig;

  CpuPowerMgmtVrConfig = ConfigBlockPointer;

  DEBUG ((DEBUG_INFO, "CpuPowerMgmtVrConfig->Header.GuidHob.Name = %g\n", &CpuPowerMgmtVrConfig->Header.GuidHob.Name));
  DEBUG ((DEBUG_INFO, "CpuPowerMgmtVrConfig->Header.GuidHob.Header.HobLength = 0x%x\n", CpuPowerMgmtVrConfig->Header.GuidHob.Header.HobLength));

}

/**
  External call for loading Config block default

  @param[in/out] CpuPowerMgmtVrConfigEx   Pointer to CPU_POWER_MGMT_VR_CONFIG_EX array.

  @retval EFI_SUCCESS                   The policy default is initialized.
  @retval EFI_OUT_OF_RESOURCES          Insufficient resources to create buffer
**/
EFI_STATUS
EFIAPI
LoadCpuPowerMgmtVrConfigDefaultEx (
  IN OUT CPU_POWER_MGMT_VR_CONFIG_EX     *CpuPowerMgmtVrConfigEx
  )
{
  UINTN                           Index;
  CPU_POWER_MGMT_VR_CONFIG        CpuPowerMgmtVrConfig;
  UINT16                          MaxNumVrs;

  ZeroMem (&CpuPowerMgmtVrConfig, sizeof (CPU_POWER_MGMT_VR_CONFIG));

  ///
  /// Define Maximum Number of Voltage Regulator Domains.
  ///
  MaxNumVrs = GetMaxNumVrs ();

  LoadCpuPowerMgmtVrConfigDefault (&CpuPowerMgmtVrConfig);

  for (Index = 0; Index < MaxNumVrs; Index++) {
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->VrConfigEnable[Index]  = CpuPowerMgmtVrConfig.VrConfigEnable[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->TdcEnable[Index]       = CpuPowerMgmtVrConfig.TdcEnable[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->TdcTimeWindow[Index]   = CpuPowerMgmtVrConfig.TdcTimeWindow[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->TdcCurrentLimit[Index] = CpuPowerMgmtVrConfig.TdcCurrentLimit[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->AcLoadline[Index]      = CpuPowerMgmtVrConfig.AcLoadline[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->DcLoadline[Index]      = CpuPowerMgmtVrConfig.DcLoadline[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->Psi1Threshold[Index]   = CpuPowerMgmtVrConfig.Psi1Threshold[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->Psi2Threshold[Index]   = CpuPowerMgmtVrConfig.Psi2Threshold[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->Psi3Threshold[Index]   = CpuPowerMgmtVrConfig.Psi3Threshold[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->Psi3Enable[Index]      = CpuPowerMgmtVrConfig.Psi3Enable[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->Psi4Enable[Index]      = CpuPowerMgmtVrConfig.Psi4Enable[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->IccMax[Index]          = CpuPowerMgmtVrConfig.IccMax[Index];
    CpuPowerMgmtVrConfigEx->CpuPowerMgmtVrData->Irms[Index]            = CpuPowerMgmtVrConfig.Irms[Index];
  }
  return EFI_SUCCESS;
}


STATIC COMPONENT_BLOCK_ENTRY mVrIpBlock = {
  &gCpuPowerMgmtVrConfigGuid,
  sizeof (CPU_POWER_MGMT_VR_CONFIG),
  CPU_POWER_MGMT_VR_CONFIG_REVISION,
  LoadCpuPowerMgmtVrConfigDefault
};

/**
  Get VR config block total size.

  @retval Size of config block
**/
UINT16
GetCpuPowerMgmtVrConfigBlockTotalSize (
  VOID
  )
{
  return mVrIpBlock.Size;
}

/**
  Add VR ConfigBlock.

  @param[in] ConfigBlockTableAddress The pointer to config block table

  @retval EFI_SUCCESS                The policy default is initialized.
  @retval EFI_OUT_OF_RESOURCES       Insufficient resources to create buffer
**/
EFI_STATUS
AddCpuPowerMgmtVrConfigBlock (
  IN VOID *ConfigBlockTableAddress
  )
{
  EFI_STATUS Status;

  Status = AddComponentConfigBlocks (ConfigBlockTableAddress, &mVrIpBlock, 1);
  return Status;
}
