/** @file
  SA Platform Lib implementation.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2014 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include "SaPlatformLibrary.h"
#include <Library/PciSegmentLib.h>
#include <Library/CpuPlatformLib.h>
#include <IndustryStandard/Pci22.h>
#include <CpuPcieInfo.h>


/**
  Checks if SKU is Mobile

  @retval FALSE  SKU is not Mobile
  @retval TRUE   SKU is Mobile
**/
BOOLEAN
EFIAPI
IsMobileSku (
  VOID
  )
{
  UINT16           DeviceId;

  DeviceId = PciSegmentRead16 (PCI_SEGMENT_LIB_ADDRESS (SA_SEG_NUM, SA_MC_BUS, SA_MC_DEV, SA_MC_FUN, R_SA_MC_DEVICE_ID));
  if (
      (DeviceId == V_SA_DEVICE_ID_MB_ULT_1) || \
      (DeviceId == V_SA_DEVICE_ID_MB_ULT_2) || \
      (DeviceId == V_SA_DEVICE_ID_MB_ULX_1) || \
      (DeviceId == V_SA_DEVICE_ID_MB_ULX_2) \
    ) {
    return TRUE;
  }
  return FALSE;
}

/**
  Checks if SKU is Desktop

  @retval FALSE  SKU is not Desktop
  @retval TRUE   SKU is Desktop
**/
BOOLEAN
EFIAPI
IsDesktopSku (
  VOID
  )
{
  UINT16           DeviceId;

  DeviceId = PciSegmentRead16 (PCI_SEGMENT_LIB_ADDRESS (SA_SEG_NUM, SA_MC_BUS, SA_MC_DEV, SA_MC_FUN, R_SA_MC_DEVICE_ID));
  if (
      (DeviceId == V_SA_DEVICE_ID_DT_1) || \
      (DeviceId == V_SA_DEVICE_ID_DT_2) || \
      (DeviceId == V_SA_DEVICE_ID_DT_3) \
    ) {
    return TRUE;
  }
  return FALSE;
}

/**
  Checks if SKU is Halo

  @retval FALSE  SKU is not Halo
  @retval TRUE   SKU is Halo
**/
BOOLEAN
EFIAPI
IsHaloSku (
  VOID
  )
{
  UINT16           DeviceId;

  DeviceId = PciSegmentRead16 (PCI_SEGMENT_LIB_ADDRESS (SA_SEG_NUM, SA_MC_BUS, SA_MC_DEV, SA_MC_FUN, R_SA_MC_DEVICE_ID));
  if (
      (DeviceId == V_SA_DEVICE_ID_HALO_1) || \
      (DeviceId == V_SA_DEVICE_ID_HALO_2) || \
      (DeviceId == V_SA_DEVICE_ID_HALO_3) || \
      (DeviceId == V_SA_DEVICE_ID_HALO_4) || \
      (DeviceId == V_SA_DEVICE_ID_HALO_5) \
    ) {
      return TRUE;
  }
  return FALSE;
}

/**
  Checks if SKU is Server

  @retval FALSE  SKU is not Server
  @retval TRUE   SKU is Server
**/
BOOLEAN
EFIAPI
IsServerSku (
  VOID
  )
{
    return FALSE;
}

