/** @file
  JEDEC Memory Manufacturer Identifiers

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
  JEDEC Standard Manufacturer's Identification Code - JEP106.
**/
#include "SmbiosMemory.h"

GLOBAL_REMOVE_IF_UNREFERENCED MEMORY_MODULE_MANUFACTURE_LIST MemoryModuleManufactureList[] = {
  //
  // BANK 1
  //
  {0,    0x01, "AMD"},
  {0,    0x02, "AMI"},
  {0,    0x83, "Fairchild"},
  {0,    0x04, "Fujitsu"},
  {0,    0x85, "GTE"},
  {0,    0x86, "Harris"},
  {0,    0x07, "Hitachi"},
  {0,    0x08, "Inmos"},
  {0,    0x89, "Intel"},
  {0,    0x8a, "I.T.T."},
  {0,    0x0b, "Intersil"},
  {0,    0x8c, "Monolithic Memories"},
  {0,    0x0d, "Mostek"},
  {0,    0x0e, "Freescale (Motorola)"},
  {0,    0x8f, "National"},
  {0,    0x10, "NEC"},
  {0,    0x91, "RCA"},
  {0,    0x92, "Raytheon"},
  {0,    0x13, "Conexant (Rockwell)"},
  {0,    0x94, "Seeq"},
  {0,    0x15, "NXP (Philips)"},
  {0,    0x16, "Synertek"},
  {0,    0x97, "Texas Instruments"},
  {0,    0x98, "Toshiba"},
  {0,    0x19, "Xicor"},
  {0,    0x1a, "Zilog"},
  {0,    0x9b, "Eurotechnique"},
  {0,    0x1c, "Mitsubishi"},
  {0,    0x9d, "Lucent (AT&T)"},
  {0,    0x9e, "Exel"},
  {0,    0x1f, "Atmel"},
  {0,    0x20, "STMicroelectronics"},
  {0,    0xa1, "Lattice Semi."},
  {0,    0xa2, "NCR"},
  {0,    0x23, "Wafer Scale Integration"},
  {0,    0xa4, "IBM"},
  {0,    0x25, "Tristar"},
  {0,    0x26, "Visic"},
  {0,    0xa7, "Intl. CMOS Technology"},
  {0,    0xa8, "SSSI"},
  {0,    0x29, "MicrochipTechnology"},
  {0,    0x2a, "Ricoh Ltd"},
  {0,    0xab, "VLSI"},
  {0,    0x2c, "Micron Technology"},
  {0,    0xad, "SK Hynix"},
  {0,    0xae, "OKI Semiconductor"},
  {0,    0x2f, "ACTEL"},
  {0,    0xb0, "Sharp"},
  {0,    0x31, "Catalyst"},
  {0,    0x32, "Panasonic"},
  {0,    0xb3, "IDT"},
  {0,    0x34, "Cypress"},
  {0,    0xb5, "DEC"},
  {0,    0xb6, "LSI Logic"},
  {0,    0x37, "Zarlink (Plessey)"},
  {0,    0x38, "UTMC"},
  {0,    0xb9, "Thinking Machine"},
  {0,    0xba, "Thomson CSF"},
  {0,    0x3b, "Integrated CMOS (Vertex)"},
  {0,    0xbc, "Honeywell"},
  {0,    0x3d, "Honeywell"},
  {0,    0x3e, "Tektronix"},
  {0,    0xbf, "Silicon Storage Technology"},
  {0,    0x40, "ProMos/Mosel Vitelic"},
  {0,    0xc1, "Infineon (Siemens)"},
  {0,    0xc2, "Macronix"},
  {0,    0x43, "Xerox"},
  {0,    0xc4, "Plus Logic"},
  {0,    0x45, "Western Digital Technologies Inc"},
  {0,    0x46, "Elan Circuit Tech."},
  {0,    0xc7, "European Silicon Str."},
  {0,    0xc8, "Apple Computer"},
  {0,    0x49, "Xilinx"},
  {0,    0x4a, "Compaq"},
  {0,    0xcb, "Protocol Engines"},
  {0,    0x4c, "SCI"},
  {0,    0xcd, "Seiko Instruments"},
  {0,    0xce, "Samsung"},
  {0,    0x4f, "I3 Design System"},
  {0,    0xd0, "Klic"},
  {0,    0x51, "Crosspoint Solutions"},
  {0,    0x52, "Alliance Semiconductor"},
  {0,    0xd3, "Tandem"},
  {0,    0x54, "Hewlett-Packard"},
  {0,    0xd5, "Integrated Silicon Solutions"},
  {0,    0xd6, "Brooktree"},
  {0,    0x57, "New Media"},
  {0,    0x58, "MHS Electronic"},
  {0,    0xd9, "Performance Semi."},
  {0,    0xda, "Winbond Electronic"},
  {0,    0x5b, "Kawasaki Steel"},
  {0,    0xdc, "Bright Micro"},
  {0,    0x5d, "TECMAR"},
  {0,    0x5e, "Exar"},
  {0,    0xdf, "PCMCIA"},
  {0,    0xe0, "LG Semi (Goldstar)"},
  {0,    0x61, "Northern Telecom"},
  {0,    0x62, "Sanyo"},
  {0,    0xe3, "Array Microsystems"},
  {0,    0x64, "Crystal Semiconductor"},
  {0,    0xe5, "Analog Devices"},
  {0,    0xe6, "PMC-Sierra"},
  {0,    0x67, "Asparix"},
  {0,    0x68, "Convex Computer"},
  {0,    0xe9, "Quality Semiconductor"},
  {0,    0xea, "Nimbus Technology"},
  {0,    0x6b, "Transwitch"},
  {0,    0xec, "Micronas (ITT Intermetall)"},
  {0,    0x6d, "Cannon"},
  {0,    0x6e, "Altera"},
  {0,    0xef, "NEXCOM"},
  {0,    0x70, "Qualcomm"},
  {0,    0xf1, "Sony"},
  {0,    0xf2, "Cray Research"},
  {0,    0x73, "AMS(Austria Micro)"},
  {0,    0xf4, "Vitesse"},
  {0,    0x75, "Aster Electronics"},
  {0,    0x76, "Bay Networks (Synoptic)"},
  {0,    0xf7, "Zentrum/ZMD"},
  {0,    0xf8, "TRW"},
  {0,    0x79, "Thesys"},
  {0,    0x7a, "Solbourne Computer"},
  {0,    0xfb, "Allied-Signal"},
  {0,    0x7c, "Dialog Semiconductor"},
  {0,    0xfd, "Media Vision"},
  {0,    0xfe, "Numonyx Corporation"},

  //
  // BANK 2
  //
  {1,    0x01, "Cirrus Logic"},
  {1,    0x02, "National Instruments"},
  {1,    0x83, "ILC Data Device"},
  {1,    0x04, "Alcatel Mietec"},
  {1,    0x85, "Micro Linear"},
  {1,    0x86, "Univ. of NC"},
  {1,    0x07, "JTAG Technologies"},
  {1,    0x08, "BAE Systems (Loral)"},
  {1,    0x89, "Nchip"},
  {1,    0x8a, "Galileo Tech"},
  {1,    0x0b, "Bestlink Systems"},
  {1,    0x8c, "Graychip"},
  {1,    0x0d, "GENNUM"},
  {1,    0x0e, "VideoLogic"},
  {1,    0x8f, "Robert Bosch"},
  {1,    0x10, "Chip Express"},
  {1,    0x91, "DATARAM"},
  {1,    0x92, "United Microelectronics Corp"},
  {1,    0x13, "TCSI"},
  {1,    0x94, "Smart Modular"},
  {1,    0x15, "Hughes Aircraft"},
  {1,    0x16, "Lanstar Semiconductor"},
  {1,    0x97, "Qlogic"},
  {1,    0x98, "Kingston"},
  {1,    0x19, "Music Semi"},
  {1,    0x1a, "Ericsson Components"},
  {1,    0x9b, "SpaSE"},
  {1,    0x1c, "Eon Silicon Devices"},
  {1,    0x9d, "Integrated Silicon Solution (ISSI)"},
  {1,    0x9e, "DoD"},
  {1,    0x1f, "Integ. Memories Tech."},
  {1,    0x20, "Corollary Inc"},
  {1,    0xa1, "Dallas Semiconductor"},
  {1,    0xa2, "Omnivision"},
  {1,    0x23, "EIV(Switzerland)"},
  {1,    0xa4, "Novatel Wireless"},
  {1,    0x25, "Zarlink (Mitel)"},
  {1,    0x26, "Clearpoint"},
  {1,    0xa7, "Cabletron"},
  {1,    0xa8, "STEC (Silicon Tech)"},
  {1,    0x29, "Vanguard"},
  {1,    0x2a, "Hagiwara Sys-Com"},
  {1,    0xab, "Vantis"},
  {1,    0x2c, "Celestica"},
  {1,    0xad, "Century"},
  {1,    0xae, "Hal Computers"},
  {1,    0x2f, "Rohm Company Ltd"},
  {1,    0xb0, "Juniper Networks"},
  {1,    0x31, "Libit Signal Processing"},
  {1,    0x32, "Mushkin Enhanced Memory"},
  {1,    0xb3, "Tundra Semiconductor"},
  {1,    0x34, "Adaptec Inc"},
  {1,    0xb5, "LightSpeed Semi."},
  {1,    0xb6, "ZSP Corp"},
  {1,    0x37, "AMIC Technology"},
  {1,    0x38, "Adobe Systems"},
  {1,    0xb9, "Dynachip"},
  {1,    0xba, "PNY Technologies Inc"},
  {1,    0x3b, "Newport Digital"},
  {1,    0xbc, "MMC Networks"},
  {1,    0x3d, "T Square"},
  {1,    0x3e, "Seiko Epson"},
  {1,    0xbf, "Broadcom"},
  {1,    0x40, "Viking Components"},
  {1,    0xc1, "V3 Semiconductor"},
  {1,    0xc2, "Flextronics (Orbit Semiconductor)"},
  {1,    0x43, "Suwa Electronics"},
  {1,    0xc4, "Transmeta"},
  {1,    0x45, "Micron CMS"},
  {1,    0x46, "American Computer & Digital Components Inc"},
  {1,    0xc7, "Enhance 3000 Inc"},
  {1,    0xc8, "Tower Semiconductor"},
  {1,    0x49, "CPU Design"},
  {1,    0x4a, "Price Point"},
  {1,    0xcb, "Maxim Integrated Product"},
  {1,    0x4c, "Tellabs"},
  {1,    0xcd, "Centaur Technology"},
  {1,    0xce, "Unigen Corporation"},
  {1,    0x4f, "Transcend Information"},
  {1,    0xd0, "Memory Card Technology"},
  {1,    0x51, "CKD Corporation Ltd"},
  {1,    0x52, "Capital Instruments Inc"},
  {1,    0xd3, "Aica Kogyo Ltd"},
  {1,    0x54, "Linvex Technology"},
  {1,    0xd5, "MSC Vertriebs GmbH"},
  {1,    0xd6, "AKM Company Ltd"},
  {1,    0x57, "Dynamem Inc"},
  {1,    0x58, "NERA ASA"},
  {1,    0xd9, "GSI Technology"},
  {1,    0xda, "Dane-Elec (C Memory)"},
  {1,    0x5b, "Acorn Computers"},
  {1,    0xdc, "Lara Technology"},
  {1,    0x5d, "Oak Technology Inc"},
  {1,    0x5e, "Itec Memory"},
  {1,    0xdf, "Tanisys Technology"},
  {1,    0xe0, "Truevision"},
  {1,    0x61, "Wintec Industries"},
  {1,    0x62, "Super PC Memory"},
  {1,    0xe3, "MGV Memory"},
  {1,    0x64, "Galvantech"},
  {1,    0xe5, "Gadzoox Networks"},
  {1,    0xe6, "Multi Dimensional Cons."},
  {1,    0x67, "GateField"},
  {1,    0x68, "Integrated Memory System"},
  {1,    0xe9, "Triscend"},
  {1,    0xea, "XaQti"},
  {1,    0x6b, "Goldenram"},
  {1,    0xec, "Clear Logic"},
  {1,    0x6d, "Cimaron Communications"},
  {1,    0x6e, "Nippon Steel Semi. Corp"},
  {1,    0xef, "Advantage Memory"},
  {1,    0x70, "AMCC"},
  {1,    0xf1, "LeCroy"},
  {1,    0xf2, "Yamaha Corporation"},
  {1,    0x73, "Digital Microwave"},
  {1,    0xf4, "NetLogic Microsystems"},
  {1,    0x75, "MIMOS Semiconductor"},
  {1,    0x76, "Advanced Fibre"},
  {1,    0xf7, "BF Goodrich Data."},
  {1,    0xf8, "Epigram"},
  {1,    0x79, "Acbel Polytech Inc"},
  {1,    0x7a, "Apacer Technology"},
  {1,    0xfb, "Admor Memory"},
  {1,    0x7c, "FOXCONN"},
  {1,    0xfd, "Quadratics Superconductor"},
  {1,    0xfe, "3COM"},

  //
  // BANK 3
  //
  {2,    0x01, "Camintonn Corporation"},
  {2,    0x02, "ISOA Incorporated"},
  {2,    0x83, "Agate Semiconductor"},
  {2,    0x04, "ADMtek Incorporated"},
  {2,    0x85, "HYPERTEC"},
  {2,    0x86, "Adhoc Technologies"},
  {2,    0x07, "MOSAID Technologies"},
  {2,    0x08, "Ardent Technologies"},
  {2,    0x89, "Switchcore"},
  {2,    0x8a, "Cisco Systems Inc"},
  {2,    0x0b, "Allayer Technologies"},
  {2,    0x8c, "WorkX AG (Wichman)"},
  {2,    0x0d, "Oasis Semiconductor"},
  {2,    0x0e, "Novanet Semiconductor"},
  {2,    0x8f, "E-M Solutions"},
  {2,    0x10, "Power General"},
  {2,    0x91, "Advanced Hardware Arch."},
  {2,    0x92, "Inova Semiconductors GmbH"},
  {2,    0x13, "Telocity"},
  {2,    0x94, "Delkin Devices"},
  {2,    0x15, "Symagery Microsystems"},
  {2,    0x16, "C-Port Corporation"},
  {2,    0x97, "SiberCore Technologies"},
  {2,    0x98, "Southland Microsystems"},
  {2,    0x19, "Malleable Technologies"},
  {2,    0x1a, "Kendin Communications"},
  {2,    0x9b, "Great Technology Microcomputer"},
  {2,    0x1c, "Sanmina Corporation"},
  {2,    0x9d, "HADCO Corporation"},
  {2,    0x9e, "Corsair"},
  {2,    0x1f, "Actrans System Inc"},
  {2,    0x20, "ALPHA Technologies"},
  {2,    0xa1, "Silicon Laboratories Inc (Cygnal)"},
  {2,    0xa2, "Artesyn Technologies"},
  {2,    0x23, "Align Manufacturing"},
  {2,    0xa4, "Peregrine Semiconductor"},
  {2,    0x25, "Chameleon Systems"},
  {2,    0x26, "Aplus Flash Technology"},
  {2,    0xa7, "MIPS Technologies"},
  {2,    0xa8, "Chrysalis ITS"},
  {2,    0x29, "ADTEC Corporation"},
  {2,    0x2a, "Kentron Technologies"},
  {2,    0xab, "Win Technologies"},
  {2,    0x2c, "Tezzaron Semiconductor"},
  {2,    0xad, "Extreme Packet Devices"},
  {2,    0xae, "RF Micro Devices"},
  {2,    0x2f, "Siemens AG"},
  {2,    0xb0, "Sarnoff Corporation"},
  {2,    0x31, "Itautec SA"},
  {2,    0x32, "Radiata Inc"},
  {2,    0xb3, "Benchmark Elect. (AVEX)"},
  {2,    0x34, "Legend"},
  {2,    0xb5, "SpecTek Incorporated"},
  {2,    0xb6, "Hi/fn"},
  {2,    0x37, "Enikia Incorporated"},
  {2,    0x38, "SwitchOn Networks"},
  {2,    0xb9, "AANetcom Incorporated"},
  {2,    0xba, "Micro Memory Bank"},
  {2,    0x3b, "ESS Technology"},
  {2,    0xbc, "Virata Corporation"},
  {2,    0x3d, "Excess Bandwidth"},
  {2,    0x3e, "West Bay Semiconductor"},
  {2,    0xbf, "DSP Group"},
  {2,    0x40, "Newport Communications"},
  {2,    0xc1, "Chip2Chip Incorporated"},
  {2,    0xc2, "Phobos Corporation"},
  {2,    0x43, "Intellitech Corporation"},
  {2,    0xc4, "Nordic VLSI ASA"},
  {2,    0x45, "Ishoni Networks"},
  {2,    0x46, "Silicon Spice"},
  {2,    0xc7, "Alchemy Semiconductor"},
  {2,    0xc8, "Agilent Technologies"},
  {2,    0x49, "Centillium Communications"},
  {2,    0x4a, "W.L. Gore"},
  {2,    0xcb, "HanBit Electronics"},
  {2,    0x4c, "GlobeSpan"},
  {2,    0xcd, "Element 14"},
  {2,    0xce, "Pycon"},
  {2,    0x4f, "Saifun Semiconductors"},
  {2,    0xd0, "Sibyte Incorporated"},
  {2,    0x51, "MetaLink Technologies"},
  {2,    0x52, "Feiya Technology"},
  {2,    0xd3, "I & C Technology"},
  {2,    0x54, "Shikatronics"},
  {2,    0xd5, "Elektrobit"},
  {2,    0xd6, "Megic"},
  {2,    0x57, "Com-Tier"},
  {2,    0x58, "Malaysia Micro Solutions"},
  {2,    0xd9, "Hyperchip"},
  {2,    0xda, "Gemstone Communications"},
  {2,    0x5b, "Anadigm (Anadyne)"},
  {2,    0xdc, "3ParData"},
  {2,    0x5d, "Mellanox Technologies"},
  {2,    0x5e, "Tenx Technologies"},
  {2,    0xdf, "Helix AG"},
  {2,    0xe0, "Domosys"},
  {2,    0x61, "Skyup Technology"},
  {2,    0x62, "HiNT Corporation"},
  {2,    0xe3, "Chiaro"},
  {2,    0x64, "MDT Technologies GmbH"},
  {2,    0xe5, "Exbit Technology A/S"},
  {2,    0xe6, "Integrated Technology Express"},
  {2,    0x67, "AVED Memory"},
  {2,    0x68, "Legerity"},
  {2,    0xe9, "Jasmine Networks"},
  {2,    0xea, "Caspian Networks"},
  {2,    0x6b, "nCUBE"},
  {2,    0xec, "Silicon Access Networks"},
  {2,    0x6d, "FDK Corporation"},
  {2,    0x6e, "High Bandwidth Access"},
  {2,    0xef, "MultiLink Technology"},
  {2,    0x70, "BRECIS"},
  {2,    0xf1, "World Wide Packets"},
  {2,    0xf2, "APW"},
  {2,    0x73, "Chicory Systems"},
  {2,    0xf4, "Xstream Logic"},
  {2,    0x75, "Fast-Chip"},
  {2,    0x76, "Zucotto Wireless"},
  {2,    0xf7, "Realchip"},
  {2,    0xf8, "Galaxy Power"},
  {2,    0x79, "eSilicon"},
  {2,    0x7a, "Morphics Technology"},
  {2,    0xfb, "Accelerant Networks"},
  {2,    0x7c, "Silicon Wave"},
  {2,    0xfd, "SandCraft"},
  {2,    0xfe, "Elpida"},

  //
  // BANK 4
  //
  {3,    0x01, "Solectron"},
  {3,    0x02, "Optosys Technologies"},
  {3,    0x83, "Buffalo (Formerly Melco)"},
  {3,    0x04, "TriMedia Technologies"},
  {3,    0x85, "Cyan Technologies"},
  {3,    0x86, "Global Locate"},
  {3,    0x07, "Optillion"},
  {3,    0x08, "Terago Communications"},
  {3,    0x89, "Ikanos Communications"},
  {3,    0x8a, "Princeton Technology"},
  {3,    0x0b, "Nanya Technology"},
  {3,    0x8c, "Elite Flash Storage"},
  {3,    0x0d, "Mysticom"},
  {3,    0x0e, "LightSand Communications"},
  {3,    0x8f, "ATI Technologies"},
  {3,    0x10, "Agere Systems"},
  {3,    0x91, "NeoMagic"},
  {3,    0x92, "AuroraNetics"},
  {3,    0x13, "Golden Empire"},
  {3,    0x94, "Mushkin"},
  {3,    0x15, "Tioga Technologies"},
  {3,    0x16, "Netlist"},
  {3,    0x97, "TeraLogic"},
  {3,    0x98, "Cicada Semiconductor"},
  {3,    0x19, "Centon Electronics"},
  {3,    0x1a, "Tyco Electronics"},
  {3,    0x9b, "Magis Works"},
  {3,    0x1c, "Zettacom"},
  {3,    0x9d, "Cogency Semiconductor"},
  {3,    0x9e, "Chipcon AS"},
  {3,    0x1f, "Aspex Technology"},
  {3,    0x20, "F5 Networks"},
  {3,    0xa1, "Programmable Silicon Solutions"},
  {3,    0xa2, "ChipWrights"},
  {3,    0x23, "Acorn Networks"},
  {3,    0xa4, "Quicklogic"},
  {3,    0x25, "Kingmax Semiconductor"},
  {3,    0x26, "BOPS"},
  {3,    0xa7, "Flasys"},
  {3,    0xa8, "BitBlitz Communications"},
  {3,    0x29, "eMemory Technology"},
  {3,    0x2a, "Procket Networks"},
  {3,    0xab, "Purple Ray"},
  {3,    0x2c, "Trebia Networks"},
  {3,    0xad, "Delta Electronics"},
  {3,    0xae, "Onex Communications"},
  {3,    0x2f, "Ample Communications"},
  {3,    0xb0, "Memory Experts Intl"},
  {3,    0x31, "Astute Networks"},
  {3,    0x32, "Azanda Network Devices"},
  {3,    0xb3, "Dibcom"},
  {3,    0x34, "Tekmos"},
  {3,    0xb5, "API NetWorks"},
  {3,    0xb6, "Bay Microsystems"},
  {3,    0x37, "Firecron Ltd"},
  {3,    0x38, "Resonext Communications"},
  {3,    0xb9, "Tachys Technologies"},
  {3,    0xba, "Equator Technology"},
  {3,    0x3b, "Concept Computer"},
  {3,    0xbc, "SILCOM"},
  {3,    0x3d, "3Dlabs"},
  {3,    0x3e, "c't Magazine"},
  {3,    0xbf, "Sanera Systems"},
  {3,    0x40, "Silicon Packets"},
  {3,    0xc1, "Viasystems Group"},
  {3,    0xc2, "Simtek"},
  {3,    0x43, "Semicon Devices Singapore"},
  {3,    0xc4, "Satron Handelsges"},
  {3,    0x45, "Improv Systems"},
  {3,    0x46, "INDUSYS GmbH"},
  {3,    0xc7, "Corrent"},
  {3,    0xc8, "Infrant Technologies"},
  {3,    0x49, "Ritek Corp"},
  {3,    0x4a, "empowerTel Networks"},
  {3,    0xcb, "Hypertec"},
  {3,    0x4c, "Cavium Networks"},
  {3,    0xcd, "PLX Technology"},
  {3,    0xce, "Massana Design"},
  {3,    0x4f, "Intrinsity"},
  {3,    0xd0, "Valence Semiconductor"},
  {3,    0x51, "Terawave Communications"},
  {3,    0x52, "IceFyre Semiconductor"},
  {3,    0xd3, "Primarion"},
  {3,    0x54, "Picochip Designs Ltd"},
  {3,    0xd5, "Silverback Systems"},
  {3,    0xd6, "Jade Star Technologies"},
  {3,    0x57, "Pijnenburg Securealink"},
  {3,    0x58, "takeMS - Ultron AG"},
  {3,    0xd9, "Cambridge Silicon Radio"},
  {3,    0xda, "Swissbit"},
  {3,    0x5b, "Nazomi Communications"},
  {3,    0xdc, "eWave System"},
  {3,    0x5d, "Rockwell Collins"},
  {3,    0x5e, "Picocel Co Ltd (Paion)"},
  {3,    0xdf, "Alphamosaic Ltd"},
  {3,    0xe0, "Sandburst"},
  {3,    0x61, "SiCon Video"},
  {3,    0x62, "NanoAmp Solutions"},
  {3,    0xe3, "Ericsson Technology"},
  {3,    0x64, "PrairieComm"},
  {3,    0xe5, "Mitac International"},
  {3,    0xe6, "Layer N Networks"},
  {3,    0x67, "MtekVision (Atsana)"},
  {3,    0x68, "Allegro Networks"},
  {3,    0xe9, "Marvell Semiconductors"},
  {3,    0xea, "Netergy Microelectronic"},
  {3,    0x6b, "NVIDIA"},
  {3,    0xec, "Internet Machines"},
  {3,    0x6d, "Memorysolution GmbH"},
  {3,    0x6e, "Litchfield Communication"},
  {3,    0xef, "Accton Technology"},
  {3,    0x70, "Teradiant Networks"},
  {3,    0xf1, "Scaleo Chip"},
  {3,    0xf2, "Cortina Systems"},
  {3,    0x73, "RAM Components"},
  {3,    0xf4, "Raqia Networks"},
  {3,    0x75, "ClearSpeed"},
  {3,    0x76, "Matsushita Battery"},
  {3,    0xf7, "Xelerated"},
  {3,    0xf8, "SimpleTech"},
  {3,    0x79, "Utron Technology"},
  {3,    0x7a, "Astec International"},
  {3,    0xfb, "AVM gmbH"},
  {3,    0x7c, "Redux Communications"},
  {3,    0xfd, "Dot Hill Systems"},
  {3,    0xfe, "TeraChip"},

  //
  // BANK 5
  //
  {4,    0x01, "T-RAM Incorporated"},
  {4,    0x02, "Innovics Wireless"},
  {4,    0x83, "Teknovus"},
  {4,    0x04, "KeyEye Communications"},
  {4,    0x85, "Runcom Technologies"},
  {4,    0x86, "RedSwitch"},
  {4,    0x07, "Dotcast"},
  {4,    0x08, "Silicon Mountain Memory"},
  {4,    0x89, "Signia Technologies"},
  {4,    0x8a, "Pixim"},
  {4,    0x0b, "Galazar Networks"},
  {4,    0x8c, "White Electronic Designs"},
  {4,    0x0d, "Patriot Scientific"},
  {4,    0x0e, "Neoaxiom Corporation"},
  {4,    0x8f, "3Y Power Technology"},
  {4,    0x10, "Scaleo Chip"},
  {4,    0x91, "Potentia Power Systems"},
  {4,    0x92, "C-guys Incorporated"},
  {4,    0x13, "Digital Communications Technology Inc"},
  {4,    0x94, "Silicon-Based Technology"},
  {4,    0x15, "Fulcrum Microsystems"},
  {4,    0x16, "Positivo Informatica Ltd"},
  {4,    0x97, "XIOtech Corporation"},
  {4,    0x98, "PortalPlayer"},
  {4,    0x19, "Zhiying Software"},
  {4,    0x1a, "ParkerVision Inc"},
  {4,    0x9b, "Phonex Broadband"},
  {4,    0x1c, "Skyworks Solutions"},
  {4,    0x9d, "Entropic Communications"},
  {4,    0x9e, "I'M Intelligent Memory Ltd"},
  {4,    0x1f, "Zensys A/S"},
  {4,    0x20, "Legend Silicon Corp"},
  {4,    0xa1, "Sci-worx GmbH"},
  {4,    0xa2, "SMSC (Standard Microsystems)"},
  {4,    0x23, "Renesas Electronics"},
  {4,    0xa4, "Raza Microelectronics"},
  {4,    0x25, "Phyworks"},
  {4,    0x26, "MediaTek"},
  {4,    0xa7, "Non-cents Productions"},
  {4,    0xa8, "US Modular"},
  {4,    0x29, "Wintegra Ltd"},
  {4,    0x2a, "Mathstar"},
  {4,    0xab, "StarCore"},
  {4,    0x2c, "Oplus Technologies"},
  {4,    0xad, "Mindspeed"},
  {4,    0xae, "Just Young Computer"},
  {4,    0x2f, "Radia Communications"},
  {4,    0xb0, "OCZ"},
  {4,    0x31, "Emuzed"},
  {4,    0x32, "LOGIC Devices"},
  {4,    0xb3, "Inphi Corporation"},
  {4,    0x34, "Quake Technologies"},
  {4,    0xb5, "Vixel"},
  {4,    0xb6, "SolusTek"},
  {4,    0x37, "Kongsberg Maritime"},
  {4,    0x38, "Faraday Technology"},
  {4,    0xb9, "Altium Ltd"},
  {4,    0xba, "Insyte"},
  {4,    0x3b, "ARM Ltd"},
  {4,    0xbc, "DigiVision"},
  {4,    0x3d, "Vativ Technologies"},
  {4,    0x3e, "Endicott Interconnect Technologies"},
  {4,    0xbf, "Pericom"},
  {4,    0x40, "Bandspeed"},
  {4,    0xc1, "LeWiz Communications"},
  {4,    0xc2, "CPU Technology"},
  {4,    0x43, "Ramaxel Technology"},
  {4,    0xc4, "DSP Group"},
  {4,    0x45, "Axis Communications"},
  {4,    0x46, "Legacy Electronics"},
  {4,    0xc7, "Chrontel"},
  {4,    0xc8, "Powerchip Semiconductor"},
  {4,    0x49, "MobilEye Technologies"},
  {4,    0x4a, "Excel Semiconductor"},
  {4,    0xcb, "A-DATA Technology"},
  {4,    0x4c, "VirtualDigm"},
  {4,    0xcd, "G Skill Intl"},
  {4,    0xce, "Quanta Computer"},
  {4,    0x4f, "Yield Microelectronics"},
  {4,    0xd0, "Afa Technologies"},
  {4,    0x51, "KINGBOX Technology Co Ltd"},
  {4,    0x52, "Ceva"},
  {4,    0xd3, "iStor Networks"},
  {4,    0x54, "Advance Modules"},
  {4,    0xd5, "Microsoft"},
  {4,    0xd6, "Open-Silicon"},
  {4,    0x57, "Goal Semiconductor"},
  {4,    0x58, "ARC International"},
  {4,    0xd9, "Simmtec"},
  {4,    0xda, "Metanoia"},
  {4,    0x5b, "Key Stream"},
  {4,    0xdc, "Lowrance Electronics"},
  {4,    0x5d, "Adimos"},
  {4,    0x5e, "SiGe Semiconductor"},
  {4,    0xdf, "Fodus Communications"},
  {4,    0xe0, "Credence Systems Corp"},
  {4,    0x61, "Genesis Microchip Inc"},
  {4,    0x62, "Vihana Inc"},
  {4,    0xe3, "WIS Technologies"},
  {4,    0x64, "GateChange Technologies"},
  {4,    0xe5, "High Density Devices AS"},
  {4,    0xe6, "Synopsys"},
  {4,    0x67, "Gigaram"},
  {4,    0x68, "Enigma Semiconductor Inc"},
  {4,    0xe9, "Century Micro Inc"},
  {4,    0xea, "Icera Semiconductor"},
  {4,    0x6b, "Mediaworks Integrated Systems"},
  {4,    0xec, "O'Neil Product Development"},
  {4,    0x6d, "Supreme Top Technology Ltd"},
  {4,    0x6e, "MicroDisplay Corporation"},
  {4,    0xef, "Team Group Inc"},
  {4,    0x70, "Sinett Corporation"},
  {4,    0xf1, "Toshiba Corporation"},
  {4,    0xf2, "Tensilica"},
  {4,    0x73, "SiRF Technology"},
  {4,    0xf4, "Bacoc Inc"},
  {4,    0x75, "SMaL Camera Technologies"},
  {4,    0x76, "Thomson SC"},
  {4,    0xf7, "Airgo Networks"},
  {4,    0xf8, "Wisair Ltd"},
  {4,    0x79, "SigmaTel"},
  {4,    0x7a, "Arkados"},
  {4,    0xfb, "Compete IT gmbH Co KG"},
  {4,    0x7c, "Eudar Technology Inc"},
  {4,    0xfd, "Focus Enhancements"},
  {4,    0xfe, "Xyratex"},

  //
  // BANK 6
  //
  {5,    0x01, "Specular Networks"},
  {5,    0x02, "Patriot Memory (PDP Systems)"},
  {5,    0x83, "U-Chip Technology Corp"},
  {5,    0x04, "Silicon Optix"},
  {5,    0x85, "Greenfield Networks"},
  {5,    0x86, "CompuRAM GmbH"},
  {5,    0x07, "Stargen Inc"},
  {5,    0x08, "NetCell Corporation"},
  {5,    0x89, "Excalibrus Technologies Ltd"},
  {5,    0x8a, "SCM Microsystems"},
  {5,    0x0b, "Xsigo Systems Inc"},
  {5,    0x8c, "CHIPS & Systems Inc"},
  {5,    0x0d, "Tier 1 Multichip Solutions"},
  {5,    0x0e, "CWRL Labs"},
  {5,    0x8f, "Teradici"},
  {5,    0x10, "Gigaram Inc"},
  {5,    0x91, "g2 Microsystems"},
  {5,    0x92, "PowerFlash Semiconductor"},
  {5,    0x13, "P.A. Semi Inc"},
  {5,    0x94, "NovaTech Solutions S.A."},
  {5,    0x15, "c2 Microsystems Inc"},
  {5,    0x16, "Level5 Networks"},
  {5,    0x97, "COS Memory AG"},
  {5,    0x98, "Innovasic Semiconductor"},
  {5,    0x19, "02IC Co Ltd"},
  {5,    0x1a, "Tabula Inc"},
  {5,    0x9b, "Crucial Technology"},
  {5,    0x1c, "Chelsio Communications"},
  {5,    0x9d, "Solarflare Communications"},
  {5,    0x9e, "Xambala Inc"},
  {5,    0x1f, "EADS Astrium"},
  {5,    0x20, "Terra Semiconductor Inc"},
  {5,    0xa1, "Imaging Works Inc"},
  {5,    0xa2, "Astute Networks Inc"},
  {5,    0x23, "Tzero"},
  {5,    0xa4, "Emulex"},
  {5,    0x25, "Power-One"},
  {5,    0x26, "Pulse~LINK Inc"},
  {5,    0xa7, "Hon Hai Precision Industry"},
  {5,    0xa8, "White Rock Networks Inc"},
  {5,    0x29, "Telegent Systems USA Inc"},
  {5,    0x2a, "Atrua Technologies Inc"},
  {5,    0xab, "Acbel Polytech Inc"},
  {5,    0x2c, "eRide Inc"},
  {5,    0xad, "ULi Electronics Inc"},
  {5,    0xae, "Magnum Semiconductor Inc"},
  {5,    0x2f, "neoOne Technology Inc"},
  {5,    0xb0, "Connex Technology Inc"},
  {5,    0x31, "Stream Processors Inc"},
  {5,    0x32, "Focus Enhancements"},
  {5,    0xb3, "Telecis Wireless Inc"},
  {5,    0x34, "uNav Microelectronics"},
  {5,    0xb5, "Tarari Inc"},
  {5,    0xb6, "Ambric Inc"},
  {5,    0x37, "Newport Media Inc"},
  {5,    0x38, "VMTS"},
  {5,    0xb9, "Enuclia Semiconductor Inc"},
  {5,    0xba, "Virtium Technology Inc"},
  {5,    0x3b, "Solid State System Co Ltd"},
  {5,    0xbc, "Kian Tech LLC"},
  {5,    0x3d, "Artimi"},
  {5,    0x3e, "Power Quotient International"},
  {5,    0xbf, "Avago Technologies"},
  {5,    0x40, "ADTechnology"},
  {5,    0xc1, "Sigma Designs"},
  {5,    0xc2, "SiCortex Inc"},
  {5,    0x43, "Ventura Technology Group"},
  {5,    0xc4, "eASIC"},
  {5,    0x45, "M.H.S. SAS"},
  {5,    0x46, "Micro Star International"},
  {5,    0xc7, "Rapport Inc"},
  {5,    0xc8, "Makway International"},
  {5,    0x49, "Broad Reach Engineering Co"},
  {5,    0x4a, "Semiconductor Mfg Intl Corp"},
  {5,    0xcb, "SiConnect"},
  {5,    0x4c, "FCI USA Inc"},
  {5,    0xcd, "Validity Sensors"},
  {5,    0xce, "Coney Technology Co Ltd"},
  {5,    0x4f, "Spans Logic"},
  {5,    0xd0, "Neterion Inc"},
  {5,    0x51, "Qimonda"},
  {5,    0x52, "New Japan Radio Co Ltd"},
  {5,    0xd3, "Velogix"},
  {5,    0x54, "Montalvo Systems"},
  {5,    0xd5, "iVivity Inc"},
  {5,    0xd6, "Walton Chaintech"},
  {5,    0x57, "AENEON"},
  {5,    0x58, "Lorom Industrial Co Ltd"},
  {5,    0xd9, "Radiospire Networks"},
  {5,    0xda, "Sensio Technologies Inc"},
  {5,    0x5b, "Nethra Imaging"},
  {5,    0xdc, "Hexon Technology Pte Ltd"},
  {5,    0x5d, "CompuStocx (CSX)"},
  {5,    0x5e, "Methode Electronics Inc"},
  {5,    0xdf, "Connect One Ltd"},
  {5,    0xe0, "Opulan Technologies"},
  {5,    0x61, "Septentrio NV"},
  {5,    0x62, "Goldenmars Technology Inc"},
  {5,    0xe3, "Kreton Corporation"},
  {5,    0x64, "Cochlear Ltd"},
  {5,    0xe5, "Altair Semiconductor"},
  {5,    0xe6, "NetEffect Inc"},
  {5,    0x67, "Spansion Inc"},
  {5,    0x68, "Taiwan Semiconductor Mfg"},
  {5,    0xe9, "Emphany Systems Inc"},
  {5,    0xea, "ApaceWave Technologies"},
  {5,    0x6b, "Mobilygen Corporation"},
  {5,    0xec, "Tego"},
  {5,    0x6d, "Cswitch Corporation"},
  {5,    0x6e, "Haier (Beijing) IC Design Co"},
  {5,    0xef, "MetaRAM"},
  {5,    0x70, "Axel Electronics Co Ltd"},
  {5,    0xf1, "Tilera Corporation"},
  {5,    0xf2, "Aquantia"},
  {5,    0x73, "Vivace Semiconductor"},
  {5,    0xf4, "Redpine Signals"},
  {5,    0x75, "Octalica"},
  {5,    0x76, "InterDigital Communications"},
  {5,    0xf7, "Avant Technology"},
  {5,    0xf8, "Asrock Inc"},
  {5,    0x79, "Availink"},
  {5,    0x7a, "Quartics Inc"},
  {5,    0xfb, "Element CXI"},
  {5,    0x7c, "Innovaciones Microelectronicas"},
  {5,    0xfd, "VeriSilicon Microelectronics"},
  {5,    0xfe, "W5 Networks"},

  //
  // BANK 7
  //
  {6,    0x01, "MOVEKING"},
  {6,    0x02, "Mavrix Technology Inc"},
  {6,    0x83, "CellGuide Ltd"},
  {6,    0x04, "Faraday Technology"},
  {6,    0x85, "Diablo Technologies Inc"},
  {6,    0x86, "Jennic"},
  {6,    0x07, "Octasic"},
  {6,    0x08, "Molex Incorporated"},
  {6,    0x89, "3Leaf Networks"},
  {6,    0x8a, "Bright Micron Technology"},
  {6,    0x0b, "Netxen"},
  {6,    0x8c, "NextWave Broadband Inc"},
  {6,    0x0d, "DisplayLink"},
  {6,    0x0e, "ZMOS Technology"},
  {6,    0x8f, "Tec-Hill"},
  {6,    0x10, "Multigig Inc"},
  {6,    0x91, "Amimon"},
  {6,    0x92, "Euphonic Technologies Inc"},
  {6,    0x13, "BRN Phoenix"},
  {6,    0x94, "InSilica"},
  {6,    0x15, "Ember Corporation"},
  {6,    0x16, "Avexir Technologies Corporation"},
  {6,    0x97, "Echelon Corporation"},
  {6,    0x98, "Edgewater Computer Systems"},
  {6,    0x19, "XMOS Semiconductor Ltd"},
  {6,    0x1a, "GENUSION Inc"},
  {6,    0x9b, "Memory Corp NV"},
  {6,    0x1c, "SiliconBlue Technologies"},
  {6,    0x9d, "Rambus Inc"},
  {6,    0x9e, "Andes Technology Corporation"},
  {6,    0x1f, "Coronis Systems"},
  {6,    0x20, "Achronix Semiconductor"},
  {6,    0xa1, "Siano Mobile Silicon Ltd"},
  {6,    0xa2, "Semtech Corporation"},
  {6,    0x23, "Pixelworks Inc"},
  {6,    0xa4, "Gaisler Research AB"},
  {6,    0x25, "Teranetics"},
  {6,    0x26, "Toppan Printing Co Ltd"},
  {6,    0xa7, "Kingxcon"},
  {6,    0xa8, "Silicon Integrated Systems"},
  {6,    0x29, "I-O Data Device Inc"},
  {6,    0x2a, "NDS Americas Inc"},
  {6,    0xab, "Solomon Systech Limited"},
  {6,    0x2c, "On Demand Microelectronics"},
  {6,    0xad, "Amicus Wireless Inc"},
  {6,    0xae, "SMARDTV SNC"},
  {6,    0x2f, "Comsys Communication Ltd"},
  {6,    0xb0, "Movidia Ltd"},
  {6,    0x31, "Javad GNSS Inc"},
  {6,    0x32, "Montage Technology Group"},
  {6,    0xb3, "Trident Microsystems"},
  {6,    0x34, "Super Talent"},
  {6,    0xb5, "Optichron Inc"},
  {6,    0xb6, "Future Waves UK Ltd"},
  {6,    0x37, "SiBEAM Inc"},
  {6,    0x38, "InicoreInc"},
  {6,    0xb9, "Virident Systems"},
  {6,    0xba, "M2000 Inc"},
  {6,    0x3b, "ZeroG Wireless Inc"},
  {6,    0xbc, "Gingle Technology Co Ltd"},
  {6,    0x3d, "Space Micro Inc"},
  {6,    0x3e, "Wilocity"},
  {6,    0xbf, "Novafora Inc"},
  {6,    0x40, "iKoa Corporation"},
  {6,    0xc1, "ASint Technology"},
  {6,    0xc2, "Ramtron"},
  {6,    0x43, "Plato Networks Inc"},
  {6,    0xc4, "IPtronics AS"},
  {6,    0x45, "Infinite-Memories"},
  {6,    0x46, "Parade Technologies Inc"},
  {6,    0xc7, "Dune Networks"},
  {6,    0xc8, "GigaDevice Semiconductor"},
  {6,    0x49, "Modu Ltd"},
  {6,    0x4a, "CEITEC"},
  {6,    0xcb, "Northrop Grumman"},
  {6,    0x4c, "XRONET Corporation"},
  {6,    0xcd, "Sicon Semiconductor AB"},
  {6,    0xce, "Atla Electronics Co Ltd"},
  {6,    0x4f, "TOPRAM Technology"},
  {6,    0xd0, "Silego Technology Inc"},
  {6,    0x51, "Kinglife"},
  {6,    0x52, "Ability Industries Ltd"},
  {6,    0xd3, "Silicon Power Computer & Communications"},
  {6,    0x54, "Augusta Technology Inc"},
  {6,    0xd5, "Nantronics Semiconductors"},
  {6,    0xd6, "Hilscher Gesellschaft"},
  {6,    0x57, "Quixant Ltd"},
  {6,    0x58, "Percello Ltd"},
  {6,    0xd9, "NextIO Inc"},
  {6,    0xda, "Scanimetrics Inc"},
  {6,    0x5b, "FS-Semi Company Ltd"},
  {6,    0xdc, "Infinera Corporation"},
  {6,    0x5d, "SandForce Inc"},
  {6,    0x5e, "Lexar Media"},
  {6,    0xdf, "Teradyne Inc"},
  {6,    0xe0, "Memory Exchange Corp"},
  {6,    0x61, "Suzhou Smartek Electronics"},
  {6,    0x62, "Avantium Corporation"},
  {6,    0xe3, "ATP Electronics Inc"},
  {6,    0x64, "Valens Semiconductor Ltd"},
  {6,    0xe5, "Agate Logic Inc"},
  {6,    0xe6, "Netronome"},
  {6,    0x67, "Zenverge Inc"},
  {6,    0x68, "N-trig Ltd"},
  {6,    0xe9, "SanMax Technologies Inc"},
  {6,    0xea, "Contour Semiconductor Inc"},
  {6,    0x6b, "TwinMOS"},
  {6,    0xec, "Silicon Systems Inc"},
  {6,    0x6d, "V-Color Technology Inc"},
  {6,    0x6e, "Certicom Corporation"},
  {6,    0xef, "JSC ICC Milandr"},
  {6,    0x70, "PhotoFast Global Inc"},
  {6,    0xf1, "InnoDisk Corporation"},
  {6,    0xf2, "Muscle Power"},
  {6,    0x73, "Energy Micro"},
  {6,    0xf4, "Innofidei"},
  {6,    0x75, "CopperGate Communications"},
  {6,    0x76, "Holtek Semiconductor Inc"},
  {6,    0xf7, "Myson Century Inc"},
  {6,    0xf8, "FIDELIX"},
  {6,    0x79, "Red Digital Cinema"},
  {6,    0x7a, "Densbits Technology"},
  {6,    0xfb, "Zempro"},
  {6,    0x7c, "MoSys"},
  {6,    0xfd, "Provigent"},
  {6,    0xfe, "Triad Semiconductor Inc"},

  //
  // BANK 8
  //
  {7,    0x01, "Siklu Communication Ltd"},
  {7,    0x02, "A Force Manufacturing Ltd"},
  {7,    0x83, "Strontium"},
  {7,    0x04, "ALi Corp (Abilis Systems)"},
  {7,    0x85, "Siglead Inc"},
  {7,    0x86, "Ubicom Inc"},
  {7,    0x07, "Unifosa Corporation"},
  {7,    0x08, "Stretch Inc"},
  {7,    0x89, "Lantiq Deutschland GmbH"},
  {7,    0x8a, "Visipro"},
  {7,    0x0b, "EKMemory"},
  {7,    0x8c, "Microelectronics Institute ZTE"},
  {7,    0x0d, "u-blox AG"},
  {7,    0x0e, "Carry Technology Co Ltd"},
  {7,    0x8f, "Nokia"},
  {7,    0x10, "King Tiger Technology"},
  {7,    0x91, "Sierra Wireless"},
  {7,    0x92, "HT Micron"},
  {7,    0x13, "Albatron Technology Co Ltd"},
  {7,    0x94, "Leica Geosystems AG"},
  {7,    0x15, "BroadLight"},
  {7,    0x16, "AEXEA"},
  {7,    0x97, "ClariPhy Communications Inc"},
  {7,    0x98, "Green Plug"},
  {7,    0x19, "Design Art Networks"},
  {7,    0x1a, "Mach Xtreme Technology Ltd"},
  {7,    0x9b, "ATO Solutions Co Ltd"},
  {7,    0x1c, "Ramsta"},
  {7,    0x9d, "Greenliant Systems Ltd"},
  {7,    0x9e, "Teikon"},
  {7,    0x1f, "Antec Hadron"},
  {7,    0x20, "NavCom Technology Inc"},
  {7,    0xa1, "Shanghai Fudan Microelectronics"},
  {7,    0xa2, "Calxeda Inc"},
  {7,    0x23, "JSC EDC Electronics"},
  {7,    0xa4, "Kandit Technology Co Ltd"},
  {7,    0x25, "Ramos Technology"},
  {7,    0x26, "Goldenmars Technology"},
  {7,    0xa7, "XeL Technology Inc"},
  {7,    0xa8, "Newzone Corporation"},
  {7,    0x29, "ShenZhen MercyPower Tech"},
  {7,    0x2a, "Nanjing Yihuo Technology"},
  {7,    0xab, "Nethra Imaging Inc"},
  {7,    0x2c, "SiTel Semiconductor BV"},
  {7,    0xad, "SolidGear Corporation"},
  {7,    0xae, "Topower Computer Ind Co Ltd"},
  {7,    0x2f, "Wilocity"},
  {7,    0xb0, "Profichip GmbH"},
  {7,    0x31, "Gerad Technologies"},
  {7,    0x32, "Ritek Corporation"},
  {7,    0xb3, "Gomos Technology Limited"},
  {7,    0x34, "Memoright Corporation"},
  {7,    0xb5, "D-Broad Inc"},
  {7,    0xb6, "HiSilicon Technologies"},
  {7,    0x37, "Syndiant Inc."},
  {7,    0x38, "Enverv Inc"},
  {7,    0xb9, "Cognex"},
  {7,    0xba, "Xinnova Technology Inc"},
  {7,    0x3b, "Ultron AG"},
  {7,    0xbc, "Concord Idea Corporation"},
  {7,    0x3d, "AIM Corporation"},
  {7,    0x3e, "Lifetime Memory Products"},
  {7,    0xbf, "Ramsway"},
  {7,    0x40, "Recore Systems B.V."},
  {7,    0xc1, "Haotian Jinshibo Science Tech"},
  {7,    0xc2, "Being Advanced Memory"},
  {7,    0x43, "Adesto Technologies"},
  {7,    0xc4, "Giantec Semiconductor Inc"},
  {7,    0x45, "HMD Electronics AG"},
  {7,    0x46, "Gloway International (HK)"},
  {7,    0xc7, "Kingcore"},
  {7,    0xc8, "Anucell Technology Holding"},
  {7,    0x49, "Accord Software & Systems Pvt. Ltd"},
  {7,    0x4a, "Active-Semi Inc"},
  {7,    0xcb, "Denso Corporation"},
  {7,    0x4c, "TLSI Inc"},
  {7,    0xcd, "Qidan"},
  {7,    0xce, "Mustang"},
  {7,    0x4f, "Orca Systems"},
  {7,    0xd0, "Passif Semiconductor"},
  {7,    0x51, "GigaDevice Semiconductor (Beijing) Inc"},
  {7,    0x52, "Memphis Electronic"},
  {7,    0xd3, "Beckhoff Automation GmbH"},
  {7,    0x54, "Harmony Semiconductor Corp"},
  {7,    0xd5, "Air Computers SRL"},
  {7,    0xd6, "TMT Memory"},
  {7,    0x57, "Eorex Corporation"},
  {7,    0x58, "Xingtera"},
  {7,    0xd9, "Netsol"},
  {7,    0xda, "Bestdon Technology Co Ltd"},
  {7,    0x5b, "Baysand Inc"},
  {7,    0xdc, "Uroad Technology Co Ltd"},
  {7,    0x5d, "Wilk Elektronik S.A."},
  {7,    0x5e, "AAI"},
  {7,    0xdf, "Harman"},
  {7,    0xe0, "Berg Microelectronics Inc"},
  {7,    0x61, "ASSIA Inc"},
  {7,    0x62, "Visiontek Products LLC"},
  {7,    0xe3, "OCMEMORY"},
  {7,    0x64, "Welink Solution Inc"},
  {7,    0xe5, "Shark Gaming"},
  {7,    0xe6, "Avalanche Technology"},
  {7,    0x67, "R&D Center ELVEES OJSC"},
  {7,    0x68, "KingboMars Technology Co Ltd"},
  {7,    0xe9, "High Bridge Solutions Industria Eletronica"},
  {7,    0xea, "Transcend Technology Co Ltd"},
  {7,    0x6b, "Everspin Technologies"},
  {7,    0xec, "Hon-Hai Precision"},
  {7,    0x6d, "Smart Storage Systems"},
  {7,    0x6e, "Toumaz Group"},
  {7,    0xef, "Zentel Electronics Corporation"},
  {7,    0x70, "Panram International Corporation"},
  {7,    0xf1, "Silicon Space Technology"},
  {7,    0xf2, "LITE-ON IT Corporation"},
  {7,    0x73, "Inuitive"},
  {7,    0xf4, "HMicro"},
  {7,    0x75, "BittWare Inc"},
  {7,    0x76, "GLOBALFOUNDRIES"},
  {7,    0xf7, "ACPI Digital Co Ltd"},
  {7,    0xf8, "Annapurna Labs"},
  {7,    0x79, "AcSiP Technology Corporation"},
  {7,    0x7a, "Idea! Electronic Systems"},
  {7,    0xfb, "Gowe Technology Co Ltd"},
  {7,    0x7c, "Hermes Testing Solutions Inc"},
  {7,    0xfd, "Positivo BGH"},
  {7,    0xfe, "Intelligence Silicon Technology"},

  //
  // BANK 9
  //
  {8,    0x01, "3D PLUS"},
  {8,    0x02, "Diehl Aerospace"},
  {8,    0x83, "Fairchild"},
  {8,    0x04, "Mercury Systems"},
  {8,    0x85, "Sonics Inc"},
  {8,    0x86, "Emerson Machine Automation"},
  {8,    0x07, "Shenzhen Jinge Information Co Ltd"},
  {8,    0x08, "SCWW"},
  {8,    0x89, "Silicon Motion Inc"},
  {8,    0x8a, "Anurag"},
  {8,    0x0b, "King Kong"},
  {8,    0x8c, "FROM30 Co Ltd"},
  {8,    0x0d, "Gowin Semiconductor Corp"},
  {8,    0x0e, "Fremont Micro Devices Ltd"},
  {8,    0x8f, "Ericsson Modems"},
  {8,    0x10, "Exelis"},
  {8,    0x91, "Satixfy Ltd"},
  {8,    0x92, "Galaxy Microsystems Ltd"},
  {8,    0x13, "Gloway International Co Ltd"},
  {8,    0x94, "Lab"},
  {8,    0x15, "Smart Energy Instruments"},
  {8,    0x16, "Approved Memory Corporation"},
  {8,    0x97, "Axell Corporation"},
  {8,    0x98, "Essencore Limited"},
  {8,    0x19, "Phytium"},
  {8,    0x1a, "Xi'an UnilC Semiconductors Co Ltd"},
  {8,    0x9b, "Ambiq Micro"},
  {8,    0x1c, "eveRAM Technology Inc"},
  {8,    0x9d, "Infomax"},
  {8,    0x9e, "Butterfly Network Inc"},
  {8,    0x1f, "Shenzhen City Gcai Electronics"},
  {8,    0x20, "Stack Devices Corporation"},
  {8,    0xa1, "ADK Media Group"},
  {8,    0xa2, "TSP Global Co Ltd"},
  {8,    0x23, "HighX"},
  {8,    0xa4, "Shenzhen Elicks Technology"},
  {8,    0x25, "ISSI/Chingis"},
  {8,    0x26, "Google Inc"},
  {8,    0xa7, "Dasima International Development"},
  {8,    0xa8, "Leahkinn Technology Limited"},
  {8,    0x29, "HIMA Paul Hildebrandt GmbH Co KG"},
  {8,    0x2a, "Keysight Technologies"},
  {8,    0xab, "Techcomp International (Fastable)"},
  {8,    0x2c, "Ancore Technology Corporation"},
  {8,    0xad, "Nuvoton"},
  {8,    0xae, "Korea Uhbele International Group Ltd"},
  {8,    0x2f, "Ikegami Tsushinki Co Ltd"},
  {8,    0xb0, "RelChip Inc"},
  {8,    0x31, "Baikal Electronics"},
  {8,    0x32, "Nemostech Inc"},
  {8,    0xb3, "Memorysolution GmbH"},
  {8,    0x34, "Silicon Integrated Systems Corporation"},
  {8,    0xb5, "Xiede"},
  {8,    0xb6, "BRC"},
  {8,    0x37, "Flash Chi"},
  {8,    0x38, "Jone"},
  {8,    0xb9, "GCT Semiconductor Inc"},
  {8,    0xba, "Hong Kong Zetta Device Technology"},
  {8,    0x3b, "Unimemory Technology(s) Pte Ltd"},
  {8,    0xbc, "Cuso"},
  {8,    0x3d, "Kuso"},
  {8,    0x3e, "Uniquify Inc"},
  {8,    0xbf, "Skymedi Corporation"},
  {8,    0x40, "Core Chance Co Ltd"},
  {8,    0xc1, "Tekism Co Ltd"},
  {8,    0xc2, "Seagate Technology PLC"},
  {8,    0x43, "Hong Kong Gaia Group Co Limited"},
  {8,    0xc4, "Gigacom Semiconductor LLC"},
  {8,    0x45, "V2 Technologies"},
  {8,    0x46, "TLi"},
  {8,    0xc7, "Neotion"},
  {8,    0xc8, "Lenovo"},
  {8,    0x49, "Shenzhen Zhongteng Electronic Corp Ltd"},
  {8,    0x4a, "Compound Photonics"},
  {8,    0xcb, "in2H2 inc"},
  {8,    0x4c, "Shenzhen Pango Microsystems Co Ltd"},
  {8,    0xcd, "Vasekey"},
  {8,    0xce, "Cal-Comp Industria de Semicondutores"},
  {8,    0x4f, "Eyenix Co Ltd"},
  {8,    0xd0, "Heoriady"},
  {8,    0x51, "Accelerated Memory Production Inc"},
  {8,    0x52, "INVECAS Inc"},
  {8,    0xd3, "AP Memory"},
  {8,    0x54, "Douqi Technology"},
  {8,    0xd5, "Etron Technology Inc"},
  {8,    0xd6, "Indie Semiconductor"},
  {8,    0x57, "Socionext Inc"},
  {8,    0x58, "HGST"},
  {8,    0xd9, "EVGA"},
  {8,    0xda, "Audience Inc"},
  {8,    0x5b, "EpicGear"},
  {8,    0xdc, "Vitesse Enterprise Co"},
  {8,    0x5d, "Foxtronn International Corporation"},
  {8,    0x5e, "Bretelon Inc"},
  {8,    0xdf, "Graphcore"},
  {8,    0xe0, "Eoplex Inc"},
  {8,    0x61, "MaxLinear Inc"},
  {8,    0x62, "ETA Devices"},
  {8,    0xe3, "LOKI"},
  {8,    0x64, "IMS Electronics Co Ltd"},
  {8,    0xe5, "Dosilicon Co Ltd"},
  {8,    0xe6, "Dolphin Integration"},
  {8,    0x67, "Shenzhen Mic Electronics Technology"},
  {8,    0x68, "Boya Microelectronics Inc"},
  {8,    0xe9, "Geniachip (Roche)"},
  {8,    0xea, "Axign"},
  {8,    0x6b, "Kingred Electronic Technology Ltd"},
  {8,    0xec, "Chao Yue Zhuo Computer Business Dept."},
  {8,    0x6d, "Guangzhou Si Nuo Electronic Technology"},
  {8,    0x6e, "Crocus Technology Inc"},
  {8,    0xef, "Creative Chips GmbH"},
  {8,    0x70, "GE Aviation Systems LLC"},
  {8,    0xf1, "Asgard"},
  {8,    0xf2, "Good Wealth Technology Ltd"},
  {8,    0x73, "TriCor Technologies"},
  {8,    0xf4, "Nova-Systems GmbH"},
  {8,    0x75, "JUHOR"},
  {8,    0x76, "Zhuhai Douke Commerce Co Ltd"},
  {8,    0xf7, "DSL Memory"},
  {8,    0xf8, "Anvo-Systems Dresden GmbH"},
  {8,    0x79, "Realtek"},
  {8,    0x7a, "AltoBeam"},
  {8,    0xfb, "Wave Computing"},
  {8,    0x7c, "Beijing TrustNet Technology Co Ltd"},
  {8,    0xfd, "Innovium Inc"},
  {8,    0xfe, "Starsway Technology Limited"},

  //
  // BANK 10
  //
  {9,    0x01, "Weltronics Co LTD"},
  {9,    0x02, "VMware Inc"},
  {9,    0x83, "Hewlett Packard Enterprise"},
  {9,    0x04, "INTENSO"},
  {9,    0x85, "Puya Semiconductor"},
  {9,    0x86, "MEMORFI"},
  {9,    0x07, "MSC Technologies GmbH"},
  {9,    0x08, "Txrui"},
  {9,    0x89, "SiFive Inc"},
  {9,    0x8a, "Spreadtrum Communications"},
  {9,    0x0b, "XTX Technology Limited"},
  {9,    0x8c, "UMAX Technology"},
  {9,    0x0d, "Shenzhen Yong Sheng Technology"},
  {9,    0x0e, "SNOAMOO (Shenzhen Kai Zhuo Yue)"},
  {9,    0x8f, "Daten Tecnologia LTDA"},
  {9,    0x10, "Shenzhen XinRuiYan Electronics"},
  {9,    0x91, "Eta Compute"},
  {9,    0x92, "Energous"},
  {9,    0x13, "Raspberry Pi Trading Ltd"},
  {9,    0x94, "Shenzhen Chixingzhe Tech Co Ltd"},
  {9,    0x15, "Silicon Mobility"},
  {9,    0x16, "IQ-Analog Corporation"},
  {9,    0x97, "Uhnder Inc"},
  {9,    0x98, "Impinj"},
  {9,    0x19, "DEPO Computers"},
  {9,    0x1a, "Nespeed Sysems"},
  {9,    0x9b, "Yangtze Memory Technologies Co Ltd"},
  {9,    0x1c, "MemxPro Inc"},
  {9,    0x9d, "Tammuz Co Ltd"},
  {9,    0x9e, "Allwinner Technology"},
  {9,    0x1f, "Shenzhen City Futian District Qing Xuan Tong Computer Trading Firm"},
  {9,    0x20, "XMC"},
  {9,    0xa1, "Teclast"},
  {9,    0xa2, "Maxsun"},
  {9,    0x23, "Haiguang Integrated Circuit Design"},
  {9,    0xa4, "RamCENTER Technology"},
  {9,    0x25, "Phison Electronics Corporation"},
  {9,    0x26, "Guizhou Huaxintong Semi-Conductor"},
  {9,    0xa7, "Network Intelligence"},
  {9,    0xa8, "Continental Technology (Holdings)"},
  {9,    0x29, "Guangzhou Huayan Suning Electronic"},
  {9,    0x2a, "Guangzhou Zhouji Electronic Co Ltd"},
  {9,    0xab, "Shenzhen Giant Hui Kang Tech Co Ltd"},
  {9,    0x2c, "Shenzhen Yilong Innovative Co Ltd"},
  {9,    0xad, "Neo Forza"},
  {9,    0xae, "Lyontek Inc"},
  {9,    0x2f, "Shanghai Kuxin Microelectronics Ltd"},
  {9,    0xb0, "Shenzhen Larix Technology Co Ltd"},
  {9,    0x31, "Qbit Semiconductor Ltd"},
  {9,    0x32, "Insignis Technology Corporation"},
  {9,    0xb3, "Lanson Memory Co Ltd"},
  {9,    0x34, "Shenzhen Superway Electronics Co Ltd "},
  {9,    0xb5, "Canaan-Creative Co Ltd"},
  {9,    0xb6, "Black Diamond Memory"},
  {9,    0x37, "Shenzhen City Parker Baking Electronics"},
  {9,    0x38, "Shenzhen Baihong Technology Co Ltd"},
  {9,    0xb9, "GEO Semiconductors"},
  {9,    0xba, "OCPC"},
  {9,    0x3b, "Artery Technology Co Ltd"},
  {9,    0xbc, "Jinyu"},
  {9,    0x3d, "ShenzhenYing Chi Technology Development"},
  {9,    0x3e, "Shenzhen Pengcheng Xin Technology"},
  {9,    0xbf, "Pegasus Semiconductor (Shanghai) Co"},
  {9,    0x40, "Mythic Inc"},
  {9,    0xc1, "Elmos Semiconductor AG"},
  {9,    0xc2, "Kllisre"},
  {9,    0x43, "Shenzhen Winconway Technology"},
  {9,    0xc4, "Shenzhen Xingmem Technology Corp"},
  {9,    0x45, "Gold Key Technology Co Ltd"},
  {9,    0x46, "Habana Labs Ltd"},
  {9,    0xc7, "Hoodisk Electronics Co Ltd"},
  {9,    0xc8, "SemsoTai (SZ) Technology Co Ltd"},
  {9,    0x49, "OM Nanotech Pvt. Ltd"},
  {9,    0x4a, "Shenzhen Zhifeng Weiye Technology"},
  {9,    0xcb, "Xinshirui (Shenzhen) Electronics Co"},
  {9,    0x4c, "Guangzhou Zhong Hao Tian Electronic"},
  {9,    0xcd, "Shenzhen Longsys Electronics Co Ltd"},
  {9,    0xce, "Deciso B.V."},
  {9,    0x4f, "Puya Semiconductor (Shenzhen)"},
  {9,    0xd0, "Shenzhen Veineda Technology Co Ltd"},
  {9,    0x51, "Antec Memory"},
  {9,    0x52, "Cortus SAS"},
  {9,    0xd3, "Dust Leopard"},
  {9,    0x54, "MyWo AS"},
  {9,    0xd5, "J&A Information Inc"},
  {9,    0xd6, "Shenzhen JIEPEI Technology Co Ltd"},
  {9,    0x57, "Heidelberg University"},
  {9,    0x58, "Flexxon PTE Ltd"},
  {9,    0xd9, "Wiliot"},
  {9,    0xda, "Raysun Electronics International Ltd"},
  {9,    0x5b, "Aquarius Production Company LLC"},
  {9,    0xdc, "MACNICA DHW LTDA"},
  {9,    0x5d, "Intelimem"},
  {9,    0x5e, "Zbit Semiconductor Inc"},
  {9,    0xdf, "Shenzhen Technology Co Ltd"},
  {9,    0xe0, "Signalchip"},
  {9,    0x61, "Shenzen Recadata Storage Technology"},
  {9,    0x62, "Hyundai Technology"},
  {9,    0xe3, "Shanghai Fudi Investment Development"},
  {9,    0x64, "Aixi Technology"},
  {9,    0xe5, "Tecon MT"},
  {9,    0xe6, "Onda Electric Co Ltd"},
  {9,    0x67, "Jinshen"},
  {9,    0x68, "Kimtigo Semiconductor (HK) Limited"},
  {9,    0xe9, "IIT Madras"},
  {9,    0xea, "Shenshan (Shenzhen) Electronic"},
  {9,    0x6b, "Hefei Core Storage Electronic Limited"},
  {9,    0xec, "Colorful Technology Ltd"},
  {9,    0x6d, "Visenta (Xiamen) Technology Co Ltd"},
  {9,    0x6e, "Roa Logic BV"},
  {9,    0xef, "NSITEXE Inc"},
  {9,    0x70, "Hong Kong Hyunion Electronics"},
  {9,    0xf1, "ASK Technology Group Limited"},
  {9,    0xf2, "GIGA-BYTE Technology Co Ltd"},
  {9,    0x73, "Terabyte Co Ltd"},
  {9,    0xf4, "Hyundai Inc"},
  {9,    0x75, "EXCELERAM"},
  {9,    0x76, "PsiKick"},
  {9,    0xf7, "Netac Technology Co Ltd"},
  {9,    0xf8, "PCCOOLER"},
  {9,    0x79, "Jiangsu Huacun Electronic Technology"},
  {9,    0x7a, "Shenzhen Micro Innovation Industry"},
  {9,    0xfb, "Beijing Tongfang Microelectronics Co"},
  {9,    0x7c, "XZN Storage Technology"},
  {9,    0xfd, "ChipCraft Sp. z.o.o"},
  {9,    0xfe, "ALLFLASH Technology Limited"},

  //
  // BANK 11
  //
  {10,   0x01, "Foerd Technology Co Ltd"},
  {10,   0x02, "KingSpec"},
  {10,   0x83, "Codasip Ltd"},
  {10,   0x04, "SL Link Co Ltd"},
  {10,   0x85, "Shenzhen Kefu Technology Co Limited"},
  {10,   0x86, "Shenzhen ZST Electronics Technology"},
  {10,   0x07, "Kyokuto Electronic Inc"},
  {10,   0x08, "Warrior Technology"},
  {10,   0x89, "TRINAMIC Motion Control GmbH & Co"},
  {10,   0x8a, "PixelDisplay Inc"},
  {10,   0x0b, "Shenzhen Futian District Bo Yueda Elec"},
  {10,   0x8c, "Richtek Power"},
  {10,   0x0d, "Shenzhen LianTeng Electronics Co Ltd"},
  {10,   0x0e, "AITC Memory"},
  {10,   0x8f, "UNIC Memory Technology Co Ltd"},
  {10,   0x10, "Shenzhen Huafeng Science Technology"},
  {10,   0x91, "ChangXin Memory Technologies Inc"},
  {10,   0x92, "Guangzhou Xinyi Heng Computer Trading Firm"},
  {10,   0x13, "SambaNova Systems"},
  {10,   0x94, "V-GEN"},
  {10,   0x15, "Jump Trading"},
  {10,   0x16, "Ampere Computing"},
  {10,   0x97, "Shenzhen Zhongshi Technology Co Ltd"},
  {10,   0x98, "Shenzhen Zhongtian Bozhong Technology"},
  {10,   0x19, "Tri-Tech International"},
  {10,   0x1a, "Silicon Intergrated Systems Corporation"},
  {10,   0x9b, "Shenzhen HongDingChen Information"},
  {10,   0x1c, "Plexton Holdings Limited"},
  {10,   0x9d, "AMS (Jiangsu Advanced Memory Semi)"},
  {10,   0x9e, "Wuhan Jing Tian Interconnected Tech Co"},
  {10,   0x1f, "Axia Memory Technology"},
  {10,   0x20, "Chipset Technology Holding Limited"},
  {10,   0xa1, "Shenzhen Xinshida Technology Co Ltd"},
  {10,   0xa2, "Shenzhen Chuangshifeida Technology"},
  {10,   0x23, "Guangzhou MiaoYuanJi Technology"},
  {10,   0xa4, "ADVAN Inc"},
  {10,   0x25, "Shenzhen Qianhai Weishengda Electronic Commerce Company Ltd"},
  {10,   0x26, "Guangzhou Guang Xie Cheng Trading"},
  {10,   0xa7, "StarRam International Co Ltd"},
  {10,   0xa8, "Shen Zhen XinShenHua Tech Co Ltd"},
  {10,   0x29, "UltraMemory Inc"},
  {10,   0x2a, "New Coastline Global Tech Industry Co"},
  {10,   0xab, "Sinker"},
  {10,   0x2c, "Diamond"},
  {10,   0xad, "PUSKILL"},
  {10,   0xae, "Guangzhou Hao Jia Ye Technology Co"},
  {10,   0x2f, "Ming Xin Limited"},
  {10,   0xb0, "Barefoot Networks"},
  {10,   0x31, "Biwin Semiconductor (HK) Co Ltd"},
  {10,   0x32, "UD INFO Corporation"},
  {10,   0xb3, "Trek Technology (S) PTE Ltd"},
  {10,   0x34, "Xiamen Kingblaze Technology Co Ltd"},
  {10,   0xb5, "Shenzhen Lomica Technology Co Ltd"},
  {10,   0xb6, "Nuclei System Technology Co Ltd"},
  {10,   0x37, "Wuhan Xun Zhan Electronic Technology"},
  {10,   0x38, "Shenzhen Ingacom Semiconductor Ltd"},
  {10,   0xb9, "Zotac Technology Ltd"},
  {10,   0xba, "Foxline"},
  {10,   0x3b, "Shenzhen Farasia Science Technology"},
  {10,   0xbc, "Efinix Inc"},
  {10,   0x3d, "Hua Nan San Xian Technology Co Ltd"},
  {10,   0x3e, "Goldtech Electronics Co Ltd"},
  {10,   0xbf, "Shanghai Han Rong Microelectronics Co"},
  {10,   0x40, "Shenzhen Zhongguang Yunhe Trading"},
  {10,   0xc1, "Smart Shine(QingDao) Microelectronics"},
  {10,   0xc2, "Thermaltake Technology Co Ltd"},
  {10,   0x43, "Shenzhen O'Yang Maile Technology Ltd"},
  {10,   0xc4, "UPMEM"},
  {10,   0x45, "Chun Well Technology Holding Limited"},
  {10,   0x46, "Astera Labs Inc"},
  {10,   0xc7, "VMEMORY Co Ltd"},
  {10,   0xc8, "Advantech Co Ltd"},
  {10,   0x49, "Chengdu Fengcai Electronic Technology"},
  {10,   0x4a, "The Boeing Company"},
  {10,   0xcb, "ThinCI Inc"},
  {10,   0x4c, "Ramonster Technology Co Ltd"},
  {10,   0xcd, "Wuhan Naonongmai Technology Co Ltd"},
  {10,   0xce, "Shenzhen Hui ShingTong Technology"},
  {10,   0x4f, "Yourlyon"},
  {10,   0xd0, "Fabu Technology"},
  {10,   0x51, "Shenzhen Yikesheng Technology Co Ltd"},
  {10,   0x52, "NOR-MEM"},
  {10,   0xd3, "Cervoz Co Ltd"},
  {10,   0x54, "Bitmain Technologies Inc."},
  {10,   0xd5, "Facebook Inc"},
  {10,   0xd6, "Shenzhen Longsys Electronics Co Ltd"},
  {10,   0x57, "Guangzhou Siye Electronic Technology"},
  {10,   0x58, "Silergy"},
  {10,   0xd9, "Adamway"},
  {10,   0xda, "PZG"},
  {10,   0x5b, "Shenzhen King Power Electronics"},
  {10,   0xdc, "Guangzhou ZiaoFu Tranding Co Ltd"},
  {10,   0x5d, "Shenzhen SKIHOTAR Semiconductor"},
  {10,   0x5e, "PulseRain Technology"},
  {10,   0xdf, "Seeker Technology Limited"},
  {10,   0xe0, "Shenzhen OSCOO Tech Co Ltd"},
  {10,   0x61, "Shenzhen Yze Technology Co Ltd"},
  {10,   0x62, "Shenzhen Jieshuo Electronic Commerce"},
  {10,   0xe3, "Gazda"},
  {10,   0x64, "Hua Wei Technology Co Ltd"},
  {10,   0xe5, "Esperanto Technologies"},
  {10,   0xe6, "JinSheng Electronic (Shenzhen) Co Ltd"},
  {10,   0x67, "Shenzhen Shi Bolunshuai Technology"},
  {10,   0x68, "Shanghai Rei Zuan Information Tech"},
  {10,   0xe9, "Fraunhofer IIS"},
  {10,   0xea, "Kandou Bus SA"},
  {10,   0x6b, "Acer"},
  {10,   0xec, "Artmem Technology Co Ltd"},
  {10,   0x6d, "Gstar Semiconductor Co Ltd"},
  {10,   0x6e, "ShineDisk"},
  {10,   0xef, "Shenzhen CHN Technology Co Ltd"},
  {10,   0x70, "UnionChip Semiconductor Co Ltd"},
  {10,   0xf1, "Tanbassh"},
  {10,   0xf2, "Shenzhen Tianyu Jieyun Intl Logistics"},
  {10,   0x73, "MCLogic Inc"},
  {10,   0xf4, "Eorex Corporation"},
  {10,   0x75, "Arm Technology (China) Co Ltd"},
  {10,   0x76, "Lexar Co Limited"},
  {10,   0xf7, "QinetiQ Group plc"},
  {10,   0xf8, "Exascend"},

  {0xff, 0xff, 0}
};
