<!--
 @file
 Tool to generate encoded source file for Catalog usage.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains 'Framework Code' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may not be
  modified, except as allowed by additional terms of your license agreement.

 @par Specification Reference:

 @par Glossary:
-->

CatalogDebug v0.6
===================================================

## System Requirement
---------------------------------------------------
1. Download and Install `Python 2.7 or 3.6`.
2. Add `Python 2.7 or 3.6` directory into system `path`.
3. Install portalocker by `pip install portalocker`

  | Compiler   | OS      | Support |
  | ---------- | ------- | ------- |
  | Python 2.7 | Windows | V       |
  | Python 2.7 | Ubuntu  | V       |
  | Python 2.7 | Mac     | V       |
  | Python 3.6 | Windows | V       |
  | Python 3.6 | Ubuntu  | V       |
  | Python 3.6 | Mac     | V       |


## Usage
---------------------------------------------------
> CatalogEncoder.py [-h] -I SampleOrigin.c -O SampleModify.c -X Sample.xml [-M Mode]   <BR>

- ```-h, --help```
  - Help user use the tool correctly

- ```-I INPUTFILE, --InputFile INPUTFILE```
  - File use normal format DEBUG macro ussage.

- ```-O OUTPUTFILE, --OutputFile OUTPUTFILE```
  - OutputFile replace normal format to catalog format DEBUG macro ussage by InputFile.

- ```-X XMLFILE, --XmlFile XMLFILE```
  - Follow NPK catalog xml setting rule, and assign every message UUID and record in xml.

- ```-M MODE, --Mode MODE```
  - HEX (Default)
    - Assign a HEX number as ID to a message dynamically.
    - SampleOrigin.c: DEBUG ((LEVEL, "Message %d %x\n", Arg0, Arg1));
    - SampleModify.c: DEBUG ((LEVEL, NULL, 2, 0x1001, Arg0, Arg1));

- ```-OD OUTPUTDEBUGFILE, --OutputDebugFile OUTPUTDEBUGFILE                              ```
  - It's designed for developer to debug InputFile format detail rule.
