/** @file
  File name:    MLMC.h
  Input File:   BXTM_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in MLMC.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/
#ifndef _MLMC_H_
#define _MLMC_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define MLM_CR_CONFIG_MLMC_REG                             0x00004F00
#ifndef ASM_INC
typedef union {
  struct {
    //
    //
    //               [list]
    //               [*]0: 4Ch
    //               [*]1: 8Ch
    //               [/list]
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX num_nm_channels : 1;
    //
    // Near memory size in GB:
    //               [list]
    //               [*]1: 1GB
    //               [*]2: 2GB
    //               [/list]
    //
    // Bits[2:1], RW, default = 0x1
    //
    UINTX nm_size_mb : 2;
    //
    // Watermark for when Astore starts to evict old translations.
    //
    // Bits[9:3], RW, default = 0x4
    //
    UINTX astore_low_wm : 7;
    //
    // TBD
    //
    // Bits[16:10], RW, default = 0x0
    //
    UINTX astore_rsvd_non_vc0 : 7;
    //
    // TBD
    //
    // Bits[23:17], RW, default = 0x0
    //
    UINTX tq_rsvd_non_vc0 : 7;
    //
    // [list]
    //               [*]0: 2LM
    //               [*]1: 1LM mode bypass MLM core logic
    //               [/list]
    //
    // Bits[24:24], RW, default = 0x1
    //
    UINTX cr_1lm_mode : 1;
    //
    //  [list]
    //                [*]0: exclusive 2LMDDR
    //                [*]1: inclusive 2LMDDR
    //                [*]2: inclusive 2LMSXP
    //                [*]3: Reserved
    //                [/list]
    //
    // Bits[26:25], RW, default = 0x0
    //
    UINTX cr_2lm_mode : 2;
    //
    // 4bit vector to identify active MLMCs:
    //              [list]
    //              [*]0: inactive
    //              [*]1: active
    //              [/list]
    //
    // Bits[30:27], RW, default = 0xF
    //
    UINTX mlm_controller_enable : 4;
    //
    // Specifies how many read request credits to give to B-Unit.
    //
    // Bits[33:31], RW, default = 0x2
    //
    UINTX pmi_max_bunit_rd_credits : 3;
    //
    // Specifies how many write request credits to give to B-Unit.
    //
    // Bits[36:34], RW, default = 0x2
    //
    UINTX pmi_max_bunit_wr_credits : 3;
    //
    // Specifies how many read return credits to give to each near memory D-Unit.
    //
    // Bits[39:37], RW, default = 0x4
    //
    UINTX pmi_max_nm_rd_ret_credits : 3;
    //
    // Specifies how many read return credits to give to each far memory D-Unit.
    //
    // Bits[42:40], RW, default = 0x4
    //
    UINTX pmi_max_fm_rd_ret_credits : 3;
    //
    // Set/cleared by Pcode. When set, causes MLMC to stop swapping. Dynamic.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX thermal_throttling_enabled : 1;
    //
    // Set/cleared by PSMI handler. When set, causes MLMC to stop swapping. Overrides
    // Disable_Swaps.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX psmi_mode_enabled : 1;
    //
    // Reserved bits
    //
    // Bits[63:45], RW, default = 0x0
    //
    UINTX reserved_0 : 19;
  } Bits;
  UINTX Data;
} MLM_CR_CONFIG_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_SWAP_PARAMS_MLMC_REG                        0x00004F08
#ifndef ASM_INC
typedef union {
  struct {
    //
    // First Miss2 currently our only supported policy.
    //
    // Bits[3:0], RW, default = 0x2
    //
    UINTX policy : 4;
    //
    // Max outstanding FM swap CL requests.
    //
    // Bits[7:4], RW, default = 0x4
    //
    UINTX swap_num_outstanding_cl_requests : 4;
    //
    // Intersector delay in MLM clocks.
    //
    // Bits[15:8], RW, default = 0x11
    //
    UINTX swap_inter_sector_delay : 8;
    //
    // Interswap delay in MLM clocks.
    //
    // Bits[25:16], RW, default = 0x10
    //
    UINTX swap_inter_swap_delay : 10;
    //
    // Reserved bits
    //
    // Bits[31:26], RW, default = 0x0
    //
    UINTX reserved_0 : 6;
  } Bits;
  UINTX Data;
} MLM_CR_SWAP_PARAMS_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_DEFEATURES_MLMC_REG                         0x00004F0C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Disable swapping. Static overrides all other swapping enables.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX disable_swaps : 1;
    //
    // Disable ondie tag store.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX disable_odts : 1;
    //
    // Disable ondie tag cache.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX disable_tc : 1;
    //
    // Disable pinning.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX disable_pinning : 1;
    //
    // Disable porous swapping.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX disable_porous_swap : 1;
    //
    // [list]
    //               [*]00: Expose SDT in MLMC 0
    //               [*]01: Expose SDT in MLMC 1
    //               [*]10: Expose SDT in MLMC 2
    //               [*]11: Expose SDT in MLMC 3
    //               [/list]
    //
    // Bits[6:5], RW, default = 0x0
    //
    UINTX mlm_sdt_expose_target : 2;
    //
    // Polled by SDT Expose clients to determine expose completion.
    //
    // Bits[7:7], RWV, default = 0x0
    //
    UINTX mlm_sdt_expose_runbusy : 1;
    //
    // Disable large SRAM BL floating.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX disable_bl_float : 1;
    //
    // Disable large SRAM WL sleep mode.
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX disable_wl_sleep : 1;
    //
    // Change idle count for entering SRAM sleep from 1 us to
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX adjust_sleep_idle_count : 1;
    //
    // Reserved bits - FIXME  - jlunderd - the lower 3 bits of this field have been used
    // in the RTL and must be renamed. reserved_0[2] --> forcepgpok_sai_check_def, reserved_0[1]
    // --> sbep_cgctrl_clkgaten_b, reserved_0[0] --> sbep_cgctrl_clkgate_def
    //
    // Bits[31:11], RW, default = 0x0
    //
    UINTX reserved_0 : 21;
  } Bits;
  UINTX Data;
} MLM_CR_DEFEATURES_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_PINNING_REGION0_MLMC_REG                    0x00004F10
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Pinning region 0 -- base address of pinned PPA, 1MB granularity.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX base : 16;
    //
    // Pinned region 0 -- size of pinned region, 1MB granularity.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX size : 6;
    //
    // Read only 0
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Pinned region 0 pinned way.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX pinned_way : 4;
    //
    // Read only 0
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Enable pinning region 0.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX enabled : 1;
  } Bits;
  UINTX Data;
} MLM_CR_PINNING_REGION0_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_PINNING_REGION1_MLMC_REG                    0x00004F14
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Pinning region 1: Base address of pinned PPA, 1MB granularity.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX base : 16;
    //
    // Pinned region 1 -- size of pinned region, 1MB granularity.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX size : 6;
    //
    // Read only 0
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Pinned region 1 pinned way.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX pinned_way : 4;
    //
    // Read only 0
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Enable pinning region 1.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX enabled : 1;
  } Bits;
  UINTX Data;
} MLM_CR_PINNING_REGION1_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_PINNING_REGION2_MLMC_REG                    0x00004F18
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Pinning region 2: Base address of pinned PPA, 1MB granularity.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX base : 16;
    //
    // Pinned region 2: Size of pinned region, 1MB granularity.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX size : 6;
    //
    // Read only 0
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Pinned region 2 pinned way.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX pinned_way : 4;
    //
    // Read only 0
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Enable pinning region 2.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX enabled : 1;
  } Bits;
  UINTX Data;
} MLM_CR_PINNING_REGION2_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_PINNING_REGION3_MLMC_REG                    0x00004F1C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Pinning region 2: Base address of pinned PPA, 1MB granularity.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX base : 16;
    //
    // Pinned region 2: Size of pinned region, 1MB granularity.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX size : 6;
    //
    // Read only 0
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Pinned region 2 pinned way.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX pinned_way : 4;
    //
    // Read only 0
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Enable pinning region 2
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX enabled : 1;
  } Bits;
  UINTX Data;
} MLM_CR_PINNING_REGION3_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_PINNING_MLMC_REG                            0x00004F20
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Minimum number of unpinned ways per set
    //
    // Bits[4:0], RW, default = 0x4
    //
    UINTX min_unpinned_ways : 5;
    //
    // Maximum number of pinned ways per set.
    //
    // Bits[9:5], RW, default = 0x4
    //
    UINTX max_pinned_ways : 5;
    //
    // Reserved bits
    //
    // Bits[31:10], RW, default = 0x0
    //
    UINTX reserved_0 : 22;
  } Bits;
  UINTX Data;
} MLM_CR_PINNING_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_MISC_MLMC_REG                               0x00004F24
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flag for Pcode/BIOS to set when MLMC should perform SDT initialization.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX execute_sdt_init : 1;
    //
    // Flag set by MLMC when SDT initialization is complete.
    //
    // Bits[1:1], RWV, default = 0x0
    //
    UINTX sdt_init_done : 1;
    //
    // Reserved bits
    //
    // Bits[31:2], RW, default = 0x0
    //
    UINTX reserved_0 : 30;
  } Bits;
  UINTX Data;
} MLM_CR_MISC_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_ARRAY_ECC_STATUS_MLMC_REG                   0x00004F28
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [list]
    //               [*]0: no double bit errors in the large SRAM
    //               [*]1: DED happens in the small SRAM
    //               [/list]
    //
    // Bits[0:0], RWV, default = 0x0
    //
    UINTX mlm0_small_sram_ded : 1;
    //
    // [list]
    //               [*]0: no double bit errors in the large SRAM
    //               [*]1: DED happens in the large SRAM
    //               [/list]
    //
    // Bits[1:1], RWV, default = 0x0
    //
    UINTX mlm0_large_sram_ded : 1;
    //
    // There are DEDs more than 1.
    //
    // Bits[2:2], RWV, default = 0x0
    //
    UINTX mlm0_ded_overflow : 1;
    //
    // [list]
    //               [*]0: set address is not valid
    //               [*]1: SET address in DED is valid
    //               [/list]
    //
    // Bits[3:3], RWV, default = 0x0
    //
    UINTX mlm0_ded_set_valid : 1;
    //
    // SET address in DED: For the case in which both SRAMs have DED, the set of small
    // SRAM will be reported.
    //
    // Bits[15:4], RWV, default = 0x0
    //
    UINTX mlm0_ded_set_address : 12;
    //
    // [list]
    //               [*]0: no double bit errors in the large SRAM
    //               [*]1: DED happens in the small SRAM
    //               [/list]
    //
    // Bits[16:16], RWV, default = 0x0
    //
    UINTX mlm1_small_sram_ded : 1;
    //
    // [list]
    //               [*]0: no double bit errors in the large SRAM
    //               [*]1: DED happens in the large SRAM
    //               [/list]
    //
    // Bits[17:17], RWV, default = 0x0
    //
    UINTX mlm1_large_sram_ded : 1;
    //
    // There are DEDs more than 1.
    //
    // Bits[18:18], RWV, default = 0x0
    //
    UINTX mlm1_ded_overflow : 1;
    //
    // [list]
    //               [*]0: set address is not valid
    //               [*]1: SET address in DED is valid
    //               [/list]
    //
    // Bits[19:19], RWV, default = 0x0
    //
    UINTX mlm1_ded_set_valid : 1;
    //
    // SET address in DED: For the case in which both SRAMs have DED, the set of small
    // SRAM will be reported.
    //
    // Bits[31:20], RWV, default = 0x0
    //
    UINTX mlm1_ded_set_address : 12;
    //
    // [list]
    //               [*]0: no double bit errors in the large SRAM
    //               [*]1: DED happens in the small SRAM
    //               [/list]
    //
    // Bits[32:32], RWV, default = 0x0
    //
    UINTX mlm2_small_sram_ded : 1;
    //
    // [list]
    //               [*]0: no double bit errors in the large SRAM
    //               [*]1: DED happens in the large SRAM
    //               [/list]
    //
    // Bits[33:33], RWV, default = 0x0
    //
    UINTX mlm2_large_sram_ded : 1;
    //
    // There are DEDs more than 1.
    //
    // Bits[34:34], RWV, default = 0x0
    //
    UINTX mlm2_ded_overflow : 1;
    //
    // [list]
    //               [*]0: set address is not valid
    //               [*]1: SET address in DED is valid
    //               [/list]
    //
    // Bits[35:35], RWV, default = 0x0
    //
    UINTX mlm2_ded_set_valid : 1;
    //
    // SET address in DED: For the case in which both SRAMs have DED, the set of small
    // SRAM will be reported.
    //
    // Bits[47:36], RWV, default = 0x0
    //
    UINTX mlm2_ded_set_address : 12;
    //
    // [list]
    //               [*]0: no double bit errors in the large SRAM
    //               [*]1: DED happens in the small SRAM
    //               [/list]
    //
    // Bits[48:48], RWV, default = 0x0
    //
    UINTX mlm3_small_sram_ded : 1;
    //
    // [list]
    //               [*]0: no double bit errors in the large SRAM
    //               [*]1: DED happens in the large SRAM
    //               [/list]
    //
    // Bits[49:49], RWV, default = 0x0
    //
    UINTX mlm3_large_sram_ded : 1;
    //
    // There are DEDs more than 1.
    //
    // Bits[50:50], RWV, default = 0x0
    //
    UINTX mlm3_ded_overflow : 1;
    //
    // [list]
    //               [*]0: set address is not valid
    //               [*]1: SET address in DED is valid
    //               [/list]
    //
    // Bits[51:51], RWV, default = 0x0
    //
    UINTX mlm3_ded_set_valid : 1;
    //
    // SET address in DED : For the case of both SRAM have DED the set of small SRAM
    // will be reported.
    //
    // Bits[63:52], RWV, default = 0x0
    //
    UINTX mlm3_ded_set_address : 12;
  } Bits;
  UINTX Data;
} MLM_CR_ARRAY_ECC_STATUS_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_STATUS_MLMC_REG                             0x00004F30
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Total swap count across all 4 MLMCs.
    //
    // Bits[15:0], RWV, default = 0x0
    //
    UINTX swap_count : 16;
    //
    // Total number of FM accesses readswrites across all MLMCs.
    //
    // Bits[39:16], RWV, default = 0x0
    //
    UINTX fm_access_count : 24;
    //
    // 1 if all B-Unit PMIs are in idle state.
    //
    // Bits[40:40], RWV, default = 0x0
    //
    UINTX bunit_pmi_idle_status : 1;
    //
    // 1 if all near memory PMIs are in idle state.
    //
    // Bits[41:41], RWV, default = 0x0
    //
    UINTX nm_pmi_idle_status : 1;
    //
    // 1 if all far memory PMIs are in idle state.
    //
    // Bits[42:42], RWV, default = 0x0
    //
    UINTX fm_pmi_idle_status : 1;
    //
    // 1 if all responders are ready for entering clock_gating.
    //
    // Bits[43:43], ROV, default = 0x0
    //
    UINTX mlmc_adapters_quiet : 1;
    //
    // 1 if all TC/TM/LA/DA are quiet --  all functional units in mlmc are quiet.
    //
    // Bits[44:44], ROV, default = 0x0
    //
    UINTX mlmc_core_quiet : 1;
    //
    // 1 if la astore is empty -- all rd/wt were done.
    //
    // Bits[45:45], ROV, default = 0x0
    //
    UINTX mlmc_core_empty : 1;
    //
    // Reserved bits
    //
    // Bits[63:46], RWV, default = 0x0
    //
    UINTX reserved_0 : 18;
  } Bits;
  UINTX Data;
} MLM_CR_STATUS_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_SAI_RAC_MLMC_REG                            0x00004F38
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[63:0], RW, default = 0xC0061010212
    //
    UINTX reserved_0 : 64;
  } Bits;
  UINTX Data;
} MLM_CR_SAI_RAC_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_SAI_WAC_MLMC_REG                            0x00004F40
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[63:0], RW, default = 0xC0061010212
    //
    UINTX reserved_0 : 64;
  } Bits;
  UINTX Data;
} MLM_CR_SAI_WAC_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_SAI_CP_MLMC_REG                             0x00004F48
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX reserved_0 : 64;
  } Bits;
  UINTX Data;
} MLM_CR_SAI_CP_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_POWER_MGMT_MLMC_REG                         0x00004F50
#ifndef ASM_INC
typedef union {
  struct {
    //
    // If set, prevents all PMI ISMs from entering idle state.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pmi_ism_idle_disable : 1;
    //
    // If set, forces all requestor ISMs to wake up and stop requesting clock/power gating.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX pmi_ism_force_wakeup : 1;
    //
    // Number of MLMC clocks of idleness before requesting PMI to go idle.
    //
    // Bits[5:2], RW, default = 0x4
    //
    UINTX pmi_ism_idle_timer : 4;
    //
    // This will disable internal clock gating in cdc. This in turn will also disable
    // IP to CCP clock req.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX pgcb_cgreq_disable : 1;
    //
    // If set, then IP will PG when idle and the PMC requests power gating.
    //
    // Bits[7:7], RW, default = 0x1
    //
    UINTX pmc_request_enable : 1;
    //
    // Enable of PGCB HW_AutoPG -- always 0 since POR is P-Unit control.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX pgcb_hw_autonomous_enable : 1;
    //
    // Number of SB clocks 100MHz till PGCB clockgates MLMC.
    //
    // Bits[12:9], RW, default = 0x2
    //
    UINTX pgcb_clockgate_hyst_timer : 4;
    //
    // Number of SB clocks 100MHz till PGCB powergates MLMC.
    //
    // Bits[23:13], RW, default = 0x2
    //
    UINTX pgcb_powergate_timer : 11;
    //
    // If set, causes TC to remain turned on during AutoPG.
    //
    // Bits[24:24], RW, default = 0x1
    //
    UINTX powergate_leave_tc_on : 1;
    //
    // Enables immediate flushing of Astore entries.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX astore_always_flush : 1;
    //
    // If set, then IP may assert Sleep during PG ing.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX sleep_enable : 1;
    //
    // This is for disabling the clock req from CDC to the CCP.ie trunk clock. This will
    // not affect local clock gating.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX enable_clkreq2ccp : 1;
    //
    // This will prevent PGCB clockreq from going down. pgcb clock stays alive but ipclk
    // clkreq can turn off.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX disable_pgcbclk_trunk_gating : 1;
    //
    // Reserved bits
    //
    // Bits[31:29], RW, default = 0x0
    //
    UINTX reserved_0 : 3;
  } Bits;
  UINTX Data;
} MLM_CR_POWER_MGMT_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_FM_CONFIG_MLMC_REG                          0x00004F54
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Near memory only configuration, i.e. only WIO2 populated -- debugonly only.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX fm_no_lpddr_present : 1;
    //
    // Active far memory Dunits. One bit for S N W E Dunits.
    //
    // Bits[4:1], RW, default = 0x9
    //
    UINTX fm_active_dunits : 4;
    //
    // Far memory channel South size in 256MB multiples
    //
    // Bits[10:5], RW, default = 0x4
    //
    UINTX fm_chan_s_size : 6;
    //
    // Far memory channel North size in 256MB multiples
    //
    // Bits[16:11], RW, default = 0x4
    //
    UINTX fm_chan_n_size : 6;
    //
    // Far memory channel West size in 256MB multiples
    //
    // Bits[22:17], RW, default = 0x4
    //
    UINTX fm_chan_w_size : 6;
    //
    // Far memory channel East size in 256MB multiples.
    //
    // Bits[28:23], RW, default = 0x4
    //
    UINTX fm_chan_e_size : 6;
    //
    // Flag for BIOS to set when FM configuration fields are set.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX mem_init_done : 1;
    //
    // Reserved bits
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX reserved_0 : 2;
  } Bits;
  UINTX Data;
} MLM_CR_FM_CONFIG_MLMC_STRUCT;
#endif // ASM_INC

#define MLM_CR_NM_INTERLEAVE_MLMC_REG                      0x00004F58
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [list]
    //               [*]0: bit 10 interleave
    //               [*]1: bit 11 interleave
    //               [*]2: bit 6 interleave
    //               [/list]
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX nm_intlv_bit : 2;
    //
    // Optional. Do not use with 1K and 2K interleave.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX nm_intlv_xor_bit1_enable : 1;
    //
    // This should be higher than bit 6, if enabled.
    //
    // Bits[6:3], RW, default = 0xA
    //
    UINTX nm_intlv_xor_bit1 : 4;
    //
    // Optional. Do not use with 1K and 2K interleave.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX nm_intlv_xor_bit2_enable : 1;
    //
    // NM interleave XOR bit 2 should be higher than XOR bit 1 if enabled
    //
    // Bits[11:8], RW, default = 0xD
    //
    UINTX nm_intlv_xor_bit2 : 4;
    //
    // [list]
    //               [*]1: FMArb performs staggered interleave
    //               [*]0: FMArb does flat interleave
    //               [/list]
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX fmarb_staggered_intlv : 1;
    //
    // Reserved bits
    //
    // Bits[31:13], RW, default = 0x0
    //
    UINTX reserved_0 : 19;
  } Bits;
  UINTX Data;
} MLM_CR_NM_INTERLEAVE_MLMC_STRUCT;
#endif // ASM_INC


#endif // _MLMC_H_
