/** @file
  File name:    DUNIT_BOXTYPE.h
  Input File:   BXTP_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in DUNIT_BOXTYPE.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/
#ifndef _DUNIT_BOXTYPE_H_
#define _DUNIT_BOXTYPE_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define D_CR_DRP0_DUNIT_BOXTYPE_REG                        0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enable Rank 0: Must be set to 1 to enable use of this rank.
    //     [p]Note: Setting this bit to 0 is not a functional mode.[/p]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX rken0 : 1;
    //
    // Enable Rank 1: Must be set to 1 to enable use of this rank.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX rken1 : 1;
    //
    //
    //       [list]
    //       [*]0: PMI Dual Data Mode is disabled in D-Unit, full cacheline read and
    // writes go through a single D-Unit.
    //       [*]1: PMI Dual Data Mode is enabled, only half cacheline read/writes go
    // through a single D-Unit.
    //       [/list]
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX ddmen : 1;
    //
    // Reserved.
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX rsvd3 : 1;
    //
    // Data width of the DRAM device populated on Ranks 0 and 1.
    //       [list]
    //     [*]00: x8.
    //     [*]01: x16.
    //     [*]10: x32.
    //     [*]11: x64.
    //     [/list]
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX dwid : 2;
    //
    // Density of the DRAM devices populated on Ranks 0 and 1.
    //       [list]
    //     [*]000: 4 Gb.
    //     [*]001: 6 Gb.
    //     [*]010: 8 Gb.
    //     [*]011: 12 Gb.
    //     [*]100: 16 Gb.
    //     [*]101-111: Reserved.
    //       [/list]
    //     [p]Note: For LPDDR4 this value is the die density.[/p]
    //
    // Bits[8:6], RW, default = 0x0
    //
    UINTX dden : 3;
    //
    // Reserved.
    //
    // Bits[13:9], RO, default = 0x0
    //
    UINTX rsvd13_9 : 5;
    //
    // See Address Mapping section for full description.
    //       [list]
    //     [*]0: Rank Select Interleaving disabled.
    //     [*]1: Rank Select Interleaving enabled.
    //     [/list]
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX rsien : 1;
    //
    // See Address Mapping section for full description.
    //     [list]
    //     [*]0: Bank Address Hashing disabled.
    //     [*]1: Bank Address Hashing enabled.
    //     [/list]
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX bahen : 1;
    //
    // Reserved.
    //
    // Bits[18:16], RO, default = 0x0
    //
    UINTX rsvd18_16 : 3;
    //
    //
    //       [list]
    //       [*]00: uniDIMM/SODIMM.
    //       [*]01: BGA.
    //       [*]10: BGA mirrored (LPDDR3 Only).
    //       [*]11: UDIMM (DDR3L Only).
    //       [/list]
    //
    // Bits[20:19], RW, default = 0x0
    //
    UINTX caswizzle : 2;
    //
    //
    //     [list]
    //     [*]0: ECC is disabled.
    //     [*]1: ECC is enabled.
    //       [/list]
    //     [p]This bit determines if the D-Unit treats the PMI BE_ECC bits as ECC bits
    // or Byte Enables. The D-Unit should not allow this bit to be set if ECC is disabled
    // by fuse. This should only be used in configurations that support ECC (DDR3L).[/p]
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX eccen : 1;
    //
    //
    //     [list]
    //     [*]000: DDR3L.
    //     [*]001: LPDDR3.
    //     [*]010: LPDDR4.
    //     [*]011: WIO2.
    //     [*]100: DDR4.
    //     [*]101-111: Reserved.
    //       [/list]
    //     [p]Note: The D-Unit should only use this field if allowed by fuse.[/p]
    //
    // Bits[24:22], RW, default = 0x0
    //
    UINTX dramtype : 3;
    //
    //
    //     [list]
    //     [*]000: Fixed BL8.
    //     [*]001: Onthefly BL8.
    //     [*]010: Fixed BL16.
    //     [*]011: Onthefly BL16.
    //     [*]100: Fixed BL32.
    //     [*]101: Onthefly BL32.
    //     [*]110-111: Reserved.
    //     [/list]
    //
    // Bits[27:25], RW, default = 0x0
    //
    UINTX blmode : 3;
    //
    // Specifies the address mapping to be used:
    //     [list]
    //     [*]00: 1KB (A).
    //     [*]01: 2KB (B).
    //     [*]10: 4KB (C).
    //     [*]11: Reserved.
    //     [/list]
    //
    // Bits[29:28], RW, default = 0x1
    //
    UINTX addrdec : 2;
    //
    // Specifies the number of DRAM devices that are ganged together to form a single
    // rank.
    //       [list]
    //       [*]00: 1 DRAM device in each rank.
    //       [*]01: 2 DRAM devices in each rank.
    //       [*]10: 4 DRAM devices in each rank.
    //       [*]11: 8 DRAM devices in each rank.
    //       [/list]
    //       [p]Note: The actual number of devices is one more than the value programmed
    // when ECC is enabled.[/p]
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX dramdevice_pr : 2;
  } Bits;
  UINTX Data;
} D_CR_DRP0_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DTR0A_DUNIT_BOXTYPE_REG                       0x00000008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the delay between a DRAM Precharge command and a DRAM Activate command
    // to the same bank (in DRAM Clocks).
    //       [p]Note : this CR should be constrained to a minimum of 4 in LPDDR3 and
    // minimum of 8 in LPDDR4.[/p]
    //     [p]Note: Derating adds 1.875ns to this timing.[/p]
    //
    // Bits[5:0], RW, default = 0xB
    //
    UINTX trppb : 6;
    //
    // Specifies the delay between a DRAM Activate command and a DRAM Read or Write command
    // to the same bank (in DRAM clocks).
    //     [p]Note: Derating adds 1.875ns to this timing.[/p]
    //
    // Bits[11:6], RW, default = 0xB
    //
    UINTX trcd : 6;
    //
    // DDR3L: tXS - Delay between Self Refresh Exit SRX to any DRAM Command not requiring
    // DLL Lock.
    //     [p]LPDDR/WIO2: tXSR - Delay between Self Refresh Exit SRX to any DRAM Command.
    // (in DRAM clocks).[/p]
    //
    // Bits[20:12], RW, default = 0x70
    //
    UINTX txsr : 9;
    //
    // D-Unit waits max(tXSR+tZQCL/tZQCS, tXSDLL) before allowing traffic to DRAM (in
    // 64 x DRAM Clocks).
    //       [p]LPDDR3/LPDDR4/WIO2: tXSDLL = 0.[/p]
    //       [p]DDR3L: tXSDLL = tDLLK = 512 Clocks = 8 x 64 DRAM Clocks.[/p]
    //       [p]Note: In the equation above, tZQCL/tZQCS = 0 if no ZQ is performed on
    // SR exit.[/p]
    //
    // Bits[24:21], RW, default = 0x8
    //
    UINTX txsdll : 4;
    //
    // Number of valid clocks before CKE high (in DRAM clocks).
    //     [list]
    //     [*]LPDDR4: The value in this register covers both tCKCKEH and tCSCKEH.
    //     [*]DDR3L/LPDDR3/WIO2: The value covers tCKSRX which is defined as the number
    // of valid DRAM clocks that have to toggle before the issuing of the Self Refresh
    // Exit SRX. This value is also used if the clock frequency is changed or the clock
    // is stopped or tristated during Power Down i.e. the number valid DRAM clocks that
    // have to toggle before the issuing of the Power Down Exit PDX command.
    //     [/list]
    //     [p]tCKCKEH can be used to compensate for clock stabilization delays in the
    // motherboard.[/p]
    //
    // Bits[31:25], RW, default = 0x10
    //
    UINTX tckckeh : 7;
  } Bits;
  UINTX Data;
} D_CR_DTR0A_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DTR1A_DUNIT_BOXTYPE_REG                       0x0000000C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the delay between the DRAM  ZQ Calibration Latch command and any DRAM
    // command (in DRAM clocks).
    //     [p]LPDDR4 only.Not used in DDR3L/LPDDR3/WIO2.[/p]
    //
    // Bits[5:0], RW, default = 0x18
    //
    UINTX tzqlat : 6;
    //
    // ZQCS to any DRAM Command Delay:  Specifies the delay between the DRAM ZQ Calibration
    // Short (ZQCS) command and any DRAM command (in DRAM clocks).
    //     [p]DDR3L and LPDDR3 only. LPDDR4 does not support ZQCS command[/p]
    //
    // Bits[13:6], RW, default = 0x48
    //
    UINTX tzqcs : 8;
    //
    //
    //     [list]
    //     [*]LPDDR3/DDR3L: tZQCL/tZQoper: Specifies the delay between the DRAM ZQ Calibration
    // Long (ZQCL) command and any DRAM command during normal operation.
    //     [*]LPDDR4: tZQCAL: ZQ Calibration time (in DRAM clocks).
    //     [/list]
    //     [p]Note: This field defines the ZQ Calibration Long delay during normal operation.
    // It is not the same as tZQinit which uses the same ZQCL command but the delay is
    // longer. tZQinit applies only during poweron initialization of the DRAM devices
    // and tZQoper applies during normal operation. BIOS executes the DRAM initialization
    // sequence so it has to ensure tZQinit is met and not the D-Unit.[/p]
    //
    // Bits[25:14], RW, default = 0x120
    //
    UINTX tzqcl : 12;
    //
    // Reserved.
    //
    // Bits[26:26], RO, default = 0x0
    //
    UINTX rsvd26 : 1;
    //
    // Specifies the delay from the DRAM Power Down Exit (PDX) command to any valid command
    // (in DRAM clocks).
    //       [p]Note: The value in this field must be programmed to tXPDLL when Slow
    // Exit Mode Power-down is enabled for DDR3L.[/p]
    //
    // Bits[31:27], RW, default = 0x6
    //
    UINTX txp : 5;
  } Bits;
  UINTX Data;
} D_CR_DTR1A_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DTR2A_DUNIT_BOXTYPE_REG                       0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the average time between refresh commands. JEDEC Base Refresh Interval
    // time (in DRAM clocks).
    //       [p]Note: D-Unit will ignore the 2 LSBs of this field.[/p]
    //
    // Bits[15:0], RW, default = 0xC30
    //
    UINTX nrefi : 16;
    //
    // Reserved.
    //
    // Bits[16:16], RO, default = 0x0
    //
    UINTX rsvd16 : 1;
    //
    // Specifies the minimum time from CKEL to CKEH (in DRAM clocks).
    //
    // Bits[20:17], RW, default = 0x4
    //
    UINTX tcke : 4;
    //
    // Reserved.
    //
    // Bits[22:21], RO, default = 0x0
    //
    UINTX rsvd22_21 : 2;
    //
    // Specifies the delay between the REFab command to the next valid command. (in DRAM
    // clocks)
    //
    // Bits[31:23], RW, default = 0x118
    //
    UINTX nrfcab : 9;
  } Bits;
  UINTX Data;
} D_CR_DTR2A_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DTR3A_DUNIT_BOXTYPE_REG                       0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the minimum delay between DRAM Write command to Masked Write command
    // to same bank (in DRAM clocks).
    //       [list]
    //     [*]LPDDR4 Equation: tWMWSB = tCCDMW (BL16) or tCCDMW + 8 (BL32).
    //     [*]WIO2 Equation: tWMWSB = tCCDMW (BL4) or tCCDMW + 2 (BL8).
    //     [/list]
    //     [p]Note: Masked Write operation in LPDDR4 is always BL16 and in WIO2 is always
    // BL4.[/p]
    //     [p]D-Unit applies this timing for same rank as well as same bank, refer to
    // D-Unit HAS for more details.[/p]
    //
    // Bits[5:0], RW, default = 0x28
    //
    UINTX twmwsb : 6;
    //
    // The delay between the internal write command and the availability of the first
    // word of DRAM input data (in DRAM clocks).
    //
    // Bits[10:6], RW, default = 0x8
    //
    UINTX tcwl : 5;
    //
    // Specifies the number of DRAM clocks a command is held valid on the DRAM Address
    // and Control buses. 1N is the DDR3 basic requirement.  2N is the extended mode
    // for board signal integrity.
    //     [list]
    //     [*]0h: Reserved.
    //     [*]1h: 1 DRAM Clock (1N).
    //     [*]2h: 2 DRAM Clocks (2N).
    //     [*]3h: Reserved.
    //     [/list]
    //     [p]Note: DDR3L only. tCMD must be set to 1N for LPDDR3/LPDDR4/WIO2.[/p]
    //
    // Bits[12:11], RW, default = 0x1
    //
    UINTX tcmd : 2;
    //
    // Specifies the minimum delay between the DRAM Write command and the Precharge command
    // to the same bank (in DRAM clocks).
    //     [list]
    //       [*]LPDDR3/LPDDR4/WIO2 Equation: tWTP = BL/2 + WL + tWR + 1.
    //       [*]DDR3L Equation: tWTP = BL/2 + CWL + tWR.
    //       [/list]
    //
    // Bits[19:13], RW, default = 0x17
    //
    UINTX twtp : 7;
    //
    // Specifies the number of clocks to be added to turnaround times (for Stretch Mode).
    // It increases delay between Read to Read or Read to Write commands (in 4 x DRAM
    // clocks).
    //
    // Bits[26:20], RW, default = 0x0
    //
    UINTX tccd_inc : 7;
    //
    // Specifies the minimum delay between the DRAM Read and Precharge commands to the
    // same bank (in DRAM clocks).
    //     [list]
    //     [*]LPDDR3 Equation: = BL/2 + tRTP - 4.
    //     [*]LPDDR4 Equation: = BL/2 + Max (8, tRTP) - 8.
    //     [*]WIO2 Equation: = BL/2 + tRTP - 2.
    //       [*]DDR3L Equation: = tRTP.
    //     [/list]
    //
    // Bits[31:27], RW, default = 0x6
    //
    UINTX trtp : 5;
  } Bits;
  UINTX Data;
} D_CR_DTR3A_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DTR4A_DUNIT_BOXTYPE_REG                       0x00000018
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the delay from the start of a Read data burst of one rank to the Start
    // of a Read data burst of a different rank (in DRAM clocks).
    //       [list]
    //     [*]LPDDR3/4 Equation: tRRDR = BL/2 + tDQSCKmax - tDQSCKmin + tRPRE.
    //       [*]DDR3L Equation: tRRDR = BL/2 + tRPST + tDQSCKmax - tDQSCKmin + tRPRE
    // + 1.
    //       [/list]
    //
    // Bits[5:0], RW, default = 0x9
    //
    UINTX trrdr : 6;
    //
    // Specifies the delay from the start of a Write data burst of one rank to the start
    // of a Write data burst of a different rank (in DRAM clocks).
    //     [list]
    //     [*]LPDDR3 Equation: tWWDR = BL/2 + tDQSSmax - tDQSSmin + tWPRE.
    //     [*]LPDDR4 Equation: tWWDR = BL/2 + 4 - tDQSSmin.
    //       [*]DDR3L Equation: tWWDR = BL/2 + tDQSSmax - tDQSSmin + tWPRE.
    //     [/list]
    //     [p]Note: For LPDDR3/4 using ODT, this latency may need to be increased by tODToffadj.[/p]
    //
    // Bits[11:6], RW, default = 0x5
    //
    UINTX twwdr : 6;
    //
    // Specifies the delay from the start of a Read data burst of one rank to the Start
    // of a Write data burst of a different rank (in DRAM clocks).
    //     [list]
    //     [*]LPDDR3 Equation: tRWDR = RL + tDQSCKmax + BL/2 + tRPST - (WL + tDQSSmin
    // - tWPRE).
    //     [*]LPDDR4 Equation: tRWDR = RL + tDQSCKmax + BL/2 - (WL - 2).
    //       [*]DDR3L Equation: tRWDR = CL + tDQSCKmax + BL/2 + tRPST - (CWL + tDQSSmin
    // - tWPRE).
    //     [/list]
    //     [p]Note: For LPDDR3/4 using ODT, this latency may need to be adjusted by tODTon.[/p]
    //       [p]Note: For DDR3L using ODT, this latency may need to be increased by one
    // clock.[/p]
    //
    // Bits[17:12], RW, default = 0x9
    //
    UINTX trwdr : 6;
    //
    // Specifies the delay from the start of a Write data burst of one rank to the start
    // of a Read data burst of a different rank (in DRAM clocks).
    //     [list]
    //     [*]LPDDR3 Equation: tWRDR = WL + tDQSSmax + BL/2 + tWPST - (RL + tDQSCKmin
    // - tRPRE).
    //     [*]LPDDR4 Equation: tWRDR = WL - RL + BL/2 + 4 - tDQSCKmin.
    //       [*]DDR3L Equation: tWRDR = CWL + tDQSSmax + BL/2 + tWPST - (CL + tDQSCKmin
    // - tRPRE).
    //       [/list]
    //     [p]Note: For LPDDR3/4 using ODT, this latency may need to be increased by tODToffadj.[/p]
    //
    // Bits[23:18], RW, default = 0x8
    //
    UINTX twrdr : 6;
    //
    // A rolling timeframe in which a maximum of four Activate commands can be issued
    // to the same rank. This is to limit the peak current draw from the DRAM devices
    // (in DRAM clocks).
    //
    // Bits[31:24], RW, default = 0x30
    //
    UINTX tfaw : 8;
  } Bits;
  UINTX Data;
} D_CR_DTR4A_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DTR5A_DUNIT_BOXTYPE_REG                       0x0000001C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the delay from a DRAM Read to a Write command of the same rank (in DRAM
    // clocks).
    //       [list]
    //     [*]LPDDR3/LPDDR4/WIO2 Equation: tRWSR = RL + tDQSCKmax + BL/2 - WL + tWPRE.
    //       [*]DDR3L Equation: tRWSR = CL + tDQSCKmax + BL/2 + tRPST - (CWL +tDQSSmin
    // - tWPRE).
    //       [/list]
    //     [p]Note: For LPDDR3/4 using ODT, this latency may need to be increased by tODToffadj.[/p]
    //       [p]Note: For DDR3L using ODT, this latency may need to be increased by one
    // clock.[/p]
    //
    // Bits[5:0], RW, default = 0x2
    //
    UINTX trwsr : 6;
    //
    // Specifies the delay from a DRAM Read to Write command of the same rank (in DRAM
    // clocks).
    //       [list]
    //     [*]LPDDR3/LPDDR4/WIO2 Equation: tWRSR  = WL + tDQSSmax + BL/2 + tWTR.
    //       [*]DDR3L Equation: tWRSR  = CWL + tDQSSmax + BL/2 + tWPST + tWTR.
    //       [/list]
    //
    // Bits[12:6], RW, default = 0x3
    //
    UINTX twrsr : 7;
    //
    // Specifies the delay from a DRAM Read to another Read command of the same rank
    // (in DRAM clocks).
    //     [p]LPDDR3/LPDDR4/WIO2/DDR3L Equation: tRRSR = tCCD.[/p]
    //
    // Bits[17:13], RW, default = 0x10
    //
    UINTX trrsr : 5;
    //
    // Specifies the delay from a DRAM Write to another Write command of the same rank
    // (in DRAM clocks).
    //     [p]LPDDR3/LPDDR4/WIO2/DDR3L Equation: tRRSR = tCCD.[/p]
    //
    // Bits[22:18], RW, default = 0x10
    //
    UINTX twwsr : 5;
    //
    // Specifies the additional delay that is added to DRAM timing when indicated by
    // MR4 status. (in DRAM clocks)
    //     [p]LPDDR3/LPDDR4/WIO2: Value is 1.875ns.[/p]
    //     [p]Note: The value in this register is only added to these timing parameters:
    // tRCD, tRAS, tRP and tRRD.[/p]
    //
    // Bits[25:23], RW, default = 0x0
    //
    UINTX tderate_inc : 3;
    //
    // Reserved.
    //
    // Bits[26:26], RO, default = 0x0
    //
    UINTX rsvd26 : 1;
    //
    // Specifies the minimum delay in DRAM clocks between two DRAM Activate commands
    // to the same rank but different banks (tRC is the minimum delay between activations
    // of the same bank).
    //     [p]Note: Derating adds 1.875ns to this timing.[/p]
    //
    // Bits[31:27], RW, default = 0x6
    //
    UINTX trrd : 5;
  } Bits;
  UINTX Data;
} D_CR_DTR5A_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DTR6A_DUNIT_BOXTYPE_REG                       0x00000020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the quiet time before issuing MRR/MRW command. (in DRAM clocks).
    //       [p]Note: D-Unit treats MRR as a read and always applies relevant turnaround
    // times, any value programmed in this CR must be greater than those turnaround times
    // for D-Unit to enforce any additional time from previous read/writes.[/p]
    //
    // Bits[6:0], RW, default = 0x0
    //
    UINTX tpremrblk : 7;
    //
    // Reserved.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX rsvd7 : 1;
    //
    // Specifies the quiet time after issuing MRR command (in DRAM Clocks).
    //       [p]Note: D-Unit treats MRR as a read and always applies relevant turnaround
    // times, any value programmed in this CR must be greater than those turnaround times
    // for D-Unit to enforce any additional time from MRR to the next read/write.[/p]
    //
    // Bits[14:8], RW, default = 0x0
    //
    UINTX tpstmrrblk : 7;
    //
    // When a critical read request is pending in RPQ and a maintenance
    //       operation (MRR, ZQCal, Ref, etc, panic refresh is an exception to this
    //       delay.) needs to be performed, D-Unit waits this amount of time before performing
    // the maintenance operation to allow for some high priority requests to be issued
    // (in 4x SPID clocks).
    //
    // Bits[18:15], RW, default = 0x0
    //
    UINTX mntdly : 4;
    //
    // Specifies the amount of time that DRAM clocks need to toggle after CKE goes low
    // (in DRAM Clocks).
    //     [list]
    //     [*]For WIO2/LPDDR3, this covers tCPDED.
    //     [*]For LPDDR4, this covers both tCKCKEL and tCKELCS.
    //     [*]For DDR3L, this is tCKSRE.
    //       [/list]
    //     [p]Note: D-Unit hardware enforces minimum of two SPID clocks after CKEL, any
    // value in this register is the additional time.[/p]
    //
    // Bits[23:19], RW, default = 0x2
    //
    UINTX tckckel : 5;
    //
    // Rank idle period that defines an opportunity for refresh (in DRAM clocks).
    //
    // Bits[31:24], RW, default = 0x20
    //
    UINTX orefdly : 8;
  } Bits;
  UINTX Data;
} D_CR_DTR6A_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DTR7A_DUNIT_BOXTYPE_REG                       0x00000024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the minimum delay between the DRAM Activate and Precharge commands to
    // the same bank (in DRAM clocks).
    //       [p]Note: Derating adds 1.875ns to this timing.[/p]
    //
    // Bits[6:0], RW, default = 0x6
    //
    UINTX tras : 7;
    //
    // Reserved.
    //
    // Bits[8:7], RO, default = 0x0
    //
    UINTX rsvd8_7 : 2;
    //
    // Specifies the minimum time between a read command to PowerDown command (in DRAM
    // clocks).
    //     [p]Must be at least equal to CL/RL + tDQSCKmax + tCCD + tRPST.[/p]
    //
    // Bits[15:9], RW, default = 0x6
    //
    UINTX trdpden : 7;
    //
    // Specifies the minimum time between a write command to PowerDown command (in DRAM
    // clocks).
    //     [p]Must be at least equal to tWR + tCCD + tWL + 2.[/p]
    //
    // Bits[22:16], RW, default = 0x6
    //
    UINTX twrpden : 7;
    //
    // Specifies the quiet time after issuing MRW command (in 8 x DRAM clocks).
    //       [p]Note: This time covers for both tMRD and tMRW.[/p]
    //
    // Bits[25:23], RW, default = 0x2
    //
    UINTX tpstmrwblk : 3;
    //
    // Specifies the delay between a DRAM Precharge All Bank command and a DRAM Activate
    // command (in DRAM Clocks).
    //       [p]Note: This CR should be constrained to a minimum of 4 in LP3 and minimum
    // of 8 in LP4.[/p]
    //     [p]Note: Derating adds 1.875ns to this timing.[/p]
    //     [list]
    //     [*]For LPDDR, tRPpb = tRP, tRPab = tRP + 3ns.
    //     [*]For DDR3L and WIO2 8ch tRPpb = tRPab = tRP.
    //     [/list]
    //
    // Bits[31:26], RW, default = 0x3
    //
    UINTX trpab : 6;
  } Bits;
  UINTX Data;
} D_CR_DTR7A_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DTR8A_DUNIT_BOXTYPE_REG                       0x00000028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is a non-JEDEC timing parameter used to delay powerdown entry (in DRAM clocks).
    //
    // Bits[7:0], RW, default = 0x18
    //
    UINTX pwddly : 8;
    //
    // Specifies the time between CK stop/tristate to the Low Power Mode entry. This
    // timing parameter is used to delay Low Power Mode entry (in DRAM clocks).
    //     [p]Note: Must be at least equal to t_idle_length parameter published in the
    // DDRIO PHY HAS and less than 0x7C.[/p]
    //
    // Bits[14:8], RW, default = 0xA
    //
    UINTX cketolpmddly : 7;
    //
    // Specifies the minimum time between the LP Mode exit to the CK stop/tristate deassertion
    // and powerdown exit (in DRAM clocks).
    //     [p]Note: Must be equal to t_idle_latency published in the DDRIO PHY HAS and
    // less than 0x3C.[/p]
    //
    // Bits[20:15], RW, default = 0xA
    //
    UINTX lpmdtockedly : 6;
    //
    // Specifies the minimum time that PHY should remain in LPMode (in DRAM clocks).
    //
    // Bits[25:21], RW, default = 0x6
    //
    UINTX lpmdres : 5;
    //
    // Specifies the minimum time that DRAM should remain in SR (in DRAM clocks).
    //
    // Bits[31:26], RW, default = 0x3
    //
    UINTX tckesr : 6;
  } Bits;
  UINTX Data;
} D_CR_DTR8A_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DOCRA_DUNIT_BOXTYPE_REG                       0x0000002C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies number of clocks after Write command that D-Unit asserts ODT signal
    // (in DRAM clocks).
    //       [p]LPDDR3 Equation: WRODTSTART = WL - RU(tODTon(max)/tCK) [/p]
    //       [p]DDR3L Equation: WRODTSTART = 0[/p]
    //       Note: DDR3 spec requires ODT to be asserted high when the DRAM Write command
    // is issued. In DDR3L 2N mode the value can be set to 0 to assert ODT one DRAM clock
    // earlier than the Write Command (WR) or set to 1 to assert at the same clock as
    // command (CS assertion).
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX wrodtstart : 4;
    //
    // Reserved.
    //
    // Bits[4:4], RO, default = 0x0
    //
    UINTX rsvd4 : 1;
    //
    // Specifies number of clocks after ODT assertion that D-Unit deasserts ODT signal
    // (in DRAM clocks).
    //       [p]LPDDR3 Equation: WRODTSTOP = RU(tODTon(max)/tCK) + RU((tDQSSmax+tWPST)/tCK)
    // + BL/2 - RD(tODToffmin/tCK)[/p]
    //       [p]DDR3L Equation: WRODTSTOP >= 6[/p]
    //
    // Bits[8:5], RW, default = 0x0
    //
    UINTX wrodtstop : 4;
    //
    // Specifies Read ODT assertion delay after Read Command (in DRAM clocks).
    //       [p]DDR3L Equation: RDODTSTART = CL  CWL (add 1 if DOCRx.EARLYWRODT = 1 in
    // 2N mode).[/p]
    //
    // Bits[12:9], RW, default = 0x0
    //
    UINTX rdodtstart : 4;
    //
    // Reserved.
    //
    // Bits[13:13], RO, default = 0x0
    //
    UINTX rsvd13 : 1;
    //
    // Specifies Read ODT assertion to ODT de-assert delay (in DRAM clocks).
    //       [p]DDR3L Equation: RDODTSTOP = DOCRx.WRODTSTOP (subtract 1 if DOCRx.EARLYWRODT
    // = 0 in 2N mode).[/p]
    //
    // Bits[17:14], RW, default = 0x0
    //
    UINTX rdodtstop : 4;
    //
    // Reserved.
    //
    // Bits[23:18], RO, default = 0x0
    //
    UINTX rsvd23_18 : 6;
    //
    // Specifies the behavior of ODT signals when a Write command is issued to Rank 0.
    //       [p]00 - Write ODT is disabled [/p]
    //       [p]01 - Assert ODT to Rank 0 (targeted Rank) [/p]
    //       [p]10 - Assert ODT to Rank 1 (non-targeted Rank) [/p]
    //       [p]11 - Assert ODT to Rank 0 and Rank 1 [/p]
    //       [p]Note: 10 and 11 are reserved values for LPDDR3[/p]
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX r0wrodtctl : 2;
    //
    // Specifies the behavior of ODT signals when a Write command is issued to Rank 1.
    //       [p]00 - Write ODT is disabled [/p]
    //       [p]01 - Assert ODT to Rank 0 (non-targeted Rank) [/p]
    //       [p]10 - Assert ODT to Rank 1 (targeted Rank) [/p]
    //       [p]11 - Assert ODT to Rank 0 and Rank 1 [/p]
    //       [p]Note: 10 and 11 are reserved values for LPDDR3[/p]
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX r1wrodtctl : 2;
    //
    // Specifies the behavior of ODT signals when a Read command is issued to Rank 0.
    //       [p]0 - Read ODT is disabled for Rank 0 [/p]
    //       [p]1 - Assert ODT to for Rank 1 (non-targeted Rank) [/p]
    //       [p]Note: This register is reserved for LPDDR3 devices[/p]
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX r0rdodtctl : 1;
    //
    // Specifies the behavior of ODT signals when a Read command is issued to Rank 1.
    //       [p]0 - Read ODT is disabled for Rank 1[/p]
    //       [p]1 - Assert ODT to for Rank 0 (non-targeted Rank) [/p]
    //       [p]Note: This register should be set to 0 for LPDDR3 devices[/p]
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX r1rdodtctl : 1;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_DOCRA_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DPMC0_DUNIT_BOXTYPE_REG                       0x00000030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the minimum time the D-Unit will wait before it enters Dynamic Self-Refresh
    // mode when idle (in 16x DRAM Clocks).
    //       [p]Note: The value in this field needs to be minimum of 4 in functional
    // mode and minimum of 50 in PSMI mode.[/p]
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX sredly : 16;
    //
    // When set to 1, the D-Unit will automatically control DRAM Self Refresh entry and
    // exit based on interface state and requests in pending queues. When there is no
    // pending request in the queues and PMI is idle, then the D-Unit will place the
    // DRAM devices in Self Refresh mode. The DRAM devices will be brought out of Self-Refresh
    // when idle conditions don't hold.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dynsren : 1;
    //
    // DDRIO PHY Power Mode Opcode:  After the D-Unit has placed the DRAM devices in
    // Self Refresh mode as the result of a Dynamic Self-Refresh, it sends this 5bit
    // value to the DDRIO PHY to tell it which power saving mode it should enter.
    //     [p]Changing this register value while in self-refresh will only change the
    // PM state for the next entry in DynSR.[/p]
    //
    // Bits[21:17], RW, default = 0x0
    //
    UINTX dynpmop : 5;
    //
    // Specifies when it is safe to send PM message to the PHY. When enabled, D-Unit
    // waits for SPID Clock to deassert before sending a PM message on SR entry.
    //     [list]
    //     [*]0: D-Unit will not wait for SPID_clk to deassert before sending the PM message
    // to PHY.
    //     [*]1: D-Unit will wait for SPID_clk to deassert before sending PM message to
    // the PHY.
    //       [/list]
    //     [p]Note: The value must be 1 when DYNPMOP = 7h.[/p]
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX srpmclkw : 1;
    //
    // Reserved.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX rsvd23 : 1;
    //
    // DDRIO PHY Power Mode Opcode: After the D-Unit has placed the DRAM devices in Self
    // Refresh/PASR mode as the result of a SUSPEND/SUSPENDP message, it sends this 5-bit
    // value to the DDRIO PHY to tell it which power saving mode it should enter.
    //     [p]Changing this register value while in SUSPEND will have no effect.[/p]
    //     [p]Note: This opcode cannot be a PM state where it disables PHY PLLs i.e PM7
    // in LPDDR PHY.[/p]
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX suspmop : 5;
    //
    // Reserved.
    //
    // Bits[31:29], RO, default = 0x0
    //
    UINTX rsvd31_29 : 3;
  } Bits;
  UINTX Data;
} D_CR_DPMC0_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DPMC1_DUNIT_BOXTYPE_REG                       0x00000034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Setting this bit to 1 disables dynamic control of DRAM Power-Down entry and exit
    // by keeping the CKE pins driven high. BIOS may set it to 1 during DRAM initialization
    // and DDRIO training. This bit should be set to 0 for normal operation.
    //     [list]
    //     [*]0: The D-Unit dynamically controls the CKE pins to place the DRAM devices
    // in Power Down mode and bring them out of Power Down mode.
    //     [*]1: The D-Unit constantly drives the CKE pins high to keep the DRAM devices
    // from entering Power Down mode when ranks are idle.
    //     [/list]
    //     [p]Note: This bit is overridden if CKEMODE = 1.[/p]
    //     [p]This bit does not control CKE behavior on SR entry/exit.[/p]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX dispwrdn : 1;
    //
    // D-Unit will send the value in this register after it has entered Powerdown Mode
    // and has stopped/tristated the clock.
    //     [p]00: Disable LPMode.[/p]
    //       [p]Note: LPMODE entry is not possible when global tristate flow is disabled
    // (DCBR.TRISTDIS = 1).[/p]
    //
    // Bits[2:1], RW, default = 0x0
    //
    UINTX lpmodeop : 2;
    //
    // Enable/Disable CK Stop/Tristate During Power down.
    //     [list]
    //     [*]00: Disable CK Stop/Tristate During Power down.
    //     [*]01: Enable CK Stop During Power down.
    //     [*]10: Enable CK Tristate During Power down.
    //     [*]11: Reserved
    //       [/list]
    //       [p]Note: CK is not stopped or tristated when global tristate flow is disabled
    // (DCBR.TRISTDIS = 1).[/p]
    //
    // Bits[4:3], RW, default = 0x1
    //
    UINTX enckstp : 2;
    //
    //
    //       [list]
    //       [*]0: The DRAM ODT pins associated with the enabled ranks are never tristated.
    //
    //       [*]1: DRAMs ODT pins are tristated when DRAM clock is stopped or tristated.
    //       [/list]
    //       [p]Note: ODT is not tristated when global tristate flow is disabled (DCBR.TRISTDIS
    // = 1)[/p]
    //
    // Bits[5:5], RW, default = 0x1
    //
    UINTX odttrist : 1;
    //
    // Reserved.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX rsvd6 : 1;
    //
    // When disabled, D-Unit will not close the DRAM page when idle.
    //     [list]
    //     [*]0: Enable page close timer.
    //     [*]1: Disable page close timer (Used during DRAM init and DDRIO training).
    //     [/list]
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX pclstodis : 1;
    //
    // Specifies the time from the last access of a DRAM page until that page is scheduled
    // to close by sending a Precharge command to DRAM (in 16 x DRAM clocks).
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX pclsto : 8;
    //
    // This is the Segment Mask used for the MRW to enable PASR during SUSPENDP (Partial
    // Array Self Refresh entry).
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX pasr : 8;
    //
    //
    //       [list]
    //       [*]00: The DRAM CA pins are never tristated.
    //       [*]01: The DRAM CA pins are only tristated when all enabled CKE pins are
    // low.
    //       [*]10: The DRAM CA pins are tristated when not driving a valid command.
    //       [*]11: Reserved
    //       [/list]
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX cmdtrist : 2;
    //
    //
    //     [list]
    //     [*]0: The DRAM CS pins associated with the enabled ranks are never tristated.
    //
    //     [*]1: The DRAM CS pins are tristated when DRAM clock is stopped or tristated.
    //     [/list]
    //     [p]Note: CS is not tristated when global tristate flow is disabled (DCBR.TRISTDIS
    // = 1).[/p]
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX cstrist : 1;
    //
    // Setting this bit to 0 allows the majority of the D-Unit clocks to be gated off
    // when there is no activity in order to save power.
    //     [p]When set to 1, D-Unit clockgating is disabled.[/p]
    //     [list]
    //     [*]0: Enable.
    //     [*]1: Disable.
    //       [/list]
    //     [p]Note: This is a de-feature bit and should be set to 0 for normal operation.[/p]
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX clkgtdis : 1;
    //
    // Setting this bit to 0 enables the clock gating of IOSF-SB End Points in D-Unit
    // and CPGC when there is no IOSF-SB activity in order to save power.
    //       [p]0 -  Enable IOSF-SB EP clock gating,  1 -  Disable IOSF-SB clock gating.[/p]
    //
    //       [p]Note: This is a de-feature bit and should be set to 0 for normal operation.[/p]
    //
    // Bits[28:28], RW, default = 0x1
    //
    UINTX sbepclkgtdis : 1;
    //
    // Setting this bit to 0 allows majority of the repeaters between D-Unit and PHY
    // to clock gate when there is no activity in order to save power.
    //       [p]0 -  Enable Repeaters clock gating,  1 -  Disable Repeaters clock gating.[/p]
    //       [p]Note: This is a de-feature bit and should be set to 0 for normal operation.[/p]
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX rptclkgtdis : 1;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_DPMC1_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DRFC_DUNIT_BOXTYPE_REG                        0x00000038
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Disable opportunistic scheduling of refresh.
    //       [list]
    //     [*]0: D-Unit will send a REF command only if there is no pending request to
    // that rank.
    //     [*]1: D-Unit will not send any opportunistic refreshes. Refresh commands are
    // only sent when the refresh counter is greater than REFWMHI.
    //     [/list]
    //     [p]Note: When set, DISREFDBTCLR must also be set to be able to enter SR.[/p]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX orefdis : 1;
    //
    // Reserved.
    //
    // Bits[3:1], RO, default = 0x0
    //
    UINTX rsvd3_1 : 3;
    //
    // When the Refresh counter per rank is greater than this value, the D-Unit will
    // send a REF command to the rank if there is no critical priority requests in the
    // pending queues.
    //     [p]Note: Value must be greater or equal to 1 and less than or equal to REFWMPNC.[/p]
    //
    // Bits[7:4], RW, default = 0x5
    //
    UINTX refwmhi : 4;
    //
    // When the Refresh counter per rank is greater than this value, the D-Unit will
    // send a REF command to the rank regardless of pending requests.
    //     [p]Note: REFWMPNC must be greater than or equal to REFWMHI and greater than
    // 2, Max Value must be less than 8 to not violate 9xtREFI JEDEC requirement.[/p]
    //
    // Bits[11:8], RW, default = 0x7
    //
    UINTX refwmpnc : 4;
    //
    // Ensures that refresh rate never drops below a certain limit regardless of TQ polling.
    //
    //     [list]
    //     [*]000: Disable  tREFI counter and stop issuing refresh commands.
    //     [*]001: 0.25x refresh rate (i.e. 4x tREFI same as no limit).
    //     [*]010: 0.5x refresh rate (i.e. 2x tREFI).
    //     [*]011: 1x refresh rate (i.e. 1x tREFI).
    //     [*]100: 2x refresh rate (i.e. 0.5x tREFI).
    //     [*]101: 4x refresh rate (i.e. 0.25x tREFI).
    //     [*]110: 4x refresh rate with derating forced on i.e. 0.25x tREFI.
    //     [*]111: Reserved.
    //     [/list]
    //
    // Bits[14:12], RW, default = 0x1
    //
    UINTX minrefrate : 3;
    //
    // When set to 1, D-Unit adds one extra refresh debit (for a total of two) on Self-refresh
    // exit.
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX extrarefdbt : 1;
    //
    // Reserved.
    //
    // Bits[17:16], RO, default = 0x0
    //
    UINTX rsvd17_16 : 2;
    //
    // Reserved.
    //
    // Bits[19:18], RO, default = 0x0
    //
    UINTX rsvd19_18 : 2;
    //
    // Disables Skewing of Refresh Counting between Ranks.
    //     [p]Each rank has its own refresh counter. By default incrementing these refresh
    // counters are skewed by 1/2 the tREFI period. Setting this bit to a 1 disables
    // this feature and all refresh counters will increment at the same time per tREFI
    // period. Skewing the tREFI counters can improve performance since traffic to all
    // ranks does not have to be blocked to perform refresh.[/p]
    //     [list]
    //     [*]0: Incrementing the refresh counters are skewed by 1/2 tREFI period.
    //     [*]1: All refresh counters will increment at the same time per tREFI period.
    //
    //     [/list]
    //     [p]Reserved in BXT0/1.[/p]
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX refskwdis : 1;
    //
    // When set, D-Unit will not clear refresh debt before Self Refresh SR Entry:
    //     [list]
    //     [*]0: D-Unit sends all postponed REF commands to DRAM before it enters Self
    // Refresh.
    //     [*]1: D-Unit enters SR without clearing the Refresh Debt (for Debug only).
    //     [/list]
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX disrefdbtclr : 1;
    //
    // Reserved.
    //
    // Bits[31:22], RO, default = 0x0
    //
    UINTX rsvd31_22 : 10;
  } Bits;
  UINTX Data;
} D_CR_DRFC_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DSCH_DUNIT_BOXTYPE_REG                        0x0000003C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The value in this register is subtracted from Masked Write to Read, Masked Write
    // to Write and Masked Write to Masked Write turnaround times to account for half
    // BL MWr commands in LPDDR4 and WIO2.
    //     [list]
    //     [*]LPDDR4: = MWr tCCD = MWr BL/2 = 8.
    //     [*]WIO2: = MWr tCCD = MWr BL/2 = 2.
    //     [/list]
    //
    // Bits[3:0], RW, default = 0x8
    //
    UINTX tmwr_ta_delta : 4;
    //
    // When stretch mode is enabled, commands are initiated only on Phase 0 of SPIDClk.
    //
    //     [list]
    //     [*]00: Stretch mode is disabled.
    //     [*]01: Commands are initiated on Phase 0 of every SPID clocks.
    //     [*]10: Commands are initiated on Phase 0 of even SPID clocks.
    //     [*]11: Commands are initiated on Phase 0 of odd SPID clocks.
    //     [/list]
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX stretchmode : 2;
    //
    // When set D-Unit stops scheduling new read commands to DRAM when the read data
    // buffer (RDB) is full.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX blkrdbf : 1;
    //
    // When set new page hit/empty read requests will bypass D-Unit pipeline stages to
    // save latency 0 - Disable Idle Bypass 1 - Enable Idle Bypass Note: Only applies
    // to WIO2, this bit is reserved for other technologies
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX bypassen : 1;
    //
    //
    //     [list]
    //     [*]0h: In order mode disabled: Commands are sent out of order.
    //     [*]1h: Partial in order mode: Read and Write CAS commands are sent in the order
    // they were recieved. ACT and PRE can go out of order.
    //     [*]2h: Full in order mode serialized test: All DRAM commands CAS ACT PRE associated
    // with a PMI request are issued to DDR before any DRAM commands for a subsequent
    // PMI request.
    //     [*]3h: Reserved.
    //     [/list]
    //     In order modes should be enabled during init/training/CPGC testing. Should
    // never be changed while the D-Unit queues are nonempty. For WIO2, when in-order
    // mode is enabled (01 or 10), D_CR_DSCH_BYPASSEN must be set to 0
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX inordermode : 2;
    //
    // Number of additional  full cacheline (64B) read data return credits exposed to
    // D-Unit when BLKRDBF is set.
    //       [p]Note: The value in this field has no effect on Read return credits when
    // BLKRDBF is not set.[/p]
    //
    // Bits[13:10], RW, default = 0x7
    //
    UINTX blkrdbf_add_rddata_cr : 4;
    //
    // Reserved.
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX rsvd15_14 : 2;
    //
    // Used to limit the number of entries in Read Pending Queue. RPQCOUNT will only
    // recognize changes when PMI ISM is not active.
    //
    // Bits[20:16], RW, default = 0x10
    //
    UINTX rpqcount : 5;
    //
    // Used to limit the number of available slots in Write Pending Queue/ Write Data
    // Buffer. WPQCOUNT will only recognize changes when PMI ISM is not active.
    //
    // Bits[26:21], RW, default = 0x1C
    //
    UINTX wpqcount : 6;
    //
    // Specifies the delay in SPID clocks from RDDATA_VALID assertion to actual data
    // on SPID. The value should match what is programmed in DDRIO (PHY).
    //
    // Bits[28:27], RW, default = 0x0
    //
    UINTX spid_early_rddata_valid : 2;
    //
    // Specifies the number of clocks the D-Unit sends the read data valid through the
    // BGF earlier as compared to the data.
    //       [list]
    //       [*]00: Always write read valid in same SPID clock as data.
    //       [*]01: Always write read valid one SPID clock before data.
    //       [*]10: Write read valid up to 2 SPID clocks before data.
    //       [*]11: Reserved
    //       [/list]
    //
    // Bits[30:29], RW, default = 0x0
    //
    UINTX bgf_early_rddata_valid : 2;
    //
    // Reserved.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX rsvd31 : 1;
  } Bits;
  UINTX Data;
} D_CR_DSCH_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DCAL_DUNIT_BOXTYPE_REG                        0x00000040
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the time interval between two ZQCS (LPDDR3) or ZQ Start (LPDDR4) commands
    // to a DRAM device. (in RTC 32.8KHz clocks)
    //
    // Bits[13:0], RW, default = 0x1057
    //
    UINTX zqint : 14;
    //
    // Reserved.
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX rsvd15_14 : 2;
    //
    //
    //     [list]
    //     [*]0: Periodic ZQ Calibration is Enabled.
    //     [*]1: Disable periodic ZQ Calibration.
    //     [/list]
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX zqcdis : 1;
    //
    // Specifies how ZQCal commands are sent to different ranks.
    //     [list]
    //     [*]0: ZQCal commands are sent in parallel to all ranks.
    //     [*]1: ZQCal commands are sent serially to each rank.
    //     [/list]
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX zqclmode : 1;
    //
    // Reserved.
    //
    // Bits[20:18], RO, default = 0x0
    //
    UINTX rsvd20_18 : 3;
    //
    //
    //     [list]
    //     [*]00: On DynSR exit ZQ timer determines the ZQ type. When the state is lost
    // (i.e due to AutoPG/S0ix) ZQCL is always performed.
    //     [*]01: Always perform ZQCL after self refresh exit, in LPDDR4, ZQ with traffic
    // blocked.
    //     [*]10: Always perform ZQCS on SR exit. For LPDDR4, ZQ while traffic is allowed.
    //
    //     [*]11: No ZQCL commands are sent (it disables ZQCAL commands on SR exit).
    //     [/list]
    //
    // Bits[22:21], RW, default = 0x0
    //
    UINTX srxzqc : 2;
    //
    // Reserved.
    //
    // Bits[28:23], RO, default = 0x0
    //
    UINTX rsvd28_23 : 6;
    //
    // Set this bit to 1 to start the ZQ calibration sequence on Rank 0. This bit will
    // remain a 1 until the ZQ calibration is complete for rank 0, then it will return
    // to 0.
    //       [p]0: ZQ calibration is done.[/p]
    //       [p]1: ZQ calibration has started and is in progress.[/p]
    //
    // Bits[29:29], RW/V, default = 0x0
    //
    UINTX zqcalstrtr0 : 1;
    //
    // Set this bit to 1 to start the ZQ calibration sequence on Rank 1. This bit will
    // remain a 1 until the ZQ calibration is complete for rank 1, then it will return
    // to 0.
    //       [p]0: ZQ calibration is done.[/p]
    //       [p]1: ZQ calibration has started and is in progress.[/p]
    //
    // Bits[30:30], RW/V, default = 0x0
    //
    UINTX zqcalstrtr1 : 1;
    //
    // Determines whether the ZQ Calibration is a long or short calibration command (due
    // to ZQCALSTRT).
    //       [p]0: Short calibration (ZQCS).[/p]
    //       [p]1: Long calibration (ZQCL).[/p]
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX zqcaltype : 1;
  } Bits;
  UINTX Data;
} D_CR_DCAL_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DRMC_DUNIT_BOXTYPE_REG                        0x00000044
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Each bit of CKEVAL directly controls a CKE pin when CKEMODE is set to 1.
    //     [p]Used only during init flow.[/p]
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX ckeval : 2;
    //
    // Reserved.
    //
    // Bits[3:2], RO, default = 0x0
    //
    UINTX rsvd3_2 : 2;
    //
    //
    //     [list]
    //     [*]0: D-Unit auto controls the CKE pins based on PowerDown and Self Refresh
    // entry and exit.
    //     [*]1: The value of CKEVAL field directly controls the CKE pins.
    //     [/list]
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX ckemode : 1;
    //
    // Reserved.
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX rsvd7_5 : 3;
    //
    // Each bit of ODTVAL directly controls an ODT pin when ODTMODE is set to 1.  Used
    // only during init flow. Note: Reserved for BXT0/1
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX odtval : 2;
    //
    // Reserved.
    //
    // Bits[11:10], RO, default = 0x0
    //
    UINTX rsvd11_10 : 2;
    //
    //
    //     [list]
    //     [*]0: D-Unit auto controls the ODT pins based on DRAM transactions.
    //     [*]1: The value of ODTVAL directly controls the ODT pins.
    //     [/list]
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX odtmode : 1;
    //
    // Reserved.
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX rsvd15_13 : 3;
    //
    // This bit must be set and then cleared by BIOS during cold/warm reset.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX coldwake : 1;
    //
    // Write a 1 to this bit to send warm reset to CPGC and then set to 0 to deassert
    // the reset. Value of this field must be 0 before CPGC funtional usage is enabled.
    //
    // Bits[17:17], RW, default = 0x1
    //
    UINTX cpgcwarmrst : 1;
    //
    // Write a 1 to this bit to lock and clock gate the CPGC.
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX cpgclock : 1;
    //
    // When set before a SUSPEND/WAKE command, D-Unit will not send SR entry/exit commands
    // to DRAM.
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX mansrdis : 1;
    //
    // Reserved.
    //
    // Bits[31:20], RO, default = 0x0
    //
    UINTX rsvd31_20 : 12;
  } Bits;
  UINTX Data;
} D_CR_DRMC_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_VNNTIMER_DUNIT_BOXTYPE_REG                    0x0000004C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The final timer value (in 16 x DRAM clocks).
    //
    // Bits[11:0], RW, default = 0x0
    //
    UINTX vnn_timer_time : 12;
    //
    // Reserved.
    //
    // Bits[30:12], RO, default = 0x0
    //
    UINTX rsvd30_12 : 19;
    //
    //
    //     [list]
    //     [*]0: The D-Unit VNN Scaling Timer is disabled.
    //     [*]1: The D-Unit VNN Scaling Timer is enabled.
    //     [/list]
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX vnn_timer_en : 1;
  } Bits;
  UINTX Data;
} D_CR_VNNTIMER_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_TQCTL_DUNIT_BOXTYPE_REG                       0x00000050
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This bit enables periodic TQ Poll. If disabled, D-Unit will not read MR4 value
    // periodically.
    //     [p]Note: Will be enabled only if refreshes are enabled.[/p]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX tqpollen : 1;
    //
    // This bit enables MR4 read on Self Refresh Exit. If disabled, D-Unit will not read
    // MR4 value on Self-Refresh exit.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX tqpollsren : 1;
    //
    // When set to 1, D-Unit pushes the data form the last MR4 read to a punit register.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX tqdatapushen : 1;
    //
    // When set to 1, the Dynamic Timing Derating is enabled. When the D-Unit determines
    // (via TQ polling) that the DRAM requires timing derating in addition to refresh
    // interval adjustment, the D-Unit will automatically adjust the relevant timing
    // parameters.
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX enderate : 1;
    //
    // When set, before every Self refresh entry, D-Unit writes a 1 to bit 7 of TQOFFSET.MR_VALUE
    // when TQDATA for that rank indicates a value higher then 0x3, and writes a 0 to
    // that bit otherwise. The new MR_VALUE is then written into MR2 of DDR3 for each
    // enabled rank.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX srten : 1;
    //
    // Reserved.
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX rsvd7_5 : 3;
    //
    // This sets the frequency by which the D-Unit polls the DRAM mode register MR4 to
    // determine required refresh rate (in 4x tREFI units).
    //
    // Bits[21:8], RW, default = 0x0
    //
    UINTX tqpollper : 14;
    //
    // Reserved.
    //
    // Bits[25:22], RO, default = 0x0
    //
    UINTX rsvd25_22 : 4;
    //
    // This field contains the data of the last DRAM Mode Register Read to MR4 MRR issued.
    // It is overwritten with each command.
    //
    // Bits[28:26], RW/V, default = 0x3
    //
    UINTX tqdatar0 : 3;
    //
    // If Rank 1 is disabled, this value will remain zero.
    //     [p]This field contains the data of the last DRAM Mode Register Read to MR4
    // MRR issued. It is overwritten with each command.[/p]
    //
    // Bits[31:29], RW/V, default = 0x3
    //
    UINTX tqdatar1 : 3;
  } Bits;
  UINTX Data;
} D_CR_TQCTL_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_TQOFFSET_DUNIT_BOXTYPE_REG                    0x00000054
#ifndef ASM_INC
typedef union {
  struct {
    //
    // (WIO2 only) Everytime MR3_OFFSET_UPDATE is set, D-Unit merges the value in this
    // field with MR3_VALUE and writes the result to MR3 in DRAM
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX mr3_therm_offset : 2;
    //
    // When set, D-Unit writes the merged value of MR3_VALUE and MR3_THERM_OFFSET into
    // MR3 of DRAM. D-Unit clears this bit once the value is written.
    //
    // Bits[2:2], RW/V, default = 0x0
    //
    UINTX mr3_offset_update : 1;
    //
    // Reserved.
    //
    // Bits[7:3], RO, default = 0x0
    //
    UINTX rsvd7_3 : 5;
    //
    // D-Unit adds the value of this field to TQDATA read from MR4 the resulting value
    // is used to control refresh rate and AC timing derating.
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX mr4_adder : 3;
    //
    // Reserved
    //
    // Bits[15:11], RO, default = 0x0
    //
    UINTX rsvd15_11 : 5;
    //
    // MR3 Shadow Register (WIO2 only):
    //       [p]BIOS sets the value of this field at boot time based on the DRAM device
    // configuration. D-Unit merges the value in MR3_THERM_OFFSET with this field and
    // writes the result into DRAM MR3 [/p]
    //       [p]MR2 Shadow Register (DDR3L Only):[/p]
    //       [p]BIOS writes the correct value of MR2 register in DDR3L into this field
    // at boot time. D-Unit modifies one bit and rewrites the MR2 into DDR3L DRAM before
    // SR entry.[/p]
    //
    // Bits[25:16], RW, default = 0x0
    //
    UINTX mr_value : 10;
    //
    // Reserved.
    //
    // Bits[31:26], RO, default = 0x0
    //
    UINTX rsvd31_26 : 6;
  } Bits;
  UINTX Data;
} D_CR_TQOFFSET_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DCO_DUNIT_BOXTYPE_REG                         0x00000058
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX rsvd0 : 1;
    //
    // Setting this field to 1 enables all maintenance operations. When DCO.IC is set,
    // the maintenance operations are enabled irrespective of the value of this field.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX mnten : 1;
    //
    // Writing a 1 to this field resets all maintenance timers. Clears all states and
    // also clears refresh debt queues. This bit needs to be cleared by software after
    // at least 3 SPID clocks.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX mntrst : 1;
    //
    // When enabled, D-Unit will synchronize clock crossing signals.
    //     [list]
    //     [*]0: PSMI Mode is disabled.
    //     [*]1: PSMI Mode is enabled.
    //           [/list]
    //     [p]Note: Change only allowed when D-Unit is idle.[/p]
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX psmien : 1;
    //
    // Reserved.
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX rsvd7_4 : 4;
    //
    // Reserved.
    //
    // Bits[27:8], RO, default = 0x0
    //
    UINTX rsvd27_8 : 20;
    //
    //
    //     [list]
    //     [*]0: D-Unit PMI is connected to Bunit/GSA/2LM.
    //     [*]1: D-Unit PMI is connected to CPGC.
    //       [/list]
    //       [p]Note: D_CR_DSCH_BYPASSEN must be set to 0 in CPGC mode.[/p]
    //     [p]Note: PMI must be idle and D-Unit BGF_RUN = 0 before changing the value
    // in this register.[/p]
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX pmictl : 1;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX rsvd29 : 1;
    //
    // Status indication that the DDRIO PHY initialization is complete reflects the status
    // spid_init_complete signal.
    //
    // Bits[30:30], RO/V, default = 0x0
    //
    UINTX dioic : 1;
    //
    // Indicates that initialization of the D-Unit has been completed. Memory accesses
    // are permitted and maintenance operation begins. Until this bit is set to a 1,
    // the memory controller will not accept DRAM requests from the Bunit/GSA/2LM (PMI
    // ISMs will not leave idle).
    //     [p]Note: Set this bit to 1 only when all other D-Unit registers have been configured.
    // Usually set at the last configuration step by BIOS on cold/warm reset. D-Unit
    // hardware sets this bit on SR exit.[/p]
    //
    // Bits[31:31], RW/V, default = 0x0
    //
    UINTX ic : 1;
  } Bits;
  UINTX Data;
} D_CR_DCO_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DTRC_DUNIT_BOXTYPE_REG                        0x0000005C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Block Read Commands to DRAM.
    //       [list]
    //     [*]0: No Block.
    //     [*]1: Block.
    //     [/list]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX blkrd : 1;
    //
    // Block Write Commands to DRAM.
    //       [list]
    //     [*]0: No Block.
    //     [*]1: Block.
    //     [/list]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX blkwr : 1;
    //
    // Block Activate Commands to DRAM.
    //     [list]
    //     [*]0: No Block.
    //     [*]1: Block.
    //     [/list]
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX blkact : 1;
    //
    // Block Precharge Commands to DRAM.
    //     [list]
    //     [*]0: No Block.
    //     [*]1: Block.
    //     [/list]
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX blkpre : 1;
    //
    // Block Processing Read Requests until RPQ is Full.
    //     [p]When this bit is set to 1, the D-Unit is blocked from processing any of
    // the requests in the RPQ until it is full. The full level is based on the RPQCOUNT
    // value.[/p]
    //     [list]
    //     [*]0: No block.
    //     [*]1: Block.
    //     [/list]
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX blkrpqf : 1;
    //
    // Block Processing Write Requests until WPQ is Full.
    //     [p]When this bit is set to 1, the D-Unit is blocked from processing any of
    // the requests in the WPQ until it is full. The full level is based on the WPQCOUNT
    // value.[/p]
    //     [list]
    //     [*]0: No block.
    //     [*]1: Block.
    //     [/list]
    //     [p]Note: Once WPQ is full, it is unblocked until an entry is deallocated. So
    // there could be more than one write scheduled during that window.[/p]
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX blkwpqf : 1;
    //
    // The D-Unit runs at half (LPDDR3/WIO2/DDR3L) or quarter (LPDDR4) the frequency
    // of the DRAM clock to save power. In order to issue back-to-back commands on every
    // DRAM clock cycle, the D-Unit has to schedule two/four commands per D-Unit clock.
    // Therefore, it processes requests through separate arbitration paths labeled as
    // Phase_0, Phase_1, Phase_2 and Phase_3.
    //       [p]In LPDDR3/WIO2/DDR3 case setting this bit to a 1 will disable Phase_1
    // and all memory requests will be processed through Phase_0 arbitration path. With
    // only Phase_0 enabled, the DRAM device will never see back-to-back commands. The
    // best it will see is a command every other DRAM clock cycle.[/p]
    //       [p]In LPDDR4 case, each command is two DRAM clocks and they are sent in
    // two consecutive phases. Also, most of the LPDDR4 operations are broken into two
    // commands that have to be sent back-to-back. Therefore, setting this bit to 1 will
    // disable initiating *new* commands on Phase_1, Phase_2 and Phase_3.[/p]
    //       [p]0: No block[/p]
    //       [p]1: Block [/p]
    //       [p]Note: This bit does/must not impact the CPGCs ability to send requests
    // to the SPID in Phase 1/2/3.  D-Unit arbiter comprehends this bit to issue 1 Command
    // per SPIDCLK when set versus 2 Commands per SPIDCLK when not set.[/p]
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX blkphaseb : 1;
    //
    //
    //     [list]
    //     [*]0: D-Unit is not in DQ Calibration Mode.
    //     [*]1: D-Unit is in DQ Calibration Mode.
    //     [/list]
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX dqcalen : 1;
    //
    //
    //     [list]
    //     [*]0: D-Unit is not in JEDEC CA Training Mode.
    //     [*]1: D-Unit is in JEDEC CA Training Mode.
    //     [/list]
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX catrainen : 1;
    //
    // When set, CPGC will have full control of the Write ECC data and bypasses D-Unit's
    // runtime ECC and data scrambling function. Also when enabled, read ECC error detection/correction/reporting
    // logic is disabled.
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX cpgc_ecc_bypass_en : 1;
    //
    // Reserved.
    //
    // Bits[31:10], RO, default = 0x0
    //
    UINTX rsvd31_10 : 22;
  } Bits;
  UINTX Data;
} D_CR_DTRC_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DCBR_DUNIT_BOXTYPE_REG                        0x000000A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When set to 1, D-Unit error correction logic will be disabled. So all ECC errors
    // would be considered uncorrectable.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX ecdis : 1;
    //
    // When set, D-Unit will update the status bits in D_CR_DSTAT. If not set, D_CR_DSTAT
    // will not reflect the latest status of the D-Unit.
    //       [p]Note: This enable bit does not control Page Table Status Field in DSTAT
    // CR.[/p]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX cr_stat_en : 1;
    //
    // When set to 1, the PMI interface remains in idle state.
    //     [p]Note: Setting this bit does not force the PMI ISM to move to idle state.[/p]
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX pmidis : 1;
    //
    // When set to 1, the D-Unit ignores PHY periodic quite time update requests.
    //     [p]Note: Setting this bit does not prevent PHY from requesting selfrefresh
    // exit or bus quiet time.[/p]
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX phyqtdis : 1;
    //
    // When set, D-Unit will update the status bits in DSTAT.PGTBLVLD. If not set, the
    // status CR, will not reflect the latest status of the page table.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX pgtblstaten : 1;
    //
    // Reserved.
    //
    // Bits[6:5], RO, default = 0x0
    //
    UINTX rsvd6_5 : 2;
    //
    // When set to 1, D-Unit closes all pages by issuing a PREALL before sending the
    // MRR command to DRAM.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX mrrcp : 1;
    //
    // Disable Accepting Requests During Self Refresh Exit (prevent D-Unit PMI ISM to
    // leave idle).
    //     [list]
    //     [*]0: D-Unit accepts and loads PMI requests into the queues during Self Refresh
    // exit period while maintenance operation are in progress.
    //     [*]1: D-Unit does not accept PMI requests until Self Refresh exit and all maintenance
    // operations have completed.
    //     [/list]
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX srxnrqdis : 1;
    //
    // When set to 1, D-Unit will always use credit metering to only advertise few initial
    // credits to PMI requestor.
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX fullcmdcrdis : 1;
    //
    // When set, D-Unit will not be able to enter the state to stop/tristate the CK or
    // tristate ODT/CS pins.
    //       [p]Note: Setting this bit also disables entry to LPMODEs.[/p]
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX tristdis : 1;
    //
    // When set, D-Unit will not do a Mode Register Write to set the mask on SR entry
    // due to SUSPENDP message and will not do Mode Register Write to clear the mask
    // on SR due to WAKE message.
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX pasrdis : 1;
    //
    // Reserved.
    //
    // Bits[31:12], RO, default = 0x0
    //
    UINTX rsvd31_12 : 20;
  } Bits;
  UINTX Data;
} D_CR_DCBR_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_SCRAMCTRL_DUNIT_BOXTYPE_REG                   0x000000A4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Sets the key for the scrambler. The key should be a random value that is set following
    // each cold boot.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX key : 16;
    //
    // Reserved.
    //
    // Bits[27:16], RO, default = 0x0
    //
    UINTX rsvd27_16 : 12;
    //
    // This field controls how the scrambler output code is clock gated to reduce power.
    //     [list]
    //     [*]00: Clock gate disabled.
    //     [*]01: Clock Gate every 2 cycle.
    //     [*]10: Clock Gate every 3 cycle.
    //     [*]11: Clock Gate every 4 cycle.
    //     [/list]
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX clockgate : 2;
    //
    // Reserved.
    //
    // Bits[30:30], RO, default = 0x0
    //
    UINTX rsvd30 : 1;
    //
    // When set to 1, data scrambling is enabled. When set to 0, data scrambling is disabled.
    // Should be set before D_CR_BGF_CTL_BGF_RUN is set to 1.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX scrm_en : 1;
  } Bits;
  UINTX Data;
} D_CR_SCRAMCTRL_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DSTAT_DUNIT_BOXTYPE_REG                       0x000000A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX rsvd4_0 : 5;
    //
    //
    //     [list]
    //     [*]0: D-Unit RPQ is not empty (pending read requests in RPQ).
    //     [*]1: D-Unit RPQ is empty.
    //     [/list]
    //
    // Bits[5:5], RO/V, default = 0x1
    //
    UINTX rpqempty : 1;
    //
    //
    //     [list]
    //     [*]0: D-Unit WPQ is not empty (pending write requests in WPQ).
    //     [*]1: D-Unit WPQ is empty.
    //     [/list]
    //
    // Bits[6:6], RO/V, default = 0x1
    //
    UINTX wpqempty : 1;
    //
    //
    //     [list]
    //     [*]0: Selected technology is valid.
    //     [*]1: Selected technology is not supported.
    //     [/list]
    //
    // Bits[7:7], RO/V, default = 0x0
    //
    UINTX invtech : 1;
    //
    // Rank 0 has a Refresh Debt.
    //
    // Bits[8:8], RO/V, default = 0x0
    //
    UINTX refdbt0 : 1;
    //
    // Rank 1 has a Refresh Debt.
    //
    // Bits[9:9], RO/V, default = 0x0
    //
    UINTX refdbt1 : 1;
    //
    // The D-Unit sets this bit to a 1 after it has placed the DRAM devices in Self Refresh
    // mode.
    //     [p]The D-Unit clears this bit when it brings the DRAM devices out of Self Refresh
    // mode and completes maintenance operations.[/p]
    //     [list]
    //     [*]0: DRAM not in SelfRefresh.
    //     [*]1: DRAM in SelfRefresh.
    //     [/list]
    //     [p]Note: If DRAM is in SR because of Dynamic SR reading any D-Unit register
    // will bring DRAM out of SR.[/p]
    //
    // Bits[10:10], RO/V, default = 0x0
    //
    UINTX disr : 1;
    //
    // Reserved.
    //
    // Bits[15:11], RO, default = 0x0
    //
    UINTX rsvd15_11 : 5;
    //
    // This register indicates whether a page is open within a bank. Each bit reflects
    // the page open status of a bank. 2 Ranks x 8 banks/rank = 16 status bits.
    //     [list}
    //     [*]PGTBLVLD[7:0] = Page open status for Rank 0 Bank[7:0].
    //     [*]PGTBLVLD[15:8] = Page open status for Rank 1 Bank[7:0].
    //           [*]0: The associated bank is closed.
    //     [*]1: The associated bank has been opened.
    //     [/list]
    //
    // Bits[31:16], RO/V, default = 0xFFFF
    //
    UINTX pgtblvld : 16;
  } Bits;
  UINTX Data;
} D_CR_DSTAT_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_ERR_INJ_DUNIT_BOXTYPE_REG                     0x000000AC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX rsvd0 : 1;
    //
    // Specifies the PMI address of the write transaction to be injected with the error.
    // Only applicable to Write transactions. Read/under-fill read of the partial write
    // operation is not affected.
    //
    // Bits[30:1], RW, default = 0x0
    //
    UINTX address : 30;
    //
    // Reserved.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX rsvd31 : 1;
  } Bits;
  UINTX Data;
} D_CR_ERR_INJ_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_ERR_INJ_CTL_DUNIT_BOXTYPE_REG                 0x000000B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When set, the error injection is continuously armed for lower 32B of D_CR_ERR_INJ_ADDR
    // write address matching until it is cleared.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX en_lo : 1;
    //
    // 0 - Uncorrectable Error (UE) is armed for write address matching to inject UE
    // by using the same poisoning scheme, i.e. inverting corresponding write ECC[6:0]
    // on every QW of the 32B data. [br]1 - Correctable Error (CE) is armed for write
    // address matching to inject CE by inverting corresponding write ECC[0] on every
    // QW of the 32B data.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX sel_lo : 1;
    //
    // When set the error injection is continuously armed for higher 32B of D_CR_ERR_INJ_ADDR
    // write address matching until it is cleared.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX en_hi : 1;
    //
    // If enabled, the error injection is continuously armed for ERR_INJ.ADDR 32B write
    // address matching until it is cleared.
    //       [list]
    //       [*]00: No error injection.
    //       [*]01: Uncorrectable Error (UE) is armed for write address matching to inject
    // UE by using the same poisoning scheme, i.e. inverting corresponding write ECC[6:0]
    // on QW0 of the 32B data.
    //       [*]10: Correctable Error (CE) is armed for write address matching to inject
    // CE by inverting corresponding write ECC[0] on QW0 of the 32B data.
    //       [*]11: Reserved.
    //       [/list]
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX sel_hi : 1;
    //
    // Reserved
    //
    // Bits[31:4], RO, default = 0x0
    //
    UINTX rsvd31_4 : 28;
  } Bits;
  UINTX Data;
} D_CR_ERR_INJ_CTL_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_ERR_ECC_LOG_DUNIT_BOXTYPE_REG                 0x000000B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Read Return Tag matches with the PMI Request Tag which triggered the error log.
    //
    // Bits[15:0], RW/V, default = 0x0
    //
    UINTX tag : 16;
    //
    // ECC Syndrome for a QW (64 bit) within 32B Address
    //
    // Bits[23:16], RW/V, default = 0x0
    //
    UINTX syndrome_qw : 8;
    //
    // Chunk number of the error. [br]0 - lower 32B chunk has error if MERR/CERR is set
    // [br]1 - higher 32B chunk has the error if MERR/CERR is set
    //
    // Bits[24:24], RW/V, default = 0x0
    //
    UINTX err_chunk : 1;
    //
    // Burst number (in BL8) of the error within a chunk.
    //
    // Bits[26:25], RW/V, default = 0x0
    //
    UINTX err_burst : 2;
    //
    // This bit is set when an uncorrectable multiple-bit error occurs on a memory read
    // data transfer.  When this bit is set, the address that caused the error and the
    // error syndrome are also logged and they are locked until this bit is cleared.
    //
    // Bits[27:27], RW/V, default = 0x0
    //
    UINTX merr : 1;
    //
    // This bit is set when a correctable single-bit error occurs on a memory read data
    // transfer.  When this bit is set, the address that caused the error and the error
    // syndrome are also logged and they are locked to further single bit errors, until
    // this bit is cleared. A multiple bit error that occurs after this bit is set will
    // override the address/error syndrome information.
    //
    // Bits[28:28], RW/V, default = 0x0
    //
    UINTX cerr : 1;
    //
    // Select ECC byte on Visa :
    //       00 : Ecc byte,
    //       01: PMI Data Byte [7:0],
    //       10: PMI Data Byte [63:56],
    //       11: PMI Data Byte [255:248]
    //
    // Bits[30:29], RW, default = 0x0
    //
    UINTX ecc_visa : 2;
    //
    // Setting this bit to one clears all fields in this register, including itself.
    //
    // Bits[31:31], RW/V, default = 0x0
    //
    UINTX clear : 1;
  } Bits;
  UINTX Data;
} D_CR_ERR_ECC_LOG_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DFUSESTAT_DUNIT_BOXTYPE_REG                   0x000000BC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // D-Unit fuse bits are captured into this register and are available to be read.
    //       [list]
    //     [*][0]: fus_dun_ecc_dis.
    //     [*][3:1]: fus_dun_max_supported_device_size[2:0].
    //     [*][4:4]: fus_dun_lpddr3_dis.
    //     [*][5:5]: fus_dun_lpddr4_dis.
    //     [*][6:6]: fus_dun_wio2_dis.
    //     [*][7:7]: fus_dun_ddr3l_dis.
    //     [*][15:8]: reserved.
    //     [/list]
    //
    // Bits[15:0], RO/V, default = 0x0
    //
    UINTX fusestat : 16;
    //
    // Reserved.
    //
    // Bits[31:16], RO, default = 0x0
    //
    UINTX rsvd31_16 : 16;
  } Bits;
  UINTX Data;
} D_CR_DFUSESTAT_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_SSKPD0_DUNIT_BOXTYPE_REG                      0x000000C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // General purpose scratchpad.  May be used for BIOS for data storage.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX val : 32;
  } Bits;
  UINTX Data;
} D_CR_SSKPD0_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_SSKPD1_DUNIT_BOXTYPE_REG                      0x000000C4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // General purpose scratchpad.  May be used for BIOS for data storage.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX val : 32;
  } Bits;
  UINTX Data;
} D_CR_SSKPD1_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_BONUS0_DUNIT_BOXTYPE_REG                      0x000000C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This register is reserved for ECO.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX bonus0 : 32;
  } Bits;
  UINTX Data;
} D_CR_BONUS0_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_BONUS1_DUNIT_BOXTYPE_REG                      0x000000CC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This register is reserved for ECO.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX bonus1 : 32;
  } Bits;
  UINTX Data;
} D_CR_BONUS1_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DQCALRDATLO_DUNIT_BOXTYPE_REG                 0x000000D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Holds least significant 32 bits returned as a result of CA Training.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX dqcalrdatlo : 32;
  } Bits;
  UINTX Data;
} D_CR_DQCALRDATLO_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DQCALRDATHI_DUNIT_BOXTYPE_REG                 0x000000D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Holds most significant 32 bits returned as a result of DQ calibration/CA training
    // (Reserved in BXT0/1).
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX dqcalrdathi : 32;
  } Bits;
  UINTX Data;
} D_CR_DQCALRDATHI_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_BGF_CUSTOM_TSV_CMD_PATTERN_DUNIT_BOXTYPE_REG  0x000000D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Provides custom TSVs for BGFs which write in the SABY2 clock and read in CMD SPID
    // clock.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX saby2_to_cmdspid_tsvs : 16;
    //
    // Provides custom TSVs for BGFs which write in the CMD SPID clock and read in SABY2
    // clock.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX cmdspid_to_saby2_tsvs : 16;
  } Bits;
  UINTX Data;
} D_CR_BGF_CUSTOM_TSV_CMD_PATTERN_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_BGF_CUSTOM_TSV_CMD_INIT_DUNIT_BOXTYPE_REG     0x000000DC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Provides custom TSVs for BGFs which write in SABY2 clock and read in CMD SPID
    // clock.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX saby2_to_cmdspid_tsvs : 16;
    //
    // Provides custom TSVs for BGFs which write in the CMD SPID clock and read in SABY2
    // clock.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX cmdspid_to_saby2_tsvs : 16;
  } Bits;
  UINTX Data;
} D_CR_BGF_CUSTOM_TSV_CMD_INIT_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_BGF_CUSTOM_TSV_DATA_PATTERN_DUNIT_BOXTYPE_REG 0x000000E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Provides custom TSVs for BGFs which write in SABY2 clock and read in DATA SPID
    // clock
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX saby2_to_dataspid_tsvs : 16;
    //
    // Provides custom TSVs for BGFs which write in the DATA SPID clock and read in SABY2
    // clock.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX dataspid_to_saby2_tsvs : 16;
  } Bits;
  UINTX Data;
} D_CR_BGF_CUSTOM_TSV_DATA_PATTERN_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_BGF_CUSTOM_TSV_DATA_INIT_DUNIT_BOXTYPE_REG    0x000000E4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Provides custom TSVs for BGFs which write in SABY2 clock and read in DATA SPID
    // clock.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX saby2_to_dataspid_tsvs : 16;
    //
    // Provides custom TSVs for BGFs which write in the DATA SPID clock and read in SABY2
    // clock.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX dataspid_to_saby2_tsvs : 16;
  } Bits;
  UINTX Data;
} D_CR_BGF_CUSTOM_TSV_DATA_INIT_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_BGF_CTL_DUNIT_BOXTYPE_REG                     0x00000120
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Start BGFs.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX bgf_run : 1;
    //
    // Reserved.
    //
    // Bits[1:1], RO, default = 0x0
    //
    UINTX rsvd1 : 1;
    //
    // Enable the use of locally generated sync signals.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX use_localsync : 1;
    //
    // Variable separation of the serial fifos to be passed into the se module. BEZAN
    // TO FIX
    //
    // Bits[4:3], RW, default = 0x0
    //
    UINTX fus_separation_saby2spid : 2;
    //
    // Disable BGF clock generator.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX cg_dis : 1;
    //
    // Variable separation of the serial fifos to be passed into the se module.
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX fus_separation_spidsaby2 : 2;
    //
    // The ratio of clock A (SAby2):1.
    //     [p]Note: this field must be set to the same value as SPIDCMDCLK_RATIO when
    // CPGC is active.[/p]
    //
    // Bits[15:8], RW, default = 0x1
    //
    UINTX saclkby2_ratio : 8;
    //
    // The ratio of clock B (SPIDCmd):1.
    //
    // Bits[23:16], RW, default = 0x3
    //
    UINTX spidcmdclk_ratio : 8;
    //
    // The ratio of clock C (SPIDData):1.
    //
    // Bits[31:24], RW, default = 0x3
    //
    UINTX spiddataclk_ratio : 8;
  } Bits;
  UINTX Data;
} D_CR_BGF_CTL_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_MMC_DUNIT_BOXTYPE_REG                         0x00000124
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When the number of entries in WPQ is greater than or equal to this value, the
    // D-Unit will switch to write major mode (WMM).
    //     [p]Note: the value must not be set to 0.[/p]
    //
    // Bits[5:0], RW, default = 0x18
    //
    UINTX wmmentry : 6;
    //
    // When the number of entries in WPQ is less than this value, the D-Unit will switch
    // back to read major mode.
    //
    // Bits[11:6], RW, default = 0x14
    //
    UINTX wmmexit : 6;
    //
    // When the number of entries in WPQ is greater than or equal to this value (higher
    // than WMM entry watermark, less than WPQ size), it triggers write isoch mode (WIM).
    //
    // Bits[17:12], RW, default = 0x1E
    //
    UINTX wimthrs : 6;
    //
    // Reserved.
    //
    // Bits[22:18], RO, default = 0x0
    //
    UINTX rsvd22_18 : 5;
    //
    // If any read in the RPQ is at this programmable priority, RIM is triggered.
    //
    // Bits[25:23], RW, default = 0x6
    //
    UINTX rimprio : 3;
    //
    // Reserved.
    //
    // Bits[26:26], RO, default = 0x0
    //
    UINTX rsvd26 : 1;
    //
    // If a conflict read reaches this priority (or greater depending on access class
    // occupancy), WMM will be triggered to unblock the corresponding write. D-Unit will
    // stay in WMM until corresponding write is issued.
    //     [p]Note: The value in this bit must not be higher than lowest terminal priority
    // level of each access class.[/p]
    //
    // Bits[29:27], RW, default = 0x5
    //
    UINTX raw_wmm : 3;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_MMC_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_MMRDWR_AB_DUNIT_BOXTYPE_REG                   0x00000128
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Minimum number of reads that has to be serviced before a switch to WMM is allowed
    // (set A).
    //
    // Bits[5:0], RW, default = 0x8
    //
    UINTX minrda : 6;
    //
    // Maximum number of writes D-Unit can send in WMM mode before returning to RMM (set
    // A).
    //
    // Bits[11:6], RW, default = 0x1F
    //
    UINTX maxwra : 6;
    //
    // Reserved.
    //
    // Bits[13:12], RO, default = 0x0
    //
    UINTX rsvd13_12 : 2;
    //
    // Minimum number of reads that has to be serviced before a switch to WMM is allowed
    // (set B).
    //
    // Bits[19:14], RW, default = 0x8
    //
    UINTX minrdb : 6;
    //
    // Maximum number of writes D-Unit can send in WMM mode before returning to RMM (set
    // B).
    //
    // Bits[25:20], RW, default = 0x1F
    //
    UINTX maxwrb : 6;
    //
    // Reserved.
    //
    // Bits[31:26], RO, default = 0x0
    //
    UINTX rsvd31_26 : 6;
  } Bits;
  UINTX Data;
} D_CR_MMRDWR_AB_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_MMRDWR_CD_DUNIT_BOXTYPE_REG                   0x0000012C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Minimum number of reads that has to be serviced before a switch to WMM is allowed
    // (set C).
    //
    // Bits[5:0], RW, default = 0x8
    //
    UINTX minrdc : 6;
    //
    // Maximum number of writes D-Unit can send in WMM mode before returning to RMM (set
    // C).
    //
    // Bits[11:6], RW, default = 0x1F
    //
    UINTX maxwrc : 6;
    //
    // Reserved.
    //
    // Bits[13:12], RO, default = 0x0
    //
    UINTX rsvd13_12 : 2;
    //
    // Minimum number of reads that has to be serviced before a switch to WMM is allowed
    // (set D).
    //
    // Bits[19:14], RW, default = 0x8
    //
    UINTX minrdd : 6;
    //
    // Maximum number of writes D-Unit can send in WMM mode before returning to RMM (set
    // D).
    //
    // Bits[25:20], RW, default = 0x1F
    //
    UINTX maxwrd : 6;
    //
    // Reserved.
    //
    // Bits[31:26], RO, default = 0x0
    //
    UINTX rsvd31_26 : 6;
  } Bits;
  UINTX Data;
} D_CR_MMRDWR_CD_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_ACCIP_DUNIT_BOXTYPE_REG                       0x00000130
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Initial priority level of read requests coming with access class 0.
    //
    // Bits[2:0], RW, default = 0x2
    //
    UINTX ac0ip : 3;
    //
    // Initial priority level of read requests coming with access class 1.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX ac1ip : 3;
    //
    // Initial priority level of read requests coming with access class 2.
    //
    // Bits[8:6], RW, default = 0x7
    //
    UINTX ac2ip : 3;
    //
    // Initial priority level of read requests coming with access class 3.
    //
    // Bits[11:9], RW, default = 0x3
    //
    UINTX ac3ip : 3;
    //
    // Initial priority level of read requests coming with access class 4.
    //
    // Bits[14:12], RW, default = 0x1
    //
    UINTX ac4ip : 3;
    //
    // Reserved.
    //
    // Bits[31:15], RO, default = 0x0
    //
    UINTX rsvd31_15 : 17;
  } Bits;
  UINTX Data;
} D_CR_ACCIP_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_RD_PROM0_DUNIT_BOXTYPE_REG                    0x00000134
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX p1res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[9:5], RW, default = 0xA
    //
    UINTX p2res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[14:10], RW, default = 0xA
    //
    UINTX p3res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[19:15], RW, default = 0xA
    //
    UINTX p4res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[24:20], RW, default = 0x1F
    //
    UINTX p5res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[29:25], RW, default = 0x0
    //
    UINTX p6res : 5;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_RD_PROM0_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_RD_PROM1_DUNIT_BOXTYPE_REG                    0x00000138
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX p1res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[9:5], RW, default = 0x0
    //
    UINTX p2res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[14:10], RW, default = 0x0
    //
    UINTX p3res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[19:15], RW, default = 0x0
    //
    UINTX p4res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[24:20], RW, default = 0x0
    //
    UINTX p5res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[29:25], RW, default = 0xA
    //
    UINTX p6res : 5;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_RD_PROM1_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_RD_PROM2_DUNIT_BOXTYPE_REG                    0x0000013C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX p1res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[9:5], RW, default = 0x0
    //
    UINTX p2res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[14:10], RW, default = 0x0
    //
    UINTX p3res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[19:15], RW, default = 0x0
    //
    UINTX p4res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[24:20], RW, default = 0x0
    //
    UINTX p5res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[29:25], RW, default = 0x0
    //
    UINTX p6res : 5;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_RD_PROM2_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_RD_PROM3_DUNIT_BOXTYPE_REG                    0x00000140
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX p1res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[9:5], RW, default = 0x0
    //
    UINTX p2res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[14:10], RW, default = 0x5
    //
    UINTX p3res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[19:15], RW, default = 0x5
    //
    UINTX p4res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[24:20], RW, default = 0x1F
    //
    UINTX p5res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[29:25], RW, default = 0x0
    //
    UINTX p6res : 5;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_RD_PROM3_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_RD_PROM4_DUNIT_BOXTYPE_REG                    0x00000144
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[4:0], RW, default = 0xA
    //
    UINTX p1res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[9:5], RW, default = 0xA
    //
    UINTX p2res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[14:10], RW, default = 0xA
    //
    UINTX p3res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[19:15], RW, default = 0xA
    //
    UINTX p4res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[24:20], RW, default = 0x1F
    //
    UINTX p5res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level.
    //
    // Bits[29:25], RW, default = 0x0
    //
    UINTX p6res : 5;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_RD_PROM4_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DL_THRS_DUNIT_BOXTYPE_REG                     0x00000148
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A requests with initial priority of 0 will exit priority 0 when its deadline is
    // equal or less than this value plus current time.  This field does not affect the
    // priority of any requests in access classes with initial priority bigger than 0.
    //
    // Bits[10:0], RW, default = 0x6
    //
    UINTX deadline_thrs : 11;
    //
    // Reserved.
    //
    // Bits[31:11], RO, default = 0x0
    //
    UINTX rsvd31_11 : 21;
  } Bits;
  UINTX Data;
} D_CR_DL_THRS_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_MM_BLK_DUNIT_BOXTYPE_REG                      0x0000014C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Disable RMM unsafe top critical read miss block read and write hit same bank.
    //
    //     [p]Note: Priority rules 1, 3 and 4 should be enabled/disabled together.[/p]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX rmm_prio_r1 : 1;
    //
    // Disable RMM CAS block rule.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX rmm_prio_r2 : 1;
    //
    // Disable RMM unsafe critical read hit block read and write miss to same bank.
    //     [p]Note: This rule does not block the bank that is being blocked by RMM_PRIO_R1.[/p]
    //     [p]Priority rules 1, 3 and 4 should be enabled/disabled together.[/p]
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX rmm_prio_r3 : 1;
    //
    // Disable RMM unsafe critical read miss block read and write hit to same bank.
    //     [p]Note: This rule does not block the bank that is being blocked by RMM_PRIO_R3.[/p]
    //     [p]Priority rules 1, 3 and 4 should be enabled/disabled together.[/p]
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX rmm_prio_r4 : 1;
    //
    // Reserved.
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX rsvd7_4 : 4;
    //
    // Disable RMM unsafe read page hit block safe write page hit same rank.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX rmm_reg_r1 : 1;
    //
    // Disable RMM unsafe read page empty block safe write page empty same rank.
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX rmm_reg_r2 : 1;
    //
    // Disable RMM unsafe read page hit block safe read and write page miss same bank.
    //
    //     [p]Note: This rule does not block the bank that is being blocked by RMM_PRIO_R3
    // and RMM_PRIO_R1.[/p]
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX rmm_reg_r3 : 1;
    //
    // Disable RMM unsafe write page hit block safe read page miss same bank.
    //     [p]Note: This field must not be set to 0 (enabled) if RMM_REG_R5 is also 0.[/p]
    //
    // Bits[11:11], RW, default = 0x1
    //
    UINTX rmm_reg_r4 : 1;
    //
    // Disable RMM unsafe read page miss block all safe and unsafe write page hit to
    // the same bank.
    //     [p]Note: This field must not be set to 0 (enabled) if RMM_REG_R4 is also 0.[/p]
    //
    // Bits[12:12], RW, default = 0x1
    //
    UINTX rmm_reg_r5 : 1;
    //
    // Disable RMM unsafe write page hits block safe write page misses same bank.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX rmm_reg_r6 : 1;
    //
    // Reserved.
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX rsvd15_14 : 2;
    //
    // Disable WMM unsafe top priority 1 write miss block write hit same bank.
    //     [p]Priority rules 1, 3 and 4 should be enabled/disabled together.[/p]
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX wmm_prio_r1 : 1;
    //
    // Disable WMM CAS block rule.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX wmm_prio_r2 : 1;
    //
    // Disable WMM unsafe priority 1 write hit block write miss to same bank.
    //     [p]Note: This rule does not block the bank that is being blocked by WMM_PRIO_R1.[/p]
    //     [p]Priority rules 1,3 and 4 should be enabled/disabled together.[/p]
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX wmm_prio_r3 : 1;
    //
    // Disable WMM unsafe priority 1 read miss block write hit to same bank.
    //     [p]Note: This rule does not block the bank that is being blocked by WMM_PRIO_R3.[/p]
    //     [p]Priority rules 1, 3 and 4 should be enabled/disabled together.[/p]
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX wmm_prio_r4 : 1;
    //
    // Reserved.
    //
    // Bits[23:20], RO, default = 0x0
    //
    UINTX rsvd23_20 : 4;
    //
    // Disable WMM unsafe write page hits block safe write page misses same bank.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX wmm_reg_r1 : 1;
    //
    // Reserved.
    //
    // Bits[31:25], RO, default = 0x0
    //
    UINTX rsvd31_25 : 7;
  } Bits;
  UINTX Data;
} D_CR_MM_BLK_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DRAM_SR_CMD_DUNIT_BOXTYPE_REG                 0x00000154
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Take PHY out of PM states and wakes the DRAM out of self refresh mode. The bit
    // is cleared by hardware only when the DRAM has exited out of self refresh mode
    // and is accessible.
    //     [p]Note: When COLDWAKE is set prior of setting this bit the D-Unit will not
    // send SR exit command and will not set the DCO.IC bit.[/p]
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX wake : 1;
    //
    // Reserved.
    //
    // Bits[1:1], RO, default = 0x0
    //
    UINTX rsvd1 : 1;
    //
    // A SUSPEND message will put the DRAM into self-refresh mode. The D-Unit will complete
    // servicing outstanding memory requests and flush all queued Refresh commands to
    // DRAM before putting the DRAM in Self Refresh mode. Finally, a PM message will
    // be sent to the PHY. The bit is cleared by hardware only after the PHY indicates
    // the transition requested in the PM message has been completed.
    //     [p]Note: When COLDWAKE is set prior of setting this bit the DRAM will not be
    // placed in SR.[/p]
    //
    // Bits[2:2], RW/V, default = 0x0
    //
    UINTX suspend : 1;
    //
    // A SUSPENDP message will put the DRAM into self-refresh mode. The D-Unit will complete
    // servicing outstanding memory requests and flush all queued Refresh commands to
    // DRAM before putting the DRAM in self refresh mode. Finally, a PM message will
    // be sent to the PHY. The bit is cleared by hardware after the PHY indicates the
    // transition requested in the PM message has been completed.  D-Unit will perform
    // an MRW to MR17 with an opcode as defined by DPMC0.PASR before it places the DRAM
    // into Self-Refresh.
    //     [p]Note: Reserved for BXT0/1.[/p]
    //
    // Bits[3:3], RW/V, default = 0x0
    //
    UINTX suspendp : 1;
    //
    // Reserved.
    //
    // Bits[31:4], RO, default = 0x0
    //
    UINTX rsvd31_4 : 28;
  } Bits;
  UINTX Data;
} D_CR_DRAM_SR_CMD_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DRAM_CMD_DUNIT_BOXTYPE_REG                    0x00000158
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Command to be sent to DRAM. Not all DRAM commands are supported.
    //       [p]For DDR3L: DATA[15:0] = A[15:0], DATA[18:16] = BA[2:0], DATA[19] = WE_N,
    // DATA[20] = CAS_N, DATA[21] = RAS_N, DATA[23:22] not used.[/p]
    //     [p]For LPDDR3: DATA[9:0]=CA[9:0] Rising Edge, DATA [19:10]=CA[9:0] Falling
    // Edge, DATA[23:20] not used.[/p]
    //     [p]For WIO2: DATA[10:0]=CA[10:0] Rising Edge, DATA[21:11]=CA[10:0] Falling
    // Edge, Data[23:22] not used.[/p]
    //     [p]For LPDDR4: DATA[5:0]=CA[5:0] CMD1 Edge1, DATA[11:6]=CA[5:0] CMD1 Edge2,
    // DATA[17:12]=CA[5:0] CMD2 Edge1, DATA[23:18]=CA[5:0] CMD2 Edge2.[/p]
    //
    // Bits[23:0], RW, default = 0x0
    //
    UINTX data : 24;
    //
    // Reserved.
    //
    // Bits[27:24], RO, default = 0x0
    //
    UINTX rsvd27_24 : 4;
    //
    // This field sets the BL that D-Unit drives on SPID interface.
    //     For LPDDR3, DDR3L and WIO2:
    //     [list]
    //     [*]0: Burst Length is 4.
    //     [*]1: Burst Length is 8.
    //     [/list]
    //     For LPDDR4:
    //       [list]
    //     [*]0: Burst Length is 16.
    //     [*]1: Burst Length is 32.
    //       [/list]
    //
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX bl : 1;
    //
    // This bit needs to be set if the command is a MRR.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX mrrcmd : 1;
    //
    // Rank select.
    //     [list]
    //     [*]0: Rank0.
    //     [*]1: Rank1.
    //     [/list]
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX rank : 1;
    //
    // 2N Mode Command (Reserved in BXT0/1)
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX m2n : 1;
  } Bits;
  UINTX Data;
} D_CR_DRAM_CMD_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DCMDDATA_DUNIT_BOXTYPE_REG                    0x0000015C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MRR Data: This field contains the data of the last DRAM mode register read MRR
    // issued through DRAM_CMD register. It is overwritten with each MRR command.
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX mrrdata : 8;
    //
    // Reserved.
    //
    // Bits[31:8], RO, default = 0x0
    //
    UINTX rsvd31_8 : 24;
  } Bits;
  UINTX Data;
} D_CR_DCMDDATA_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_SBFT_CTL_DUNIT_BOXTYPE_REG                    0x00000160
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contains the final checksum value for all data written to this D-Unit. Write 1
    // to clear this field.
    //
    // Bits[15:0], RW/1C, default = 0x0
    //
    UINTX data_checksum : 16;
    //
    // Contains the address checksum value for all addresses read and written from this
    // D-Unit. Write 1 to clear this field.
    //
    // Bits[23:16], RW/1C, default = 0x0
    //
    UINTX addr_checksum : 8;
    //
    // Read data credit counter value. This values is used as read return credit.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rddata_credit : 4;
    //
    // When set, read data credit counter register is used for credit handling instead
    // of initial credit handshaking.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX rddata_credit_en : 1;
    //
    // Resets the checksum registers when written to 1.
    //     [p]Bit automatically resets to 0.[/p]
    //
    // Bits[29:29], RW/V, default = 0x0
    //
    UINTX reset : 1;
    //
    // Enables checksum calculation in D-Unit. Should be set before D_CR_BGF_CTL_BGF_RUN
    // is set to 1
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX enable_checksum : 1;
    //
    // Enables pseudo-random data return feature in D-Unit. Should be set before D_CR_BGF_CTL_BGF_RUN
    // is set to 1
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX enable_prdr : 1;
  } Bits;
  UINTX Data;
} D_CR_SBFT_CTL_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_SBFT_CMASK_DUNIT_BOXTYPE_REG                  0x00000164
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask ANDed with pseudo-random data. Resets to all 1s. Setting bit n to 0 in this
    // register will force every nth bit in the data to be set to 0
    //
    // Bits[31:0], RW, default = 0xFFFFFFFF
    //
    UINTX clear_mask : 32;
  } Bits;
  UINTX Data;
} D_CR_SBFT_CMASK_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_SBFT_SMASK_DUNIT_BOXTYPE_REG                  0x00000168
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask ORed with pseudo-random data.  Resets to all 0s.  Setting bit n to 1 in this
    // register will force every nth bit in the data to be set to 1.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX set_mask : 32;
  } Bits;
  UINTX Data;
} D_CR_SBFT_SMASK_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_SBFT_SEED_DUNIT_BOXTYPE_REG                   0x0000016C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Seed XORed with address bits to produce pseudo-random data.  Use this to statically
    // produce different pseudo-random data streams for the same set of request addresses.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX seed : 32;
  } Bits;
  UINTX Data;
} D_CR_SBFT_SEED_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DQS_RETRAINING_CTL_DUNIT_BOXTYPE_REG          0x00000180
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Periodic retraining enable:
    //     [p]This bit enables periodic DQS retraining. If disabled, D-Unit will not perform
    // retraining periodically.[/p]
    //     [p]Note: Will be enabled only if DCO.IC is set and refreshes are enabled in
    // DRF.MINREFRATE.[/p]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX dqs_retrain_en : 1;
    //
    // Enable retraining on SR exit.
    //     [p]This bit enables LPDDR4 DQS retraining on Self Refresh Exit. If disabled,
    // D-Unit will not perform retraining on SR exit.[/p]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX dqs_retrain_srx_en : 1;
    //
    // Reserved.
    //
    // Bits[3:2], RO, default = 0x0
    //
    UINTX rsvd3_2 : 2;
    //
    // After D-Unit starts DQS oscillator, it must wait this amount of time before being
    // able to read the value in MR18 and MR19 (in 16x DRAM clocks).
    //     [p]Value in this register must be at least equal to DRAM's MR23 value. + tOSCO.[/p]
    //
    // Bits[13:4], RW, default = 0x0
    //
    UINTX dqs_osc_rt : 10;
    //
    // Reserved.
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX rsvd15_14 : 2;
    //
    // This sets the frequency by which the D-Unit initiates periodic retraining (in
    // 1x NREFI).
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX dqs_retrain_int : 16;
  } Bits;
  UINTX Data;
} D_CR_DQS_RETRAINING_CTL_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_MR4_DESWIZZLE_DUNIT_BOXTYPE_REG               0x00000184
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Selects byte position of the MR4 data first device.
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX mr4_byte_sel : 2;
    //
    // Reserved.
    //
    // Bits[3:2], RO, default = 0x0
    //
    UINTX rsvd3_2 : 2;
    //
    // Selects bit 0 of MR4 data.
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX mr4_bit0_sel : 3;
    //
    // Reserved.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX rsvd7 : 1;
    //
    // Selects bit 1 of MR4 data.
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX mr4_bit1_sel : 3;
    //
    // Reserved.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX rsvd11 : 1;
    //
    // Selects bit 2 of MR4 data.
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX mr4_bit2_sel : 3;
    //
    // Reserved
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX rsvd15 : 1;
    //
    // Selects byte position of the MR4 data for second device.
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX mr4_byte_sel2 : 2;
    //
    // Reserved
    //
    // Bits[19:18], RO, default = 0x0
    //
    UINTX rsvd19_18 : 2;
    //
    // Selects bit 0 of MR4 data.
    //
    // Bits[22:20], RW, default = 0x0
    //
    UINTX mr4_bit0_sel2 : 3;
    //
    // Reserved
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX rsvd23 : 1;
    //
    // Selects bit 1 of MR4 data
    //
    // Bits[26:24], RW, default = 0x0
    //
    UINTX mr4_bit1_sel2 : 3;
    //
    // Reserved
    //
    // Bits[27:27], RO, default = 0x0
    //
    UINTX rsvd27 : 1;
    //
    // Selects bit 2 of MR4 data.
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX mr4_bit2_sel2 : 3;
    //
    // Reserved.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX rsvd31 : 1;
  } Bits;
  UINTX Data;
} D_CR_MR4_DESWIZZLE_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_PGCB_PWRGATE_PCE_DUNIT_BOXTYPE_REG            0x00000170
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When enabled (1), D-Unit will power gate when idle and the PMC requests power
    // gating.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX pmcre : 1;
    //
    // Reserved.
    //
    // Bits[2:1], RO, default = 0x0
    //
    UINTX rsvd2_1 : 2;
    //
    //
    //     [list]
    //     [*]0: D-Unit will never asset Sleep to the retention flops.
    //     [*]1: D-Unit may assert Sleep during Power Gating.
    //     [/list]
    //     [p]Note: Some platforms may default this bit to 0 others to 1.[/p]
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX se : 1;
    //
    // Reserved.
    //
    // Bits[4:4], RO, default = 0x0
    //
    UINTX rsvd4 : 1;
    //
    // If enabled (1), D-Unit may request a power-gate whenever it is idle.
    //     [p]Note: If this bit is set, then PMCRE must be 0.[/p]
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX hae : 1;
    //
    // Reserved.
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX rsvd31_6 : 26;
  } Bits;
  UINTX Data;
} D_CR_PGCB_PWRGATE_PCE_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_PGCB_PG_IDLE_TIMER_DUNIT_BOXTYPE_REG          0x00000174
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the time from which all internal Idle conditions have been observed to
    // when PGCB actually starts the power gating sequence. Used only when power gating
    // is enabled (HAE is set to 1).
    //     [p]Note: The actual count value is 2^value.[/p]
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX pg_timer : 4;
    //
    // Reserved.
    //
    // Bits[31:4], RO, default = 0x0
    //
    UINTX rsvd31_4 : 28;
  } Bits;
  UINTX Data;
} D_CR_PGCB_PG_IDLE_TIMER_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_PGCB_CLKGATE_DIS_DUNIT_BOXTYPE_REG            0x00000178
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Setting this field to 1 disables any Side Band clock gating due to idle conditions.
    // Also if set, it prevents SB trunk clock gating.
    //     [list]
    //     [*]0: Enable SB Clock Gating.
    //     [*]1: Disable SB Clock Gating.
    //     [/list]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX sb_cg_dis : 1;
    //
    // Setting this field to 1 disables any SPID clock gating due to idle conditions.
    // Also if set, it prevents SPID trunk clock gating.
    //     [list]
    //     [*]0: Enable SPID clock gating.
    //     [*]1: Disable SPID clock gating.
    //     [/list]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX spid_cg_dis : 1;
    //
    // Setting this field to 1 disables SA/2 clock gating due to idle conditions. Also,
    // if set, it prevents SA/2 trunk clock gating.
    //     [list]
    //     [*]0: Enable SA/2 clock gating.
    //     [*]1: Disable SA/2 clock gating.
    //     [/list]
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX saby2_cg_dis : 1;
    //
    // Reserved
    //
    // Bits[6:3], RO, default = 0x0
    //
    UINTX rsvd6_3 : 4;
    //
    // Setting this field to 1 disables any clock gating in the ungated domain due to
    // idle conditions. Also, if set, it prevents D-Unit ungated domain trunk clock gating.
    //
    //       [p]0 - Enable ungated domain Clock Gating.[/p]
    //       [p]1 - Disable ungated domain Clock Gating.[/p]
    //
    // Bits[7:7], RW, default = 0x1
    //
    UINTX sb_clkreq_dis : 1;
    //
    // When set to 1, it prevents the SB CDC from deasserting clkreq due to idle conditions.
    // Has no effect on clkreq deassertion during a forced power gate entry flow. This
    // prevents trunk clock gating. However, local clock gating can still be enabled.
    //
    //     [list]
    //     [*]0: Enable SB clock request.
    //     [*]1: Disable SB clock request.
    //     [/list]
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX sb_clkreq_dis_1 : 1;
    //
    // When set to 1, it prevents the SPID CDC from deasserting clkreq due to idle conditions.
    // Has no effect on clkreq deassertion during a forced power gate entry flow. This
    // prevents trunk clock gating. However, local clock gating can still be enabled.
    //
    //     [list]
    //     [*]0: Enable SPID clock request.
    //     [*]1: Disable SPID clock request.
    //     [/list]
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX spid_clkreq_dis : 1;
    //
    // When set to 1, it prevents the SA/2 CDC from deasserting clkreq due to idle conditions.
    // Has no effect on clkreq deassertion during a forced power gate entry flow. This
    // prevents trunk clock gating. However, local clock gating can still be enabled.
    //
    //     [list]
    //     [*]0: Enable SA/2 clock request.
    //     [*]1: Disable SA/2 clock request.
    //     [/list]
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX saby2_clkreq_dis : 1;
    //
    // When set to 1, it prevents the PGCB from deasserting PGCB clkreq. Prevents PGCB
    // clock trunk from ever gating.
    //     [list]
    //     [*]0: Enable PGCB clock request.
    //     [*]1: Disable PGCB clock request.
    //     [/list]
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX pgcb_clkreq_dis : 1;
    //
    // Reserved.
    //
    // Bits[31:12], RO, default = 0x0
    //
    UINTX rsvd31_12 : 20;
  } Bits;
  UINTX Data;
} D_CR_PGCB_CLKGATE_DIS_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_PGCB_CG_IDLE_TIMER_DUNIT_BOXTYPE_REG          0x0000017C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the minimum time from the SB CDC detects all clock reqs deasserting until
    // gclock is gated. The actual count is 2^value. For example, setting this register
    // to 4'd5 would result in a holdoff time of 32 clock cycles.
    //
    // Bits[3:0], RW, default = 0x2
    //
    UINTX sb_clk_timer : 4;
    //
    // Reserved.
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX rsvd7_4 : 4;
    //
    // This is the minimum time from the SPID CDC detects all clock reqs deasserting
    // until gclock is gated. The actual count is 2^value. For example, setting this
    // register to 4'd5 would result in a holdoff time of 32 clock cycles.
    //
    // Bits[11:8], RW, default = 0x2
    //
    UINTX spid_clk_timer : 4;
    //
    // Reserved.
    //
    // Bits[15:12], RO, default = 0x0
    //
    UINTX rsvd15_12 : 4;
    //
    // This is the minimum time from the SA/2 CDC detects clock reqs deasserting until
    // gclock is gated.  The actual count is 2^value. For example, setting this register
    // to 4'd5 would result in a holdoff time of 32 clock cycles.
    //
    // Bits[19:16], RW, default = 0x2
    //
    UINTX saby2_clk_timer : 4;
    //
    // Reserved.
    //
    // Bits[31:20], RO, default = 0x0
    //
    UINTX rsvd31_20 : 12;
  } Bits;
  UINTX Data;
} D_CR_PGCB_CG_IDLE_TIMER_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DUNIT_GRPA_RAC_DUNIT_BOXTYPE_REG              0x00000190
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Each bit specifies read access policy of one SAI agent.
    //
    // Bits[63:0], RW, default = 0xC00610D0212
    //
    UINTX rac_policy : 64;
  } Bits;
  UINTX Data;
} D_CR_DUNIT_GRPA_RAC_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DUNIT_GRPA_WAC_DUNIT_BOXTYPE_REG              0x00000198
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Each bit specifies write access policy of one SAI agent.
    //
    // Bits[63:0], RW, default = 0xC00610D0212
    //
    UINTX wac_policy : 64;
  } Bits;
  UINTX Data;
} D_CR_DUNIT_GRPA_WAC_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define D_CR_DUNIT_GRPA_CP_DUNIT_BOXTYPE_REG               0x000001A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Each bit specifies control access policy of one SAI agent. Agents who have access
    // can modify the control policies in the SAI registers.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX c_policy : 64;
  } Bits;
  UINTX Data;
} D_CR_DUNIT_GRPA_CP_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CR_BGF_CTL_DUNIT_BOXTYPE_REG                       0x00000120
#ifndef ASM_INC
typedef union {
  struct {
    //
    // xxx
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX tmpdata : 32;
  } Bits;
  UINTX Data;
} CR_BGF_CTL_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define FAKE_WAKE_DUNIT_BOXTYPE_REG                        0x000001F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // xxx
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX tmpdata : 32;
  } Bits;
  UINTX Data;
} FAKE_WAKE_DUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC


#endif // _DUNIT_BOXTYPE_H_
