/** @file
  File name:    BUNIT.h
  Input File:   BXTE_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in BUNIT.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/
#ifndef _BUNIT_H_
#define _BUNIT_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define B_CR_INDEX_0_2_0_IOBAR_BUNIT_REG                   0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 00: MMIO Registers  01: GTT  1X: Reserved
    //
    // Bits[1:0], RW/V, default = 0x0
    //
    UINTX targ : 2;
    //
    // This field selects any one of the DWORD registers within the MMIO register space
    // of Device 2 if the target is MMIO Registers.  This field selects a GTT offset
    // if the target is the GTT.
    //
    // Bits[22:2], RW/V, default = 0x0
    //
    UINTX reggto : 21;
    //
    // Reserved
    //
    // Bits[31:23], RO, default = 0x0
    //
    UINTX reserved_0 : 9;
  } Bits;
  UINTX Data;
} B_CR_INDEX_0_2_0_IOBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_VGADEC_0_2_0_VGABAR_BUNIT_REG                 0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Selects the IO space  0: 3Bx mode mono  1: 3Dx mode color
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX vgamsr0 : 1;
    //
    // Controls memory access not IO  0: VGA memory access is disabled  1: VGA memory
    // access is enabled
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX vgamsr1 : 1;
    //
    // select for VGA memory space  00: 0xA_0000-0xB_FFFF  01: 0xA_0000-0xA_FFFF  10:
    // 0xB_0000-0xB_7FFF  11: 0xB_0000-0xB_FFFF
    //
    // Bits[3:2], RW/V, default = 0x0
    //
    UINTX vgagr6 : 2;
    //
    // Page mode enable  0: VGA mode  1: Page mode
    //
    // Bits[4:4], RW/V, default = 0x0
    //
    UINTX vgagr10 : 1;
    //
    // Reserved
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
  } Bits;
  UINTX Data;
} B_CR_VGADEC_0_2_0_VGABAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PCICMD_0_2_0_PCI_BUNIT_REG                    0x00000004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This bit controls the IGDs response to I/O space accesses.  0: Disable.  1: Enable.
    //    Device 2 Function Level Reset must reset this bit.
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX ioae : 1;
    //
    // This bit controls the IGDs response to memory space accesses.  0: Disable.  1:
    // Enable.    Device 2 Function Level Reset must reset this bit.
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX mae : 1;
    //
    // 0: Disable IGD bus mastering.  1: Enable the IGD to function as a PCI compliant
    // master.  INTERNAL INTEL ONLY:GSA Implementation: When 0 blocks the sending of
    // MSI interrupts. When 1 permits the sending of above. Note: See description INTDIS
    // MSE and INTSTS bits.
    //
    // Bits[2:2], RW/V, default = 0x0
    //
    UINTX bme : 1;
    //
    // This bit is hardwired to 0. The IGD ignores Special cycles.
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX sce : 1;
    //
    // Hardwired to 0. The IGD does not support memory write and invalidate commands.
    //
    // Bits[4:4], RO, default = 0x0
    //
    UINTX mwie : 1;
    //
    // This bit is hardwired to 0 to disable snooping.
    //
    // Bits[5:5], RO, default = 0x0
    //
    UINTX vps : 1;
    //
    // Not Implemented. Hardwired to 0. Since the IGD belongs to the category of devices
    // that does not corrupt programs or data in system memory or hard drives the IGD
    // ignores any parity error that it detects and continues with normal operation.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX per : 1;
    //
    // Not Implemented. Hardwired to 0.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX wcc : 1;
    //
    // Not Implemented. Hardwired to 0.
    //
    // Bits[8:8], RO, default = 0x0
    //
    UINTX sen : 1;
    //
    // Not Implemented. Hardwired to 0.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX fb2b : 1;
    //
    // This bit disables the device from asserting INTx.  0: Enable the assertion of
    // this devices INTx signal.  1: Disable the assertion of this devices INTx signal.
    // DO_INTx messages will not be sent to DMI.  INTERNAL INTEL ONLY:GSA Implementation:
    // When 1 blocks sending of Line interrupts. The interrupt status is not blocked
    // from being reflected in the INTSTS bit.
    //
    // Bits[10:10], RW/V, default = 0x0
    //
    UINTX intdis : 1;
    //
    // Reserved
    //
    // Bits[15:11], RO, default = 0x0
    //
    UINTX reserved_0 : 5;
  } Bits;
  UINTX Data;
} B_CR_PCICMD_0_2_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PCICMD_0_3_0_PCI_BUNIT_REG                    0x00000004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This bit controls the IGDs response to I/O space accesses.  0: Disable.  1: Enable.
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX ioae : 1;
    //
    // This bit controls the IGDs response to memory space accesses.  0: Disable.  1:
    // Enable.
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX mae : 1;
    //
    // Reserved
    //
    // Bits[15:2], RO, default = 0x0
    //
    UINTX reserved_0 : 14;
  } Bits;
  UINTX Data;
} B_CR_PCICMD_0_3_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_GTTMMADR_LO_0_2_0_PCI_BUNIT_REG               0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Hardwired to 0 to indicate memory space.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX mios : 1;
    //
    // 00 : To indicate 32 bit base address  01: Reserved  10 : To indicate 64 bit base
    // address  11: Reserved
    //
    // Bits[2:1], RO, default = 0x2
    //
    UINTX memtyp : 2;
    //
    // Hardwired to 0 to prevent prefetching.
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX prefmem : 1;
    //
    // Hardwired to 0s to indicate at least 16MB address range.
    //
    // Bits[23:4], RO, default = 0x0
    //
    UINTX adm : 20;
    //
    // GTTMMADR[38:24] is {GTTMMADR_HI[6:0],GTTMMADR_LO[31:24]}.  Set by the OS these
    // bits correspond to address signals [38:24]. 16MB combined for MMIO and Global
    // GTT table aperture. 2MB for MMIO. 6MB reserved and 8 MB for GTT.
    //
    // Bits[31:24], RW/V, default = 0x0
    //
    UINTX mba : 8;
  } Bits;
  UINTX Data;
} B_CR_GTTMMADR_LO_0_2_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_ISPMMADR_LO_0_3_0_PCI_BUNIT_REG               0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Hardwired to 0 to indicate memory space.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX mios : 1;
    //
    // 00 : To indicate 32 bit base address  01: Reserved  10 : To indicate 64 bit base
    // address  11: Reserved
    //
    // Bits[2:1], RO, default = 0x2
    //
    UINTX memtyp : 2;
    //
    // Hardwired to 0 to prevent prefetching.
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX prefmem : 1;
    //
    // Hardwired to 0s to indicate at least 16MB address range.
    //
    // Bits[23:4], RO, default = 0x0
    //
    UINTX adm : 20;
    //
    // ISPMMADR[38:24] is {ISPMMADR_HI[6:0],ISPMMADR_LO[31:24]}.  Set by the OS these
    // bits correspond to address signals [38:24]. 16MB is the size of the ISPMMADR.
    //
    // Bits[31:24], RW/V, default = 0x0
    //
    UINTX mba : 8;
  } Bits;
  UINTX Data;
} B_CR_ISPMMADR_LO_0_3_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_GTTMMADR_HI_0_2_0_PCI_BUNIT_REG               0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Set by the OS these bits correspond to address signals [38:24]. 16MB combined
    // for MMIO and Global GTT table aperture. 2MB for MMIO, 6MB reserved and 8 MB for
    // GTT.
    //
    // Bits[6:0], RW/V, default = 0x0
    //
    UINTX mba : 7;
    //
    // Reserved.  Must be set to 0 since addressing above 512GB is not supported.
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_GTTMMADR_HI_0_2_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_ISPMMADR_HI_0_3_0_PCI_BUNIT_REG               0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Upper bits of ISPMMADR[38:24]
    //
    // Bits[6:0], RW/V, default = 0x0
    //
    UINTX mba : 7;
    //
    // Reserved.  Must be set to 0 since addressing above 512GB is not supported.
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_ISPMMADR_HI_0_3_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_GMADR_LO_0_2_0_PCI_BUNIT_REG                  0x00000018
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Hardwired to 0 to indicate memory space.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX mios : 1;
    //
    // 00 : To indicate 32 bit base address  01: Reserved  10 : To indicate 64 bit base
    // address  11: Reserved
    //
    // Bits[2:1], RO, default = 0x2
    //
    UINTX memtyp : 2;
    //
    // Hardwired to 0 to prevent prefetching.
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX prefmem : 1;
    //
    // Hardwired to 0s to indicate at least 128MB address range.
    //
    // Bits[26:4], RO, default = 0x0
    //
    UINTX adm : 23;
    //
    // This Bit is either part of the Memory Base Address R/W or part of the Address
    // Mask RO depending on the value of MSAC[4:0].
    //
    // Bits[27:27], RW/V, default = 0x0
    //
    UINTX admsk256 : 1;
    //
    // This Bit is either part of the Memory Base Address R/W or part of the Address
    // Mask RO depending on the value of MSAC[4:0].
    //
    // Bits[28:28], RW/V, default = 0x0
    //
    UINTX admsk512 : 1;
    //
    // This Bit is either part of the Memory Base Address R/W or part of the Address
    // Mask RO depending on the value of MSAC[4:0].
    //
    // Bits[29:29], RW/V, default = 0x0
    //
    UINTX admsk1024 : 1;
    //
    // This Bit is either part of the Memory Base Address R/W or part of the Address
    // Mask RO depending on the value of MSAC[4:0].
    //
    // Bits[30:30], RW/V, default = 0x0
    //
    UINTX admsk2048 : 1;
    //
    // This Bit is either part of the Memory Base Address R/W or part of the Address
    // Mask RO depending on the value of MSAC[4:0].
    //
    // Bits[31:31], RW/V, default = 0x0
    //
    UINTX admsk4096 : 1;
  } Bits;
  UINTX Data;
} B_CR_GMADR_LO_0_2_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_GMADR_HI_0_2_0_PCI_BUNIT_REG                  0x0000001C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Memory Base Address MBA: Set by the OS these bits correspond to address signals
    // [38:32].
    //
    // Bits[6:0], RW/V, default = 0x0
    //
    UINTX mba : 7;
    //
    // Reserved.  Must be set to 0 since addressing above 512GB is not supported.
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_GMADR_HI_0_2_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_IOBAR_0_2_0_PCI_BUNIT_REG                     0x00000020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Hardwired to 1 to indicate IO space.
    //
    // Bits[0:0], RO, default = 0x1
    //
    UINTX mios : 1;
    //
    // Hardwired to 0s to indicate 32bit address.
    //
    // Bits[2:1], RO, default = 0x0
    //
    UINTX memtype : 2;
    //
    // Reserved
    //
    // Bits[5:3], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // These bits correspond to address signals [15:6]. If there is a match then address
    // hits the IOBAR.  Device 2 FLR must reset this field.
    //
    // Bits[15:6], RW/V, default = 0x0
    //
    UINTX iobase : 10;
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
    UINTX reserved_1 : 16;
  } Bits;
  UINTX Data;
} B_CR_IOBAR_0_2_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MCHBAR_LO_0_0_0_PCI_BUNIT_REG                 0x00000048
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 0: MCHBAR is disabled and does not claim any memory  1: MCHBAR memory mapped accesses
    // are claimed and decoded appropriately.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX mchbaren : 1;
    //
    // Prefetchable space
    //
    // Bits[3:1], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // Hardwired to 0 to indicate size of BAR 32kB
    //
    // Bits[14:4], RO, default = 0x0
    //
    UINTX base_addr_not_implemented : 11;
    //
    // Defines the base address of the MCHBAR.  MCHBAR[38:15] is {MCHBAR_HI[6:0],MCHBAR_LO[31:15]}.
    // If incoming Request Address[38:15] matches MCHBAR[38:15] then request hits an
    // address in the MCHBAR range.
    //
    // Bits[31:15], RW, default = 0x1FBFF
    //
    UINTX base_addr : 17;
  } Bits;
  UINTX Data;
} B_CR_MCHBAR_LO_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MCHBAR_HI_0_0_0_PCI_BUNIT_REG                 0x0000004C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines the base address of the MCHBAR.  If incoming Request Address[38:15] matches
    // MCHBAR[38:15] then request hits an address in the MCHBAR range.
    //
    // Bits[6:0], RW, default = 0x0
    //
    UINTX base_addr : 7;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MCHBAR_HI_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_GGC_0_0_0_PCI_BUNIT_REG                       0x00000050
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.  Unused by the Bunit.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX ggclck : 1;
    //
    // 0: Enable. Device 2 IGD claims VGA memory and IO cycles the SubClass Code within
    // Device 2 Class Code register is 00.  1: Disable. Device 2 IGD does not claim VGA
    // cycles Mem and IO and the Sub Class Code field within Device 2 function 0 Class
    // Code register is 80.  BIOS Requirement: BIOS must not set this bit to 0 if the
    // GMS field bits 7:3 of this register preallocates no memory.  This bit MUST be
    // set to 1 if Device 2 is disabled either via a fuse or fuse override B_CR_CAPID0_A[IGD]
    //  1 or via a register DEVEN[3]  0.  This register is locked by Intel TXT lock.
    //  0:Enable  1:Disable
    //
    // Bits[1:1], RW/L, default = 0x0
    //
    UINTX ivd : 1;
    //
    // Enables the use of the iGFX enbines for Versatile Acceleration.  1: iGFX engines
    // are in Versatile Acceleration Mode. Device 2 Class Code is 048000h.  0: iGFX engines
    // are in iGFX Mode. Device 2 Class Code is 030000h.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX vamen : 1;
    //
    // Reserved
    //
    // Bits[5:3], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // This field is used to select the amount of Main Memory that is preallocated to
    // support the Internal Graphics Translation Table. The BIOS ensures that memory
    // is preallocated only when Internal graphics is enabled.  GSM is assumed to be
    // a contiguous physical DRAM space with DSM and BIOS needs to allocate a contiguous
    // memory chunk. Hardware will derive the base of GSM from DSM only using the GSM
    // size programmed in the register.  Hardware functionality in case of programming
    // this value to Reserved is not guaranteed.  0x0:No Preallocated Memory  0x1:2MB
    // of Preallocated Memory  0x2:4MB of Preallocated Memory  0x3:8MB of Preallocated
    // Memory
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX ggms : 2;
    //
    // This field is used to select the amount of Main Memory that is preallocated to
    // support the Internal Graphics device in VGA nonlinear and Native linear modes.
    // The BIOS ensures that memory is preallocated only when Internal graphics is enabled.
    //  This register is also Intel TXT lockable.  Hardware does not clear or set any
    // of these bits automatically based on IGD being disabled/enabled.  BIOS Requirement:
    // BIOS must not set this field to 0h if IVD bit 1 of this register is 0.  0x00:0MB
    //  0x01:32MB  0x02:64MB  0x03:96MB  0x04:128MB  0x05:160MB  0x06:192MB  0x07:224MB
    //  0x08:256MB  0x09:288MB  0x0A:320MB  0x0B:352MB  0x0C:384MB  0x0D:416MB  0x0E:448MB
    //  0x0F:480MB  0x10:512MB  0x20:...1024MB...  0x30:...1536MB...  0x3F:...2016MB
    //  0x40-0xFF:Illegal value
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX gms : 8;
  } Bits;
  UINTX Data;
} B_CR_GGC_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_DEVEN_0_0_0_PCI_BUNIT_REG                     0x00000054
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bus 0 Device 0 Function 0 may not be disabled and is therefore hardwired to 1.
    //
    // Bits[0:0], RO, default = 0x1
    //
    UINTX d0f0en : 1;
    //
    // 0:      Bus 0 Device 0 Function 1 is disabled and hidden  1:      Bus 0 Device
    // 0 Function 1 is enabled and visible  This bit will be set to 0b and remain 0b
    // if Device 0/0/1 capability is disabled.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX d0f1en : 1;
    //
    // Reserved
    //
    // Bits[3:2], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // 0:      Bus 0 Device 2 Function 0 is disabled and hidden;  1:      Bus 0 Device
    // 2 Function 0 is enabled and visible  This bit will be set to 0b and remain 0b
    // if Device 2 capability is disabled.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX d2f0en : 1;
    //
    // 0:      Bus 0 Device 3 Function 0 is disabled and hidden;  1:      Bus 0 Device
    // 3 Function 0 is enabled and visible  This bit will be set to 0b and remain 0b
    // if Device 3 capability is disabled.
    //
    // Bits[5:5], RW, default = 0x1
    //
    UINTX d3f0en : 1;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_1 : 26;
  } Bits;
  UINTX Data;
} B_CR_DEVEN_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_DEV2CTL_0_2_0_PCI_BUNIT_REG                   0x00000058
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IOBAR Disable. IOBARDIS:  System BIOS can choose to disable and hide the IOBAR
    // for systems that do not require legacy IOBAR access to Gfx MMIO registers  0:
    // IOBAR is enabled and exposed at offset 0x20 in Device 2 Configuration space. Default
    //  1: IOBAR is disabled and not visible in PCI Configuration Space. Behaves as if
    // hardwired to zeros.
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX iobardis : 1;
    //
    // Reserved
    //
    // Bits[7:1], RO, default = 0x0
    //
    UINTX reserved_0 : 7;
  } Bits;
  UINTX Data;
} B_CR_DEV2CTL_0_2_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PCIEXBAR_LO_0_0_0_PCI_BUNIT_REG               0x00000060
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PCIEXBAREN:  0:  PCIEXBAR range is disabled.  Address may target DRAM or MMIO
    // depending on other address decode rules.  1: PCIEXBAR range is enabled.  Incoming
    // request address must be compared with PCIEXBAR to determine whether the request
    // targets PCI Express Enhanced Configuration region.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pciexbaren : 1;
    //
    // Length of the region.  Reserved and set to 0 indicating a fixed 256 MB region.
    //
    // Bits[2:1], RO, default = 0x0
    //
    UINTX length : 2;
    //
    // Reserved
    //
    // Bits[25:3], RO, default = 0x0
    //
    UINTX reserved_1 : 23;
    //
    // Reserved.  Unused by SoC since PCIEXBAR is a fixed 256MB region in SoCs.
    //
    // Bits[26:26], RO, default = 0x0
    //
    UINTX admsk64 : 1;
    //
    // Reserved.  Unused by SoC since PCIEXBAR is a fixed 256MB region in SoCs.
    //
    // Bits[27:27], RO, default = 0x0
    //
    UINTX admsk128 : 1;
    //
    // PCIEXBAR: PCIEXBAR[38:28] is {PCIEXBAR_HI[6:0],PCIEXBAR_LO[31:28]}. Describes
    // bits [38:28] of the base address of the contiguous 256MB region for PCI Express
    // Enhanced Configuration region.   If bits [38:28] of the request address matches
    // the PCIEXBAR[38:28] then the request targets the PCI Express Enhanced Configuration
    // Space region.  A posted memory operation from an IDI agent will be treated as
    // a nonposted operation by the Tunit and Aunit.
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX pciexbar : 4;
  } Bits;
  UINTX Data;
} B_CR_PCIEXBAR_LO_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MSAC_0_2_0_PCI_BUNIT_REG                      0x00000062
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field is used in conjuction with other APSZ fields to determine the size
    // of Aperture GMADR and affects certain bits of GMADR register. The description
    // below is for all APSZ fields [4:0]  00000: 128MB  GMADR.B[26:4] is hardwired to
    // 0.  00001:  256MB  GMADR.B[27]=0, RO.  00010:  illegal hardware will treat this
    // as 00011.  00011:  512MB  GMADR.B[28:27]=0, RO.  00100-00110:  illegal hardware
    // will treat this as 00111.  00111:  1024MB  GMADR.B[29:27]=0,RO.  01000-01110:
    //  illegal hardware will treat this as 01111.  01111:  2048MB  GMADR.B[30:27]=0,RO.
    //  10000-11110:  illegal hardware will treat this as 11111.  11111:  4096MB  GMADR.B[31:27]=0,RO
    //
    // Bits[0:0], RW/V, default = 0x1
    //
    UINTX apsz0 : 1;
    //
    // This field is used in conjuction with other APSZ fields to determine the size
    // of Aperture GMADR and affects certain bits of GMADR register. The description
    // below is for all APSZ fields [4:0]  00000: 128MB  GMADR.B[26:4] is hardwired to
    // 0.  00001:  256MB  GMADR.B[27]=0, RO.  00010:  illegal hardware will treat this
    // as 00011.  00011:  512MB  GMADR.B[28:27]=0, RO.  00100-00110:  illegal hardware
    // will treat this as 00111.  00111:  1024MB  GMADR.B[29:27]=0,RO.  01000-01110:
    //  illegal hardware will treat this as 01111.  01111:  2048MB  GMADR.B[30:27]=0,RO.
    //  10000-11110:  illegal hardware will treat this as 11111.  11111:  4096MB  GMADR.B[31:27]=0,RO
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX apsz1 : 1;
    //
    // This field is used in conjuction with other APSZ fields to determine the size
    // of Aperture GMADR and affects certain bits of GMADR register. The description
    // below is for all APSZ fields [4:0]  00000: 128MB  GMADR.B[26:4] is hardwired to
    // 0.  00001:  256MB  GMADR.B[27]=0, RO.  00010:  illegal hardware will treat this
    // as 00011.  00011:  512MB  GMADR.B[28:27]=0, RO.  00100-00110:  illegal hardware
    // will treat this as 00111.  00111:  1024MB  GMADR.B[29:27]=0,RO.  01000-01110:
    //  illegal hardware will treat this as 01111.  01111:  2048MB  GMADR.B[30:27]=0,RO.
    //  10000-11110:  illegal hardware will treat this as 11111.  11111:  4096MB  GMADR.B[31:27]=0,RO
    //
    // Bits[2:2], RW/V, default = 0x0
    //
    UINTX apsz2 : 1;
    //
    // This field is used in conjuction with other APSZ fields to determine the size
    // of Aperture GMADR and affects certain bits of GMADR register. The description
    // below is for all APSZ fields [4:0]  00000: 128MB  GMADR.B[26:4] is hardwired to
    // 0.  00001:  256MB  GMADR.B[27]=0, RO.  00010:  illegal hardware will treat this
    // as 00011.  00011:  512MB  GMADR.B[28:27]=0, RO.  00100-00110:  illegal hardware
    // will treat this as 00111.  00111:  1024MB  GMADR.B[29:27]=0,RO.  01000-01110:
    //  illegal hardware will treat this as 01111.  01111:  2048MB  GMADR.B[30:27]=0,RO.
    //  10000-11110:  illegal hardware will treat this as 11111.  11111:  4096MB  GMADR.B[31:27]=0,RO
    //
    // Bits[3:3], RW/V, default = 0x0
    //
    UINTX apsz3 : 1;
    //
    // This field is used in conjuction with other APSZ fields to determine the size
    // of Aperture GMADR and affects certain bits of GMADR register. The description
    // below is for all APSZ fields [4:0]  00000: 128MB  GMADR.B[26:4] is hardwired to
    // 0.  00001:  256MB  GMADR.B[27]=0, RO.  00010:  illegal hardware will treat this
    // as 00011.  00011:  512MB  GMADR.B[28:27]=0, RO.  00100-00110:  illegal hardware
    // will treat this as 00111.  00111:  1024MB  GMADR.B[29:27]=0,RO.  01000-01110:
    //  illegal hardware will treat this as 01111.  01111:  2048MB  GMADR.B[30:27]=0,RO.
    //  10000-11110:  illegal hardware will treat this as 11111.  11111:  4096MB  GMADR.B[31:27]=0,RO
    //
    // Bits[4:4], RW/V, default = 0x0
    //
    UINTX apsz4 : 1;
    //
    // Reserved
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
  } Bits;
  UINTX Data;
} B_CR_MSAC_0_2_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PCIEXBAR_HI_0_0_0_PCI_BUNIT_REG               0x00000064
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PCIEXBAR: PCIEXBAR[38:28] is {PCIEXBAR_HI[6:0],PCIEXBAR_LO[31:28]}. Describes
    // bits [38:28] of the base address of the contiguous 256MB region for PCI Express
    // Enhanced Configuration region.   If bits [38:28] of the request address matches
    // the PCIEXBAR[38:28] then the request targets the PCI Express Enhanced Configuration
    // Space region.  A posted memory operation from an IDI agent will be treated as
    // a nonposted operation by the Tunit and Aunit.
    //
    // Bits[6:0], RW, default = 0x0
    //
    UINTX pciexbar : 7;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_PCIEXBAR_HI_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PMEN_REG_0_0_0_DEFVTDBAR_BUNIT_REG            0x00000064
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Unused by the Bunit.  This field indicates the status of protected memory regions:
    //  0: Protected memory regions disabled.  1: Protected memory regions enabled.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX prs : 1;
    //
    // Reserved
    //
    // Bits[30:1], RO, default = 0x0
    //
    UINTX reserved_0 : 30;
    //
    // This field controls DMA accesses to the protected lowmemory and protected highmemory
    // regions.  0: Protected memory regions are disabled.  1: Protected memory regions
    // are enabled. Access control is implemented.  IA accesses are always allowed access.
    //  NonIA accesses are allowed if request SAI matches the SAI of the Default VTd
    // Engine.  Requests blocked due to protected memory region violation are not recorded
    // or reported as remapping faults. Hardware reports the status of the protected
    // memory enable/disable operation through the PRS field in this register. Hardware
    // implementations supporting DMA draining must drain any inflight translated DMA
    // requests queued within the RootComplex before indicating the protected memory
    // region as enabled through the PRS field.
    //
    // Bits[31:31], RW/V, default = 0x0
    //
    UINTX epm : 1;
  } Bits;
  UINTX Data;
} B_CR_PMEN_REG_0_0_0_DEFVTDBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PLMBASE_REG_0_0_0_DEFVTDBAR_BUNIT_REG         0x00000068
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[19:0], RO, default = 0x0
    //
    UINTX reserved_0 : 20;
    //
    // This register specifies the base of protected lowmemory region in system memory.
    //
    // Bits[31:20], RW/V, default = 0x0
    //
    UINTX plmb : 12;
  } Bits;
  UINTX Data;
} B_CR_PLMBASE_REG_0_0_0_DEFVTDBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PLMLIMIT_REG_0_0_0_DEFVTDBAR_BUNIT_REG        0x0000006C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[19:0], RO, default = 0x0
    //
    UINTX reserved_0 : 20;
    //
    // This register specifies the last host physical address of the DMAprotected lowmemory
    // region in system memory.
    //
    // Bits[31:20], RW/V, default = 0x0
    //
    UINTX plml : 12;
  } Bits;
  UINTX Data;
} B_CR_PLMLIMIT_REG_0_0_0_DEFVTDBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PHMBASE_REG_0_0_0_DEFVTDBAR_BUNIT_REG         0x00000070
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[19:0], RO, default = 0x0
    //
    UINTX reserved_0 : 20;
    //
    // This register specifies the base of protected high memory region in system memory.
    //  Hardware ignores and does not implement bits 63:HAW where HAW is the host address
    // width.
    //
    // Bits[38:20], RW/V, default = 0x0
    //
    UINTX phmb : 19;
    //
    // Reserved
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_PHMBASE_REG_0_0_0_DEFVTDBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_DEVICECTL_0_2_0_PCI_BUNIT_REG                 0x00000078
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Correctable Error Enable:  A Root Complex Integrated Endpoint that is not associated
    // with a Root Complex Event Collector is permitted to hardwire this bit to 0b.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX correctable_err_enable : 1;
    //
    // NonFatal Error Enable:  A Root Complex Integrated Endpoint that is not associated
    // with a Root Complex Event Collector is permitted to hardwire this bit to 0b.
    //
    // Bits[1:1], RO, default = 0x0
    //
    UINTX nonfatal_err_enable : 1;
    //
    // Fatal Error Enable:  A Root Complex Integrated Endpoint that is not associated
    // with a Root Complex Event Collector is permitted to hardwire this bit to 0b.
    //
    // Bits[2:2], RO, default = 0x0
    //
    UINTX fatal_err_enable : 1;
    //
    // Unsupported Request Response Enable:  A Root Complex Integrated Endpoint that
    // is not associated with a Root Complex Event Collector is permitted to hardwire
    // this bit to 0b.
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX ur_enable : 1;
    //
    // Enable Relaxed Ordering:  A Function is permitted to hardwire this bit to 0b if
    // it never sets the Relaxed Ordering attribute in transactions it initiates as a
    // Requester. The graphics device never generates a PCI Express TLP.
    //
    // Bits[4:4], RO, default = 0x0
    //
    UINTX ro_enable : 1;
    //
    // Max Payload Size:  Functions that support only the 128byte max payload size are
    // permitted to hardwire this field to 000b.
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX max_payload_size : 3;
    //
    // Extended Tag Field Enable:  Functions that do not implement this capability hardwire
    // this bit to 0b.
    //
    // Bits[8:8], RO, default = 0x0
    //
    UINTX extended_tag_enable : 1;
    //
    // Phantom Functions Enable  Functions that do not implement this capability hardwire
    // this bit to 0b.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX phantom_functions_enable : 1;
    //
    // Aux Power PM Enable  Functions that do not implement this capability hardwire
    // this bit to 0b.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX aux_pm_enable : 1;
    //
    // Enable No Snoop  This bit is permitted to be hardwired to 0b if a Function would
    // never Set the No Snoop attribute in transactions it initiates. The graphics device
    // never generates a PCI Express TLP.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX enable_no_snoop : 1;
    //
    // Max Read Request Size:  Functions that do not generate Read Requests larger than
    // 128 bytes and Functions that do not generate Read Requests on their own behalf
    // are permitted to implement this field as Read Only RO with a value of 000b.
    //
    // Bits[14:12], RO, default = 0x0
    //
    UINTX max_read_request_size : 3;
    //
    // Initiate Function Level Reset:  A write of 1b initiates Function Level Reset to
    // the Function. The value read by software from this bit is always 0b.  Bunit uses
    // only this bit for Dev2 FLR.  Rest of the bits in this register are ignored by
    // the Bunit.
    //
    // Bits[15:15], RW/V, default = 0x0
    //
    UINTX initiate_flr : 1;
  } Bits;
  UINTX Data;
} B_CR_DEVICECTL_0_2_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_DEVICECTL_0_3_0_PCI_BUNIT_REG                 0x00000078
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Correctable Error Enable:  A Root Complex Integrated Endpoint that is not associated
    // with a Root Complex Event Collector is permitted to hardwire this bit to 0b.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX correctable_err_enable : 1;
    //
    // NonFatal Error Enable:  A Root Complex Integrated Endpoint that is not associated
    // with a Root Complex Event Collector is permitted to hardwire this bit to 0b.
    //
    // Bits[1:1], RO, default = 0x0
    //
    UINTX nonfatal_err_enable : 1;
    //
    // Fatal Error Enable:  A Root Complex Integrated Endpoint that is not associated
    // with a Root Complex Event Collector is permitted to hardwire this bit to 0b.
    //
    // Bits[2:2], RO, default = 0x0
    //
    UINTX fatal_err_enable : 1;
    //
    // Unsupported Request Response Enable:  A Root Complex Integrated Endpoint that
    // is not associated with a Root Complex Event Collector is permitted to hardwire
    // this bit to 0b.
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX ur_enable : 1;
    //
    // Enable Relaxed Ordering:  A Function is permitted to hardwire this bit to 0b if
    // it never sets the Relaxed Ordering attribute in transactions it initiates as a
    // Requester. The graphics device never generates a PCI Express TLP.
    //
    // Bits[4:4], RO, default = 0x0
    //
    UINTX ro_enable : 1;
    //
    // Max Payload Size:  Functions that support only the 128byte max payload size are
    // permitted to hardwire this field to 000b.
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX max_payload_size : 3;
    //
    // Extended Tag Field Enable:  Functions that do not implement this capability hardwire
    // this bit to 0b.
    //
    // Bits[8:8], RO, default = 0x0
    //
    UINTX extended_tag_enable : 1;
    //
    // Phantom Functions Enable  Functions that do not implement this capability hardwire
    // this bit to 0b.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX phantom_functions_enable : 1;
    //
    // Aux Power PM Enable  Functions that do not implement this capability hardwire
    // this bit to 0b.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX aux_pm_enable : 1;
    //
    // Enable No Snoop  This bit is permitted to be hardwired to 0b if a Function would
    // never Set the No Snoop attribute in transactions it initiates. The graphics device
    // never generates a PCI Express TLP.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX enable_no_snoop : 1;
    //
    // Max Read Request Size:  Functions that do not generate Read Requests larger than
    // 128 bytes and Functions that do not generate Read Requests on their own behalf
    // are permitted to implement this field as Read Only RO with a value of 000b.
    //
    // Bits[14:12], RO, default = 0x0
    //
    UINTX max_read_request_size : 3;
    //
    // Initiate Function Level Reset:  A write of 1b initiates Function Level Reset to
    // the Function. The value read by software from this bit is always 0b.  Bunit uses
    // only this bit for Dev3 FLR.  Rest of the bits in this register are ignored by
    // the Bunit.
    //
    // Bits[15:15], RW/V, default = 0x0
    //
    UINTX initiate_flr : 1;
  } Bits;
  UINTX Data;
} B_CR_DEVICECTL_0_3_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PHMLIMIT_REG_0_0_0_DEFVTDBAR_BUNIT_REG        0x00000078
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[19:0], RO, default = 0x0
    //
    UINTX reserved_0 : 20;
    //
    // This register specifies the last host physical address of the DMA protected highmemory
    // region in system memory.  Hardware ignores and does not implement bits 63:HAW
    // where HAW is the host address width.
    //
    // Bits[38:20], RW/V, default = 0x0
    //
    UINTX phml : 19;
    //
    // Reserved
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_PHMLIMIT_REG_0_0_0_DEFVTDBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_TOUUD_LO_0_0_0_PCI_BUNIT_REG                  0x000000A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.  Lock is unused by Bunit.  Register overwrites are protected via SAI
    // access control policy registers.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved
    //
    // Bits[19:1], RO, default = 0x0
    //
    UINTX reserved_1 : 19;
    //
    // TOUUD[38:20] is {TOUUD_HI[6:0],TOUUD_LO[31:20]}.  Upper usable DRAM address range
    // ends at the preceding byte.  Upper MMIO Range starts at this address and extends
    // up to the maximum system addressable memory range.  Bits 38:20 are compared with
    // bits 38:20 of the incoming request address to determine whether the request targets
    // the upper usable DRAM range or upper MMIO range.  If Request Address[38:20]>=TOUUD[38:20]
    // and any bit in Request Address[38:32] is set request is determined to target the
    // upper MMIO range.
    //
    // Bits[31:20], RW, default = 0x0
    //
    UINTX touud : 12;
  } Bits;
  UINTX Data;
} B_CR_TOUUD_LO_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_TOUUD_HI_0_0_0_PCI_BUNIT_REG                  0x000000AC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // TOUUD[38:20] is {TOUUD_HI[6:0],TOUUD_LO[31:20]}.  Upper usable DRAM address range
    // ends at the preceding byte.  Upper MMIO Range starts at this address and extends
    // up to the maximum system addressable memory range.  Bits 38:20 are compared with
    // bits 38:20 of the incoming request address to determine whether the request targets
    // the upper usable DRAM range or upper MMIO range.  If Request Address[38:20]>=TOUUD[38:20]
    // and any bit in Request Address[38:32] is set request is determined to target the
    // upper MMIO range.
    //
    // Bits[6:0], RW, default = 0x1
    //
    UINTX touud : 7;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_TOUUD_HI_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BGSM_0_0_0_PCI_BUNIT_REG                      0x000000B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.  Lock is unused by Bunit.  Register overwrites are protected via SAI
    // access control policy registers.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved
    //
    // Bits[19:1], RO, default = 0x0
    //
    UINTX reserved_0 : 19;
    //
    // This register contains the base address of the Graphics Stolen Memory.  The limit
    // for the Graphics Stolen Memory is TOLUD-1.  Incoming Request Address[31:20] is
    // compared against BGSM[31:20] and TOLUD[31:20] to determine if the address falls
    // in the range.  The comparison check is as follows:  BGSM[31:20]<=Address[31:20]
    // && Address[31:20]<TOLUD[31:20] and Address[38:32]==0.  Request SAI is then checked
    // against the allowed SAIs to determine if access is allowed
    //
    // Bits[31:20], RW, default = 0x0
    //
    UINTX bgsm : 12;
  } Bits;
  UINTX Data;
} B_CR_BGSM_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_TSEGMB_0_0_0_PCI_BUNIT_REG                    0x000000B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.  Lock is unused by Bunit.  Register overwrites are protected via SAI
    // access control policy registers.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved
    //
    // Bits[19:1], RO, default = 0x0
    //
    UINTX reserved_0 : 19;
    //
    // Base address of TSEG DRAM memory.  BIOS determines the base of TSEG memory which
    // must be at or below Graphics Base of GTT Stolen Memory BGSM.  SMM range starts
    // at this base and ends at BGSM1.  Incoming Request Address [31:20] will be compared
    // with TSEGMB[31:20] and BGSM[31:20] to determine if the request targets the SMM
    // range.  The comparison check is as follows: Address[31:20]>=TSEGMB[31:20] && Address[31:20]<BGSM[31:20]
    // and  Address[38:32]==0.  If the check passes the request targets the SMM range.
    //  If the protection for the range is enabled then the request SAI is compared against
    // allowed SAIs specified by BSMRRAC and BSMRWAC registers to determine if access
    // is allowed.
    //
    // Bits[31:20], RW, default = 0x1
    //
    UINTX tsegmb : 12;
  } Bits;
  UINTX Data;
} B_CR_TSEGMB_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_TOLUD_0_0_0_PCI_BUNIT_REG                     0x000000BC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.  Lock is unused by Bunit.  Register overwrites are protected via SAI
    // access control policy registers.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved
    //
    // Bits[19:1], RO, default = 0x0
    //
    UINTX reserved_0 : 19;
    //
    // Defines the top of lower usable DRAM which ends at the preceding byte.  Lower
    // MMIO Address range starts at this address and continues up to the 4GB Address
    // 0xFFFF_FFFF.  Bits 31:20 are compared with incoming request Address[31:20] to
    // determine whether the request targets lower usable DRAM range or the lower MMIO
    // range.  If Request Address[31:20]>=TOLUD[31:20] and Request Address[38:32]==0
    // then the Request Address falls in the Lower MMIO Address range.
    //
    // Bits[31:20], RW, default = 0x400
    //
    UINTX tolud : 12;
  } Bits;
  UINTX Data;
} B_CR_TOLUD_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PMCS_0_2_0_PCI_BUNIT_REG                      0x000000D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field indicates the current power state of the IGD and can be used to set
    // the IGD into a new power state. If software attempts to write an unsupported state
    // to this field write operation must complete normally on the bus but the data is
    // discarded and no state change occurs. On a transition from D3 to D0 the graphics
    // controller is optionally reset to initial values.   Bits[1:0] Power state  00:
    // D0 Default  01: D1 Not Supported  10: D2 Not Supported  11: D3
    //
    // Bits[1:0], RW/V, default = 0x0
    //
    UINTX pwrstat : 2;
    //
    // Reserved
    //
    // Bits[7:2], RO, default = 0x0
    //
    UINTX reserved_1 : 6;
    //
    // This bit is 0 to indicate that PME assertion from D3 cold is disabled.
    //
    // Bits[8:8], RO, default = 0x0
    //
    UINTX pmeen : 1;
    //
    // The IGD does not support data register. This bit always returns 0h when read write
    // operations have no effect.
    //
    // Bits[12:9], RO, default = 0x0
    //
    UINTX dsel : 4;
    //
    // The IGD does not support data register. This bit always returns 00 when read write
    // operations have no effect.
    //
    // Bits[14:13], RO, default = 0x0
    //
    UINTX dscale : 2;
    //
    // This bit is 0 to indicate that IGD does not support PME generation from D3 cold.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX pmests : 1;
  } Bits;
  UINTX Data;
} B_CR_PMCS_0_2_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PMCS_0_3_0_PCI_BUNIT_REG                      0x000000D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field indicates the current power state of the Iunit and can be used to set
    // the Iunit into a new power state. If software attempts to write an unsupported
    // state to this field write operation must complete normally on the bus but the
    // data is discarded and no state change occurs. On a transition from D3 to D0 the
    // Iunit is optionally reset to initial values.   Bits[1:0] Power state  00: D0 Default
    //  01: D1 Not Supported  10: D2 Not Supported  11: D3
    //
    // Bits[1:0], RW/V, default = 0x0
    //
    UINTX pwrstat : 2;
    //
    // Reserved
    //
    // Bits[15:2], RO, default = 0x0
    //
    UINTX reserved_1 : 14;
  } Bits;
  UINTX Data;
} B_CR_PMCS_0_3_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_CAPID0_A_0_0_0_PCI_BUNIT_REG                  0x000000E4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved for future capabilities
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX spare7_0 : 8;
    //
    // Controls the value of Dev2 GFX device ID. This functionality is not needed on
    // BXT because Dev2 supports receiving the SetIDValue message for changing device
    // ID. Hardwared to 2b00.  Identifier assigned to the core/primary PCI device.The
    // corresponding two bit capability ID  programming is:  00: Desktop  01: Mobile
    //  10: Server  11: Marketing Spare
    //
    // Bits[9:8], RO, default = 0x0
    //
    UINTX cdid : 2;
    //
    // Controls if there is an override of Dev2 GFX device ID. This functionality is
    // not needed on BXT because Dev2 supports receiving the SetIDValue message for changing
    // device ID. Hardwired to 1b0.   0b Disable ability to override DID  For production
    //  1b Enable ability to override DID  For debug and samples only
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX didoe : 1;
    //
    // 0: There is a graphics engine within this CPU. Internal Graphics Device Device
    // 2 is enabled and all of its memory and I/O spaces are accessable. Configuration
    // cycles to Device 2 will be completed within the CPU. All nonSMM memory and IO
    // accesses to VGA will be handled based on Memory and IO enables of Device 2 and
    // IO registers within Device 2 and VGA Enable of the PCI to PCI bridge control register
    // in Devices 1 and 6 If PCI Express GFX attach is supported. A selected amount of
    // Graphics Memory space is preallocated from the main memory based on Graphics Mode
    // Select GMS in the GGC Register. Graphics Memory is preallocated above TSEG Memory.
    //  1: There is no graphics engine within this CPU. Internal Graphics Device Device
    // 2 and all of its memory and I/O functions are disabled. Configuration cycle targeted
    // to Device 2 will be passed on to DMI. In addition all clocks to internal graphics
    // logic are turned off. All nonSMM memory and IO accesses to VGA will be handled
    // based on VGA Enable of the PCI to PCI bridge control register in Devices 1 and
    // 6. DEVEN [4:3] Device 0 offset 54h have no meaning. Device 2 Functions 0 and 1
    // are disabled and hidden.
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX igd : 1;
    //
    // Fuse backed spare.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX fuse_spare12 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX fuse_spare13 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX fuse_spare14 : 1;
    //
    // 0: DPTF Camarillo associated memory spaces are accessible.  1: DPTF Camarillo
    // associated memory and IO spaces are disabled.  DEVEN_0_0_0_PCI field for DPTF
    // can not be set.
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX cdd : 1;
    //
    // Fuse backed spare.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX fuse_spare16 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX fuse_spare17 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX fuse_spare18 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX fuse_spare19 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX fuse_spare20 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX fuse_spare21 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX fuse_spare22 : 1;
    //
    // 0: Enable VTd  1: Disable VTd
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX vtdd : 1;
    //
    // Reserved for future capabilities.
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX spare31_24 : 8;
  } Bits;
  UINTX Data;
} B_CR_CAPID0_A_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_CAPID0_B_0_0_0_PCI_BUNIT_REG                  0x000000E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved for future capabilities.
    //
    // Bits[23:0], RW, default = 0x0
    //
    UINTX spare23_0 : 24;
    //
    // 0: Enable SVM mode  1: Disable SVM mode
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX svmdis : 1;
    //
    // Fuse backed spares potentially to be used for PKGTYP encoding.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX fuse_spare25 : 1;
    //
    // Fuse backed spares potentially to be used for PKGTYP encoding.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX fuse_spare26 : 1;
    //
    // Fuse backed spares potentially to be used for PKGTYP encoding.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX fuse_spare27 : 1;
    //
    // Fuse backed spares potentially to be used for PKGTYP encoding.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX fuse_spare28 : 1;
    //
    // Fuse backed spares potentially to be used for PKGTYP encoding.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX fuse_spare29 : 1;
    //
    // Fuse backed spare.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX fuse_spare30 : 1;
    //
    // 0: Imaging Unit associated memory spaces are accessible.  1: Imaging Unit associated
    // memory and IO spaces are disabled.  DEVEN_0_0_0_PCI field for Iunit can not be
    // set.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imgu_dis : 1;
  } Bits;
  UINTX Data;
} B_CR_CAPID0_B_0_0_0_PCI_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_SECURE_BOOT_ALLOWED_BUNIT_REG                 0x00001000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 0:  Secure boot is disabled.  1: Secure boot is enabled.
    //
    // Bits[0:0], RO/V, default = 0x0
    //
    UINTX secure_boot_allowed : 1;
    //
    // Reserved
    //
    // Bits[7:1], RO, default = 0x0
    //
    UINTX reserved_0 : 7;
  } Bits;
  UINTX Data;
} B_CR_SECURE_BOOT_ALLOWED_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_HH_TIMER_SHADOW_BUNIT_REG                 0x00004B00
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Shadow copy of the MOT Hammock Harbor Timer counter.
    //
    // Bits[45:0], RW/V, default = 0x0
    //
    UINTX mot_hh_timer_shadow : 46;
    //
    // Reserved
    //
    // Bits[61:46], RO, default = 0x0
    //
    UINTX reserved_0 : 16;
    //
    // 0: upon de-assertion of PSMI_Wipe signal, Bunit will copy the 46-bit HH Timer
    // to the shadow register.  This mode is used during PSMI trace Collect mode on silicon.
    // 1: upon de-assertion of PSMI_Wipe signal, Bunit will copy the shadow register
    // value to the 46-bit Hammock Harbor Timer.  This mode is used during PSMI trace
    // Replay mode on emulation.
    //
    // Bits[62:62], RW, default = 0x0
    //
    UINTX copy_direction : 1;
    //
    // When set, indicates that PSMI mode is enabled
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX psmi_mode : 1;
  } Bits;
  UINTX Data;
} B_CR_MOT_HH_TIMER_SHADOW_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PGCB_PWRGATE_PCE_BUNIT_REG                    0x00004B10
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PMC Request Enable
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX pmcre : 1;
    //
    // Reserved
    //
    // Bits[2:1], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Sleep Enable
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX se : 1;
    //
    // Reserved
    //
    // Bits[4:4], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Hardware Autonomous Enable
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX hae : 1;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_2 : 26;
  } Bits;
  UINTX Data;
} B_CR_PGCB_PWRGATE_PCE_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PGCB_PG_IDLE_TIMER_BUNIT_REG                  0x00004B14
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Power gating hold-off time. This is the min time from when all internal Idle conditions
    // have been observed to when PGCB starts the power gating sequence. The actual time
    // is 2^value.
    //
    // Bits[3:0], RW, default = 0x2
    //
    UINTX cfg_pwrgate_holdoff : 4;
    //
    // Reserved
    //
    // Bits[31:4], RO, default = 0x0
    //
    UINTX reserved_0 : 28;
  } Bits;
  UINTX Data;
} B_CR_PGCB_PG_IDLE_TIMER_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PGCB_CLKGATE_DIS_BUNIT_REG                    0x00004B18
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Clock gating disable. 1 bit per domain. Bit 0: sideband clk, Bit 1: sa2xclk, Bit
    // 2: sa1xclk.  Set to disable clock gating.  Clear to enable clock gating.
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX cfg_clkgate_disabled : 3;
    //
    // Reserved
    //
    // Bits[15:3], RO, default = 0x0
    //
    UINTX reserved_0 : 13;
    //
    // Trunk clock gating disable. 1 bit per domain: bit 16 = sideband clk, bit 17 =
    // sa2xclk, bit 18 = sa1xclk.  Set to disable trunk clock gating.  Clear to enable
    // trunk clock gating.
    //
    // Bits[18:16], RW, default = 0x0
    //
    UINTX cfg_clkreq_ctl_disabled : 3;
    //
    // Reserved
    //
    // Bits[23:19], RO, default = 0x0
    //
    UINTX reserved_1 : 5;
    //
    // PGCB clock gating disable. Controls whether the PGCB's own clock can be gated.
    //  Set to disable PGCB clock gating.  Clear to enable PGCB clock gating.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX cfg_pgcb_clkgate_disabled : 1;
    //
    // Reserved
    //
    // Bits[31:25], RO, default = 0x0
    //
    UINTX reserved_2 : 7;
  } Bits;
  UINTX Data;
} B_CR_PGCB_CLKGATE_DIS_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PGCB_CG_IDLE_TIMER_BUNIT_REG                  0x00004B1C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // sideband clock gating hold-off time.  This is the minimum time from sideband clock
    // request deassertion to when the clock can be gated.  The actual time is 2^value.
    //
    // Bits[3:0], RW, default = 0x4
    //
    UINTX sbclk_cfg_clkgate_holdoff : 4;
    //
    // sa2xclk clock gating hold-off time.  This is the minimum time from sa2x clock
    // request deassertion to when the clock can be gated.  The actual time is 2^value.
    //
    // Bits[7:4], RW, default = 0x4
    //
    UINTX sa2xclk_cfg_clkgate_holdoff : 4;
    //
    // sa1xclk clock gating hold-off time.  This is the minimum time from sa1x clock
    // request deassertion to when the clock can be gated.  The actual time is 2^value.
    //
    // Bits[11:8], RW, default = 0x4
    //
    UINTX sa1xclk_cfg_clkgate_holdoff : 4;
    //
    // Reserved
    //
    // Bits[31:12], RO, default = 0x0
    //
    UINTX reserved_0 : 20;
  } Bits;
  UINTX Data;
} B_CR_PGCB_CG_IDLE_TIMER_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MCI_CTL_BUNIT_REG                             0x00004B20
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Unsupported IDI Opcode
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX uns_idi_op : 1;
    //
    // NonIDI access to MMIO
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX pii_2_mmio : 1;
    //
    // MMIO Access HITM
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX mmio_hitm : 1;
    //
    // WBMTo access to MMIO
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX mmio_wbmtoie : 1;
    //
    // ClFlush to MMIO
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX mmio_clflush : 1;
    //
    // IA hit to graphics stolen memory
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX ia_hit_gsm : 1;
    //
    // XUCode Software initiated error.  FIXME: Meant for private, Intel only use.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX xucode_err : 1;
    //
    // BRAM Write parity error userver only feature
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX bram_wr_par : 1;
    //
    // BRAM Read parity error userver only feature
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX bram_rd_par : 1;
    //
    // NonIDI access to MMIO
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX mc_rd_data_unc : 1;
    //
    // NonIDI access to MMIO
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX mc_rd_data_cor : 1;
    //
    // Reserved
    //
    // Bits[63:11], RO, default = 0x0
    //
    UINTX reserved_0 : 53;
  } Bits;
  UINTX Data;
} B_CR_MCI_CTL_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MCI_STATUS_BUNIT_REG                          0x00004B28
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MCA Error Code
    //
    // Bits[15:0], RW/V, default = 0x0
    //
    UINTX mca_err_code : 16;
    //
    // Model Specific Error Code
    //
    // Bits[31:16], RW/V, default = 0x0
    //
    UINTX model_specific_err_code : 16;
    //
    // Agent ID: Agent ID of request that had an ECC or BRAM error
    //
    // Bits[36:32], RW/V, default = 0x0
    //
    UINTX agent_id : 5;
    //
    // BRAM Error: Parity Error on BRAM
    //
    // Bits[37:37], RW/V, default = 0x0
    //
    UINTX bram_err : 1;
    //
    // Corrected Error Count CERRCNT: The number of corrected errors that have been received
    // from the Dunit.
    //
    // Bits[51:38], RW/V, default = 0x0
    //
    UINTX corrected_err_count : 14;
    //
    // Corrected Error Count Overflow CERRCNTOVER: Sets if the corrected error count
    // is saturated to 3FFh and another corrected error occurs.
    //
    // Bits[52:52], RW/V, default = 0x0
    //
    UINTX corrected_err_count_overflow : 1;
    //
    // Reserved. These bits correspond to S AR and Corrected Error Status indicator.
    //  They are all readonly and always return 0s
    //
    // Bits[56:53], RO, default = 0x0
    //
    UINTX reserved_0 : 4;
    //
    // Processor Context Corrupted PCC: When set indicates the state of the processor
    // might have been corrupted. When clear indicates the error did not affect the processor
    // state.   In BXT this field is set whenever an error is logged.  For Denverton
    // UC and PCC are not set for correctable errors from the Dunit but uncorrectable
    // errors will set both UC and PCC.
    //
    // Bits[57:57], RW/V, default = 0x0
    //
    UINTX processor_context_corrupted : 1;
    //
    // MCI_ADDR register Valid ADDRV: When set indicated the value stored in the MCI_ADDR
    // register is valid.
    //
    // Bits[58:58], RW/V, default = 0x0
    //
    UINTX mci_status_addrv : 1;
    //
    // MCI_MISC register Valid MISCV: This field will be 0 except for XuCode writter
    // errors which set this field to 1.
    //
    // Bits[59:59], RW/V, default = 0x0
    //
    UINTX mci_status_miscv : 1;
    //
    // Error Reporting Enabled EN: Error reporting has been enabled by the MCI_CTL register
    //
    // Bits[60:60], RW/V, default = 0x0
    //
    UINTX err_enabled : 1;
    //
    // Uncorrected Error UC: Indicates that an uncorrected error was received by the
    // Bunit. The source of the uncorrected error can be any of those as indicated in
    // the MCI_CTL register.  For BXT when an error is logged both UC and PCC are set
    // to 1.  In DNV corretable errors do no set UC and PCC.
    //
    // Bits[61:61], RW/V, default = 0x0
    //
    UINTX uncorrected_err : 1;
    //
    // Error Overflow OVER: Indicates a second error was received while the MCI_Status
    // Valid bit as set. The Bunit supports the Machine Check Overwrite rules for a Machine
    // Check Overflow. For the purpose of Bunit error reporting corrected errors or SERRORs
    // sent from the Dunit will be overwritten by any new errors received. The first
    // uncorrected error received will not be overwritten by any new errors received.
    //
    // Bits[62:62], RW/V, default = 0x0
    //
    UINTX err_overflow : 1;
    //
    // MCI_Status Valid VAL: When set indicates the information in the rest of this register
    // is valid.  Software is responsible for clearing the VAL flag.
    //
    // Bits[63:63], RW/V, default = 0x0
    //
    UINTX mci_status_valid : 1;
  } Bits;
  UINTX Data;
} B_CR_MCI_STATUS_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MCI_ADDR_BUNIT_REG                            0x00004B30
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Address MCI_ADDR: When ADDRV is set in the MCI_STATUS register the memory or system
    // address is stored in this register.
    //
    // Bits[39:0], RW/V, default = 0x0
    //
    UINTX mca_address : 40;
    //
    // Reserved
    //
    // Bits[63:40], RO, default = 0x0
    //
    UINTX reserved_0 : 24;
  } Bits;
  UINTX Data;
} B_CR_MCI_ADDR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MCI_MISC_BUNIT_REG                            0x00004B38
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Misc info
    //
    // Bits[63:0], RW/V, default = 0x0
    //
    UINTX misc : 64;
  } Bits;
  UINTX Data;
} B_CR_MCI_MISC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MCI_CTL2_BUNIT_REG                            0x00004B40
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Corrected Error Count Threshold CECTHRSH: Specifies the value to use for the corrected
    // error threshold.
    //
    // Bits[14:0], RW, default = 0x0
    //
    UINTX corrected_error_count_threshold : 15;
    //
    // Reserved
    //
    // Bits[29:15], RO, default = 0x0
    //
    UINTX reserved_0 : 15;
    //
    // This bit is set by software to enable the generation of corrected error interrupts.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX corrected_error_interrupt_enable : 1;
    //
    // Reserved
    //
    // Bits[63:31], RO, default = 0x0
    //
    UINTX reserved_1 : 33;
  } Bits;
  UINTX Data;
} B_CR_MCI_CTL2_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BMCMODE_LOW_BUNIT_REG                         0x00004B48
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When set to 1  Bunit will not allow any transaction with uncorrectable error or
    // subsequent memory transaction to propagate through to DRAM FIXME:  actually prevents
    // only live data from returning to CPU and signal MC event to CPU if enabled in
    // IA32_MC5_CTL. This will essentially hang CPU and CPU will end up with IERR shutdown.
    //  Issue: When set to zero Bunit will allow transaction with an uncorrectable error
    // to propagate and signal MC event to CPU if enabled in IA32_MC5_CTL.  If enabled
    // MC event will be taken by CPU cores at the end of instruction boundary after it
    // detected by ROB.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX mc_signal_mode : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved_0 : 31;
  } Bits;
  UINTX Data;
} B_CR_BMCMODE_LOW_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BMCMODE_HIGH_BUNIT_REG                        0x00004B4C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[31:0], RO, default = 0x0
    //
    UINTX reserved_0 : 32;
  } Bits;
  UINTX Data;
} B_CR_BMCMODE_HIGH_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIOSWR_CP_BUNIT_REG                           0x00004B50
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the BIOSWR_RAC
    // BIOSWR_WAC and BIOSWR_CP registers based on the value from the agents 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0x40061010202
    //
    UINTX mem_range_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIOSWR_CP_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIOSWR_RAC_BUNIT_REG                          0x00004B58
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access based on the
    // agents 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC00630D0217
    //
    UINTX mem_range_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIOSWR_RAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIOSWR_WAC_BUNIT_REG                          0x00004B60
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access based on the
    // agents 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC00610C0212
    //
    UINTX mem_range_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIOSWR_WAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BSMRCP_BUNIT_REG                              0x00004B68
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit SMM Control Policy: Bit vector used to determine which agents are allowed
    // access to the BSMRRAC BSMRWAC and BSMRCP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX smm_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BSMRCP_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BSMRRAC_BUNIT_REG                             0x00004B70
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX smm_sai_pol_0 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX smm_sai_pol_1 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX smm_sai_pol_2 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX smm_sai_pol_3 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX smm_sai_pol_4 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX smm_sai_pol_5 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX smm_sai_pol_6 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX smm_sai_pol_7 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX smm_sai_pol_8 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX smm_sai_pol_9 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX smm_sai_pol_10 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX smm_sai_pol_11 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX smm_sai_pol_12 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX smm_sai_pol_13 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX smm_sai_pol_14 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX smm_sai_pol_15 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x1
    //
    UINTX smm_sai_pol_16 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX smm_sai_pol_17 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX smm_sai_pol_18 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX smm_sai_pol_19 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX smm_sai_pol_20 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX smm_sai_pol_21 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX smm_sai_pol_22 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX smm_sai_pol_23 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX smm_sai_pol_24 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX smm_sai_pol_25 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX smm_sai_pol_26 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX smm_sai_pol_27 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX smm_sai_pol_28 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX smm_sai_pol_29 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX smm_sai_pol_30 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX smm_sai_pol_31 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX smm_sai_pol_32 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX smm_sai_pol_33 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX smm_sai_pol_34 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX smm_sai_pol_35 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX smm_sai_pol_36 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX smm_sai_pol_37 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX smm_sai_pol_38 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX smm_sai_pol_39 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX smm_sai_pol_40 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX smm_sai_pol_41 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX smm_sai_pol_42 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX smm_sai_pol_43 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX smm_sai_pol_44 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX smm_sai_pol_45 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX smm_sai_pol_46 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX smm_sai_pol_47 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX smm_sai_pol_48 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX smm_sai_pol_49 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX smm_sai_pol_50 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX smm_sai_pol_51 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX smm_sai_pol_52 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX smm_sai_pol_53 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX smm_sai_pol_54 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX smm_sai_pol_55 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX smm_sai_pol_56 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX smm_sai_pol_57 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX smm_sai_pol_58 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX smm_sai_pol_59 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX smm_sai_pol_60 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX smm_sai_pol_61 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX smm_sai_pol_62 : 1;
    //
    // Bunit SMM Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX smm_sai_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BSMRRAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BSMRWAC_BUNIT_REG                             0x00004B78
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX smm_sai_pol_0 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX smm_sai_pol_1 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX smm_sai_pol_2 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX smm_sai_pol_3 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX smm_sai_pol_4 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX smm_sai_pol_5 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX smm_sai_pol_6 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX smm_sai_pol_7 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX smm_sai_pol_8 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX smm_sai_pol_9 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX smm_sai_pol_10 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX smm_sai_pol_11 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX smm_sai_pol_12 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX smm_sai_pol_13 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX smm_sai_pol_14 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX smm_sai_pol_15 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x1
    //
    UINTX smm_sai_pol_16 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX smm_sai_pol_17 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX smm_sai_pol_18 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX smm_sai_pol_19 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX smm_sai_pol_20 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX smm_sai_pol_21 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX smm_sai_pol_22 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX smm_sai_pol_23 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX smm_sai_pol_24 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX smm_sai_pol_25 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX smm_sai_pol_26 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX smm_sai_pol_27 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX smm_sai_pol_28 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX smm_sai_pol_29 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX smm_sai_pol_30 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX smm_sai_pol_31 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX smm_sai_pol_32 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX smm_sai_pol_33 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX smm_sai_pol_34 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX smm_sai_pol_35 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX smm_sai_pol_36 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX smm_sai_pol_37 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX smm_sai_pol_38 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX smm_sai_pol_39 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX smm_sai_pol_40 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX smm_sai_pol_41 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX smm_sai_pol_42 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX smm_sai_pol_43 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX smm_sai_pol_44 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX smm_sai_pol_45 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX smm_sai_pol_46 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX smm_sai_pol_47 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX smm_sai_pol_48 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX smm_sai_pol_49 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX smm_sai_pol_50 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX smm_sai_pol_51 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX smm_sai_pol_52 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX smm_sai_pol_53 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX smm_sai_pol_54 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX smm_sai_pol_55 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX smm_sai_pol_56 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX smm_sai_pol_57 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX smm_sai_pol_58 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX smm_sai_pol_59 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX smm_sai_pol_60 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX smm_sai_pol_61 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX smm_sai_pol_62 : 1;
    //
    // Bunit SMM Write Access Policy: Bit vector used to determine which agents are allowed
    // write access to the Bunit SMM Range from TSEGMB to BGSM1 based on the agents 6bit
    // encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX smm_sai_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BSMRWAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BDEFVTDPMR_CP_BUNIT_REG                       0x00004B80
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit Def VTd PMR Control Policy: Bit vector used to determine which agents are
    // allowed access to the BDEFVTDPMR_RAC BDEFVTDPMR_WAC and BDEFVTDPMR_CP registers
    // based on the value from the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX defvtdpmr_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BDEFVTDPMR_CP_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BDEFVTDPMR_RAC_BUNIT_REG                      0x00004B88
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_0 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_1 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_2 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_3 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_4 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_5 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_6 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_7 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_8 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_9 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_10 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_11 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_12 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_13 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_14 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_15 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_16 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_17 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_18 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_19 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_20 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_21 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_22 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_23 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_24 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_25 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_26 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_27 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_28 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_29 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_30 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_31 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_32 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_33 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_34 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_35 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_36 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_37 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_38 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_39 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_40 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_41 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_42 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_43 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_44 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_45 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_46 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_47 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_48 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_49 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_50 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_51 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_52 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_53 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_54 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_55 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_56 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_57 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_58 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_59 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_60 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_61 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_62 : 1;
    //
    // Bunit Def VTd PMR Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BDEFVTDPMR_RAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BDEFVTDPMR_WAC_BUNIT_REG                      0x00004B90
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_0 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_1 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_2 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_3 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_4 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_5 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_6 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_7 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_8 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_9 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_10 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_11 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_12 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_13 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_14 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_15 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_16 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_17 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_18 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_19 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_20 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_21 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_22 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_23 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_24 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_25 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_26 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_27 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_28 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_29 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_30 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_31 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_32 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_33 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_34 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_35 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_36 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_37 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_38 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_39 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_40 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_41 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_42 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_43 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_44 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_45 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_46 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_47 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x1
    //
    UINTX defvtdpmr_sai_pol_48 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_49 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_50 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_51 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_52 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_53 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_54 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_55 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_56 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_57 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_58 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_59 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_60 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_61 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_62 : 1;
    //
    // Bunit Def VTd PMR Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Default VTd PMR Low and High memory ranges based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX defvtdpmr_sai_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BDEFVTDPMR_WAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_IA_GT_UNTRUSTED_CP_BUNIT_REG                  0x00004B98
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IA_GT_UNTRUSTED_RAC
    // IA_GT_UNTRUSTED_WAC and IA_GT_UNTRUSTED_CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0x40061010202
    //
    UINTX mem_range_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_IA_GT_UNTRUSTED_CP_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_IA_GT_UNTRUSTED_RAC_BUNIT_REG                 0x00004BA0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access based on the
    // agents 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0x11C0063010317
    //
    UINTX mem_range_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_IA_GT_UNTRUSTED_RAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_IA_GT_UNTRUSTED_WAC_BUNIT_REG                 0x00004BA8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access based on the
    // agents 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0x11C0061000317
    //
    UINTX mem_range_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_IA_GT_UNTRUSTED_WAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_P_U_CODERDWR_CP_BUNIT_REG                     0x00004C00
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IA Core Control Policy: Bit vector used to determine which agents are allowed
    // access to the P_U_CODERDWR_RAC P_U_CODERDWR_WAC and P_U_CODERDWR_CP registers
    // based on the value from the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0x40021000202
    //
    UINTX ia_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_P_U_CODERDWR_CP_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_P_U_CODERDWR_RAC_BUNIT_REG                    0x00004C08
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IA Core SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Bunit IA Core Configuration registers based on
    // the agents 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0x40021010202
    //
    UINTX ia_sai_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_P_U_CODERDWR_RAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_P_U_CODERDWR_WAC_BUNIT_REG                    0x00004C10
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IA Core SAI Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Bunit IA Core Configuration registers based on
    // the agents 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0x40021000202
    //
    UINTX ia_sai_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_P_U_CODERDWR_WAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_LPMODE_BUNIT_REG                              0x00004C18
#ifndef ASM_INC
typedef union {
  struct {
    //
    // SMM  Mode : When set Core is in SMM mode.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX smm_mode : 1;
    //
    // ACM/NPP Mode: When set Core is in Authenticated Code Module / NonPersistent Patch
    // mode.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX acm_npp_mode : 1;
    //
    // Boot Bios : When set Core is in Boot mode.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX boot_mode : 1;
    //
    // Reserved
    //
    // Bits[31:3], RO, default = 0x0
    //
    UINTX reserved_0 : 29;
  } Bits;
  UINTX Data;
} B_CR_LPMODE_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BT_IDLE_STATUS_BUNIT_REG                      0x00004C1C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When set, T unit SB endpoint is not requesting SB clock.
    //
    // Bits[0:0], RO/V, default = 0x1
    //
    UINTX t_sb_no_clkreq : 1;
    //
    // When set, B unit SB endpoint is not requesting SB clock.
    //
    // Bits[1:1], RO/V, default = 0x1
    //
    UINTX b_sb_no_clkreq : 1;
    //
    // When set, T unit SB fabric ISM is in Idle state.
    //
    // Bits[2:2], RO/V, default = 0x1
    //
    UINTX t_sb_fabric_idle : 1;
    //
    // When set, T unit SB agent ISM is in Idle state.
    //
    // Bits[3:3], RO/V, default = 0x1
    //
    UINTX t_sb_agent_idle : 1;
    //
    // When set, B unit SB fabric ISM is in Idle state.
    //
    // Bits[4:4], RO/V, default = 0x1
    //
    UINTX b_sb_fabric_idle : 1;
    //
    // When set, B unit SB agent ISM is in Idle state.
    //
    // Bits[5:5], RO/V, default = 0x1
    //
    UINTX b_sb_agent_idle : 1;
    //
    // When set, T unit has no outbound SB message pending.
    //
    // Bits[6:6], RO/V, default = 0x1
    //
    UINTX no_outb_sb_msg : 1;
    //
    // When set, T unit VLW is idle.
    //
    // Bits[7:7], RO/V, default = 0x1
    //
    UINTX vlw_idle : 1;
    //
    // When set, T unit PICLET is idle.
    //
    // Bits[8:8], RO/V, default = 0x1
    //
    UINTX piclet_idle : 1;
    //
    // When set, T unit OOAQ in slice 1 is empty.
    //
    // Bits[9:9], RO/V, default = 0x1
    //
    UINTX ooaq_empty_s1 : 1;
    //
    // When set, T unit OOAQ in slice 0 is empty.
    //
    // Bits[10:10], RO/V, default = 0x1
    //
    UINTX ooaq_empty_s0 : 1;
    //
    // When set, B unit MOT in slice 1 is idle.
    //
    // Bits[11:11], RO/V, default = 0x1
    //
    UINTX mot_idle_s1 : 1;
    //
    // When set, B unit MOT in slice 0 is idle.
    //
    // Bits[12:12], RO/V, default = 0x1
    //
    UINTX mot_idle_s0 : 1;
    //
    // When set, B unit scoreboard in slice 1 has no dirty entries.
    //
    // Bits[13:13], RO/V, default = 0x1
    //
    UINTX no_dirty_entries_s1 : 1;
    //
    // When set, B unit scoreboard in slice 0 has no dirty entries.
    //
    // Bits[14:14], RO/V, default = 0x1
    //
    UINTX no_dirty_entries_s0 : 1;
    //
    // When set, B unit scoreboard in slice 1 has no pending read requests.
    //
    // Bits[15:15], RO/V, default = 0x1
    //
    UINTX no_pend_rd_req_s1 : 1;
    //
    // When set, B unit scoreboard in slice 0 has no pending read requests.
    //
    // Bits[16:16], RO/V, default = 0x1
    //
    UINTX no_pend_rd_req_s0 : 1;
    //
    // When set, all B unit scoreboard refcnts in slice 1 are zero.
    //
    // Bits[17:17], RO/V, default = 0x1
    //
    UINTX refcnts_zero_s1 : 1;
    //
    // When set, all B unit scoreboard refcnts in slice 0 are zero.
    //
    // Bits[18:18], RO/V, default = 0x1
    //
    UINTX refcnts_zero_s0 : 1;
    //
    // When set, Lock queue is empty.
    //
    // Bits[19:19], RO/V, default = 0x1
    //
    UINTX lockq_empty : 1;
    //
    // When set, PII conflict queues are empty.
    //
    // Bits[20:20], RO/V, default = 0x1
    //
    UINTX pii_cq_empty : 1;
    //
    // When set, IDI conflict queue in slice 1 is empty.
    //
    // Bits[21:21], RO/V, default = 0x1
    //
    UINTX idi_cq_empty_s1 : 1;
    //
    // When set, IDI conflict queue in slice 0 is empty.
    //
    // Bits[22:22], RO/V, default = 0x1
    //
    UINTX idi_cq_empty_s0 : 1;
    //
    // When set, all PMI fabric ISM's for slice 1 (in D units) are in Idle state.
    //
    // Bits[23:23], RO/V, default = 0x1
    //
    UINTX pmi_fabric_idle_s1 : 1;
    //
    // When set, all PMI agent ISM's for slice 1 (in B unit) are in Idle state.
    //
    // Bits[24:24], RO/V, default = 0x1
    //
    UINTX pmi_agent_idle_s1 : 1;
    //
    // When set, all PMI fabric ISM's for slice 0 (in D units) are in Idle state.
    //
    // Bits[25:25], RO/V, default = 0x1
    //
    UINTX pmi_fabric_idle_s0 : 1;
    //
    // When set, all PMI agent ISM's for slice 0 (in B unit) are in Idle state.
    //
    // Bits[26:26], RO/V, default = 0x1
    //
    UINTX pmi_agent_idle_s0 : 1;
    //
    // When set, A unit's IOSF interface is idle.
    //
    // Bits[27:27], RO/V, default = 0x1
    //
    UINTX iosf_idle : 1;
    //
    // When set, PII fabric ISM (in B unit) is in Idle state.
    //
    // Bits[28:28], RO/V, default = 0x1
    //
    UINTX pii_fabric_idle : 1;
    //
    // When set, PII agent ISM (in A unit) is in Idle state.
    //
    // Bits[29:29], RO/V, default = 0x1
    //
    UINTX pii_agent_idle : 1;
    //
    // When set, all IDI interfaces are in SHUTDOWN state.
    //
    // Bits[30:30], RO/V, default = 0x1
    //
    UINTX idi_shutdown : 1;
    //
    // Reserved
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
  } Bits;
  UINTX Data;
} B_CR_BT_IDLE_STATUS_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIOSWR_EXPOSE_CP_BUNIT_REG                    0x00004C20
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the BIOSWR_EXPOSE_RAC
    // BIOSWR_EXPOSE_WAC and BIOSWR_EXPOSE_CP registers based on the value from the agents
    // 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0x40061010212
    //
    UINTX mem_range_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIOSWR_EXPOSE_CP_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIOSWR_EXPOSE_RAC_BUNIT_REG                   0x00004C28
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access based on the
    // agents 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC0063010217
    //
    UINTX mem_range_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIOSWR_EXPOSE_RAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIOSWR_EXPOSE_WAC_BUNIT_REG                   0x00004C30
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access based on the
    // agents 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC0061000212
    //
    UINTX mem_range_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIOSWR_EXPOSE_WAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_SCH_AC_MAPPING0_BUNIT_REG                     0x00004C38
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Access Class for IA Demand Requests
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX ia_demand_ac : 4;
    //
    // Access Class for IA Prefetch Requests.  Not supported by BXT/DNV
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX ia_prefetch_ac : 4;
    //
    // Access Class for GFX Requests
    //
    // Bits[11:8], RW, default = 0x4
    //
    UINTX gfx_ac : 4;
    //
    // Access Class for MOT requests
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX mot : 4;
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
    UINTX reserved_0 : 16;
  } Bits;
  UINTX Data;
} B_CR_SCH_AC_MAPPING0_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_SCH_AC_MAPPING1_BUNIT_REG                     0x00004C3C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Access Class for Channel 0 BXT VC0a
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX channel0_ac : 4;
    //
    // Access Class for Channel 1 BXT VC0b
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX channel1_ac : 4;
    //
    // Access Class for Channel 2 BXT VC1a
    //
    // Bits[11:8], RW, default = 0x1
    //
    UINTX channel2_ac : 4;
    //
    // Access Class for Channel 3 BXT VC1b
    //
    // Bits[15:12], RW, default = 0x1
    //
    UINTX channel3_ac : 4;
    //
    // Access Class for Channel 4 BXT VC2a
    //
    // Bits[19:16], RW, default = 0x2
    //
    UINTX channel4_ac : 4;
    //
    // Access Class for Channel 5 BXT VC2b
    //
    // Bits[23:20], RW, default = 0x2
    //
    UINTX channel5_ac : 4;
    //
    // Access Class for Channel 6 BXT VC2c
    //
    // Bits[27:24], RW, default = 0x2
    //
    UINTX channel6_ac : 4;
    //
    // Access Class for Channel 7 BXT VCbr
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX channel7_ac : 4;
  } Bits;
  UINTX Data;
} B_CR_SCH_AC_MAPPING1_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_SCH_AC_MAPPING2_BUNIT_REG                     0x00004C40
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Access Class for Channel 8 BXT VCiommu0a
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX channel8_ac : 4;
    //
    // Access Class for Channel 9 BXT VCiommu0b
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX channel9_ac : 4;
    //
    // Access Class for Channel 10 BXT VCiommu1b
    //
    // Bits[11:8], RW, default = 0x1
    //
    UINTX channel10_ac : 4;
    //
    // Access Class for Channel 11 BXT Reserved
    //
    // Bits[15:12], RO, default = 0x0
    //
    UINTX channel11_ac : 4;
    //
    // Access Class for Channel 12 BXT Reserved
    //
    // Bits[19:16], RO, default = 0x0
    //
    UINTX channel12_ac : 4;
    //
    // Access Class for Channel 13 BXT Reserved
    //
    // Bits[23:20], RO, default = 0x0
    //
    UINTX channel13_ac : 4;
    //
    // Access Class for Channel 14 BXT Reserved
    //
    // Bits[27:24], RO, default = 0x0
    //
    UINTX channel14_ac : 4;
    //
    // Access Class for Channel 15 BXT Reserved
    //
    // Bits[31:28], RO, default = 0x0
    //
    UINTX channel15_ac : 4;
  } Bits;
  UINTX Data;
} B_CR_SCH_AC_MAPPING2_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BISOC_BUNIT_REG                               0x00004C44
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enable PMI to move to an idle state:  When set Bunit will cause a PMI interface
    // to move to an idle state depending on various idle indicators.  When cleared Bunit
    // will always keep all PMI interfaces active.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX enable_pmi_idle : 1;
    //
    // Enter PMI Idle Delay: Formerly called ENTER_SELF_REFRESH_DLY.  Duration the Bunit
    // waits before asking PMI interfaces to go idle. Each unit of time is 240ns.
    //
    // Bits[7:1], RW, default = 0x1
    //
    UINTX enter_pmi_idle_dly : 7;
    //
    // Reserved
    //
    // Bits[9:8], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // 0: Request in Bunit scheduler scoreboard targeting any PMI channel within the
    // slice will cause all PMI channels to exit IDLE state.  1: A PMI channel will exit
    // IDLE state only when a request targeting that PMI channel is available to be scheduled
    // in the Bunit scheduler scoreboard.
    //
    // Bits[10:10], RW, default = 0x1
    //
    UINTX ch_exit_mode : 1;
    //
    // 0: Bunit causes all PMI channels in both slices to exit IDLE state if a transaction
    // targeting any slice is stalled in the BunitFE Badmit arbiter.  1: Bunit causes
    // all PMI channels in only the targeted slcie to exit IDLE state when a transaction
    // is stalled in the BunitFE Badmit arbiter.
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX slice_exit_mode : 1;
    //
    // Exit PMI Idle Latency:  Required latency to Exit Self Refresh in 240ns increments.
    // Default is 0usec which will cause any isoc request regardless of its deadline
    // indication to cause PMI to exit idle state.  Note that best effort requests will
    // always cause PMI to exit idle state.  NOTE:  PND2 will always wake up PMI on any
    // request regardless of the request deadline hence the default value of 0.
    //
    // Bits[18:12], RW, default = 0x0
    //
    UINTX exit_pmi_idle_latency : 7;
    //
    // Used by the Punit for reset flow.  When set to 1, Bunit will abort all PII transactions,
    // i.e no PMI transactions will be launched for the PII transactions.  Reads will
    // be completed with all 1's data and Abort bit set on the PII completion.  Writes
    // will be dropped.  This bit has no effect on transactions admitted to the Bunit
    // prior to when the bit was set and they will be handled normally.   When the bit
    // is clear, all PII transactions will be handled normally.
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX abort_pii_requests : 1;
    //
    // Scheduler Latency:  Request latency below which an ISOC request is considered
    // as a HiPriority Request. Value programmed has 240ns resolution. Default is approximately
    // 2usec.
    //
    // Bits[23:20], RW, default = 0x8
    //
    UINTX scheduler_latency : 4;
    //
    // Enter PMI Idle Deadline Threshold:  Formerly ENTER_SELF_REFRESH_THRSH.  Required
    // request latency to allow PMI to enter IDLE state.  Value programmed has a 240ns
    // resolution.  If the Bunit receives ISOC requests that have a required latency
    // less than this value the Bunit will keep the memory out of Self Refresh.  NOTE:
    //  PND2 will not need this and hence the default of 0x0
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX enter_pmi_idle_deadline_thrsh : 8;
  } Bits;
  UINTX Data;
} B_CR_BISOC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BCOSCAT_BUNIT_REG                             0x00004C4C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // COS Category for Agent0
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX cos_cat_agent0 : 2;
    //
    // COS Category for Agent1
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX cos_cat_agent1 : 2;
    //
    // COS Category for Agent2
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX cos_cat_agent2 : 2;
    //
    // COS Category for Agent3
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX cos_cat_agent3 : 2;
    //
    // COS Category for Agent4
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX cos_cat_agent4 : 2;
    //
    // COS Category for Agent5
    //
    // Bits[11:10], RW, default = 0x1
    //
    UINTX cos_cat_agent5 : 2;
    //
    // COS Category for Agent6
    //
    // Bits[13:12], RW, default = 0x1
    //
    UINTX cos_cat_agent6 : 2;
    //
    // COS Category for Agent7
    //
    // Bits[15:14], RW, default = 0x1
    //
    UINTX cos_cat_agent7 : 2;
    //
    // COS Category for Agent8
    //
    // Bits[17:16], RW, default = 0x1
    //
    UINTX cos_cat_agent8 : 2;
    //
    // COS Category for Agent9
    //
    // Bits[19:18], RW, default = 0x1
    //
    UINTX cos_cat_agent9 : 2;
    //
    // COS Category for Agent10
    //
    // Bits[21:20], RW, default = 0x0
    //
    UINTX cos_cat_agent10 : 2;
    //
    // COS Category for Agent11
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX cos_cat_agent11 : 2;
    //
    // COS Category for Agent12
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX cos_cat_agent12 : 2;
    //
    // COS Category for Agent13
    //
    // Bits[27:26], RW, default = 0x1
    //
    UINTX cos_cat_agent13 : 2;
    //
    // COS Category for Agent14
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX cos_cat_agent14 : 2;
    //
    // COS Category for Agent15
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX cos_cat_agent15 : 2;
  } Bits;
  UINTX Data;
} B_CR_BCOSCAT_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BDPT_BUNIT_REG                                0x00004C50
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Lower threshold for DPT throttling.
    //
    // Bits[5:0], RW, default = 0x8
    //
    UINTX dpt_lo_thresh : 6;
    //
    // Reserved
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Upper threshold for DPT throttling.
    //
    // Bits[13:8], RW, default = 0x10
    //
    UINTX dpt_hi_thresh : 6;
    //
    // Reserved
    //
    // Bits[30:14], RO, default = 0x0
    //
    UINTX reserved_0 : 17;
    //
    // DPT Enable:  When set enables dynamic prefetch throttling of IDI requests.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX dpt_mode : 1;
  } Bits;
  UINTX Data;
} B_CR_BDPT_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_SLICE_CHANNEL_HASH_BUNIT_REG                  0x00004C58
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Slice 1 is disabled no memory address mapped to Slice 1.  All request sent to
    // Slice 0
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX slice_1_disabled : 1;
    //
    // 0: HVM mode is disabled.  1: HVM mode is enabled.   When HVM mode is enabled Slice
    // Hash and Channel Hash is done as follows:  Both slices and all four PMI channels
    // enabled:  Slice Hash is Request Physical Addr[29] Channel Hash is PostRemap Addr[30]
    //  Both slices enabled but only one PMI channel in each slice enabled:  Slice Hash
    // is Request Physical Addr[29]  Only one SLICE0 enabled but both PMI channels in
    // SLICE0 enabled:  Channel Hash is PostRemap Addr[29]  When HVM_MODE is enabled
    // TOLUD must be set at 2GB.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX hvm_mode : 1;
    //
    // Default interleave mode that specifies how the Slice Selector and Channel Selector
    // bits are to be determined.  Relevant only when HVM mode is disabled and only for
    // system memory addresses that do not fall under the MOT region or the Asymmetric
    // memory region in the System Address Map.  Legal encodings are 0x0 0x1 and 0x2.
    //  An encoding of 0x3 is treated as if it was 0x2.   When both slices and all four
    // PMI channels are enabled   0x0: Default Slice Selector is Addr[10] and Default
    // Channel Selector is Addr[11]  0x1: Default Slice Selector is Addr[11] and Default
    // Channel Selector is Addr[12]  0x2: Default Slice Selector is Addr[12] and Default
    // Channel Selector is Addr[13]  When both slices are enabled but only one channel
    // in each slice enabled:   0x0: Default Slice Selector is Addr[10]  0x1: Default
    // Slice Selector is Addr[11]  0x2: Default Slice Selector is Addr[12]  When only
    // SLICE0 is enabled and both channels on that slice are enabled:   0x0: Default
    // Channel Selector is Addr[10]  0x1: Default Channel Selector is Addr[11]  0x2:
    // Default Channel Selector is Addr[12]  When SLICE0 and only one channel in that
    // slice is enabled this field is not relevant.  Bunit overrides the setting of the
    // SLICE_HASH_MASK to always include the Slice Selector bit.  Similarly Bunit overrides
    // the setting of the CH_HASH_MASK to always include the Channel Selector bit.
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX interleave_mode : 2;
    //
    // Reserved
    //
    // Bits[5:4], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // When both slices are enabled this field specifies the Slice Hash Mask to be applied
    // on Addr[19:6] physical address of the request to compute which slice a request
    // must be routed to.  Relevant only when HVM mode is disabled and only for physical
    // addresses that do not fall under the Asymmetric Memory Region and the MOT region.
    //  Bunit will override the programmed value to include the Slice Selector bit.
    // Additionally, Bunit will remove the Channel Selector bit. See INTERLEAVE_MODE
    // field.  Note that HVM mode non-address IDI requests asymmetric memory region and
    // MOT regions have special hash requirements and hence they do not use the SLICE_HASH_MASK.
    //
    // Bits[19:6], RW, default = 0x0
    //
    UINTX slice_hash_mask : 14;
    //
    // Reserved
    //
    // Bits[30:20], RO, default = 0x0
    //
    UINTX reserved_1 : 11;
    //
    // Spare bit: TBD.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX spare : 1;
    //
    // Bunit is divided into two slices, and each slice has two PMI channels to the internal
    // memory subsystem, for a total of four channels. With this bit asserted, channel
    // 1 in both slices is disabled, and thus no memory addresses are mapped to the slice's
    // ch 1. All requests are sent to the slice's channel 0.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX ch_1_disabled : 1;
    //
    // Reserved
    //
    // Bits[37:33], RO, default = 0x0
    //
    UINTX reserved_2 : 5;
    //
    // When both PMI channels in a slice are enabled this field specifies the Channel
    // Hash Mask to be applied on Addr[19:6] postremap DRAM address of the request to
    // compute which PMI channel a request must be routed to.  Relevant only when HVM
    // mode is disabled and only for requests that do not fall under the MOT region.
    //  Bunit will override the programmed value to include the Channel Selector bit.
    //  Additionally, Bunit will remove the Slice Selector bit.  See INTERLEAVE_MODE
    // field.  Note that HVM mode and MOT regions have special hash requirements and
    // hence they do not use the CH_HASH_MASK.
    //
    // Bits[51:38], RW, default = 0x0
    //
    UINTX ch_hash_mask : 14;
    //
    // Reserved
    //
    // Bits[62:52], RO, default = 0x0
    //
    UINTX reserved_3 : 11;
    //
    // When set, microcode will disallow writes to the this register via the WRMSR path.
    //  Intended usage is for BIOS to set the LOCK when it updates the CR and Ucode to
    // check the LOCK bit to decide whether the WRMSR to this CR must be allowed.  Bunit
    // implements only storage for this bit.  No hardware exists to implement hardware
    // locking.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX lock : 1;
  } Bits;
  UINTX Data;
} B_CR_SLICE_CHANNEL_HASH_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BSCHCTRL0_BUNIT_REG                           0x00004C60
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[23:0], RO, default = 0x0
    //
    UINTX reserved_1 : 24;
    //
    // Best Effort Max Latency: This field specifies the max latency for scheduling Best
    // Effort Traffic. The value is added to the global timer value when a read request
    // is granted at Badmit. After the delay specified the page scheduling is ignored
    // for the requests and the request will be scheduled in order. Agent weights still
    // affect the final scheduling latency after the specified delay time has expired.
    //  NOTE:  No longer relevant since page aware scheduling has been removed.
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX best_effort_max_latency : 8;
  } Bits;
  UINTX Data;
} B_CR_BSCHCTRL0_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BPMRVCTL_BUNIT_REG                            0x00004C68
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Protect Asset Access Violation Channel ID:  This value indicates the Channel ID
    // VC of the request that caused the last access violation if the interrupt is enabled.
    // If access violation was from an IDI attach point this field latches the LPID.
    //
    // Bits[7:0], RW/V, default = 0x0
    //
    UINTX violating_agent_chiid : 8;
    //
    // Protected Asset Access Violation Agent ID:  This 4bit value indicates which agent
    // caused the last access violation if the interrupt is enabled. The Agent ID values
    // are assigned starting with the Goldmont IDI Attach Points GT IDI Attach and followed
    // by Aunit.  For 2GLM configuration AgentID 0 is GLM0 AgentID 1 is GLM1 AgentID
    // 2 is GT and AgentID 3 is Aunit.
    //
    // Bits[11:8], RW/V, default = 0x0
    //
    UINTX violating_agent_id : 4;
    //
    // Unsupported IDI Request Opcode.   This field is deprecated which implies RTL functionality
    // for correct setting of this status field may not be validated.  Future derivatives
    // will remove this status field altogether.  Unsupported IDI length is logged a
    // machine check error.
    //
    // Bits[12:12], RW/V, default = 0x0
    //
    UINTX uns_idi_opc : 1;
    //
    // Unsupported PII A2B Request Opcode.   This field is deprecated which implies RTL
    // functionality for correct setting of this status field may not be validated.
    // Future derivatives will remove this status field altogether.  Aunit is an internal
    // IP and as such it must be validated to emit correct request opcodes.  Unsupported
    // opcodes should be coded as assertions
    //
    // Bits[13:13], RW/V, default = 0x0
    //
    UINTX uns_pfi_opc : 1;
    //
    // MMIO Access from a nonIDI agent.   This field is deprecated which implies RTL
    // functionality for correct setting of this status field may not be validated.
    // Future derivatives will remove this status field altogether.  This is logged as
    // machine check error.
    //
    // Bits[14:14], RW/V, default = 0x0
    //
    UINTX pii_2_mmio : 1;
    //
    // Memory Access to APIC region from a nonIDI agent
    //
    // Bits[15:15], RW/V, default = 0x0
    //
    UINTX mem_axs_2apic : 1;
    //
    // Protected Memory Range Violation :  This 6bit value indicates which region was
    // last violated when the interrupt is enabled.  Encoding is as follows:   0x0: Reserved
    //  0x1: Graphics Stolen Memory violation  0x2: SMM region violation  0x3: PRMRR
    // region violation  0x4: Reserved  0x5: VTd PMR Low region violation  0x6: VTd PMR
    // High region violation  0x7: MOT region violation  0x10-0x23:  Generic IMR region
    // violation.  0x10 is for IMR0 violation and 0x23 is for IMR19 violation.
    //
    // Bits[21:16], RW/V, default = 0x0
    //
    UINTX pmr_vio : 6;
    //
    // Reserved
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // IDI WB is not to DRAM space.   This field is deprecated which implies RTL functionality
    // for correct setting of this status field may not be validated.  Future derivatives
    // will remove this status field altogether.  WbMto targeting WB space is logged
    // as a machine check error.
    //
    // Bits[23:23], RW/V, default = 0x0
    //
    UINTX wb_non_dram_vio : 1;
    //
    // ECAM opcode is not PRD or WIL.
    //
    // Bits[24:24], RW/V, default = 0x0
    //
    UINTX ecam_opc_vio : 1;
    //
    // Unsupported IDI length.  This field is deprecated which implies RTL functionality
    // for correct setting of this status field may not be validated.  Future derivatives
    // will remove this status field altogether.  RTL must code assertions to check for
    // correct IDI lengths.
    //
    // Bits[25:25], RW/V, default = 0x0
    //
    UINTX uns_idi_len : 1;
    //
    // Unsupported PII A2B request length.  This field is deprecated which implies RTL
    // functionality for correct setting of this status field may not be validated.
    // Future derivatives will remove this status field altogether.  Aunit is an internal
    // IP and as such it must be validated to emit correct request lengths.  Unsupported
    // lengths should be coded as assertions.
    //
    // Bits[26:26], RW/V, default = 0x0
    //
    UINTX uns_pfi_len : 1;
    //
    // PII request address had Abort bit set and hence was aborted.
    //
    // Bits[27:27], RW/V, default = 0x0
    //
    UINTX pii_abort : 1;
    //
    // Reserved
    //
    // Bits[29:28], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Enable Logging on Protected Memory Region Violation: When set  the BUnit will
    // latch violation information into this register.  This bit is cleared upon first
    // violation and must be reset by software in order to log again.  Memory protection
    // is maintained even while the interrupt/capture mechanism is disabled.
    //
    // Bits[30:30], RW/V, default = 0x0
    //
    UINTX enable_log : 1;
    //
    // Enable Interrupt on Protected Memory Region Violation: When set the BUnit will
    // send an interrupt request on IOSF SB to the PUnit. Bunit will send IOSF-SB message
    // only on the first violation
    //
    // Bits[31:31], RW/V, default = 0x0
    //
    UINTX enable_intr : 1;
  } Bits;
  UINTX Data;
} B_CR_BPMRVCTL_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_B_SECURITY_STAT0_BUNIT_REG                    0x00004C6C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // First SAI violation detected
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX vio_more_than_0 : 1;
    //
    // More than one SAI violation detected
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX vio_more_than_1 : 1;
    //
    // Reserved
    //
    // Bits[7:2], RO, default = 0x0
    //
    UINTX reserved_1 : 6;
    //
    // SAI bits that triggered the violation
    //
    // Bits[15:8], RW/V, default = 0x0
    //
    UINTX vio_sai : 8;
    //
    // Toggles sending of SAI violation messages on sideband
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX sai_vio_msg_enable : 1;
    //
    // Toggles logging of SAI violations in the status registers
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX sai_vio_log_enable : 1;
    //
    // Reserved
    //
    // Bits[31:18], RO, default = 0x0
    //
    UINTX reserved_0 : 14;
  } Bits;
  UINTX Data;
} B_CR_B_SECURITY_STAT0_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_B_SECURITY_STAT1_BUNIT_REG                    0x00004C70
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Opcode that triggered the violation
    //
    // Bits[7:0], RW/V, default = 0x0
    //
    UINTX vio_opc : 8;
    //
    // Port that sent the violation
    //
    // Bits[15:8], RW/V, default = 0x0
    //
    UINTX vio_src_port : 8;
    //
    // Address that triggered the violation
    //
    // Bits[31:16], RW/V, default = 0x0
    //
    UINTX vio_addr : 16;
  } Bits;
  UINTX Data;
} B_CR_B_SECURITY_STAT1_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BDEBUG0_BUNIT_REG                             0x00004C78
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Casual Water Mark CasualWaterMark :  The casual watermark is used to trigger the
    // BUnits casual flush mechanism.  When the number of dirty entries is below the
    // casual watermark  no entries will be flushed even if the PMI interfaces are idle.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX casual_water_mark : 8;
    //
    // Chicken bits to change posted queue threshold.  Programming to a value greater
    // than 12 in BXT can cause deadlocks.
    //
    // Bits[15:8], RW, default = 0xC
    //
    UINTX posted_queue_threshold : 8;
    //
    // This will limit the number of downstream non-posted transaction that can be admitted
    // into each Slice.  Be careful with programming the value of this register, set
    // to high and you can cause deadlocks.
    //
    // Bits[20:16], RW, default = 0x1
    //
    UINTX total_downstream_np_limit : 5;
    //
    // Reserved
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // 0: Disables lock keepout timer. 1: Enables lock keepout timer which would prevent
    // Bunit from processing successive lock transactions back to back.
    //
    // Bits[24:24], RW, default = 0x1
    //
    UINTX lock_keepout_enable : 1;
    //
    // Counter value that specifies how long the Bunit will keep out a second lock transaction
    // after the first one has completed.Based on the usync clk frequency (16.67 MHz)
    // 0:0.96us(16 usyncs) 1:1.92us(32 usyncs) 2:2.88us(48 usyncs) 3:3.84us(64 usyncs)
    // 7:7.6us(128 usyncs)
    //
    // Bits[27:25], RW, default = 0x0
    //
    UINTX lock_keepout_timer : 3;
    //
    // Intended for Post Silicon testing of parity logic.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX invert_parity_err : 1;
    //
    // This bit is not used by the HW; it counts as a spare bit. There is an A-unit CR
    // bit that approximates this behavior. Was: Disable Badmit Urgent ISOC Requests:
    // Disables the ISOC high priority path in Badmit. When set all ISOC agent requests
    // are treated as Normal priority.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX disable_badmit_urgent_isoc : 1;
    //
    // XSBFT Mode: Enable XSBFT mode. When set  the Bunit does not wait for a read completion
    // from Dunit to determine read data availability.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX xsbft_mode : 1;
    //
    // Send All Accesses to Memory:  When set  all accesses will be sent to memory  regardless
    // of address.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX send_all_access_mem : 1;
  } Bits;
  UINTX Data;
} B_CR_BDEBUG0_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BDEBUG1_BUNIT_REG                             0x00004C7C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enable DRAM Read for Partial Write:  The BUnit has byteenable capability so it
    // doesnt require a DRAM read when there is a partial write.  This bit forces it
    // to perform the read anyway.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX enable_dram_read : 1;
    //
    // When set, B-unit will not grant a second PII transaction until the first transaction
    // has retired from the B-unit.  If this CR is set to 1 when PII transactions are
    // still pending, Bunit may not limit the outstanding PII transactions to 1.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX enable_single_pii_request_outstanding : 1;
    //
    // When set, B-unit will allow at most one request per IDI agent to be queued up
    // in each of the IDI Conflict Queues.  Enabling this mode will severly throttle
    // performance even in the absence of address conflicts.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX enable_single_entry_idi_cq : 1;
    //
    // Maximum number of entries in each slice that IDI requests are allowed to allocate
    // in the Bunit scoreboard/BRAM and the Tunit tracker.  Same CR is used as the limit
    // value for both Bunit scoreboard/BRAM and the Tunit tracker.  Once either limit
    // - scoreboard/BRAM or tracker is reached, no IDI request will be accepted by the
    // Badmit arbiter.  Limit is global across all IDI agents and not enforced per IDI
    // agent.  In other words any IDI agent individually and together with other IDI
    // agents are allowed to use only up to TOTAL_IDI_LIMIT entries in each slice.  NOTE:
    //  In BXT, programming a value lower than 34 can lead to deadlocks.
    //
    // Bits[8:3], RW, default = 0x27
    //
    UINTX total_idi_limit : 6;
    //
    // These bits enable the bypass of the Read Data pipestage for those agents for which
    // the pipestage has been provisioned. When set  the Read Data will be returned 1
    // clock cycle earlier. There is 1 bit per Bunit requester  with lower bits corresponding
    // to IDI agents followed by Aunit. The bit may only be set for those agents that
    // have the pipestage provisioned.  FIXME:  Can we find another home for this register
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX read_data_bypass_enable : 1;
    //
    // This bit enables the bypass path of the DB. When set data received from the dunit
    // may be sent directly to the requesting agent using the Live Read Data Return path.
    // When this bit is clear the Live Read Data Return path is delayed 1 clock cycle.
    //  FIXME:  Can we find another home for this register
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX enable_db_bypass : 1;
    //
    // PII2 ConflictQ s will accumulate credits in a counter and will not send the credits
    // to the AUnit immediately if the corresponding ConflictQ is not empty. Only when
    // the ConflictQ is empty will credits be sent to the AUnit. This is to avoid new
    // requests from continuously recycling through the ConflictQ.
    //
    // Bits[11:11], RW, default = 0x1
    //
    UINTX pii2_credit_acc : 1;
    //
    // Reserved
    //
    // Bits[15:12], RO, default = 0x0
    //
    UINTX reserved_0 : 4;
    //
    // Agent Weight Enable: When set these bits enable the use of Agent weights by the
    // Bunit scheduler regardless of the COS Category configuration set for Agents 015.
    // Normally the Agent weights are only used when the COS Category for an Agent is
    // configured for Best Effort. When the Agent Weight Enable bit is set for an agent
    // the COS category is still used as priority for the agent but the agent is also
    // limited by the weights specified for the agent in the BARBCTRL and BSCHWTx registers.
    //
    // Bits[31:16], RW, default = 0xFF
    //
    UINTX agent_weight_enable : 16;
  } Bits;
  UINTX Data;
} B_CR_BDEBUG1_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BTHCTRL_BUNIT_REG                             0x00004C80
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Total number of read and write requests allowed to be sent during any throttle
    // interval across all PMI channels in each slice.  Slice0 is allowed to send up
    // to THROTTLE_COUNT requests.  Similarly Slice1 is allowed to send up to THROTTLE_COUNT
    // requests.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX throttle_count : 16;
    //
    // Specifies the duration of the throttling interval as a multiple of 60ns N60ns.
    //  Example:  When programmed to 0x4 the throttling interval is 240ns.
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX throttle_interval : 8;
    //
    // Reserved
    //
    // Bits[30:24], RO, default = 0x0
    //
    UINTX reserved_0 : 7;
    //
    // Memory Throttling Enable: 0: Bunit scheduler will not throttle any transaction.
    //  1: Bunit scheduler will implement throttling and limit the number of transactions
    // sent during a throttling window
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX throttle_enable : 1;
  } Bits;
  UINTX Data;
} B_CR_BTHCTRL_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BTH_CYCLE_COUNT_SLICE0_BUNIT_REG              0x00004C84
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Counts the number of cycles the Bunit has an available request to send but the
    // request is throttled.  Counter is not saturating and will roll over to zero.
    // It is upto the consumer of the counter to handle roll over cases.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX throttle_cycle_count : 32;
  } Bits;
  UINTX Data;
} B_CR_BTH_CYCLE_COUNT_SLICE0_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BTH_CYCLE_COUNT_SLICE1_BUNIT_REG              0x00004C88
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Counts the number of cycles the Bunit has an available request to send but the
    // request is throttled.  Counter is not saturating and will roll over to zero.
    // It is upto the consumer of the counter to handle roll over cases.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX throttle_cycle_count : 32;
  } Bits;
  UINTX Data;
} B_CR_BTH_CYCLE_COUNT_SLICE1_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_IA_UNTRUSTED_CP_BUNIT_REG                     0x00004C90
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IA_UNTRUSTED_RAC
    // IA_UNTRUSTED_WAC and IA_UNTRUSTED_CP registers based on the value from the agents
    // 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0x40061010202
    //
    UINTX mem_range_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_IA_UNTRUSTED_CP_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_IA_UNTRUSTED_RAC_BUNIT_REG                    0x00004C98
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access based on the
    // agents 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC0063010217
    //
    UINTX mem_range_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_IA_UNTRUSTED_RAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_IA_UNTRUSTED_WAC_BUNIT_REG                    0x00004CA0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access based on the
    // agents 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC0061000217
    //
    UINTX mem_range_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_IA_UNTRUSTED_WAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MISRCTL_BUNIT_REG                             0x00004CB4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IDI select for U2C request MISR observation.
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX u2c_req_idi_sel : 4;
    //
    // IDI select for C2U request MISR observation.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX c2u_req_idi_sel : 4;
    //
    // IDI select for U2C data MISR observation.
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX u2c_data_idi_sel : 4;
    //
    // IDI select for C2U data MISR observation.
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX c2u_data_idi_sel : 4;
    //
    // IDI select for U2C response MISR observation.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX u2c_rsp_idi_sel : 4;
    //
    // IDI select for C2U reply MISR observation.
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX c2u_rpl_idi_sel : 4;
    //
    // When set, enables normal IDI MISRs
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX misr_en : 1;
    //
    // When set, enables FAB1 to IDI MISRs
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX misr_fab1_en : 1;
    //
    // Reserved
    //
    // Bits[26:26], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Write 1 to reset MISRU2CREQSIG register to 0xFFFF_FFFF
    //
    // Bits[27:27], WO, default = 0x0
    //
    UINTX u2c_req_clr : 1;
    //
    // Write 1 to reset MISRC2UREQSIG register to 0xFFFF_FFFF
    //
    // Bits[28:28], WO, default = 0x0
    //
    UINTX c2u_req_clr : 1;
    //
    // Write 1 to reset MISRU2CDATSIG register to 0xFFFF_FFFF
    //
    // Bits[29:29], WO, default = 0x0
    //
    UINTX u2c_data_clr : 1;
    //
    // Write 1 to reset MISRC2UDATSIG register to 0xFFFF_FFFF
    //
    // Bits[30:30], WO, default = 0x0
    //
    UINTX c2u_data_clr : 1;
    //
    // Write 1 to reset MISRRPLSIG register to 0xFFFF_FFFF
    //
    // Bits[31:31], WO, default = 0x0
    //
    UINTX c2urpl_u2crsp_clr : 1;
  } Bits;
  UINTX Data;
} B_CR_MISRCTL_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MISRS2CREQSIG_BUNIT_REG                       0x00004CB8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MISR signature for U2C request.
    //
    // Bits[31:0], RO/V, default = 0xFFFFFFFF
    //
    UINTX u2c_req_sig : 32;
  } Bits;
  UINTX Data;
} B_CR_MISRS2CREQSIG_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MISRC2SREQSIG_BUNIT_REG                       0x00004CBC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MISR signature for C2U request. Read only.
    //
    // Bits[31:0], RO/V, default = 0xFFFFFFFF
    //
    UINTX c2u_req_sig : 32;
  } Bits;
  UINTX Data;
} B_CR_MISRC2SREQSIG_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MISRS2CDATASIG_BUNIT_REG                      0x00004CC0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MISR signature for U2C data.
    //
    // Bits[31:0], RO/V, default = 0xFFFFFFFF
    //
    UINTX u2c_data_sig : 32;
  } Bits;
  UINTX Data;
} B_CR_MISRS2CDATASIG_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MISRC2SDATASIG_BUNIT_REG                      0x00004CC4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MISR signature for C2U data.
    //
    // Bits[31:0], RO/V, default = 0xFFFFFFFF
    //
    UINTX c2u_data_sig : 32;
  } Bits;
  UINTX Data;
} B_CR_MISRC2SDATASIG_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MISRRPLSIG_BUNIT_REG                          0x00004CC8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MISR signature for U2C response and C2U reply.
    //
    // Bits[31:0], RO/V, default = 0xFFFFFFFF
    //
    UINTX u2crsp_c2urpl_sig : 32;
  } Bits;
  UINTX Data;
} B_CR_MISRRPLSIG_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BCTRL_BUNIT_REG                               0x00004CD4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // RequestClkGateEnable: Enable signal for requestspecific BUnit clock gating.  Meaningful
    // only when MasterClkGateEnable signal is asserted.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX requestclk_gate_en : 1;
    //
    // MasterClkGateEnable: Master enable signal for BUnit clock gating
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX masterclk_gate_en : 1;
    //
    // BEClkGateEnable: Enables clock gating for the byte enable storage  when the MasterClkGateEnable
    // bit is set. Should be set in normal operation.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX beclk_gate_en : 1;
    //
    // Single Chunk Access: When set the Bunit will only allow 1 access to each 32B chunk
    // of the Tag entry at a time.  Note when DISABLE_REQUEST_COMBINING is set for a
    // VC the Bunit will only allow one request to the entire Tag entry at a time.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX single_chunk_access : 1;
    //
    // 0:  Read/Write access type checks for request combining are done separately for
    // each of the two 32B chunks in a cache line.  1:  Read/Write access type checks
    // for request combining are done over the full line.  In other words when this bit
    // is set, Bunit will not admit a read request if a write request to any chunk of
    // the same line is still not retired.  Similarly, Bunit will not admit a write request,
    // if a read request to any chunk of the same line is till pending.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX enable_rw_match_over_full_line : 1;
    //
    // When set to 1,  MOT will be forced to flush its pending buffers when any IDI or
    // PII write data interface is head-of-line blocked at the X2B arbiter waiting on
    // MOT to release its lock on the targeted BTag entry.  When clear, MOT will not
    // be forced to flush upon write data interface stalls due to MOT.
    //
    // Bits[5:5], RW, default = 0x1
    //
    UINTX force_mot_flush_for_x2b_write : 1;
    //
    // When set to 1,  MOT will be forced to flush its pending buffers when the oldest
    // read request in the Bunit scheduler is unable to be scheduled waiting on MOT to
    // release its lock on the targeted BTag entry.  When clear, MOT will not be forced
    // to flush when the scheduling of oldest read request to PMI is stalled due to MOT.
    //
    // Bits[6:6], RW, default = 0x1
    //
    UINTX force_mot_flush_for_read_sched : 1;
    //
    // When set to 1,  Bunit behavior will be such that MOT will be forced to flush its
    // pending buffers when all other idle conditions are met for atleast one PMI channel.
    //  When clear, Bunit will not pro-actively flush the MOT buffer and will wait on
    // MOT buffer to naturally go empty (for e.g. after a periodic internal MOT flush
    // event) before any PMI channel is brought to an idle state.
    //
    // Bits[7:7], RW, default = 0x1
    //
    UINTX force_mot_flush_for_idle : 1;
    //
    // 0: Disable IO space matching.  Nonaddress requests will not cause conflicts with
    // themselves and with other requests.  1:  Enable IO space matching.  Nonaddress
    // requests can cause conflicts with themselves and with other requests.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX enable_io_space_match : 1;
    //
    // When set Bunit will map all downstream transactions to the channel specified by
    // ALL_DOWNSTREAM_CHID ignoring the results of the Bunit system address decode logic.
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX all_downstream_chid_override : 1;
    //
    // When ALL_DOWNSTREAM_CHID_OVERRIDE bit is set to 1 Bunit will map all downstream
    // MMIO and IO transactions to only one channel specified by this ALL_DOWNSTREAM_CHID
    // bit ignoring the results of the system address decode logic.   In SoCs where there
    // is only one downstream channel e.g. DNV specifying chid 1  will have undefined
    // behavior.  It is the responsibility of BIOS or other system software to ensure
    // that downstream chid is not overridden to refer to a nonexistent channel.  NOTE:
    //  In BXT usage of this override to send transactions to agents below PSF1 on VC0a
    // will lead to unexpected machine behavior including hangs.
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX all_downstream_chid : 1;
    //
    // InOrder Flush Enable: When set enables the BUnit to flush entries from its write
    // buffer in the order they were enqueued into the Bunit.
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX inorder_flush_enable : 1;
    //
    // InOrder Read Enable: When set enables the BUnit to schedule read commands in the
    // order they were enqueued into the Bunit.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX inorder_read_enable : 1;
    //
    // Disable Owned: When set the Bunit will not used the Owned status for a tag entry.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX disable_owned : 1;
    //
    // When clear and MOT is enabled, Bunit admit arbiter will wait for valid Hammock
    // Harbor Time before granting any transaction.  When clear or when MOT is disabled,
    // Bunit admit arbiter will grant transactions without waiting for Hammock Harbor
    // time to be valid.
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX disable_badmit_stall_for_mot_hh_time : 1;
    //
    // Disable Hammock Harbor Sync protocol and enable clock counting NOTE: This does
    // not prevent badmit blocking for not having a valid sync'd time
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX hh_disable_sync : 1;
    //
    // For A2B requests this field specifies which VCs are eligible for request combining.
    //  DISABLE_REQUEST_COMBINING[16] specifies eligibility for channel 0 VC0a DISABLE_REQUEST_COMBINING[17]
    // specifies eligibility for channel 1 VC0b and so on.  When the bit is set for a
    // VC the VC is disabled for reqeust combining.  Any VC is eligible for request combining
    // only if either of the following holds: a VC can accept only inorder read completions
    // and T_WRITE_ORDERING specifies that the VC must receive inorder writepulls or
    // b a VC provides the guarantee that it will never send snooped requests.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX disable_request_combining : 16;
  } Bits;
  UINTX Data;
} B_CR_BCTRL_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PRMRR_BASE_BUNIT_REG                          0x00004CD8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[11:0], RO, default = 0x0
    //
    UINTX reserved_2 : 12;
    //
    // This field corresponds to bits 38:12 of the base address memory range which is
    // allocated to PRMRR memory.  PRMRR region size must be a strict poweroftwo at least
    // 4KB and naturally aligned to the size.  These bits are compared with the result
    // of the RANGE_MASK[38:12] applied to bits 38:12 of the incoming address to determine
    // if an access falls within the PRMRR defined region.
    //
    // Bits[38:12], RW, default = 0x0
    //
    UINTX range_base : 27;
    //
    // Reserved
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_PRMRR_BASE_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_PRMRR_MASK_BUNIT_REG                          0x00004CE0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[7:0], RO, default = 0x0
    //
    UINTX reserved_2 : 8;
    //
    // 1: Allows tracing of transactions to the PRMRR region by tracing agents.  0: Disallows
    // tracing of transactions to the PRMRR region by tracing agents.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // 1: Enables IWB data from caching agents for requests targeting PRMRR to be returned
    // to requestor.  0: Disables IWB data from caching agents for requests targeting
    // PRMRR to be returned to requestor.  NOTE: PRMRR does not have separate IA_IWB_EN
    // and GT_IWB_EN bits.  Since GT self-protects accesses to PRMRR, IWB_EN can be set
    // to 1.
    //
    // Bits[9:9], RW, default = 0x1
    //
    UINTX iwb_en : 1;
    //
    // Reserved. Lock bit is unused by Bunit.  Bunit uses policy registers to lock down
    // register.
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Indicates whether the PRMRR range is enabled and valid.  1: Enabled and Valid.
    //  Access control is enforced.  0: Not enabled.  Access control is not enforced.
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX range_en : 1;
    //
    // This field indicates which address bits must match PRMRR base in order to qualify
    // as an PRMRR access.  These bits are ANDed with bits 38:12 of the incoming address
    // to determine if the combined result matches the RANGE_BASE[38:12] value.  A match
    // indicates the the incoming address falls within the PRMRR region.
    //
    // Bits[38:12], RW, default = 0x0
    //
    UINTX range_mask : 27;
    //
    // Reserved
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_PRMRR_MASK_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BPRMRRCP_BUNIT_REG                            0x00004CE8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit PRMRR Control Policy: Bit vector used to determine which agents are allowed
    // access to the BPRMRRRAC, BPRMRRWAC and BPRMRRCP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0x40061010202
    //
    UINTX prmrr_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BPRMRRCP_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BPRMRRRAC_BUNIT_REG                           0x00004CF0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX prmrr_sai_pol_0 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX prmrr_sai_pol_1 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX prmrr_sai_pol_2 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_3 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX prmrr_sai_pol_4 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_5 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_6 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_7 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_8 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_9 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_10 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_11 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_12 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_13 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_14 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_15 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x1
    //
    UINTX prmrr_sai_pol_16 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_17 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_18 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_19 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_20 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_21 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_22 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_23 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_24 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_25 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_26 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_27 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_28 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_29 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_30 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_31 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_32 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_33 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_34 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_35 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_36 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_37 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_38 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_39 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_40 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_41 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_42 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_43 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_44 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_45 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_46 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_47 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_48 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_49 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_50 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_51 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_52 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_53 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_54 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_55 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_56 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_57 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_58 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_59 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_60 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_61 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_62 : 1;
    //
    // Bunit PRMRR SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the PRMRR region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BPRMRRRAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BPRMRRWAC_BUNIT_REG                           0x00004CF8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX prmrr_sai_pol_0 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX prmrr_sai_pol_1 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX prmrr_sai_pol_2 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_3 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX prmrr_sai_pol_4 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_5 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_6 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_7 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_8 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_9 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_10 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_11 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_12 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_13 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_14 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_15 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[16:16], RW, default = 0x1
    //
    UINTX prmrr_sai_pol_16 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_17 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_18 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_19 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_20 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_21 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_22 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_23 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_24 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_25 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_26 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_27 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_28 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_29 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_30 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_31 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_32 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_33 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_34 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_35 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_36 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_37 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_38 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_39 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_40 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_41 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_42 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_43 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_44 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_45 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_46 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_47 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_48 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_49 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_50 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_51 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_52 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_53 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_54 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_55 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_56 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_57 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_58 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_59 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_60 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_61 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX prmrr_sai_pol_62 : 1;
    //
    // Bunit PRMRR Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the Bunit PRMRR region based on the agents 6bit encoded
    // SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX prmrr_sai_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BPRMRRWAC_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BMISC_0_0_0_MCHBAR_BUNIT_REG                  0x00006800
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Read ESeg from DRAM ESegmentReadFromDRAM: When this bit is set  reads targeting
    // Esegment are routed to DRAM.  Fsegment corresponds to the memory range 0xE_0000
    // to 0xE_FFFF.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX read_eseg_from_dram : 1;
    //
    // Read FSeg from DRAM FSegmentReadFromDRAM: When this bit is set  reads targeting
    // Fsegment are routed to DRAM.  Fsegment corresponds to the memory range 0xF_0000
    // to 0xF_FFFF.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX read_fseg_from_dram : 1;
    //
    // ABSeginDRAM Legacy Video Area: When this bit is set  reads and writes targeting
    // A or Bsegments are routed to DRAM.  Asegment corresponds to the memory range 0xA_0000
    // to 0xA_FFFF.  Bsegment corresponds to the memory ranges 0xB_0000 to 0xB_7FFF and
    // 0xB_8000 to 0xB_FFFF.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX absegindram : 1;
    //
    // When set accesses to BIOS1, BIOS2, BIOS3 and BIOS4 ranges will be sent to memory
    // regardless of the Host IO Boundary setting in TOLUD.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX send_boot_vector_to_dram : 1;
    //
    // Reserved
    //
    // Bits[31:4], RO, default = 0x0
    //
    UINTX reserved_0 : 28;
  } Bits;
  UINTX Data;
} B_CR_BMISC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_SECURITY_CP_0_0_0_MCHBAR_BUNIT_REG            0x00006808
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit Security Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIARAC BIAWAC and BIACP registers based on the value from the agents
    // 6bit SAI field.
    //
    // Bits[63:0], RO, default = 0x0
    //
    UINTX sec_sai_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_SECURITY_CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_SECURITY_RAC_0_0_0_MCHBAR_BUNIT_REG           0x00006810
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit Security SAI Read Access Policy: Bit vector used to determine which agents
    // are allowed read access to the Bunit Security Group Configuration registers based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[63:0], RO, default = 0xC0061010202
    //
    UINTX sec_sai_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_SECURITY_RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_SECURITY_WAC_0_0_0_MCHBAR_BUNIT_REG           0x00006818
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit Security SAI Write Access Policy: Bit vector used to determine which agents
    // are allowed write access to the Bunit Security Group Configuration registers based
    // on the agents 6bit encoded SAI value.
    //
    // Bits[63:0], RO, default = 0xC0061010202
    //
    UINTX sec_sai_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_SECURITY_WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MEM_ACCESS_COUNT_SLICE0_BUNIT_REG             0x00006868
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Counts the number of PMI transactions that the Bunit has sent to any PMI channel.
    //  Counts both reads and writes.  Counter is not saturating and will roll over to
    // zero.  It is upto the consumer of the counter to handle roll over cases.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX mem_access_count : 32;
  } Bits;
  UINTX Data;
} B_CR_MEM_ACCESS_COUNT_SLICE0_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_MEM_ACCESS_COUNT_SLICE1_BUNIT_REG             0x0000686C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Counts the number of PMI transactions that the Bunit has sent to any PMI channel.
    //  Counts both reads and writes.  Counter is not saturating and will roll over to
    // zero.  It is upto the consumer of the counter to handle roll over cases.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX mem_access_count : 32;
  } Bits;
  UINTX Data;
} B_CR_MEM_ACCESS_COUNT_SLICE1_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR0BASE_0_0_0_MCHBAR_BUNIT_REG              0x00006870
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR0BASE:  Specifies bits 38:10 of the start address of IMR0 region.  IMR
    // region size must be a strict poweroftwo at least 1KB and naturally aligned to
    // the size.  These bits are compared with the result of the IMR0MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR0 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr0_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR0BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR0MASK_0_0_0_MCHBAR_BUNIT_REG              0x00006874
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR0MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR0BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR0 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr0_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR0MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR0CP_0_0_0_MCHBAR_BUNIT_REG                0x00006878
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR0 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR0RAC, BIMR0WAC, BIMR0CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr0_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR0CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR0RAC_0_0_0_MCHBAR_BUNIT_REG               0x00006880
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr0_read_pol_0 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr0_read_pol_1 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr0_read_pol_2 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr0_read_pol_3 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr0_read_pol_4 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr0_read_pol_5 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr0_read_pol_6 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr0_read_pol_7 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr0_read_pol_8 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr0_read_pol_9 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr0_read_pol_10 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr0_read_pol_11 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr0_read_pol_12 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr0_read_pol_13 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr0_read_pol_14 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr0_read_pol_15 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr0_read_pol_16 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr0_read_pol_17 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr0_read_pol_18 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr0_read_pol_19 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr0_read_pol_20 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr0_read_pol_21 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr0_read_pol_22 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr0_read_pol_23 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr0_read_pol_24 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr0_read_pol_25 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr0_read_pol_26 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr0_read_pol_27 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr0_read_pol_28 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr0_read_pol_29 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr0_read_pol_30 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr0_read_pol_31 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr0_read_pol_32 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr0_read_pol_33 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr0_read_pol_34 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr0_read_pol_35 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr0_read_pol_36 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr0_read_pol_37 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr0_read_pol_38 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr0_read_pol_39 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr0_read_pol_40 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr0_read_pol_41 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr0_read_pol_42 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr0_read_pol_43 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr0_read_pol_44 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr0_read_pol_45 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr0_read_pol_46 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr0_read_pol_47 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr0_read_pol_48 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr0_read_pol_49 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr0_read_pol_50 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr0_read_pol_51 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr0_read_pol_52 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr0_read_pol_53 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr0_read_pol_54 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr0_read_pol_55 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr0_read_pol_56 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr0_read_pol_57 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr0_read_pol_58 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr0_read_pol_59 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr0_read_pol_60 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr0_read_pol_61 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr0_read_pol_62 : 1;
    //
    // Bunit IMR0 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr0_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR0RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR0WAC_0_0_0_MCHBAR_BUNIT_REG               0x00006888
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr0_write_pol_0 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr0_write_pol_1 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr0_write_pol_2 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr0_write_pol_3 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr0_write_pol_4 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr0_write_pol_5 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr0_write_pol_6 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr0_write_pol_7 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr0_write_pol_8 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr0_write_pol_9 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr0_write_pol_10 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr0_write_pol_11 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr0_write_pol_12 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr0_write_pol_13 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr0_write_pol_14 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr0_write_pol_15 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr0_write_pol_16 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr0_write_pol_17 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr0_write_pol_18 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr0_write_pol_19 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr0_write_pol_20 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr0_write_pol_21 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr0_write_pol_22 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr0_write_pol_23 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr0_write_pol_24 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr0_write_pol_25 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr0_write_pol_26 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr0_write_pol_27 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr0_write_pol_28 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr0_write_pol_29 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr0_write_pol_30 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr0_write_pol_31 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr0_write_pol_32 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr0_write_pol_33 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr0_write_pol_34 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr0_write_pol_35 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr0_write_pol_36 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr0_write_pol_37 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr0_write_pol_38 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr0_write_pol_39 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr0_write_pol_40 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr0_write_pol_41 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr0_write_pol_42 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr0_write_pol_43 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr0_write_pol_44 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr0_write_pol_45 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr0_write_pol_46 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr0_write_pol_47 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr0_write_pol_48 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr0_write_pol_49 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr0_write_pol_50 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr0_write_pol_51 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr0_write_pol_52 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr0_write_pol_53 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr0_write_pol_54 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr0_write_pol_55 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr0_write_pol_56 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr0_write_pol_57 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr0_write_pol_58 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr0_write_pol_59 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr0_write_pol_60 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr0_write_pol_61 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr0_write_pol_62 : 1;
    //
    // Bunit IMR0 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR0 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr0_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR0WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR1BASE_0_0_0_MCHBAR_BUNIT_REG              0x00006890
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 1 IMR1BASE:  Specifies bits 38:10 of the start address of IMR1 region.  IMR
    // region size must be a strict poweroftwo at least 1KB and naturally aligned to
    // the size.  These bits are compared with the result of the IMR1MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR1 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr1_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR1BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR1MASK_0_0_0_MCHBAR_BUNIT_REG              0x00006894
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 1 IMR1MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR1BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR1 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr1_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR1MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR1CP_0_0_0_MCHBAR_BUNIT_REG                0x00006898
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR1 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR1RAC, BIMR1WAC, BIMR1CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr1_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR1CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR1RAC_0_0_0_MCHBAR_BUNIT_REG               0x000068A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr1_read_pol_0 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr1_read_pol_1 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr1_read_pol_2 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr1_read_pol_3 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr1_read_pol_4 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr1_read_pol_5 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr1_read_pol_6 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr1_read_pol_7 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr1_read_pol_8 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr1_read_pol_9 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr1_read_pol_10 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr1_read_pol_11 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr1_read_pol_12 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr1_read_pol_13 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr1_read_pol_14 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr1_read_pol_15 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr1_read_pol_16 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr1_read_pol_17 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr1_read_pol_18 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr1_read_pol_19 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr1_read_pol_20 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr1_read_pol_21 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr1_read_pol_22 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr1_read_pol_23 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr1_read_pol_24 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr1_read_pol_25 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr1_read_pol_26 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr1_read_pol_27 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr1_read_pol_28 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr1_read_pol_29 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr1_read_pol_30 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr1_read_pol_31 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr1_read_pol_32 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr1_read_pol_33 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr1_read_pol_34 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr1_read_pol_35 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr1_read_pol_36 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr1_read_pol_37 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr1_read_pol_38 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr1_read_pol_39 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr1_read_pol_40 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr1_read_pol_41 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr1_read_pol_42 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr1_read_pol_43 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr1_read_pol_44 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr1_read_pol_45 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr1_read_pol_46 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr1_read_pol_47 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr1_read_pol_48 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr1_read_pol_49 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr1_read_pol_50 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr1_read_pol_51 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr1_read_pol_52 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr1_read_pol_53 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr1_read_pol_54 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr1_read_pol_55 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr1_read_pol_56 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr1_read_pol_57 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr1_read_pol_58 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr1_read_pol_59 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr1_read_pol_60 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr1_read_pol_61 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr1_read_pol_62 : 1;
    //
    // Bunit IMR1 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr1_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR1RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR1WAC_0_0_0_MCHBAR_BUNIT_REG               0x000068A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr1_write_pol_0 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr1_write_pol_1 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr1_write_pol_2 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr1_write_pol_3 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr1_write_pol_4 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr1_write_pol_5 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr1_write_pol_6 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr1_write_pol_7 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr1_write_pol_8 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr1_write_pol_9 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr1_write_pol_10 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr1_write_pol_11 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr1_write_pol_12 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr1_write_pol_13 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr1_write_pol_14 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr1_write_pol_15 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr1_write_pol_16 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr1_write_pol_17 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr1_write_pol_18 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr1_write_pol_19 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr1_write_pol_20 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr1_write_pol_21 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr1_write_pol_22 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr1_write_pol_23 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr1_write_pol_24 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr1_write_pol_25 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr1_write_pol_26 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr1_write_pol_27 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr1_write_pol_28 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr1_write_pol_29 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr1_write_pol_30 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr1_write_pol_31 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr1_write_pol_32 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr1_write_pol_33 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr1_write_pol_34 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr1_write_pol_35 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr1_write_pol_36 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr1_write_pol_37 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr1_write_pol_38 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr1_write_pol_39 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr1_write_pol_40 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr1_write_pol_41 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr1_write_pol_42 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr1_write_pol_43 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr1_write_pol_44 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr1_write_pol_45 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr1_write_pol_46 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr1_write_pol_47 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr1_write_pol_48 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr1_write_pol_49 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr1_write_pol_50 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr1_write_pol_51 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr1_write_pol_52 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr1_write_pol_53 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr1_write_pol_54 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr1_write_pol_55 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr1_write_pol_56 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr1_write_pol_57 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr1_write_pol_58 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr1_write_pol_59 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr1_write_pol_60 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr1_write_pol_61 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr1_write_pol_62 : 1;
    //
    // Bunit IMR1 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR1 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr1_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR1WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR2BASE_0_0_0_MCHBAR_BUNIT_REG              0x000068B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR2BASE:  Specifies bits 38:10 of the start address of IMR2 region.  IMR
    // region size must be a strict poweroftwo at least 1KB and naturally aligned to
    // the size.  These bits are compared with the result of the IMR2MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR2 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr2_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR2BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR2MASK_0_0_0_MCHBAR_BUNIT_REG              0x000068B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR2MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR2BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR2 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr2_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR2MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR2CP_0_0_0_MCHBAR_BUNIT_REG                0x000068B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR2 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR2RAC, BIMR2WAC, BIMR2CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr2_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR2CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR2RAC_0_0_0_MCHBAR_BUNIT_REG               0x000068C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr2_read_pol_0 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr2_read_pol_1 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr2_read_pol_2 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr2_read_pol_3 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr2_read_pol_4 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr2_read_pol_5 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr2_read_pol_6 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr2_read_pol_7 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr2_read_pol_8 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr2_read_pol_9 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr2_read_pol_10 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr2_read_pol_11 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr2_read_pol_12 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr2_read_pol_13 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr2_read_pol_14 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr2_read_pol_15 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr2_read_pol_16 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr2_read_pol_17 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr2_read_pol_18 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr2_read_pol_19 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr2_read_pol_20 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr2_read_pol_21 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr2_read_pol_22 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr2_read_pol_23 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr2_read_pol_24 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr2_read_pol_25 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr2_read_pol_26 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr2_read_pol_27 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr2_read_pol_28 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr2_read_pol_29 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr2_read_pol_30 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr2_read_pol_31 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr2_read_pol_32 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr2_read_pol_33 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr2_read_pol_34 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr2_read_pol_35 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr2_read_pol_36 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr2_read_pol_37 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr2_read_pol_38 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr2_read_pol_39 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr2_read_pol_40 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr2_read_pol_41 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr2_read_pol_42 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr2_read_pol_43 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr2_read_pol_44 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr2_read_pol_45 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr2_read_pol_46 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr2_read_pol_47 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr2_read_pol_48 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr2_read_pol_49 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr2_read_pol_50 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr2_read_pol_51 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr2_read_pol_52 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr2_read_pol_53 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr2_read_pol_54 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr2_read_pol_55 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr2_read_pol_56 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr2_read_pol_57 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr2_read_pol_58 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr2_read_pol_59 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr2_read_pol_60 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr2_read_pol_61 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr2_read_pol_62 : 1;
    //
    // Bunit IMR2 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr2_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR2RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR2WAC_0_0_0_MCHBAR_BUNIT_REG               0x000068C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr2_write_pol_0 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr2_write_pol_1 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr2_write_pol_2 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr2_write_pol_3 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr2_write_pol_4 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr2_write_pol_5 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr2_write_pol_6 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr2_write_pol_7 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr2_write_pol_8 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr2_write_pol_9 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr2_write_pol_10 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr2_write_pol_11 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr2_write_pol_12 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr2_write_pol_13 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr2_write_pol_14 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr2_write_pol_15 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr2_write_pol_16 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr2_write_pol_17 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr2_write_pol_18 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr2_write_pol_19 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr2_write_pol_20 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr2_write_pol_21 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr2_write_pol_22 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr2_write_pol_23 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr2_write_pol_24 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr2_write_pol_25 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr2_write_pol_26 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr2_write_pol_27 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr2_write_pol_28 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr2_write_pol_29 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr2_write_pol_30 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr2_write_pol_31 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr2_write_pol_32 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr2_write_pol_33 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr2_write_pol_34 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr2_write_pol_35 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr2_write_pol_36 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr2_write_pol_37 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr2_write_pol_38 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr2_write_pol_39 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr2_write_pol_40 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr2_write_pol_41 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr2_write_pol_42 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr2_write_pol_43 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr2_write_pol_44 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr2_write_pol_45 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr2_write_pol_46 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr2_write_pol_47 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr2_write_pol_48 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr2_write_pol_49 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr2_write_pol_50 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr2_write_pol_51 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr2_write_pol_52 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr2_write_pol_53 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr2_write_pol_54 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr2_write_pol_55 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr2_write_pol_56 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr2_write_pol_57 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr2_write_pol_58 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr2_write_pol_59 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr2_write_pol_60 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr2_write_pol_61 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr2_write_pol_62 : 1;
    //
    // Bunit IMR2 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR2 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr2_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR2WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR3BASE_0_0_0_MCHBAR_BUNIT_REG              0x000068D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR3BASE:  Specifies bits 38:10 of the start address of IMR3 region.  IMR
    // region size must be a strict poweroftwo at least 1KB and naturally aligned to
    // the size.  These bits are compared with the result of the IMR3MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR3 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr3_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR3BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR3MASK_0_0_0_MCHBAR_BUNIT_REG              0x000068D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR3MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR3BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR3 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr3_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR3MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR3CP_0_0_0_MCHBAR_BUNIT_REG                0x000068D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR3 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR3RAC, BIMR3WAC, BIMR3CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr3_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR3CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR3RAC_0_0_0_MCHBAR_BUNIT_REG               0x000068E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr3_read_pol_0 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr3_read_pol_1 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr3_read_pol_2 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr3_read_pol_3 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr3_read_pol_4 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr3_read_pol_5 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr3_read_pol_6 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr3_read_pol_7 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr3_read_pol_8 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr3_read_pol_9 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr3_read_pol_10 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr3_read_pol_11 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr3_read_pol_12 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr3_read_pol_13 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr3_read_pol_14 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr3_read_pol_15 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr3_read_pol_16 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr3_read_pol_17 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr3_read_pol_18 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr3_read_pol_19 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr3_read_pol_20 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr3_read_pol_21 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr3_read_pol_22 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr3_read_pol_23 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr3_read_pol_24 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr3_read_pol_25 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr3_read_pol_26 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr3_read_pol_27 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr3_read_pol_28 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr3_read_pol_29 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr3_read_pol_30 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr3_read_pol_31 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr3_read_pol_32 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr3_read_pol_33 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr3_read_pol_34 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr3_read_pol_35 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr3_read_pol_36 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr3_read_pol_37 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr3_read_pol_38 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr3_read_pol_39 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr3_read_pol_40 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr3_read_pol_41 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr3_read_pol_42 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr3_read_pol_43 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr3_read_pol_44 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr3_read_pol_45 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr3_read_pol_46 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr3_read_pol_47 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr3_read_pol_48 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr3_read_pol_49 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr3_read_pol_50 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr3_read_pol_51 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr3_read_pol_52 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr3_read_pol_53 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr3_read_pol_54 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr3_read_pol_55 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr3_read_pol_56 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr3_read_pol_57 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr3_read_pol_58 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr3_read_pol_59 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr3_read_pol_60 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr3_read_pol_61 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr3_read_pol_62 : 1;
    //
    // Bunit IMR3 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr3_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR3RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR3WAC_0_0_0_MCHBAR_BUNIT_REG               0x000068E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr3_write_pol_0 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr3_write_pol_1 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr3_write_pol_2 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr3_write_pol_3 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr3_write_pol_4 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr3_write_pol_5 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr3_write_pol_6 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr3_write_pol_7 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr3_write_pol_8 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr3_write_pol_9 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr3_write_pol_10 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr3_write_pol_11 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr3_write_pol_12 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr3_write_pol_13 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr3_write_pol_14 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr3_write_pol_15 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr3_write_pol_16 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr3_write_pol_17 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr3_write_pol_18 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr3_write_pol_19 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr3_write_pol_20 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr3_write_pol_21 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr3_write_pol_22 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr3_write_pol_23 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr3_write_pol_24 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr3_write_pol_25 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr3_write_pol_26 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr3_write_pol_27 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr3_write_pol_28 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr3_write_pol_29 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr3_write_pol_30 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr3_write_pol_31 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr3_write_pol_32 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr3_write_pol_33 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr3_write_pol_34 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr3_write_pol_35 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr3_write_pol_36 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr3_write_pol_37 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr3_write_pol_38 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr3_write_pol_39 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr3_write_pol_40 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr3_write_pol_41 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr3_write_pol_42 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr3_write_pol_43 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr3_write_pol_44 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr3_write_pol_45 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr3_write_pol_46 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr3_write_pol_47 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr3_write_pol_48 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr3_write_pol_49 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr3_write_pol_50 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr3_write_pol_51 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr3_write_pol_52 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr3_write_pol_53 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr3_write_pol_54 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr3_write_pol_55 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr3_write_pol_56 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr3_write_pol_57 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr3_write_pol_58 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr3_write_pol_59 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr3_write_pol_60 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr3_write_pol_61 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr3_write_pol_62 : 1;
    //
    // Bunit IMR3 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR3 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr3_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR3WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR4BASE_0_0_0_MCHBAR_BUNIT_REG              0x000068F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR4BASE:  Specifies bits 38:10 of the start address of IMR4 region.  IMR
    // region size must be a strict poweroftwo at least 1KB and naturally aligned to
    // the size.  These bits are compared with the result of the IMR4MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR4 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr4_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR4BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR4MASK_0_0_0_MCHBAR_BUNIT_REG              0x000068F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR4MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR4BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR4 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr4_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR4MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR4CP_0_0_0_MCHBAR_BUNIT_REG                0x000068F8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR4 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR4RAC, BIMR4WAC, BIMR4CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr4_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR4CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR4RAC_0_0_0_MCHBAR_BUNIT_REG               0x00006900
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr4_read_pol_0 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr4_read_pol_1 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr4_read_pol_2 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr4_read_pol_3 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr4_read_pol_4 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr4_read_pol_5 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr4_read_pol_6 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr4_read_pol_7 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr4_read_pol_8 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr4_read_pol_9 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr4_read_pol_10 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr4_read_pol_11 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr4_read_pol_12 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr4_read_pol_13 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr4_read_pol_14 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr4_read_pol_15 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr4_read_pol_16 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr4_read_pol_17 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr4_read_pol_18 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr4_read_pol_19 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr4_read_pol_20 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr4_read_pol_21 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr4_read_pol_22 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr4_read_pol_23 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr4_read_pol_24 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr4_read_pol_25 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr4_read_pol_26 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr4_read_pol_27 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr4_read_pol_28 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr4_read_pol_29 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr4_read_pol_30 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr4_read_pol_31 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr4_read_pol_32 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr4_read_pol_33 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr4_read_pol_34 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr4_read_pol_35 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr4_read_pol_36 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr4_read_pol_37 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr4_read_pol_38 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr4_read_pol_39 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr4_read_pol_40 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr4_read_pol_41 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr4_read_pol_42 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr4_read_pol_43 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr4_read_pol_44 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr4_read_pol_45 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr4_read_pol_46 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr4_read_pol_47 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr4_read_pol_48 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr4_read_pol_49 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr4_read_pol_50 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr4_read_pol_51 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr4_read_pol_52 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr4_read_pol_53 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr4_read_pol_54 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr4_read_pol_55 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr4_read_pol_56 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr4_read_pol_57 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr4_read_pol_58 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr4_read_pol_59 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr4_read_pol_60 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr4_read_pol_61 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr4_read_pol_62 : 1;
    //
    // Bunit IMR4 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr4_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR4RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR4WAC_0_0_0_MCHBAR_BUNIT_REG               0x00006908
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr4_write_pol_0 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr4_write_pol_1 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr4_write_pol_2 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr4_write_pol_3 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr4_write_pol_4 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr4_write_pol_5 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr4_write_pol_6 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr4_write_pol_7 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr4_write_pol_8 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr4_write_pol_9 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr4_write_pol_10 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr4_write_pol_11 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr4_write_pol_12 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr4_write_pol_13 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr4_write_pol_14 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr4_write_pol_15 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr4_write_pol_16 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr4_write_pol_17 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr4_write_pol_18 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr4_write_pol_19 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr4_write_pol_20 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr4_write_pol_21 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr4_write_pol_22 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr4_write_pol_23 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr4_write_pol_24 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr4_write_pol_25 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr4_write_pol_26 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr4_write_pol_27 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr4_write_pol_28 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr4_write_pol_29 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr4_write_pol_30 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr4_write_pol_31 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr4_write_pol_32 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr4_write_pol_33 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr4_write_pol_34 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr4_write_pol_35 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr4_write_pol_36 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr4_write_pol_37 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr4_write_pol_38 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr4_write_pol_39 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr4_write_pol_40 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr4_write_pol_41 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr4_write_pol_42 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr4_write_pol_43 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr4_write_pol_44 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr4_write_pol_45 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr4_write_pol_46 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr4_write_pol_47 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr4_write_pol_48 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr4_write_pol_49 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr4_write_pol_50 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr4_write_pol_51 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr4_write_pol_52 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr4_write_pol_53 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr4_write_pol_54 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr4_write_pol_55 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr4_write_pol_56 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr4_write_pol_57 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr4_write_pol_58 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr4_write_pol_59 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr4_write_pol_60 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr4_write_pol_61 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr4_write_pol_62 : 1;
    //
    // Bunit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr4_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR4WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR5BASE_0_0_0_MCHBAR_BUNIT_REG              0x00006910
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR5BASE:  Specifies bits 38:10 of the start address of IMR5 region.  IMR
    // region size must be a strict poweroftwo at least 1KB and naturally aligned to
    // the size.  These bits are compared with the result of the IMR5MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR5 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr5_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR5BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR5MASK_0_0_0_MCHBAR_BUNIT_REG              0x00006914
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR5MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR5BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR5 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr5_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR5MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR5CP_0_0_0_MCHBAR_BUNIT_REG                0x00006918
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR5 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR5RAC, BIMR5WAC, BIMR5CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr5_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR5CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR5RAC_0_0_0_MCHBAR_BUNIT_REG               0x00006920
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr5_read_pol_0 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr5_read_pol_1 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr5_read_pol_2 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr5_read_pol_3 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr5_read_pol_4 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr5_read_pol_5 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr5_read_pol_6 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr5_read_pol_7 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr5_read_pol_8 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr5_read_pol_9 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr5_read_pol_10 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr5_read_pol_11 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr5_read_pol_12 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr5_read_pol_13 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr5_read_pol_14 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr5_read_pol_15 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr5_read_pol_16 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr5_read_pol_17 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr5_read_pol_18 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr5_read_pol_19 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr5_read_pol_20 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr5_read_pol_21 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr5_read_pol_22 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr5_read_pol_23 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr5_read_pol_24 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr5_read_pol_25 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr5_read_pol_26 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr5_read_pol_27 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr5_read_pol_28 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr5_read_pol_29 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr5_read_pol_30 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr5_read_pol_31 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr5_read_pol_32 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr5_read_pol_33 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr5_read_pol_34 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr5_read_pol_35 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr5_read_pol_36 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr5_read_pol_37 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr5_read_pol_38 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr5_read_pol_39 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr5_read_pol_40 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr5_read_pol_41 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr5_read_pol_42 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr5_read_pol_43 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr5_read_pol_44 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr5_read_pol_45 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr5_read_pol_46 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr5_read_pol_47 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr5_read_pol_48 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr5_read_pol_49 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr5_read_pol_50 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr5_read_pol_51 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr5_read_pol_52 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr5_read_pol_53 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr5_read_pol_54 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr5_read_pol_55 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr5_read_pol_56 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr5_read_pol_57 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr5_read_pol_58 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr5_read_pol_59 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr5_read_pol_60 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr5_read_pol_61 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr5_read_pol_62 : 1;
    //
    // Bunit IMR5 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr5_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR5RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR5WAC_0_0_0_MCHBAR_BUNIT_REG               0x00006928
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr5_write_pol_0 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr5_write_pol_1 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr5_write_pol_2 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr5_write_pol_3 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr5_write_pol_4 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr5_write_pol_5 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr5_write_pol_6 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr5_write_pol_7 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr5_write_pol_8 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr5_write_pol_9 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr5_write_pol_10 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr5_write_pol_11 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr5_write_pol_12 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr5_write_pol_13 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr5_write_pol_14 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr5_write_pol_15 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr5_write_pol_16 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr5_write_pol_17 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr5_write_pol_18 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr5_write_pol_19 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr5_write_pol_20 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr5_write_pol_21 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr5_write_pol_22 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr5_write_pol_23 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr5_write_pol_24 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr5_write_pol_25 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr5_write_pol_26 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr5_write_pol_27 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr5_write_pol_28 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr5_write_pol_29 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr5_write_pol_30 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr5_write_pol_31 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr5_write_pol_32 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr5_write_pol_33 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr5_write_pol_34 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr5_write_pol_35 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr5_write_pol_36 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr5_write_pol_37 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr5_write_pol_38 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr5_write_pol_39 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr5_write_pol_40 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr5_write_pol_41 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr5_write_pol_42 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr5_write_pol_43 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr5_write_pol_44 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr5_write_pol_45 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr5_write_pol_46 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr5_write_pol_47 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr5_write_pol_48 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr5_write_pol_49 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr5_write_pol_50 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr5_write_pol_51 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr5_write_pol_52 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr5_write_pol_53 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr5_write_pol_54 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr5_write_pol_55 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr5_write_pol_56 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr5_write_pol_57 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr5_write_pol_58 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr5_write_pol_59 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr5_write_pol_60 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr5_write_pol_61 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr5_write_pol_62 : 1;
    //
    // Bunit IMR5 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR5 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr5_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR5WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR6BASE_0_0_0_MCHBAR_BUNIT_REG              0x00006930
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR6BASE:  Specifies bits 38:10 of the start address of IMR6 region.  IMR
    // region size must be a strict poweroftwo at least 1KB and naturally aligned to
    // the size.  These bits are compared with the result of the IMR6MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR6 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr6_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR6BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR6MASK_0_0_0_MCHBAR_BUNIT_REG              0x00006934
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR6MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR6BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR6 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr6_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR6MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR6CP_0_0_0_MCHBAR_BUNIT_REG                0x00006938
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR6 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR6RAC, BIMR6WAC, BIMR6CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr6_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR6CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR6RAC_0_0_0_MCHBAR_BUNIT_REG               0x00006940
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr6_read_pol_0 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr6_read_pol_1 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr6_read_pol_2 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr6_read_pol_3 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr6_read_pol_4 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr6_read_pol_5 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr6_read_pol_6 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr6_read_pol_7 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr6_read_pol_8 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr6_read_pol_9 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr6_read_pol_10 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr6_read_pol_11 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr6_read_pol_12 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr6_read_pol_13 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr6_read_pol_14 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr6_read_pol_15 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr6_read_pol_16 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr6_read_pol_17 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr6_read_pol_18 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr6_read_pol_19 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr6_read_pol_20 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr6_read_pol_21 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr6_read_pol_22 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr6_read_pol_23 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr6_read_pol_24 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr6_read_pol_25 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr6_read_pol_26 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr6_read_pol_27 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr6_read_pol_28 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr6_read_pol_29 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr6_read_pol_30 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr6_read_pol_31 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr6_read_pol_32 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr6_read_pol_33 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr6_read_pol_34 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr6_read_pol_35 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr6_read_pol_36 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr6_read_pol_37 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr6_read_pol_38 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr6_read_pol_39 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr6_read_pol_40 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr6_read_pol_41 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr6_read_pol_42 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr6_read_pol_43 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr6_read_pol_44 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr6_read_pol_45 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr6_read_pol_46 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr6_read_pol_47 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr6_read_pol_48 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr6_read_pol_49 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr6_read_pol_50 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr6_read_pol_51 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr6_read_pol_52 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr6_read_pol_53 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr6_read_pol_54 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr6_read_pol_55 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr6_read_pol_56 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr6_read_pol_57 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr6_read_pol_58 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr6_read_pol_59 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr6_read_pol_60 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr6_read_pol_61 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr6_read_pol_62 : 1;
    //
    // Bunit IMR6 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr6_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR6RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR6WAC_0_0_0_MCHBAR_BUNIT_REG               0x00006948
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr6_write_pol_0 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr6_write_pol_1 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr6_write_pol_2 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr6_write_pol_3 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr6_write_pol_4 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr6_write_pol_5 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr6_write_pol_6 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr6_write_pol_7 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr6_write_pol_8 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr6_write_pol_9 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr6_write_pol_10 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr6_write_pol_11 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr6_write_pol_12 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr6_write_pol_13 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr6_write_pol_14 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr6_write_pol_15 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr6_write_pol_16 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr6_write_pol_17 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr6_write_pol_18 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr6_write_pol_19 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr6_write_pol_20 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr6_write_pol_21 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr6_write_pol_22 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr6_write_pol_23 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr6_write_pol_24 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr6_write_pol_25 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr6_write_pol_26 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr6_write_pol_27 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr6_write_pol_28 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr6_write_pol_29 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr6_write_pol_30 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr6_write_pol_31 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr6_write_pol_32 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr6_write_pol_33 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr6_write_pol_34 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr6_write_pol_35 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr6_write_pol_36 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr6_write_pol_37 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr6_write_pol_38 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr6_write_pol_39 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr6_write_pol_40 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr6_write_pol_41 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr6_write_pol_42 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr6_write_pol_43 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr6_write_pol_44 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr6_write_pol_45 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr6_write_pol_46 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr6_write_pol_47 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr6_write_pol_48 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr6_write_pol_49 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr6_write_pol_50 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr6_write_pol_51 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr6_write_pol_52 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr6_write_pol_53 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr6_write_pol_54 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr6_write_pol_55 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr6_write_pol_56 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr6_write_pol_57 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr6_write_pol_58 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr6_write_pol_59 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr6_write_pol_60 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr6_write_pol_61 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr6_write_pol_62 : 1;
    //
    // Bunit IMR6 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR6 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr6_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR6WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR7BASE_0_0_0_MCHBAR_BUNIT_REG              0x00006950
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR7BASE:  Specifies bits 38:10 of the start address of IMR7 region.  IMR
    // region size must be a strict poweroftwo at least 1KB and naturally aligned to
    // the size.  These bits are compared with the result of the IMR7MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR7 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr7_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR7BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR7MASK_0_0_0_MCHBAR_BUNIT_REG              0x00006954
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR7MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR7BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR7 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr7_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR7MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR7CP_0_0_0_MCHBAR_BUNIT_REG                0x00006958
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR7 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR7RAC, BIMR7WAC, BIMR7CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr7_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR7CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR7RAC_0_0_0_MCHBAR_BUNIT_REG               0x00006960
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr7_read_pol_0 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr7_read_pol_1 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr7_read_pol_2 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr7_read_pol_3 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr7_read_pol_4 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr7_read_pol_5 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr7_read_pol_6 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr7_read_pol_7 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr7_read_pol_8 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr7_read_pol_9 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr7_read_pol_10 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr7_read_pol_11 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr7_read_pol_12 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr7_read_pol_13 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr7_read_pol_14 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr7_read_pol_15 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr7_read_pol_16 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr7_read_pol_17 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr7_read_pol_18 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr7_read_pol_19 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr7_read_pol_20 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr7_read_pol_21 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr7_read_pol_22 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr7_read_pol_23 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr7_read_pol_24 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr7_read_pol_25 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr7_read_pol_26 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr7_read_pol_27 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr7_read_pol_28 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr7_read_pol_29 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr7_read_pol_30 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr7_read_pol_31 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr7_read_pol_32 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr7_read_pol_33 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr7_read_pol_34 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr7_read_pol_35 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr7_read_pol_36 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr7_read_pol_37 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr7_read_pol_38 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr7_read_pol_39 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr7_read_pol_40 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr7_read_pol_41 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr7_read_pol_42 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr7_read_pol_43 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr7_read_pol_44 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr7_read_pol_45 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr7_read_pol_46 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr7_read_pol_47 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr7_read_pol_48 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr7_read_pol_49 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr7_read_pol_50 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr7_read_pol_51 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr7_read_pol_52 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr7_read_pol_53 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr7_read_pol_54 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr7_read_pol_55 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr7_read_pol_56 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr7_read_pol_57 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr7_read_pol_58 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr7_read_pol_59 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr7_read_pol_60 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr7_read_pol_61 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr7_read_pol_62 : 1;
    //
    // Bunit IMR7 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr7_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR7RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR7WAC_0_0_0_MCHBAR_BUNIT_REG               0x00006968
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr7_write_pol_0 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr7_write_pol_1 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr7_write_pol_2 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr7_write_pol_3 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr7_write_pol_4 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr7_write_pol_5 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr7_write_pol_6 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr7_write_pol_7 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr7_write_pol_8 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr7_write_pol_9 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr7_write_pol_10 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr7_write_pol_11 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr7_write_pol_12 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr7_write_pol_13 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr7_write_pol_14 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr7_write_pol_15 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr7_write_pol_16 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr7_write_pol_17 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr7_write_pol_18 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr7_write_pol_19 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr7_write_pol_20 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr7_write_pol_21 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr7_write_pol_22 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr7_write_pol_23 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr7_write_pol_24 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr7_write_pol_25 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr7_write_pol_26 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr7_write_pol_27 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr7_write_pol_28 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr7_write_pol_29 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr7_write_pol_30 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr7_write_pol_31 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr7_write_pol_32 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr7_write_pol_33 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr7_write_pol_34 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr7_write_pol_35 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr7_write_pol_36 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr7_write_pol_37 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr7_write_pol_38 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr7_write_pol_39 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr7_write_pol_40 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr7_write_pol_41 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr7_write_pol_42 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr7_write_pol_43 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr7_write_pol_44 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr7_write_pol_45 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr7_write_pol_46 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr7_write_pol_47 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr7_write_pol_48 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr7_write_pol_49 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr7_write_pol_50 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr7_write_pol_51 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr7_write_pol_52 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr7_write_pol_53 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr7_write_pol_54 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr7_write_pol_55 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr7_write_pol_56 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr7_write_pol_57 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr7_write_pol_58 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr7_write_pol_59 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr7_write_pol_60 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr7_write_pol_61 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr7_write_pol_62 : 1;
    //
    // Bunit IMR7 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR7 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr7_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR7WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR8BASE_0_0_0_MCHBAR_BUNIT_REG              0x00006970
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR8BASE:  Specifies bits 38:10 of the start address of IMR8 region.  IMR
    // region size must be a strict poweroftwo at least 1KB and naturally aligned to
    // the size.  These bits are compared with the result of the IMR8MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR8 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr8_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR8BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR8MASK_0_0_0_MCHBAR_BUNIT_REG              0x00006974
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR8MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR8BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR8 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr8_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR8MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR8CP_0_0_0_MCHBAR_BUNIT_REG                0x00006978
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR8 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR8RAC, BIMR8WAC, BIMR8CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr8_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR8CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR8RAC_0_0_0_MCHBAR_BUNIT_REG               0x00006980
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr8_read_pol_0 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr8_read_pol_1 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr8_read_pol_2 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr8_read_pol_3 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr8_read_pol_4 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr8_read_pol_5 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr8_read_pol_6 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr8_read_pol_7 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr8_read_pol_8 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr8_read_pol_9 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr8_read_pol_10 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr8_read_pol_11 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr8_read_pol_12 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr8_read_pol_13 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr8_read_pol_14 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr8_read_pol_15 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr8_read_pol_16 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr8_read_pol_17 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr8_read_pol_18 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr8_read_pol_19 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr8_read_pol_20 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr8_read_pol_21 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr8_read_pol_22 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr8_read_pol_23 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr8_read_pol_24 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr8_read_pol_25 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr8_read_pol_26 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr8_read_pol_27 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr8_read_pol_28 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr8_read_pol_29 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr8_read_pol_30 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr8_read_pol_31 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr8_read_pol_32 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr8_read_pol_33 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr8_read_pol_34 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr8_read_pol_35 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr8_read_pol_36 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr8_read_pol_37 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr8_read_pol_38 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr8_read_pol_39 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr8_read_pol_40 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr8_read_pol_41 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr8_read_pol_42 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr8_read_pol_43 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr8_read_pol_44 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr8_read_pol_45 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr8_read_pol_46 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr8_read_pol_47 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr8_read_pol_48 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr8_read_pol_49 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr8_read_pol_50 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr8_read_pol_51 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr8_read_pol_52 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr8_read_pol_53 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr8_read_pol_54 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr8_read_pol_55 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr8_read_pol_56 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr8_read_pol_57 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr8_read_pol_58 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr8_read_pol_59 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr8_read_pol_60 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr8_read_pol_61 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr8_read_pol_62 : 1;
    //
    // Bunit IMR8 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr8_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR8RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR8WAC_0_0_0_MCHBAR_BUNIT_REG               0x00006988
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr8_write_pol_0 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr8_write_pol_1 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr8_write_pol_2 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr8_write_pol_3 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr8_write_pol_4 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr8_write_pol_5 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr8_write_pol_6 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr8_write_pol_7 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr8_write_pol_8 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr8_write_pol_9 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr8_write_pol_10 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr8_write_pol_11 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr8_write_pol_12 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr8_write_pol_13 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr8_write_pol_14 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr8_write_pol_15 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr8_write_pol_16 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr8_write_pol_17 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr8_write_pol_18 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr8_write_pol_19 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr8_write_pol_20 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr8_write_pol_21 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr8_write_pol_22 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr8_write_pol_23 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr8_write_pol_24 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr8_write_pol_25 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr8_write_pol_26 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr8_write_pol_27 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr8_write_pol_28 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr8_write_pol_29 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr8_write_pol_30 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr8_write_pol_31 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr8_write_pol_32 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr8_write_pol_33 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr8_write_pol_34 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr8_write_pol_35 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr8_write_pol_36 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr8_write_pol_37 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr8_write_pol_38 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr8_write_pol_39 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr8_write_pol_40 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr8_write_pol_41 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr8_write_pol_42 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr8_write_pol_43 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr8_write_pol_44 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr8_write_pol_45 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr8_write_pol_46 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr8_write_pol_47 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr8_write_pol_48 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr8_write_pol_49 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr8_write_pol_50 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr8_write_pol_51 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr8_write_pol_52 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr8_write_pol_53 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr8_write_pol_54 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr8_write_pol_55 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr8_write_pol_56 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr8_write_pol_57 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr8_write_pol_58 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr8_write_pol_59 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr8_write_pol_60 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr8_write_pol_61 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr8_write_pol_62 : 1;
    //
    // Bunit IMR8 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR8 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr8_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR8WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR9BASE_0_0_0_MCHBAR_BUNIT_REG              0x00006990
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 1 IMR9BASE:  Specifies bits 38:10 of the start address of IMR9 region.  IMR
    // region size must be a strict poweroftwo at least 1KB and naturally aligned to
    // the size.  These bits are compared with the result of the IMR9MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR9 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr9_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR9BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR9MASK_0_0_0_MCHBAR_BUNIT_REG              0x00006994
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 1 IMR9MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR9BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR9 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr9_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR9MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR9CP_0_0_0_MCHBAR_BUNIT_REG                0x00006998
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR9 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR9RAC, BIMR9WAC, BIMR9CP registers based on the value from the
    // agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr9_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR9CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR9RAC_0_0_0_MCHBAR_BUNIT_REG               0x000069A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr9_read_pol_0 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr9_read_pol_1 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr9_read_pol_2 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr9_read_pol_3 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr9_read_pol_4 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr9_read_pol_5 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr9_read_pol_6 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr9_read_pol_7 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr9_read_pol_8 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr9_read_pol_9 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr9_read_pol_10 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr9_read_pol_11 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr9_read_pol_12 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr9_read_pol_13 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr9_read_pol_14 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr9_read_pol_15 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr9_read_pol_16 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr9_read_pol_17 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr9_read_pol_18 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr9_read_pol_19 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr9_read_pol_20 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr9_read_pol_21 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr9_read_pol_22 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr9_read_pol_23 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr9_read_pol_24 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr9_read_pol_25 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr9_read_pol_26 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr9_read_pol_27 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr9_read_pol_28 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr9_read_pol_29 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr9_read_pol_30 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr9_read_pol_31 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr9_read_pol_32 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr9_read_pol_33 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr9_read_pol_34 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr9_read_pol_35 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr9_read_pol_36 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr9_read_pol_37 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr9_read_pol_38 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr9_read_pol_39 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr9_read_pol_40 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr9_read_pol_41 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr9_read_pol_42 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr9_read_pol_43 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr9_read_pol_44 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr9_read_pol_45 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr9_read_pol_46 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr9_read_pol_47 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr9_read_pol_48 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr9_read_pol_49 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr9_read_pol_50 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr9_read_pol_51 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr9_read_pol_52 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr9_read_pol_53 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr9_read_pol_54 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr9_read_pol_55 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr9_read_pol_56 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr9_read_pol_57 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr9_read_pol_58 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr9_read_pol_59 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr9_read_pol_60 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr9_read_pol_61 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr9_read_pol_62 : 1;
    //
    // Bunit IMR9 Read Access Policy: Bit vector used to determine which agents are allowed
    // read access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr9_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR9RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR9WAC_0_0_0_MCHBAR_BUNIT_REG               0x000069A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr9_write_pol_0 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr9_write_pol_1 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr9_write_pol_2 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr9_write_pol_3 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr9_write_pol_4 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr9_write_pol_5 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr9_write_pol_6 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr9_write_pol_7 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr9_write_pol_8 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr9_write_pol_9 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr9_write_pol_10 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr9_write_pol_11 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr9_write_pol_12 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr9_write_pol_13 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr9_write_pol_14 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr9_write_pol_15 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr9_write_pol_16 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr9_write_pol_17 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr9_write_pol_18 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr9_write_pol_19 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr9_write_pol_20 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr9_write_pol_21 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr9_write_pol_22 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr9_write_pol_23 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr9_write_pol_24 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr9_write_pol_25 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr9_write_pol_26 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr9_write_pol_27 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr9_write_pol_28 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr9_write_pol_29 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr9_write_pol_30 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr9_write_pol_31 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr9_write_pol_32 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr9_write_pol_33 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr9_write_pol_34 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr9_write_pol_35 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr9_write_pol_36 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr9_write_pol_37 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr9_write_pol_38 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr9_write_pol_39 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr9_write_pol_40 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr9_write_pol_41 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr9_write_pol_42 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr9_write_pol_43 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr9_write_pol_44 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr9_write_pol_45 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr9_write_pol_46 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr9_write_pol_47 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr9_write_pol_48 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr9_write_pol_49 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr9_write_pol_50 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr9_write_pol_51 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr9_write_pol_52 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr9_write_pol_53 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr9_write_pol_54 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr9_write_pol_55 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr9_write_pol_56 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr9_write_pol_57 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr9_write_pol_58 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr9_write_pol_59 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr9_write_pol_60 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr9_write_pol_61 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr9_write_pol_62 : 1;
    //
    // Bunit IMR9 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR9 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr9_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR9WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR10BASE_0_0_0_MCHBAR_BUNIT_REG             0x000069B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR10BASE:  Specifies bits 38:10 of the start address of IMR10 region.
    //  IMR region size must be a strict poweroftwo at least 1KB and naturally aligned
    // to the size.  These bits are compared with the result of the IMR10MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR10 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr10_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR10BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR10MASK_0_0_0_MCHBAR_BUNIT_REG             0x000069B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR10MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR10BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR10 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr10_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR10MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR10CP_0_0_0_MCHBAR_BUNIT_REG               0x000069B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR10 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR10RAC, BIMR10WAC, BIMR10CP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr10_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR10CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR10RAC_0_0_0_MCHBAR_BUNIT_REG              0x000069C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr10_read_pol_0 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr10_read_pol_1 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr10_read_pol_2 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr10_read_pol_3 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr10_read_pol_4 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr10_read_pol_5 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr10_read_pol_6 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr10_read_pol_7 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr10_read_pol_8 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr10_read_pol_9 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr10_read_pol_10 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr10_read_pol_11 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr10_read_pol_12 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr10_read_pol_13 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr10_read_pol_14 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr10_read_pol_15 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr10_read_pol_16 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr10_read_pol_17 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr10_read_pol_18 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr10_read_pol_19 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr10_read_pol_20 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr10_read_pol_21 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr10_read_pol_22 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr10_read_pol_23 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr10_read_pol_24 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr10_read_pol_25 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr10_read_pol_26 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr10_read_pol_27 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr10_read_pol_28 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr10_read_pol_29 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr10_read_pol_30 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr10_read_pol_31 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr10_read_pol_32 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr10_read_pol_33 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr10_read_pol_34 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr10_read_pol_35 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr10_read_pol_36 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr10_read_pol_37 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr10_read_pol_38 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr10_read_pol_39 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr10_read_pol_40 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr10_read_pol_41 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr10_read_pol_42 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr10_read_pol_43 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr10_read_pol_44 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr10_read_pol_45 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr10_read_pol_46 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr10_read_pol_47 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr10_read_pol_48 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr10_read_pol_49 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr10_read_pol_50 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr10_read_pol_51 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr10_read_pol_52 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr10_read_pol_53 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr10_read_pol_54 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr10_read_pol_55 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr10_read_pol_56 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr10_read_pol_57 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr10_read_pol_58 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr10_read_pol_59 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr10_read_pol_60 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr10_read_pol_61 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr10_read_pol_62 : 1;
    //
    // Bunit IMR10 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR10 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr10_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR10RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR10WAC_0_0_0_MCHBAR_BUNIT_REG              0x000069C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr10_write_pol_0 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr10_write_pol_1 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr10_write_pol_2 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr10_write_pol_3 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr10_write_pol_4 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr10_write_pol_5 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr10_write_pol_6 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr10_write_pol_7 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr10_write_pol_8 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr10_write_pol_9 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr10_write_pol_10 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr10_write_pol_11 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr10_write_pol_12 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr10_write_pol_13 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr10_write_pol_14 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr10_write_pol_15 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr10_write_pol_16 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr10_write_pol_17 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr10_write_pol_18 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr10_write_pol_19 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr10_write_pol_20 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr10_write_pol_21 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr10_write_pol_22 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr10_write_pol_23 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr10_write_pol_24 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr10_write_pol_25 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr10_write_pol_26 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr10_write_pol_27 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr10_write_pol_28 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr10_write_pol_29 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr10_write_pol_30 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr10_write_pol_31 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr10_write_pol_32 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr10_write_pol_33 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr10_write_pol_34 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr10_write_pol_35 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr10_write_pol_36 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr10_write_pol_37 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr10_write_pol_38 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr10_write_pol_39 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr10_write_pol_40 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr10_write_pol_41 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr10_write_pol_42 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr10_write_pol_43 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr10_write_pol_44 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr10_write_pol_45 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr10_write_pol_46 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr10_write_pol_47 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr10_write_pol_48 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr10_write_pol_49 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr10_write_pol_50 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr10_write_pol_51 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr10_write_pol_52 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr10_write_pol_53 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr10_write_pol_54 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr10_write_pol_55 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr10_write_pol_56 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr10_write_pol_57 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr10_write_pol_58 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr10_write_pol_59 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr10_write_pol_60 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr10_write_pol_61 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr10_write_pol_62 : 1;
    //
    // Bunit IMR10 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR10 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr10_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR10WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR11BASE_0_0_0_MCHBAR_BUNIT_REG             0x000069D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR11BASE:  Specifies bits 38:10 of the start address of IMR11 region.
    //  IMR region size must be a strict poweroftwo at least 1KB and naturally aligned
    // to the size.  These bits are compared with the result of the IMR11MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR11 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr11_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR11BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR11MASK_0_0_0_MCHBAR_BUNIT_REG             0x000069D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR11MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR11BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR11 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr11_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR11MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR11CP_0_0_0_MCHBAR_BUNIT_REG               0x000069D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR11 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR11RAC, BIMR11WAC, BIMR11CP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr11_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR11CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR11RAC_0_0_0_MCHBAR_BUNIT_REG              0x000069E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr11_read_pol_0 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr11_read_pol_1 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr11_read_pol_2 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr11_read_pol_3 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr11_read_pol_4 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr11_read_pol_5 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr11_read_pol_6 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr11_read_pol_7 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr11_read_pol_8 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr11_read_pol_9 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr11_read_pol_10 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr11_read_pol_11 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr11_read_pol_12 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr11_read_pol_13 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr11_read_pol_14 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr11_read_pol_15 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr11_read_pol_16 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr11_read_pol_17 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr11_read_pol_18 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr11_read_pol_19 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr11_read_pol_20 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr11_read_pol_21 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr11_read_pol_22 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr11_read_pol_23 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr11_read_pol_24 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr11_read_pol_25 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr11_read_pol_26 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr11_read_pol_27 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr11_read_pol_28 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr11_read_pol_29 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr11_read_pol_30 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr11_read_pol_31 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr11_read_pol_32 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr11_read_pol_33 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr11_read_pol_34 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr11_read_pol_35 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr11_read_pol_36 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr11_read_pol_37 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr11_read_pol_38 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr11_read_pol_39 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr11_read_pol_40 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr11_read_pol_41 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr11_read_pol_42 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr11_read_pol_43 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr11_read_pol_44 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr11_read_pol_45 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr11_read_pol_46 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr11_read_pol_47 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr11_read_pol_48 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr11_read_pol_49 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr11_read_pol_50 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr11_read_pol_51 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr11_read_pol_52 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr11_read_pol_53 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr11_read_pol_54 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr11_read_pol_55 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr11_read_pol_56 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr11_read_pol_57 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr11_read_pol_58 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr11_read_pol_59 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr11_read_pol_60 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr11_read_pol_61 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr11_read_pol_62 : 1;
    //
    // Bunit IMR11 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR11 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr11_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR11RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR11WAC_0_0_0_MCHBAR_BUNIT_REG              0x000069E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr11_write_pol_0 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr11_write_pol_1 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr11_write_pol_2 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr11_write_pol_3 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr11_write_pol_4 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr11_write_pol_5 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr11_write_pol_6 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr11_write_pol_7 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr11_write_pol_8 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr11_write_pol_9 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr11_write_pol_10 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr11_write_pol_11 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr11_write_pol_12 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr11_write_pol_13 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr11_write_pol_14 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr11_write_pol_15 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr11_write_pol_16 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr11_write_pol_17 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr11_write_pol_18 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr11_write_pol_19 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr11_write_pol_20 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr11_write_pol_21 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr11_write_pol_22 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr11_write_pol_23 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr11_write_pol_24 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr11_write_pol_25 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr11_write_pol_26 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr11_write_pol_27 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr11_write_pol_28 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr11_write_pol_29 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr11_write_pol_30 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr11_write_pol_31 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr11_write_pol_32 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr11_write_pol_33 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr11_write_pol_34 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr11_write_pol_35 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr11_write_pol_36 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr11_write_pol_37 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr11_write_pol_38 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr11_write_pol_39 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr11_write_pol_40 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr11_write_pol_41 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr11_write_pol_42 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr11_write_pol_43 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr11_write_pol_44 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr11_write_pol_45 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr11_write_pol_46 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr11_write_pol_47 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr11_write_pol_48 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr11_write_pol_49 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr11_write_pol_50 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr11_write_pol_51 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr11_write_pol_52 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr11_write_pol_53 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr11_write_pol_54 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr11_write_pol_55 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr11_write_pol_56 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr11_write_pol_57 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr11_write_pol_58 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr11_write_pol_59 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr11_write_pol_60 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr11_write_pol_61 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr11_write_pol_62 : 1;
    //
    // Bunit IMR11 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR11 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr11_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR11WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR12BASE_0_0_0_MCHBAR_BUNIT_REG             0x000069F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR12BASE:  Specifies bits 38:10 of the start address of IMR12 region.
    //  IMR region size must be a strict poweroftwo at least 1KB and naturally aligned
    // to the size.  These bits are compared with the result of the IMR12MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR12 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr12_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR12BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR12MASK_0_0_0_MCHBAR_BUNIT_REG             0x000069F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR12MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR12BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR12 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr12_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR12MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR12CP_0_0_0_MCHBAR_BUNIT_REG               0x000069F8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR12 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR12RAC, BIMR12WAC, BIMR12CP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr12_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR12CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR12RAC_0_0_0_MCHBAR_BUNIT_REG              0x00006A00
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr12_read_pol_0 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr12_read_pol_1 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr12_read_pol_2 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr12_read_pol_3 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr12_read_pol_4 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr12_read_pol_5 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr12_read_pol_6 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr12_read_pol_7 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr12_read_pol_8 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr12_read_pol_9 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr12_read_pol_10 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr12_read_pol_11 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr12_read_pol_12 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr12_read_pol_13 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr12_read_pol_14 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr12_read_pol_15 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr12_read_pol_16 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr12_read_pol_17 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr12_read_pol_18 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr12_read_pol_19 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr12_read_pol_20 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr12_read_pol_21 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr12_read_pol_22 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr12_read_pol_23 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr12_read_pol_24 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr12_read_pol_25 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr12_read_pol_26 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr12_read_pol_27 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr12_read_pol_28 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr12_read_pol_29 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr12_read_pol_30 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr12_read_pol_31 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr12_read_pol_32 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr12_read_pol_33 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr12_read_pol_34 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr12_read_pol_35 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr12_read_pol_36 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr12_read_pol_37 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr12_read_pol_38 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr12_read_pol_39 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr12_read_pol_40 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr12_read_pol_41 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr12_read_pol_42 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr12_read_pol_43 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr12_read_pol_44 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr12_read_pol_45 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr12_read_pol_46 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr12_read_pol_47 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr12_read_pol_48 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr12_read_pol_49 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr12_read_pol_50 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr12_read_pol_51 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr12_read_pol_52 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr12_read_pol_53 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr12_read_pol_54 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr12_read_pol_55 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr12_read_pol_56 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr12_read_pol_57 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr12_read_pol_58 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr12_read_pol_59 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr12_read_pol_60 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr12_read_pol_61 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr12_read_pol_62 : 1;
    //
    // Bunit IMR12 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR12 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr12_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR12RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR12WAC_0_0_0_MCHBAR_BUNIT_REG              0x00006A08
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr12_write_pol_0 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr12_write_pol_1 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr12_write_pol_2 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr12_write_pol_3 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr12_write_pol_4 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr12_write_pol_5 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr12_write_pol_6 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr12_write_pol_7 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr12_write_pol_8 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr12_write_pol_9 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr12_write_pol_10 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr12_write_pol_11 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr12_write_pol_12 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr12_write_pol_13 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr12_write_pol_14 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr12_write_pol_15 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr12_write_pol_16 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr12_write_pol_17 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr12_write_pol_18 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr12_write_pol_19 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr12_write_pol_20 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr12_write_pol_21 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr12_write_pol_22 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr12_write_pol_23 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr12_write_pol_24 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr12_write_pol_25 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr12_write_pol_26 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr12_write_pol_27 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr12_write_pol_28 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr12_write_pol_29 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr12_write_pol_30 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr12_write_pol_31 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr12_write_pol_32 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr12_write_pol_33 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr12_write_pol_34 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr12_write_pol_35 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr12_write_pol_36 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr12_write_pol_37 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr12_write_pol_38 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr12_write_pol_39 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr12_write_pol_40 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr12_write_pol_41 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr12_write_pol_42 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr12_write_pol_43 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr12_write_pol_44 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr12_write_pol_45 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr12_write_pol_46 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr12_write_pol_47 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr12_write_pol_48 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr12_write_pol_49 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr12_write_pol_50 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr12_write_pol_51 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr12_write_pol_52 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr12_write_pol_53 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr12_write_pol_54 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr12_write_pol_55 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr12_write_pol_56 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr12_write_pol_57 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr12_write_pol_58 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr12_write_pol_59 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr12_write_pol_60 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr12_write_pol_61 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr12_write_pol_62 : 1;
    //
    // Bunit IMR12 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR12 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr12_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR12WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR13BASE_0_0_0_MCHBAR_BUNIT_REG             0x00006A10
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR13BASE:  Specifies bits 38:10 of the start address of IMR13 region.
    //  IMR region size must be a strict poweroftwo at least 1KB and naturally aligned
    // to the size.  These bits are compared with the result of the IMR13MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR13 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr13_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR13BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR13MASK_0_0_0_MCHBAR_BUNIT_REG             0x00006A14
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR13MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR13BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR13 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr13_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR13MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR13CP_0_0_0_MCHBAR_BUNIT_REG               0x00006A18
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR13 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR13RAC, BIMR13WAC, BIMR13CP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr13_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR13CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR13RAC_0_0_0_MCHBAR_BUNIT_REG              0x00006A20
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr13_read_pol_0 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr13_read_pol_1 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr13_read_pol_2 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr13_read_pol_3 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr13_read_pol_4 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr13_read_pol_5 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr13_read_pol_6 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr13_read_pol_7 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr13_read_pol_8 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr13_read_pol_9 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr13_read_pol_10 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr13_read_pol_11 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr13_read_pol_12 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr13_read_pol_13 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr13_read_pol_14 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr13_read_pol_15 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr13_read_pol_16 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr13_read_pol_17 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr13_read_pol_18 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr13_read_pol_19 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr13_read_pol_20 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr13_read_pol_21 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr13_read_pol_22 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr13_read_pol_23 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr13_read_pol_24 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr13_read_pol_25 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr13_read_pol_26 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr13_read_pol_27 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr13_read_pol_28 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr13_read_pol_29 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr13_read_pol_30 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr13_read_pol_31 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr13_read_pol_32 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr13_read_pol_33 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr13_read_pol_34 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr13_read_pol_35 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr13_read_pol_36 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr13_read_pol_37 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr13_read_pol_38 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr13_read_pol_39 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr13_read_pol_40 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr13_read_pol_41 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr13_read_pol_42 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr13_read_pol_43 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr13_read_pol_44 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr13_read_pol_45 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr13_read_pol_46 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr13_read_pol_47 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr13_read_pol_48 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr13_read_pol_49 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr13_read_pol_50 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr13_read_pol_51 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr13_read_pol_52 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr13_read_pol_53 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr13_read_pol_54 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr13_read_pol_55 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr13_read_pol_56 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr13_read_pol_57 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr13_read_pol_58 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr13_read_pol_59 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr13_read_pol_60 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr13_read_pol_61 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr13_read_pol_62 : 1;
    //
    // Bunit IMR13 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR13 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr13_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR13RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR13WAC_0_0_0_MCHBAR_BUNIT_REG              0x00006A28
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr13_write_pol_0 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr13_write_pol_1 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr13_write_pol_2 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr13_write_pol_3 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr13_write_pol_4 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr13_write_pol_5 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr13_write_pol_6 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr13_write_pol_7 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr13_write_pol_8 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr13_write_pol_9 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr13_write_pol_10 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr13_write_pol_11 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr13_write_pol_12 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr13_write_pol_13 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr13_write_pol_14 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr13_write_pol_15 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr13_write_pol_16 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr13_write_pol_17 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr13_write_pol_18 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr13_write_pol_19 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr13_write_pol_20 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr13_write_pol_21 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr13_write_pol_22 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr13_write_pol_23 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr13_write_pol_24 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr13_write_pol_25 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr13_write_pol_26 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr13_write_pol_27 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr13_write_pol_28 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr13_write_pol_29 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr13_write_pol_30 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr13_write_pol_31 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr13_write_pol_32 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr13_write_pol_33 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr13_write_pol_34 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr13_write_pol_35 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr13_write_pol_36 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr13_write_pol_37 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr13_write_pol_38 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr13_write_pol_39 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr13_write_pol_40 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr13_write_pol_41 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr13_write_pol_42 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr13_write_pol_43 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr13_write_pol_44 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr13_write_pol_45 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr13_write_pol_46 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr13_write_pol_47 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr13_write_pol_48 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr13_write_pol_49 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr13_write_pol_50 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr13_write_pol_51 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr13_write_pol_52 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr13_write_pol_53 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr13_write_pol_54 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr13_write_pol_55 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr13_write_pol_56 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr13_write_pol_57 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr13_write_pol_58 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr13_write_pol_59 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr13_write_pol_60 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr13_write_pol_61 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr13_write_pol_62 : 1;
    //
    // Bunit IMR13 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR13 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr13_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR13WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR14BASE_0_0_0_MCHBAR_BUNIT_REG             0x00006A30
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR14BASE:  Specifies bits 38:10 of the start address of IMR14 region.
    //  IMR region size must be a strict poweroftwo at least 1KB and naturally aligned
    // to the size.  These bits are compared with the result of the IMR14MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR14 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr14_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR14BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR14MASK_0_0_0_MCHBAR_BUNIT_REG             0x00006A34
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR14MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR14BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR14 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr14_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR14MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR14CP_0_0_0_MCHBAR_BUNIT_REG               0x00006A38
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR14 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR14RAC, BIMR14WAC, BIMR14CP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr14_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR14CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR14RAC_0_0_0_MCHBAR_BUNIT_REG              0x00006A40
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr14_read_pol_0 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr14_read_pol_1 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr14_read_pol_2 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr14_read_pol_3 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr14_read_pol_4 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr14_read_pol_5 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr14_read_pol_6 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr14_read_pol_7 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr14_read_pol_8 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr14_read_pol_9 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr14_read_pol_10 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr14_read_pol_11 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr14_read_pol_12 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr14_read_pol_13 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr14_read_pol_14 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr14_read_pol_15 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr14_read_pol_16 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr14_read_pol_17 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr14_read_pol_18 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr14_read_pol_19 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr14_read_pol_20 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr14_read_pol_21 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr14_read_pol_22 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr14_read_pol_23 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr14_read_pol_24 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr14_read_pol_25 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr14_read_pol_26 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr14_read_pol_27 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr14_read_pol_28 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr14_read_pol_29 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr14_read_pol_30 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr14_read_pol_31 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr14_read_pol_32 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr14_read_pol_33 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr14_read_pol_34 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr14_read_pol_35 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr14_read_pol_36 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr14_read_pol_37 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr14_read_pol_38 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr14_read_pol_39 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr14_read_pol_40 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr14_read_pol_41 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr14_read_pol_42 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr14_read_pol_43 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr14_read_pol_44 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr14_read_pol_45 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr14_read_pol_46 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr14_read_pol_47 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr14_read_pol_48 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr14_read_pol_49 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr14_read_pol_50 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr14_read_pol_51 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr14_read_pol_52 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr14_read_pol_53 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr14_read_pol_54 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr14_read_pol_55 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr14_read_pol_56 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr14_read_pol_57 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr14_read_pol_58 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr14_read_pol_59 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr14_read_pol_60 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr14_read_pol_61 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr14_read_pol_62 : 1;
    //
    // Bunit IMR14 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR14 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr14_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR14RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR14WAC_0_0_0_MCHBAR_BUNIT_REG              0x00006A48
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr14_write_pol_0 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr14_write_pol_1 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr14_write_pol_2 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr14_write_pol_3 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr14_write_pol_4 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr14_write_pol_5 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr14_write_pol_6 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr14_write_pol_7 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr14_write_pol_8 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr14_write_pol_9 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr14_write_pol_10 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr14_write_pol_11 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr14_write_pol_12 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr14_write_pol_13 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr14_write_pol_14 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr14_write_pol_15 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr14_write_pol_16 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr14_write_pol_17 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr14_write_pol_18 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr14_write_pol_19 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr14_write_pol_20 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr14_write_pol_21 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr14_write_pol_22 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr14_write_pol_23 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr14_write_pol_24 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr14_write_pol_25 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr14_write_pol_26 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr14_write_pol_27 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr14_write_pol_28 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr14_write_pol_29 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr14_write_pol_30 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr14_write_pol_31 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr14_write_pol_32 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr14_write_pol_33 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr14_write_pol_34 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr14_write_pol_35 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr14_write_pol_36 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr14_write_pol_37 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr14_write_pol_38 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr14_write_pol_39 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr14_write_pol_40 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr14_write_pol_41 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr14_write_pol_42 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr14_write_pol_43 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr14_write_pol_44 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr14_write_pol_45 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr14_write_pol_46 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr14_write_pol_47 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr14_write_pol_48 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr14_write_pol_49 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr14_write_pol_50 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr14_write_pol_51 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr14_write_pol_52 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr14_write_pol_53 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr14_write_pol_54 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr14_write_pol_55 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr14_write_pol_56 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr14_write_pol_57 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr14_write_pol_58 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr14_write_pol_59 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr14_write_pol_60 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr14_write_pol_61 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr14_write_pol_62 : 1;
    //
    // Bunit IMR14 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR14 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr14_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR14WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR15BASE_0_0_0_MCHBAR_BUNIT_REG             0x00006A50
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR15BASE:  Specifies bits 38:10 of the start address of IMR15 region.
    //  IMR region size must be a strict poweroftwo at least 1KB and naturally aligned
    // to the size.  These bits are compared with the result of the IMR15MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR15 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr15_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR15BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR15MASK_0_0_0_MCHBAR_BUNIT_REG             0x00006A54
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR15MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR15BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR15 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr15_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR15MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR15CP_0_0_0_MCHBAR_BUNIT_REG               0x00006A58
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR15 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR15RAC, BIMR15WAC, BIMR15CP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr15_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR15CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR15RAC_0_0_0_MCHBAR_BUNIT_REG              0x00006A60
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr15_read_pol_0 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr15_read_pol_1 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr15_read_pol_2 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr15_read_pol_3 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr15_read_pol_4 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr15_read_pol_5 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr15_read_pol_6 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr15_read_pol_7 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr15_read_pol_8 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr15_read_pol_9 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr15_read_pol_10 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr15_read_pol_11 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr15_read_pol_12 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr15_read_pol_13 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr15_read_pol_14 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr15_read_pol_15 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr15_read_pol_16 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr15_read_pol_17 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr15_read_pol_18 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr15_read_pol_19 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr15_read_pol_20 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr15_read_pol_21 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr15_read_pol_22 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr15_read_pol_23 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr15_read_pol_24 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr15_read_pol_25 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr15_read_pol_26 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr15_read_pol_27 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr15_read_pol_28 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr15_read_pol_29 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr15_read_pol_30 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr15_read_pol_31 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr15_read_pol_32 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr15_read_pol_33 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr15_read_pol_34 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr15_read_pol_35 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr15_read_pol_36 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr15_read_pol_37 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr15_read_pol_38 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr15_read_pol_39 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr15_read_pol_40 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr15_read_pol_41 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr15_read_pol_42 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr15_read_pol_43 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr15_read_pol_44 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr15_read_pol_45 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr15_read_pol_46 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr15_read_pol_47 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr15_read_pol_48 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr15_read_pol_49 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr15_read_pol_50 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr15_read_pol_51 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr15_read_pol_52 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr15_read_pol_53 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr15_read_pol_54 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr15_read_pol_55 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr15_read_pol_56 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr15_read_pol_57 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr15_read_pol_58 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr15_read_pol_59 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr15_read_pol_60 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr15_read_pol_61 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr15_read_pol_62 : 1;
    //
    // Bunit IMR15 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR15 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr15_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR15RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR15WAC_0_0_0_MCHBAR_BUNIT_REG              0x00006A68
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr15_write_pol_0 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr15_write_pol_1 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr15_write_pol_2 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr15_write_pol_3 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr15_write_pol_4 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr15_write_pol_5 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr15_write_pol_6 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr15_write_pol_7 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr15_write_pol_8 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr15_write_pol_9 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr15_write_pol_10 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr15_write_pol_11 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr15_write_pol_12 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr15_write_pol_13 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr15_write_pol_14 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr15_write_pol_15 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr15_write_pol_16 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr15_write_pol_17 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr15_write_pol_18 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr15_write_pol_19 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr15_write_pol_20 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr15_write_pol_21 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr15_write_pol_22 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr15_write_pol_23 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr15_write_pol_24 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr15_write_pol_25 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr15_write_pol_26 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr15_write_pol_27 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr15_write_pol_28 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr15_write_pol_29 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr15_write_pol_30 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr15_write_pol_31 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr15_write_pol_32 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr15_write_pol_33 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr15_write_pol_34 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr15_write_pol_35 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr15_write_pol_36 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr15_write_pol_37 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr15_write_pol_38 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr15_write_pol_39 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr15_write_pol_40 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr15_write_pol_41 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr15_write_pol_42 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr15_write_pol_43 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr15_write_pol_44 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr15_write_pol_45 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr15_write_pol_46 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr15_write_pol_47 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr15_write_pol_48 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr15_write_pol_49 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr15_write_pol_50 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr15_write_pol_51 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr15_write_pol_52 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr15_write_pol_53 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr15_write_pol_54 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr15_write_pol_55 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr15_write_pol_56 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr15_write_pol_57 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr15_write_pol_58 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr15_write_pol_59 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr15_write_pol_60 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr15_write_pol_61 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr15_write_pol_62 : 1;
    //
    // Bunit IMR15 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR15 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr15_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR15WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR16BASE_0_0_0_MCHBAR_BUNIT_REG             0x00006A70
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR16BASE:  Specifies bits 38:10 of the start address of IMR16 region.
    //  IMR region size must be a strict poweroftwo at least 1KB and naturally aligned
    // to the size.  These bits are compared with the result of the IMR16MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR16 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr16_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR16BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR16MASK_0_0_0_MCHBAR_BUNIT_REG             0x00006A74
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR16MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR16BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR16 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr16_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR16MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR16CP_0_0_0_MCHBAR_BUNIT_REG               0x00006A78
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR16 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR16RAC, BIMR16WAC, BIMR16CP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr16_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR16CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR16RAC_0_0_0_MCHBAR_BUNIT_REG              0x00006A80
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr16_read_pol_0 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr16_read_pol_1 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr16_read_pol_2 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr16_read_pol_3 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr16_read_pol_4 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr16_read_pol_5 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr16_read_pol_6 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr16_read_pol_7 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr16_read_pol_8 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr16_read_pol_9 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr16_read_pol_10 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr16_read_pol_11 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr16_read_pol_12 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr16_read_pol_13 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr16_read_pol_14 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr16_read_pol_15 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr16_read_pol_16 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr16_read_pol_17 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr16_read_pol_18 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr16_read_pol_19 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr16_read_pol_20 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr16_read_pol_21 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr16_read_pol_22 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr16_read_pol_23 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr16_read_pol_24 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr16_read_pol_25 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr16_read_pol_26 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr16_read_pol_27 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr16_read_pol_28 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr16_read_pol_29 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr16_read_pol_30 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr16_read_pol_31 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr16_read_pol_32 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr16_read_pol_33 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr16_read_pol_34 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr16_read_pol_35 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr16_read_pol_36 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr16_read_pol_37 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr16_read_pol_38 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr16_read_pol_39 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr16_read_pol_40 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr16_read_pol_41 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr16_read_pol_42 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr16_read_pol_43 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr16_read_pol_44 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr16_read_pol_45 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr16_read_pol_46 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr16_read_pol_47 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr16_read_pol_48 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr16_read_pol_49 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr16_read_pol_50 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr16_read_pol_51 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr16_read_pol_52 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr16_read_pol_53 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr16_read_pol_54 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr16_read_pol_55 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr16_read_pol_56 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr16_read_pol_57 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr16_read_pol_58 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr16_read_pol_59 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr16_read_pol_60 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr16_read_pol_61 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr16_read_pol_62 : 1;
    //
    // Bunit IMR16 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR16 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr16_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR16RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR16WAC_0_0_0_MCHBAR_BUNIT_REG              0x00006A88
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr16_write_pol_0 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr16_write_pol_1 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr16_write_pol_2 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr16_write_pol_3 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr16_write_pol_4 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr16_write_pol_5 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr16_write_pol_6 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr16_write_pol_7 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr16_write_pol_8 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr16_write_pol_9 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr16_write_pol_10 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr16_write_pol_11 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr16_write_pol_12 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr16_write_pol_13 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr16_write_pol_14 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr16_write_pol_15 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr16_write_pol_16 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr16_write_pol_17 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr16_write_pol_18 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr16_write_pol_19 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr16_write_pol_20 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr16_write_pol_21 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr16_write_pol_22 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr16_write_pol_23 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr16_write_pol_24 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr16_write_pol_25 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr16_write_pol_26 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr16_write_pol_27 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr16_write_pol_28 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr16_write_pol_29 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr16_write_pol_30 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr16_write_pol_31 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr16_write_pol_32 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr16_write_pol_33 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr16_write_pol_34 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr16_write_pol_35 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr16_write_pol_36 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr16_write_pol_37 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr16_write_pol_38 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr16_write_pol_39 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr16_write_pol_40 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr16_write_pol_41 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr16_write_pol_42 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr16_write_pol_43 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr16_write_pol_44 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr16_write_pol_45 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr16_write_pol_46 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr16_write_pol_47 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr16_write_pol_48 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr16_write_pol_49 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr16_write_pol_50 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr16_write_pol_51 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr16_write_pol_52 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr16_write_pol_53 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr16_write_pol_54 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr16_write_pol_55 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr16_write_pol_56 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr16_write_pol_57 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr16_write_pol_58 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr16_write_pol_59 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr16_write_pol_60 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr16_write_pol_61 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr16_write_pol_62 : 1;
    //
    // Bunit IMR16 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR16 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr16_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR16WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR17BASE_0_0_0_MCHBAR_BUNIT_REG             0x00006A90
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR17BASE:  Specifies bits 38:10 of the start address of IMR17 region.
    //  IMR region size must be a strict poweroftwo at least 1KB and naturally aligned
    // to the size.  These bits are compared with the result of the IMR17MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR17 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr17_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR17BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR17MASK_0_0_0_MCHBAR_BUNIT_REG             0x00006A94
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR17MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR17BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR17 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr17_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR17MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR17CP_0_0_0_MCHBAR_BUNIT_REG               0x00006A98
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR17 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR17RAC, BIMR17WAC, BIMR17CP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr17_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR17CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR17RAC_0_0_0_MCHBAR_BUNIT_REG              0x00006AA0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr17_read_pol_0 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr17_read_pol_1 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr17_read_pol_2 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr17_read_pol_3 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr17_read_pol_4 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr17_read_pol_5 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr17_read_pol_6 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr17_read_pol_7 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr17_read_pol_8 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr17_read_pol_9 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr17_read_pol_10 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr17_read_pol_11 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr17_read_pol_12 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr17_read_pol_13 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr17_read_pol_14 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr17_read_pol_15 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr17_read_pol_16 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr17_read_pol_17 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr17_read_pol_18 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr17_read_pol_19 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr17_read_pol_20 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr17_read_pol_21 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr17_read_pol_22 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr17_read_pol_23 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr17_read_pol_24 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr17_read_pol_25 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr17_read_pol_26 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr17_read_pol_27 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr17_read_pol_28 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr17_read_pol_29 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr17_read_pol_30 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr17_read_pol_31 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr17_read_pol_32 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr17_read_pol_33 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr17_read_pol_34 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr17_read_pol_35 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr17_read_pol_36 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr17_read_pol_37 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr17_read_pol_38 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr17_read_pol_39 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr17_read_pol_40 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr17_read_pol_41 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr17_read_pol_42 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr17_read_pol_43 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr17_read_pol_44 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr17_read_pol_45 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr17_read_pol_46 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr17_read_pol_47 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr17_read_pol_48 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr17_read_pol_49 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr17_read_pol_50 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr17_read_pol_51 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr17_read_pol_52 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr17_read_pol_53 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr17_read_pol_54 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr17_read_pol_55 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr17_read_pol_56 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr17_read_pol_57 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr17_read_pol_58 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr17_read_pol_59 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr17_read_pol_60 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr17_read_pol_61 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr17_read_pol_62 : 1;
    //
    // Bunit IMR17 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR17 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr17_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR17RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR17WAC_0_0_0_MCHBAR_BUNIT_REG              0x00006AA8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr17_write_pol_0 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr17_write_pol_1 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr17_write_pol_2 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr17_write_pol_3 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr17_write_pol_4 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr17_write_pol_5 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr17_write_pol_6 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr17_write_pol_7 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr17_write_pol_8 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr17_write_pol_9 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr17_write_pol_10 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr17_write_pol_11 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr17_write_pol_12 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr17_write_pol_13 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr17_write_pol_14 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr17_write_pol_15 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr17_write_pol_16 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr17_write_pol_17 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr17_write_pol_18 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr17_write_pol_19 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr17_write_pol_20 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr17_write_pol_21 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr17_write_pol_22 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr17_write_pol_23 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr17_write_pol_24 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr17_write_pol_25 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr17_write_pol_26 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr17_write_pol_27 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr17_write_pol_28 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr17_write_pol_29 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr17_write_pol_30 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr17_write_pol_31 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr17_write_pol_32 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr17_write_pol_33 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr17_write_pol_34 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr17_write_pol_35 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr17_write_pol_36 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr17_write_pol_37 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr17_write_pol_38 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr17_write_pol_39 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr17_write_pol_40 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr17_write_pol_41 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr17_write_pol_42 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr17_write_pol_43 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr17_write_pol_44 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr17_write_pol_45 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr17_write_pol_46 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr17_write_pol_47 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr17_write_pol_48 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr17_write_pol_49 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr17_write_pol_50 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr17_write_pol_51 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr17_write_pol_52 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr17_write_pol_53 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr17_write_pol_54 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr17_write_pol_55 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr17_write_pol_56 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr17_write_pol_57 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr17_write_pol_58 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr17_write_pol_59 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr17_write_pol_60 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr17_write_pol_61 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr17_write_pol_62 : 1;
    //
    // Bunit IMR17 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR17 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr17_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR17WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR18BASE_0_0_0_MCHBAR_BUNIT_REG             0x00006AB0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR18BASE:  Specifies bits 38:10 of the start address of IMR18 region.
    //  IMR region size must be a strict poweroftwo at least 1KB and naturally aligned
    // to the size.  These bits are compared with the result of the IMR18MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR18 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr18_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR18BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR18MASK_0_0_0_MCHBAR_BUNIT_REG             0x00006AB4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR18MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR18BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR18 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr18_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR18MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR18CP_0_0_0_MCHBAR_BUNIT_REG               0x00006AB8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR18 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR18RAC, BIMR18WAC, BIMR18CP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr18_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR18CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR18RAC_0_0_0_MCHBAR_BUNIT_REG              0x00006AC0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr18_read_pol_0 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr18_read_pol_1 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr18_read_pol_2 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr18_read_pol_3 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr18_read_pol_4 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr18_read_pol_5 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr18_read_pol_6 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr18_read_pol_7 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr18_read_pol_8 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr18_read_pol_9 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr18_read_pol_10 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr18_read_pol_11 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr18_read_pol_12 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr18_read_pol_13 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr18_read_pol_14 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr18_read_pol_15 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr18_read_pol_16 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr18_read_pol_17 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr18_read_pol_18 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr18_read_pol_19 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr18_read_pol_20 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr18_read_pol_21 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr18_read_pol_22 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr18_read_pol_23 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr18_read_pol_24 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr18_read_pol_25 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr18_read_pol_26 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr18_read_pol_27 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr18_read_pol_28 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr18_read_pol_29 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr18_read_pol_30 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr18_read_pol_31 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr18_read_pol_32 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr18_read_pol_33 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr18_read_pol_34 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr18_read_pol_35 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr18_read_pol_36 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr18_read_pol_37 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr18_read_pol_38 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr18_read_pol_39 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr18_read_pol_40 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr18_read_pol_41 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr18_read_pol_42 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr18_read_pol_43 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr18_read_pol_44 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr18_read_pol_45 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr18_read_pol_46 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr18_read_pol_47 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr18_read_pol_48 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr18_read_pol_49 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr18_read_pol_50 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr18_read_pol_51 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr18_read_pol_52 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr18_read_pol_53 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr18_read_pol_54 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr18_read_pol_55 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr18_read_pol_56 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr18_read_pol_57 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr18_read_pol_58 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr18_read_pol_59 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr18_read_pol_60 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr18_read_pol_61 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr18_read_pol_62 : 1;
    //
    // Bunit IMR18 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR18 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr18_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR18RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR18WAC_0_0_0_MCHBAR_BUNIT_REG              0x00006AC8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr18_write_pol_0 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr18_write_pol_1 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr18_write_pol_2 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr18_write_pol_3 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr18_write_pol_4 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr18_write_pol_5 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr18_write_pol_6 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr18_write_pol_7 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr18_write_pol_8 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr18_write_pol_9 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr18_write_pol_10 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr18_write_pol_11 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr18_write_pol_12 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr18_write_pol_13 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr18_write_pol_14 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr18_write_pol_15 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr18_write_pol_16 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr18_write_pol_17 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr18_write_pol_18 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr18_write_pol_19 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr18_write_pol_20 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr18_write_pol_21 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr18_write_pol_22 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr18_write_pol_23 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr18_write_pol_24 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr18_write_pol_25 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr18_write_pol_26 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr18_write_pol_27 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr18_write_pol_28 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr18_write_pol_29 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr18_write_pol_30 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr18_write_pol_31 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr18_write_pol_32 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr18_write_pol_33 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr18_write_pol_34 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr18_write_pol_35 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr18_write_pol_36 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr18_write_pol_37 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr18_write_pol_38 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr18_write_pol_39 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr18_write_pol_40 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr18_write_pol_41 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr18_write_pol_42 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr18_write_pol_43 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr18_write_pol_44 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr18_write_pol_45 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr18_write_pol_46 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr18_write_pol_47 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr18_write_pol_48 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr18_write_pol_49 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr18_write_pol_50 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr18_write_pol_51 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr18_write_pol_52 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr18_write_pol_53 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr18_write_pol_54 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr18_write_pol_55 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr18_write_pol_56 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr18_write_pol_57 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr18_write_pol_58 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr18_write_pol_59 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr18_write_pol_60 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr18_write_pol_61 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr18_write_pol_62 : 1;
    //
    // Bunit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr18_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR18WAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR19BASE_0_0_0_MCHBAR_BUNIT_REG             0x00006AD0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base 0 IMR19BASE:  Specifies bits 38:10 of the start address of IMR19 region.
    //  IMR region size must be a strict poweroftwo at least 1KB and naturally aligned
    // to the size.  These bits are compared with the result of the IMR19MASK[28:0] applied
    // to bits 38:10 of the incoming address to determine if an access falls within the
    // IMR19 defined region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr19_base : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR19BASE_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR19MASK_0_0_0_MCHBAR_BUNIT_REG             0x00006AD4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask 0 IMR19MASK:  These bits are ANDed with bits 38:10 of the incoming address
    // to determine if the combined result matches the IMR19BASE[28:0] value.  A match
    // indicates the the incoming address falls within the IMR19 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr19_mask : 29;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR19MASK_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR19CP_0_0_0_MCHBAR_BUNIT_REG               0x00006AD8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR19 Control Policy: Bit vector used to determine which agents are allowed
    // access to the BIMR19RAC, BIMR19WAC, BIMR19CP registers based on the value from
    // the agents 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr19_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR19CP_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR19RAC_0_0_0_MCHBAR_BUNIT_REG              0x00006AE0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr19_read_pol_0 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr19_read_pol_1 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr19_read_pol_2 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr19_read_pol_3 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr19_read_pol_4 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr19_read_pol_5 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr19_read_pol_6 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr19_read_pol_7 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr19_read_pol_8 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr19_read_pol_9 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr19_read_pol_10 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr19_read_pol_11 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr19_read_pol_12 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr19_read_pol_13 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr19_read_pol_14 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr19_read_pol_15 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr19_read_pol_16 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr19_read_pol_17 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr19_read_pol_18 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr19_read_pol_19 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr19_read_pol_20 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr19_read_pol_21 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr19_read_pol_22 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr19_read_pol_23 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr19_read_pol_24 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr19_read_pol_25 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr19_read_pol_26 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr19_read_pol_27 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr19_read_pol_28 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr19_read_pol_29 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr19_read_pol_30 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr19_read_pol_31 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr19_read_pol_32 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr19_read_pol_33 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr19_read_pol_34 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr19_read_pol_35 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr19_read_pol_36 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr19_read_pol_37 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr19_read_pol_38 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr19_read_pol_39 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr19_read_pol_40 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr19_read_pol_41 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr19_read_pol_42 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr19_read_pol_43 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr19_read_pol_44 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr19_read_pol_45 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr19_read_pol_46 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr19_read_pol_47 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr19_read_pol_48 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr19_read_pol_49 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr19_read_pol_50 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr19_read_pol_51 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr19_read_pol_52 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr19_read_pol_53 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr19_read_pol_54 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr19_read_pol_55 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr19_read_pol_56 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr19_read_pol_57 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr19_read_pol_58 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr19_read_pol_59 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr19_read_pol_60 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr19_read_pol_61 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr19_read_pol_62 : 1;
    //
    // Bunit IMR19 Read Access Policy: Bit vector used to determine which agents are
    // allowed read access to the IMR19 region based on the agents 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr19_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR19RAC_0_0_0_MCHBAR_BUNIT_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR19WAC_0_0_0_MCHBAR_BUNIT_REG              0x00006AE8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr19_write_pol_0 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr19_write_pol_1 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr19_write_pol_2 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr19_write_pol_3 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr19_write_pol_4 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr19_write_pol_5 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr19_write_pol_6 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr19_write_pol_7 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr19_write_pol_8 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr19_write_pol_9 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr19_write_pol_10 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr19_write_pol_11 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr19_write_pol_12 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr19_write_pol_13 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr19_write_pol_14 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr19_write_pol_15 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr19_write_pol_16 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr19_write_pol_17 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr19_write_pol_18 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr19_write_pol_19 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr19_write_pol_20 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr19_write_pol_21 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr19_write_pol_22 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr19_write_pol_23 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr19_write_pol_24 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr19_write_pol_25 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr19_write_pol_26 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr19_write_pol_27 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr19_write_pol_28 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr19_write_pol_29 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr19_write_pol_30 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr19_write_pol_31 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr19_write_pol_32 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr19_write_pol_33 : 1;
    //
    // Bunit IMR19 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR19 region based on the agents 6bit encoded SAI
    // value.
    //
    // Bit