/** @file
  File name:    DQCCC.h
  Input File:   BXTE_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in DQCCC.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _DQCCC_H_
#define _DQCCC_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define DIGCTL_DQCCC_REG                                   0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[1:0], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved503 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Select Single data rate v/s Double Data rate for DRAM's CA pins[br]0: Double data
    // rate (LP3)[br]1: Single data rate (LP4)
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX lpddr34mode : 1;
    //
    // SPID clk sel [br]00: 0.5xmode[br]01: 0.25x mode[br]10: 0.1x mode[br]11: NA
    //
    // Bits[4:3], RW, default = 0x0
    //
    UINTX spidclksel : 2;
    //
    // This is the burstlength configuration register[br]1: BL16 and BL32[br]0: BL4 and
    // BL8
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX bl1632xbl48b : 1;
    //
    // Reserved bits
    //
    // Bits[8:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved502 : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // Programmable MCP for Tx FIFO read pointer path.[br][br]1: Enable MCP path [br]0:
    // Disable MCP path
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX rdmcpsel : 1;
    //
    // This is the Tx FIFO final flop preset enable[br]1: iobufact_b assert will reset
    // the final flop to 1'b1[br]0: iobufact_b assert will reset the final flop to 1'b0
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX txfifo_csn_ffloppreseten : 1;
    //
    // When enabled, SPID wrcmd is delayed by 1 spidclk before writing into the fifo.[br]Set
    // to 1 if clock gating is enabled. Else set it to 0. [br][br]1: 1 spidclk delay
    // [br]0: no delay
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX slowpath : 1;
    //
    // Reserved bits
    //
    // Bits[12:12], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved501 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Stretch mode factor[br]00: normal read[br]01: x4 stretch mode [br]10: x8 stretch
    // mode[br]11: x16 stretch mode
    //
    // Bits[14:13], RW, default = 0x0
    //
    UINTX stretchmode : 2;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved500 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // Delay (in spidclks) between the phy update request and ack
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX phyupd_dly : 8;
    //
    // Memory frequency[br]0001 : 1066[br]0010 : 1333[br]0011 : 1600[br]0100 : 2133[br]0110
    // : 2666[br]0111 : 3200[br]1001 : 1866
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX memfreq : 4;
    //
    // Memory technology[br]0: LPDDR3[br]1: LPDDR4
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX memtech : 4;
  } Bits;
  UINTX Data;
} DIGCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define FIFOPTRCTL_DQCCC_REG                               0x00000004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the double FIFO offset configuration(in terms of 2xclock).
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX bl_doublefifooffset : 4;
    //
    // This is the double FIFO offset configuration(in terms of 2xclock).
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX cc_doublefifooffset : 4;
    //
    // This is the ref2x read pointer init configuration.
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX ref2xrdptrinit : 5;
    //
    // This is the ref1xread pointer offset configuration.
    //
    // Bits[15:13], RW, default = 0x0
    //
    UINTX ref1xrdptroffset : 3;
    //
    // Configure DQCCC module as DQ or CCC[br]0: CCC[br]1: DQ
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dqxccb : 1;
    //
    // This is the ref1x read pointer init configuration.
    //
    // Bits[20:17], RW, default = 0x0
    //
    UINTX ref1xrdptrinit : 4;
    //
    // DLL ddr401_comp read pointer offset.
    //
    // Bits[23:21], RW, default = 0x0
    //
    UINTX compclkrdptroffset : 3;
    //
    // DLL ddr401_comp init configuration.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX compclkrdptrinit : 4;
    //
    // Reserved bits
    //
    // Bits[31:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved504 : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} FIFOPTRCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define CCCCTL_DQCCC_REG                                   0x00000008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Command tristate override select[br][br]0: SPID interface control CA tristate
    // using spid_ca_valid [br]1: SPID interface control for CA tristate is ignored.
    // In this case, CA tristate is controlled by CCCCTL.cmdtristateovrval
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX cmdtristateovrsel : 1;
    //
    // Command tristate override value. [br]This is applicable only when CCCCTL.cmdtristateovrsel
    // is set to 1'b1.[br][br]0: CA tristate is enabled[br]1: CA tristate is disabled
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX cmdtristateovrval : 1;
    //
    // Start phase of CK
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX clknegxposb : 1;
    //
    // Reserved bits
    //
    // Bits[4:3], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved511 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[5:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved510 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[6:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved509 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved508 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // CMD buffer enable[br]1: Enable buffer[br]0: Tristate buffer
    //
    // Bits[17:8], RW, default = 0x0
    //
    UINTX cmdtxdrven : 10;
    //
    // CS buffer enable[br]1: Enable buffer[br]0: Tristate buffer
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX cstxdrven : 1;
    //
    // CKE buffer enable[br]1: Enable buffer[br]0: Tristate buffer
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX cketxdrven : 1;
    //
    // CK buffer enable[br]1: Enable buffer[br]0: Tristate buffer
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX clktxdrven : 1;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved507 : 3;
#else
    UINTX reserved_4 : 3;
#endif // MEM_SV_HOOKS
    //
    // CA training mode[br]0: Disable CA training[br]1: Enable CA training
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX ca_training : 1;
    //
    // Reserved bits
    //
    // Bits[27:25], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved506 : 3;
#else
    UINTX reserved_5 : 3;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved505 : 4;
#else
    UINTX reserved_6 : 4;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CCCCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define LP4RSTCTL_DQCCC_REG                                0x0000000C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Set for the LP4 reset buffer
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX rstbtx_set : 1;
    //
    // Reset for the LP4 reset buffer
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX rstbtx_reset : 1;
    //
    // Tri-state control for LP4 reset buffer
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX rstbtx_enbrst : 1;
    //
    // Reserved bits
    //
    // Bits[31:3], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved512 : 29;
#else
    UINTX reserved : 29;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LP4RSTCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define DIGRSTCTL_DQCCC_REG                                0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reset for functional logic in upartition (except config, compensation, power management
    // logic)  [br]0: Reset assertion  [br]1: Reset de-assertion
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX spidrst_b : 1;
    //
    // Rxfifo reset (active low)[br]1: De-assert RX fifo reset[br]0 : Assert RX fifo
    // reset
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX rxfiforst_b : 1;
    //
    // Reserved bits
    //
    // Bits[31:2], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved513 : 30;
#else
    UINTX reserved : 30;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DIGRSTCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define FIFOPTREN_DQCCC_REG                                0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx FIFO write pointer enable. [br]0: Disable[br]1: Enable
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX wrptren : 1;
    //
    // Reserved bits
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved514 : 31;
#else
    UINTX reserved : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} FIFOPTREN_DQCCC_STRUCT;
#endif // ASM_INC

#define IOBUFACT_AFE_DQCCC_REG                             0x00000018
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IO buffer activate - DQ Analog[br]Tristates DQ and DQS IO buffers [br]Disable
    // Rx sections of IO buffers [br]0 : Disable IO buffers [br]1 : Enable IO buffers
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lvl_bl_iobufactafe : 1;
    //
    // IO buffer activate - CCC Analog[br]Tristates DQ and DQS IO buffers [br]Disable
    // Rx sections of IO buffers [br]0 : Disable IO buffers [br]1 : Enable IO buffers
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX lvl_cc_iobufactafe : 1;
    //
    // Reserved bits
    //
    // Bits[31:2], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved515 : 30;
#else
    UINTX reserved : 30;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} IOBUFACT_AFE_DQCCC_STRUCT;
#endif // ASM_INC

#define IOBUFACT_DIG_DQCCC_REG                             0x0000001C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IO buffer activate - DQ Digital[br]This resets the intermediate/final flops in
    // the transmit path.[br][br]0 : Assert reset [br]1 : De-assert reset
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX bl_iobufactdig : 1;
    //
    // IO buffer activate - CCC Digital.[br]This resets the intermediate/final flops
    // in the transmit path.[br][br]0 : Assert reset [br]1 : De-assert reset
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX cc_iobufactdig : 1;
    //
    // Reserved bits
    //
    // Bits[31:2], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved516 : 30;
#else
    UINTX reserved : 30;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} IOBUFACT_DIG_DQCCC_STRUCT;
#endif // ASM_INC

#define SPIDIC_DQCCC_REG                                   0x00000020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // SPID initialization complete
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX spid_init_complete : 1;
    //
    // Reserved bits
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved517 : 31;
#else
    UINTX reserved : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} SPIDIC_DQCCC_STRUCT;
#endif // ASM_INC

#define WRDQCTL_DQCCC_REG                                  0x00000024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Preamble 0 setting for DQ driver enable[br][br]00 : Drive 0 for UI0, Drive 0 for
    // UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive 1
    // for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX dqdrvenbpream0 : 2;
    //
    // Last data phase setting for DQ driver enable. For regular writes, this needs to
    // be set to 00.[br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01 : Drive 1 for
    // UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11
    // : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX dqdrvenblastph : 2;
    //
    // Preamble 1 setting for DQ driver enable. This is applicable only if 2tCK write
    // preamble mode is enabled.[br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01 :
    // Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11
    // : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX dqdrvenbpream1 : 2;
    //
    // First data phase setting for DQ driver enable. For regular writes, this needs
    // to be set to 00.[br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01 : Drive 1
    // for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11
    // : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX dqdrvenbph1 : 2;
    //
    // Reserved bits
    //
    // Bits[9:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved519 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:10], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved518 : 22;
#else
    UINTX reserved_1 : 22;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} WRDQCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define WRDQSCTL_DQCCC_REG                                 0x00000028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Write command to DQS start delay. This is in ref1xclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX wrcmd2dqsstart : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved522 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Preamble 0 setting for DQS data[br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01
    // : Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11
    // : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX dqsdatapream0 : 2;
    //
    // Last data phase setting for DQS data. For regular writes, this needs to be set
    // to 00.[br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive
    // 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11 : Drive 1 for
    // UI0, Drive 1 for UI1
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX dqsdatalastph : 2;
    //
    // Preamble 1 setting for DQS data. This is applicable only in case of 2tCK write
    // preamble case.[br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01 : Drive 1 for
    // UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11
    // : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX dqsdatapream1 : 2;
    //
    // First data phase setting for DQS data. For regular writes, this needs to be set
    // to 00.[br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive
    // 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11 : Drive 1 for
    // UI0, Drive 1 for UI1
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX dqsdataph1 : 2;
    //
    // Idle phase setting for DQS data. [br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01
    // : Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11
    // : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[17:16], RW, default = 0x3
    //
    UINTX dqsdrvenbidle : 2;
    //
    // TBD
    //
    // Bits[18:18], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved521 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // 2tCK write preamble mode[br]0 : 1 tCK write preamble mode[br]1 : 2 tCK write preamble
    // mode
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX wrpream0en : 1;
    //
    // Data mask drive enable[br]1: Enable DM buffer[br]0: Tristate DM buffer
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX dmdrven : 1;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved520 : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // Preamble 0 setting for DQS  driver enable[br][br]00 : Drive 0 for UI0, Drive 0
    // for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive
    // 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX dqsdrvenbpream0 : 2;
    //
    // Last data phase setting for DQS  driver enable. For regular writes, this needs
    // to be set to 00.[br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01 : Drive 1
    // for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11
    // : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX dqsdrvenblastph : 2;
    //
    // Preamble 1 setting for DQS  driver enable. This is applicable only if 2tCK write
    // preamble mode is enabled.[br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01 :
    // Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11
    // : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX dqsdrvenbpream1 : 2;
    //
    // First data phase setting for DQS  driver enable. For regular writes, this needs
    // to be set to 00.[br][br]00 : Drive 0 for UI0, Drive 0 for UI1[br]01 : Drive 1
    // for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11
    // : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX dqsdrvenbph1 : 2;
  } Bits;
  UINTX Data;
} WRDQSCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define RDVLDCTL_DQCCC_REG                                 0x0000002C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay between spid rdcmd and actual read valid.[br]This is in terms of spidclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX rdcmd2rdvld : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved526 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // This controls the delay between the read valid assertion to SOC and the actual
    // read valid assertion[br]0: Normal[br]1: 1 spidclk early [br]2: 2 spidclk early[br]3:
    // 3 spidclk early[br]4: 4 spidclk early[br]4+: Illegal
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX earlyrdvld : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved525 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Read command 2 read valid plus 1 sel.
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX rdcmd2rdvld_plus1sel : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved524 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Not used in design.
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX rdcmd2rdvld_bonus : 8;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved523 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} RDVLDCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define RK2RKCTL1_DQCCC_REG                                0x00000030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rank to Rank switch enable for rcven[br]0 : Disable rk2rk switch[br]1 : Disable
    // rk2rk switch
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX bl_rk2rken_txrcven : 1;
    //
    // Rank to Rank switch enable for rx dqs[br]0 : Disable rk2rk switch[br]1 : Disable
    // rk2rk switch
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX bl_rk2rken_rxdq_pi : 1;
    //
    // Reserved bits
    //
    // Bits[5:2], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved529 : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // Rank to Rank switch enable for tx dq[br]0 : Disable rk2rk switch[br]1 : Disable
    // rk2rk switch
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX bl_rk2rken_txdq_pi : 1;
    //
    // Rank to Rank switch enable for tx dqs[br]0 : Disable rk2rk switch[br]1 : Disable
    // rk2rk switch
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX bl_rk2rken_txdqs_pi : 1;
    //
    // Adds an extra clock of delay between rdptr freeze and rcven/rxodten pushout code
    // change during read based rk2rk switch.[br]1: Add 1 extra 2xclk of delay [br]0:
    // No delay[br][br]This is applicable for rcven coarse/fine/dbsel/2xrdptroffset and
    // rxodten 2xrdptroffset
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_txrcven : 1;
    //
    // Adds an extra 2x clock of delay between rdptr freeze and rcven override assertion
    // during read based rk2rk switch.[br]1: Add 1 extra 2xclk of delay [br]0: No delay
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_txrden : 1;
    //
    // Adds an extra 2x clock of delay between rdptr freeze and dq/dqs drive enable override
    // during write based rk2rk switch.[br]1: Add 1 extra 2xclk of delay[br]0: No delay
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_iodrven : 1;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved528 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Adds an extra 1x clock of delay between rdptr freeze and rcven PI code change
    // during read based rk2rk switch.[br]1: Add 1 extra ref1xclk of delay [br]0: No
    // delay
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX rcv_rk2rkswitch_dlyen : 1;
    //
    // Adds an extra 1x clock of delay between rdptr freeze and dq/dqs PI code change
    // during write based rk2rk switch.[br]1: Add 1 extra ref1xclk of delay [br]0: No
    // delay
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX dqx_rk2rkswitch_dlyen : 1;
    //
    // Reserved bits
    //
    // Bits[31:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved527 : 18;
#else
    UINTX reserved_2 : 18;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} RK2RKCTL1_DQCCC_STRUCT;
#endif // ASM_INC

#define RK2RKCTL0_DQCCC_REG                                0x00000034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Preamble setting for rcven override during rk2rk switching[br]00 : Drive 0 for
    // UI0, Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10
    // : Drive 0 for UI0, Drive 1 for UI1 [br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX rk2rkrdencode_1st : 2;
    //
    // Postamble setting for rcven override during rk2rk switching[br]00 : Drive 0 for
    // UI0, Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10
    // : Drive 0 for UI0, Drive 1 for UI1 [br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX rk2rkrdencode_2nd : 2;
    //
    // Preamble setting for dq/dqs drv enable override during rk2rk switching[br]00 :
    // Drive 0 for UI0, Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10
    // : Drive 0 for UI0, Drive 1 for UI1 [br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX rk2rkdrvenbcode_1st : 2;
    //
    // Postamble setting for dq/dqs drv enable override during rk2rk switching[br]00
    // : Drive 0 for UI0, Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10
    // : Drive 0 for UI0, Drive 1 for UI1 [br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX rk2rkdrvenbcode_2nd : 2;
    //
    // Delay between spid rdcmd (that requires a rank switch) and rank change detection
    // logic.[br]This is in terms of ref1xclks.
    //
    // Bits[13:8], RW, default = 0x0
    //
    UINTX rdcmd2rkchglatency : 6;
    //
    // Reserved bits
    //
    // Bits[14:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved530 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Delay between spid wrcmd (that requires a rank switch) and rank change detection
    // logic.[br]This is in terms of ref1xclks.
    //
    // Bits[20:15], RW, default = 0x0
    //
    UINTX wrcmd2rkchglatency : 6;
    //
    // Adds an extra clock of delay between rdptr freeze and DQ data/DQ drive enable
    // pushout code change during write based rk2rk switch.[br]1: Add 1 extra 2xclk of
    // delay [br]0: No delay[br][br]This is applicable for dq data's and dq drive enable's
    // coarse/fine/dbsel/2xrdptroffset and also their second rdport's 2xrdptroffset
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_txdq : 1;
    //
    // Adds an extra clock of delay between rdptr freeze and DQS data/ DQS drive enable
    // pushout code change during write based rk2rk switch.[br]1: Add 1 extra 2xclk of
    // delay [br]0: No delay[br][br]This is applicable for dqs coarse/fine/dbsel/2xrdptroffset
    // and dqs second rdport's 2xrdptroffset
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_txdqs : 1;
    //
    // Adds an extra clock of delay between rcven override and Rx DQS DLL pushout code
    // change during read based rk2rk switch.[br]1: Add 1 extra 2xclk of delay [br]0:
    // No delay[br][br]This is applicable for Rx DLL DQS HI/LO fine/coarse.
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_rxdq : 1;
    //
    // Length of rcven override during read based rk2rk switching. This, along with preamble
    // and postamble setting, [br]contributes to the total length of the rcven override
    // during rk2rk switching.[br]This is in ref1xclks.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rk2rkrdencode_3rd : 4;
    //
    // Length of dq/dqs drv enable override during write based rk2rk switching. This,
    // along with preamble and postamble [br]setting, contributes to the total length
    // of the dq/dqs drv enable override during rk2rk switching.[br]This is in ref1xclks.
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rk2rkdrvenbcode_3rd : 4;
  } Bits;
  UINTX Data;
} RK2RKCTL0_DQCCC_STRUCT;
#endif // ASM_INC

#define RXODTSEGCTL_CC_DQCCC_REG                           0x00000038
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Not used in design.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX cc_rdcmd2rxodtseg : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved532 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Not used in design.
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX cc_rxodtsegpre0 : 2;
    //
    // Not used in design.
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX cc_rxodtsegpst0 : 2;
    //
    // Not used in design.
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX cc_rxodtsegpre1 : 2;
    //
    // Not used in design.
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX cc_rxodtsegpst1 : 2;
    //
    // Not used in design.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX cc_rxodtseglenbl4 : 6;
    //
    // Not used in design.
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX cc_rxodtsegtwohot : 1;
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved531 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Not used in design.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rk1_odtsegenrdptroffset : 4;
    //
    // Receive ODT segment enable override select for DQCCC lane. [br]0: Dynamic  control[br]1:
    // Static control based on RXODTSEGCTL_CC.cc_rxodtsegovrval
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX cc_rxodtsegovrsel : 1;
    //
    // Receive ODT segment enable override value for DQCCC lane. [br]This is applicable
    // only if RXODTSEGCTL_CC.cc_rxodtsegovrsel is set to 1'b1.
    //
    // Bits[31:29], RW, default = 0x0
    //
    UINTX cc_rxodtsegovrval : 3;
  } Bits;
  UINTX Data;
} RXODTSEGCTL_CC_DQCCC_STRUCT;
#endif // ASM_INC

#define RXODTSEGCTL_DQ_DQCCC_REG                           0x0000003C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Not used in design.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX bl_rdcmd2rxodtseg : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved534 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Not used in design.
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX bl_rxodtsegpre0 : 2;
    //
    // Not used in design.
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX bl_rxodtsegpst0 : 2;
    //
    // Not used in design.
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX bl_rxodtsegpre1 : 2;
    //
    // Not used in design.
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX bl_rxodtsegpst1 : 2;
    //
    // Not used in design.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX bl_rxodtseglenbl4 : 6;
    //
    // one-hot v/s two-hot select for Rx ODT Segment enable in DQ lane.[br]0: One-hot
    // mode. Rxodtsegen gets sequenced as 001->010->100[br]1: Two-hot mode. Rxodtsegen
    // gets sequenced as 011->110->101
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX bl_rxodtsegtwohot : 1;
    //
    // Reseved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved533 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Not used in design.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rk0_odtsegenrdptroffset : 4;
    //
    // Receive ODT segment enable override select for DQ lane. [br]0: Dynamic  control[br]1:
    // Static control based on RXODTSEGCTL_DQ.bl_rxodtsegovrval
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX bl_rxodtsegovrsel : 1;
    //
    // Receive ODT segment enable override value for DQ lane. [br]This is applicable
    // only if RXODTSEGCTL_DQ.bl_rxodtsegovrsel is set to 1'b1.
    //
    // Bits[31:29], RW, default = 0x0
    //
    UINTX bl_rxodtsegovrval : 3;
  } Bits;
  UINTX Data;
} RXODTSEGCTL_DQ_DQCCC_STRUCT;
#endif // ASM_INC

#define RXODTCTL_CC_DQCCC_REG                              0x00000040
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay between spid rdcmd and Rx odt enable start - DQCCC Lane.[br]This is in terms
    // of ref1xclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX cc_rdcmd2rxodten : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved536 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Preamble 0 setting for Rx ODT enable  in DQCCC Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10 : Drive 0 for
    // UI0, Drive 1 for UI1 [br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX cc_rxodtenpre0 : 2;
    //
    // Postamble 0 setting for Rx ODT enable in DQCCC Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 [br]10 : Drive 0 for UI0, Drive
    // 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX cc_rxodtenpst0 : 2;
    //
    // Preamble 1 setting for Rx ODT enable  in DQCCC Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1 (illegal)[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10 :
    // Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for
    // UI1
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX cc_rxodtenpre1 : 2;
    //
    // Postamble 1 setting for Rx ODT enable in DQCCC Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive
    // 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX cc_rxodtenpst1 : 2;
    //
    // Rx odt enable length - DQCCC Lane.[br]This is in terms of ref1xclks.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX cc_rxodtenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[23:22], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved535 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // Rx DQ odt enable override select - DQCCC lane[br]0: Dynamic RCVEN control[br]1:
    // Static RCVEN control
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX cc_rxodtenovrsel : 1;
    //
    // Rx DQ odt enable override value - DQCCC lane[br]0: De-assert receive enable [br]1:
    // Assert receive enable
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX cc_rxodtenovrval : 1;
    //
    // Rx DQS odt enable override select - DQCCC lane [br]0= Dynamic RCVEN control[br]1=
    // Static RCVEN control
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX cc_dqsrxodtenovrsel : 1;
    //
    // Rx DQS odt enable override value - DQCCC lane [br]1: Assert receive enable
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX cc_dqsrxodtenovrval : 1;
    //
    // Rank 1's 2x rdptr offset control for Rx odt enable. This is common for both DQ
    // and DQCCC lanes
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rk1_odtenrdptroffset : 4;
  } Bits;
  UINTX Data;
} RXODTCTL_CC_DQCCC_STRUCT;
#endif // ASM_INC

#define RXODTCTL_DQ_DQCCC_REG                              0x00000044
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay between spid rdcmd and Rx odt enable start - DQ Lane.[br]This is in terms
    // of ref1xclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX bl_rdcmd2rxodten : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved538 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Preamble 0 setting for Rx ODT enable  in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10 : Drive 0 for
    // UI0, Drive 1 for UI1 [br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX bl_rxodtenpre0 : 2;
    //
    // Postamble 0 setting for Rx ODT enable in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 [br]10 : Drive 0 for UI0, Drive
    // 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX bl_rxodtenpst0 : 2;
    //
    // Preamble 1 setting for Rx ODT enable  in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1 (illegal)[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10 :
    // Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for
    // UI1
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX bl_rxodtenpre1 : 2;
    //
    // Postamble 1 setting for Rx ODT enable in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive
    // 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX bl_rxodtenpst1 : 2;
    //
    // Rx odt enable length - DQ Lane.[br]This is in terms of ref1xclks.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX bl_rxodtenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[23:22], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved537 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // Rx DQ odt enable override select - DQ lane[br]0: Dynamic RCVEN control[br]1: Static
    // RCVEN control
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX bl_rxodtenovrsel : 1;
    //
    // Rx DQ odt enable override value - DQ lane[br]0: De-assert receive enable [br]1:
    // Assert receive enable
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX bl_rxodtenovrval : 1;
    //
    // Rx DQS odt enable override select- DQ lane [br]0= Dynamic RCVEN control[br]1=
    // Static RCVEN control
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX bl_dqsrxodtenovrsel : 1;
    //
    // Rx DQS odt enable override value - DQ lane [br]0: De-assert receive enable [br]1:
    // Assert receive enable
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX bl_dqsrxodtenovrval : 1;
    //
    // Rank 0's 2x rdptr offset control for Rx odt  enable. This is common for both DQ
    // and DQCCC lanes
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rk0_odtenrdptroffset : 4;
  } Bits;
  UINTX Data;
} RXODTCTL_DQ_DQCCC_STRUCT;
#endif // ASM_INC

#define RCVENCTL_CC_DQCCC_REG                              0x00000048
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay between spid rdcmd and receive enable start - DQCCC Lane.[br]This is in
    // terms of ref1xclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX cc_rdcmd2rcven : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved541 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Preamble 0 setting for receive enable  in DQCCC Lane[br]00 : Drive 0 for UI0,
    // Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10 : Drive
    // 0 for UI0, Drive 1 for UI1 [br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX cc_rcvenpre0 : 2;
    //
    // Postamble 0 setting for receive enable in DQCCC Lane[br]00 : Drive 0 for UI0,
    // Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 [br]10 : Drive 0 for
    // UI0, Drive 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX cc_rcvenpst0 : 2;
    //
    // Preamble 1 setting for receive enable  in DQCCC Lane[br]00 : Drive 0 for UI0,
    // Drive 0 for UI1 (illegal)[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10
    // : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1
    // for UI1
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX cc_rcvenpre1 : 2;
    //
    // Postamble 1 setting for receive enable in DQCCC Lane[br]00 : Drive 0 for UI0,
    // Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0,
    // Drive 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX cc_rcvenpst1 : 2;
    //
    // Receive enable length - DQCCC Lane.[br]This is in terms of ref1xclks.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX cc_rcvenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[23:22], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved540 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // Receive enable override select.[br]0: Dynamic RCVEN control[br]1: Static RCVEN
    // control
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX cc_rcvenovrsel : 1;
    //
    // Receive enable override value. [br]0: De-assert receive enable [br]1: Assert receive
    // enable
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX cc_rcvenovrval : 1;
    //
    // Not used in design.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX cc_rcvenmargin : 1;
    //
    // Reset for the DQS counter in AFE - DQCCC Lane.[br]0: Reset assertion[br]1: Reset
    // de-assertion
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX drx_cc_dqscountrstb : 1;
    //
    // Reserved bits
    //
    // Bits[30:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved539 : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // Receive enable margining data - DQCCC lane.[br]Used during receive enable training.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX drx_cc_rcvsmpl : 1;
  } Bits;
  UINTX Data;
} RCVENCTL_CC_DQCCC_STRUCT;
#endif // ASM_INC

#define RCVENCTL_DQ_DQCCC_REG                              0x0000004C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay between spid rdcmd and receive enable start - DQ Lane.[br]This is in terms
    // of ref1xclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX bl_rdcmd2rcven : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved544 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Preamble 0 setting for receive enable  in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10 : Drive 0 for
    // UI0, Drive 1 for UI1 [br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX bl_rcvenpre0 : 2;
    //
    // Postamble 0 setting for receive enable in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 [br]10 : Drive 0 for UI0, Drive
    // 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX bl_rcvenpst0 : 2;
    //
    // Preamble 1 setting for receive enable  in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1 (illegal)[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10 :
    // Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for
    // UI1
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX bl_rcvenpre1 : 2;
    //
    // Postamble 1 setting for receive enable in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive
    // 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX bl_rcvenpst1 : 2;
    //
    // Recieve enable length - DQ Lane.[br]This is in terms of ref1xclks.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX bl_rcvenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[23:22], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved543 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // Receive enable override select.[br]0: Dynamic RCVEN control[br]1: Static RCVEN
    // control
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX bl_rcvenovrsel : 1;
    //
    // Receive enable override value. [br]0: De-assert receive enable [br]1: Assert receive
    // enable
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX bl_rcvenovrval : 1;
    //
    // Not used in design.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX bl_rcvenmargin : 1;
    //
    // Reset for the DQS counter in AFE - DQ Lane.[br]0: Reset assertion[br]1: Reset
    // de-assertion
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX drx_bl_dqscountrstb : 1;
    //
    // Reseved bits
    //
    // Bits[30:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved542 : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // Receive enable margining data - DQ lane.[br]Used during receive enable training.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX drx_bl_rcvsmpl : 1;
  } Bits;
  UINTX Data;
} RCVENCTL_DQ_DQCCC_STRUCT;
#endif // ASM_INC

#define DIFFAMPCTL_CC_DQCCC_REG                            0x00000050
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay between spid rdcmd and diffampen start - DQCCC Lane.[br]This is in terms
    // of ref1xclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX cc_rdcmd2diffampen : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved546 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Diffamp enable length - DQCCC Lane.[br]This is in terms of ref1xclks.
    //
    // Bits[13:8], RW, default = 0x0
    //
    UINTX cc_diffampenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[15:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved545 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // Preamble 0 setting for diffamp enable  in DQCCC Lane[br]00 : Drive 0 for UI0,
    // Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10 : Drive
    // 0 for UI0, Drive 1 for UI1 [br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX cc_diffampenpre0 : 2;
    //
    // Postamble 0 setting for diffamp enable in DQCCC Lane[br]00 : Drive 0 for UI0,
    // Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 [br]10 : Drive 0 for
    // UI0, Drive 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[19:18], RW, default = 0x0
    //
    UINTX cc_diffampenpst0 : 2;
    //
    // Preamble 1 setting for diffamp enable  in DQCCC Lane[br]00 : Drive 0 for UI0,
    // Drive 0 for UI1 (illegal)[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10
    // : Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1
    // for UI1
    //
    // Bits[21:20], RW, default = 0x0
    //
    UINTX cc_diffampenpre1 : 2;
    //
    // Postamble 1 setting for diffamp enable in DQCCC Lane[br]00 : Drive 0 for UI0,
    // Drive 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0,
    // Drive 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX cc_diffampenpst1 : 2;
    //
    // Override select for DQ/DM Diffamp enable - DQCCC Lane
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX cc_dqdmdiffampenovrsel : 1;
    //
    // Override value for DQ/DM Diffamp enable - DQCCC Lane
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX cc_dqdmdiffampenovrval : 1;
    //
    // Override select for DQS Diffamp enable - DQCCC Lane
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX cc_dqsdiffampenovrsel : 1;
    //
    // Override value for DQS Diffamp enable - DQCCC Lane
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX cc_dqsdiffampenovrval : 1;
    //
    // Not used in design.
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rk1_diffampenrdptroffset : 4;
  } Bits;
  UINTX Data;
} DIFFAMPCTL_CC_DQCCC_STRUCT;
#endif // ASM_INC

#define DIFFAMPCTL_DQ_DQCCC_REG                            0x00000054
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay between spid rdcmd and diffampen start - DQ Lane.[br]This is in terms of
    // ref1xclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX bl_rdcmd2diffampen : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved548 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Diffamp enable length - DQ Lane.[br]This is in terms of ref1xclks.
    //
    // Bits[13:8], RW, default = 0x0
    //
    UINTX bl_diffampenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[15:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved547 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // Preamble 0 setting for diffamp enable  in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10 : Drive 0 for
    // UI0, Drive 1 for UI1 [br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX bl_diffampenpre0 : 2;
    //
    // Postamble 0 setting for diffamp enable in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1 [br]10 : Drive 0 for UI0, Drive
    // 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[19:18], RW, default = 0x0
    //
    UINTX bl_diffampenpst0 : 2;
    //
    // Preamble 1 setting for diffamp enable  in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1 (illegal)[br]01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)[br]10 :
    // Drive 0 for UI0, Drive 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for
    // UI1
    //
    // Bits[21:20], RW, default = 0x0
    //
    UINTX bl_diffampenpre1 : 2;
    //
    // Postamble 1 setting for diffamp enable in DQ Lane[br]00 : Drive 0 for UI0, Drive
    // 0 for UI1[br]01 : Drive 1 for UI0, Drive 0 for UI1[br]10 : Drive 0 for UI0, Drive
    // 1 for UI1 (illegal)[br]11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX bl_diffampenpst1 : 2;
    //
    // Override select for DQ/DM Diffamp enable - DQ Lane
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX bl_dqdmdiffampenovrsel : 1;
    //
    // Override value for DQ/DM Diffamp enable - DQ Lane
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX bl_dqdmdiffampenovrval : 1;
    //
    // Override select for DQS Diffamp enable - DQ Lane
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX bl_dqsdiffampenovrsel : 1;
    //
    // Override value for DQS Diffamp enable - DQ Lane
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX bl_dqsdiffampenovrval : 1;
    //
    // 2x rdptr offset control for diff amp enable. This is common for both DQ and DQCCC
    // lanes
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rk0_diffampenrdptroffset : 4;
  } Bits;
  UINTX Data;
} DIFFAMPCTL_DQ_DQCCC_STRUCT;
#endif // ASM_INC

#define WRLVL_DQCCC_REG                                    0x00000058
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQTRAINSTS - WRLVL Byte0 sample. This is the OR combination
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX wrlvl_or_sample_b0 : 1;
    //
    // DQTRAINSTS - WRLVL Byte1 sample. This is the OR combination
    //
    // Bits[1:1], RO, default = 0x0
    //
    UINTX wrlvl_or_sample_b1 : 1;
    //
    // DQTRAINSTS - WRLVL Byte0 sample. This is the AND combination
    //
    // Bits[2:2], RO, default = 0x0
    //
    UINTX wrlvl_and_sample_b0 : 1;
    //
    // DQTRAINSTS - WRLVL Byte1 sample. This is the AND combination
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX wrlvl_and_sample_b1 : 1;
    //
    // Reserved bits
    //
    // Bits[7:4], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved550 : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // DQTRAINSTS - WRLVL sampling from all DQ bit lanes of Bytelane 0
    //
    // Bits[15:8], RO, default = 0x0
    //
    UINTX wrlvl_sample_b0 : 8;
    //
    // DQTRAINSTS - WRLVL sampling from all DQ bit lanes of Bytelane 1
    //
    // Bits[23:16], RO, default = 0x0
    //
    UINTX wrlvl_sample_b1 : 8;
    //
    // Write Levelization enable - BL Byte Labe
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX bl_wrlvl : 1;
    //
    // Write Levelization enable - CC Byte Lane
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX cc_wrlvl : 1;
    //
    // Reserved bits
    //
    // Bits[31:26], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved549 : 6;
#else
    UINTX reserved_1 : 6;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} WRLVL_DQCCC_STRUCT;
#endif // ASM_INC

#define CLKGATERDCTL_DQCCC_REG                             0x0000005C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IDLE timer counter max value for clock gating on rx . [br]Counter timeout based
    // on last RDCMD received.
    //
    // Bits[5:0], RW, default = 0x3F
    //
    UINTX readclkgate_maxcntr : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved554 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // This is the delay in terms of clocks the drven is enabled, once wrcmd/rdcmd is
    // received.
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX read_startrden : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved553 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // This is the delay in terms of clocks the dven is disabled before clock gated.
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX read_stoprden : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved552 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Enable Dynamic SPIDCLK control. [br]1= spidclken  controlled by the dynamic clock
    // gating logic (DYNDLLFSM)[br]0= Statically-controlled SPIDCLKEN
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dynreadspidclken : 1;
    //
    // Enable Dynamic REF1XCLK control. [br]1= ref1xclken  controlled by the dynamic
    // clock gating logic (DYNDLLFSM)[br]0= Statically-controlled REF1XCLKEN
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX dynreadref1xclken : 1;
    //
    // Enable Dynamic REF2XCLK control. [br]1= ref2xclken  controlled by the dynamic
    // clock gating logic (DYNDLLFSM)[br]0= Statically-controlled REF2XCLKEN
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX dynreadref2xclken : 1;
    //
    // Enable Dynamic SIGGRP 2x clock control. [br]1= SIGGRPEN  controlled by the dynamic
    // clock gating logic (DYNDLLFSM)[br]0= Statically-controlled SIGGRPEN
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX dynreadsiggrpen : 1;
    //
    // Reserved bits
    //
    // Bits[31:20], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved551 : 12;
#else
    UINTX reserved_3 : 12;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CLKGATERDCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define CLKGATEWRCTL_DQCCC_REG                             0x00000060
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IDLE timer counter max value for clock gating on tx . [br]Counter timeout based
    // on last WRCMD received.
    //
    // Bits[5:0], RW, default = 0x3F
    //
    UINTX writeclkgate_maxcntr : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved558 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // This is the delay in terms of clocks the drven is enabled, once wrcmd/rdcmd is
    // received.
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX write_startdrv : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved557 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // This is the delay in terms of clocks the dven is disabled before clock gated.
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX write_stopdrv : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved556 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Enable Dynamic SPIDCLK control  (writes)[br]1= spidclken  controlled by the dynamic
    // clock gating logic (DYNDLLFSM)[br]0= Statically-controlled SPIDCLKEN
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dynwritespidclken : 1;
    //
    // Enable Dynamic REF1XCLK control  (writes)[br]1= ref1xclken  controlled by the
    // dynamic clock gating logic (DYNDLLFSM)[br]0= Statically-controlled REF1XCLKEN
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX dynwriteref1xclken : 1;
    //
    // Enable Dynamic REF2XCLK control  (writes)[br]1= ref2xclken  controlled by the
    // dynamic clock gating logic (DYNDLLFSM)[br]0= Statically-controlled REF2XCLKEN
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX dynwriteref2xclken : 1;
    //
    // Enable Dynamic SIGGRP 2x clock control (writes)[br]1= SIGGRPEN  controlled by
    // the dynamic clock gating logic (DYNDLLFSM)[br]0= Statically-controlled SIGGRPEN
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX dynwritesiggrpen : 1;
    //
    // Reserved bits
    //
    // Bits[31:20], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved555 : 12;
#else
    UINTX reserved_3 : 12;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CLKGATEWRCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define CLKGATECTL_DQCCC_REG                               0x00000064
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IDLE timer counter max value for clock gating on tx/rx . [br]Counter timeout based
    // on last WRCMD/RDCMD received.
    //
    // Bits[5:0], RW, default = 0x3F
    //
    UINTX clkgate_maxcntr : 6;
    //
    // IDLE timer counter max value for clock gating on LDO FF[br]Counter timeout based
    // on last datavalid recieved.
    //
    // Bits[8:6], RW, default = 0x7
    //
    UINTX ldoffclkgate_maxcntr : 3;
    //
    // Reserved bits
    //
    // Bits[15:9], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved560 : 7;
#else
    UINTX reserved : 7;
#endif // MEM_SV_HOOKS
    //
    // Enable Dynamic SPIDCLK control  (reads)[br]1= spidclken  controlled by the dynamic
    // clock gating logic (DYNDLLFSM)[br]0= Statically-controlled SPIDCLKEN
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dynspidclken : 1;
    //
    // Enable Dynamic REF1XCLK control  (reads)[br]1= ref1xclken  controlled by the dynamic
    // clock gating logic (DYNDLLFSM)[br]0= Statically-controlled REF1XCLKEN
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX dynref1xclken : 1;
    //
    // Enable Dynamic REF2XCLK control  (reads)[br]1= ref2xclken  controlled by the dynamic
    // clock gating logic (DYNDLLFSM)[br]0= Statically-controlled REF2XCLKEN
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX dynref2xclken : 1;
    //
    // Enable Dynamic SIGGRP 2x clock control (reads)[br]1= SIGGRPEN  controlled by the
    // dynamic clock gating logic (DYNDLLFSM)[br]0= Statically-controlled SIGGRPEN
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX dynsiggrpen : 1;
    //
    // Dynamic LDO FF clock control.[br]1: Enable dynamic LDOFF clock gating[br]0: Disable
    // dynamic LDOFF clock gating
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX ldoffdyncg_en : 1;
    //
    // Static Clock Gating for DQCCC re2xclk going to Read Control logic (diffampen/ODT/RCVEN)
    // [br]1'b0 - Static Clock Gating Active[br]1'b1 - Static Clock Gating Disabled
    //
    // Bits[21:21], RW, default = 0x1
    //
    UINTX lp4_ref2xclken : 1;
    //
    // Static Clock Gating for DQCCC ref2xclk going to Data Bounded Logic (DQ/CA/C*)[br]1'b0
    // - Static Clock Gating Active[br]1'b1 - Static Clock Gating Disabled
    //
    // Bits[22:22], RW, default = 0x1
    //
    UINTX lp3data_ref2xclken : 1;
    //
    // Static Clock Gating for DQCCC ref2xclk going to STROBE bounded logic (DQS/CK)[br]1'b0
    // - Static Clock Gating Active[br]1'b1 - Static Clock Gating Disabled
    //
    // Bits[23:23], RW, default = 0x1
    //
    UINTX lp3strobe_ref2xclken : 1;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved559 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CLKGATECTL_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP5CTL_DQCCC_REG                          0x00000068
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 5 rank 0/rank 1[br]Note: sig group 5 maps to CKE
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp05picode : 8;
    //
    // Read pointer offset for sig group 5 rank 0/rank 1[br]Note: sig group 5 maps to
    // CKE
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp05rdptroffset : 4;
    //
    // Deadband select for sig group 5 rank 0/rank 1[br]Note: sig group 5 maps to CKE
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp05dbsel : 2;
    //
    //
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp05dbsel_process : 1;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved565 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[23:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved564 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[27:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved563 : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[29:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved562 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved561 : 2;
#else
    UINTX reserved_4 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLSIGGRP5CTL_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP4CTL_DQCCC_REG                          0x0000006C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 4 rank 0/rank 1[br]Note: sig group 4 maps to CLK
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp04picode : 8;
    //
    // Read pointer offset for sig group 4 rank 0/rank 1[br]Note: sig group 4 maps to
    // CLK
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp04rdptroffset : 4;
    //
    // Deadband select for sig group 4 rank 0/rank 1[br]Note: sig group 4 maps to CLK
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp04dbsel : 2;
    //
    //
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp04dbsel_process : 1;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved570 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[23:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved569 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[27:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved568 : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[29:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved567 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved566 : 2;
#else
    UINTX reserved_4 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLSIGGRP4CTL_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP3CTL_DQCCC_REG                          0x00000070
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 3 rank 0/rank 1[br]Note: sig group 3 maps to CA
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp03picode : 8;
    //
    // Read pointer offset for sig group 3 rank 0/rank 1[br]Note: sig group 3 maps to
    // CA
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp03rdptroffset : 4;
    //
    // Deadband select for sig group 3 rank 0/rank 1[br]Note: sig group 3 maps to CA
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp03dbsel : 2;
    //
    //
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp03dbsel_process : 1;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved575 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[23:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved574 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[27:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved573 : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[29:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved572 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved571 : 2;
#else
    UINTX reserved_4 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLSIGGRP3CTL_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP2CTL_DQCCC_REG                          0x00000074
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 2 rank 0[br]Note: sig group 3 maps to RCVEN
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp02picode : 8;
    //
    // Read pointer offset for sig group 2 rank 0[br]Note: sig group 3 maps to RCVEN
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp02rdptroffset : 4;
    //
    // Deadband select for sig group 2 rank 0[br]Note: sig group 2 maps to RCVEN
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp02dbsel : 2;
    //
    //
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp02dbsel_process : 1;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved577 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // PI code for sig group 2 rank 1[br]Note: sig group 3 maps to RCVEN
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp02picode : 8;
    //
    // Read pointer offset for sig group 2 rank 1[br]Note: sig group 3 maps to RCVEN
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp02rdptroffset : 4;
    //
    // Deadband select for sig group 2 rank 1[br]Note: sig group 2 maps to RCVEN
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp02dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved576 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLSIGGRP2CTL_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP1CTL_DQCCC_REG                          0x00000078
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 1 rank 0[br]Note: sig group 1 maps to DQS
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp01picode : 8;
    //
    // Read pointer offset for sig group 1 rank 0[br]Note: sig group 1 maps to DQS
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp01rdptroffset : 4;
    //
    // Deadband select for sig group 1 rank 0[br]Note: sig group 1 maps to DQS
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp01dbsel : 2;
    //
    //
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp01dbsel_process : 1;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved579 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // PI code for sig group 1 rank 1[br]Note: sig group 1 maps to DQS
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp01picode : 8;
    //
    // Read pointer offset for sig group 1 rank 1[br]Note: sig group 1 maps to DQS
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp01rdptroffset : 4;
    //
    // Deadband select for sig group 1 rank 1[br]Note: sig group 1 maps to DQS
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp01dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved578 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLSIGGRP1CTL_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP0CTL_DQCCC_REG                          0x0000007C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 0 rank 0[br]Note: sig group 0 maps to DQ
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp00picode : 8;
    //
    // Read pointer offset for sig group 0 rank 0[br]Note: sig group 0 maps to DQ
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp00rdptroffset : 4;
    //
    // MSB of deadband select for sig group 0 rank 0/rank 1. Deadband select for sig
    // group 0 rank 0.[br]Note: sig group 0 maps to DQ[br][br]0: slow silicon[br]1: fast
    // silicon
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp00dbsel : 2;
    //
    //
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp00dbsel_process : 1;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved581 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // PI code for sig group 0 rank 1[br]Note: sig group 0 maps to DQ
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp00picode : 8;
    //
    // Read pointer offset for sig group 0 rank 1[br]Note: sig group 0 maps to DQ
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp00rdptroffset : 4;
    //
    // Deadband select for sig group 0 rank 1. [br]Note: sig group 0 maps to DQ
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp00dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved580 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLSIGGRP0CTL_DQCCC_STRUCT;
#endif // ASM_INC

#define WKPUPPDNCTL_DQCCC_REG                              0x00000080
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Weak Pull Down Control code for DQS - DQ Lane
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX lvl_bl_weakpdn : 6;
    //
    // Weak Pull Down Control static bit for DQS - DQ Lane
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX lvl_bl_weakpdnstatic : 1;
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved585 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Weak Pull Up Control code for DQS - DQ Lane
    //
    // Bits[13:8], RW, default = 0x0
    //
    UINTX lvl_bl_weakpup : 6;
    //
    // Weak Pull Up Control static bit for DQS - DQ Lane
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX lvl_bl_weakpupstatic : 1;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved584 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Weak Pull Down Control - CC Lane
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX lvl_cc_weakpdn : 6;
    //
    // Weak Pull Down Control - CC Lane
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX lvl_cc_weakpdnstatic : 1;
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved583 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Weak Pull Up Control - CC Lane
    //
    // Bits[29:24], RW, default = 0x0
    //
    UINTX lvl_cc_weakpup : 6;
    //
    // Weak Pull Up Control - CC Lane
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX lvl_cc_weakpupstatic : 1;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved582 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} WKPUPPDNCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define AFEMISC1_DQCCC_REG                                 0x00000084
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bypasses slewrate staggering
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX tx_bl_allfire : 1;
    //
    // Bypasses slewrate staggering
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX tx_cc_allfire : 1;
    //
    // Bypasses slewrate staggering
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX dtx_bl_allfire : 1;
    //
    // Bypasses slewrate staggering
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX dtx_cc_allfire : 1;
    //
    // set cap tuning for pi
    //
    // Bits[6:4], RW, default = 0x1
    //
    UINTX txdll_picapsel : 3;
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved592 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // set cap tuning for pi
    //
    // Bits[10:8], RW, default = 0x1
    //
    UINTX rxdll_bl_picapsel : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved591 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // set cap tuning for pi
    //
    // Bits[14:12], RW, default = 0x1
    //
    UINTX rxdll_cc_picapsel : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved590 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Segment enable for CC buffer. Used for per leg testing in HVM
    //
    // Bits[18:16], RW, default = 0x7
    //
    UINTX tx_bl_drvsegen : 3;
    //
    // Reserved bits
    //
    // Bits[19:19], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved589 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // Segment enable for CC buffer. Used for per leg testing in HVM
    //
    // Bits[22:20], RW, default = 0x7
    //
    UINTX dtx_bl_drvsegen : 3;
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved588 : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // Segment enable for CC buffer. Used for per leg testing in HVM
    //
    // Bits[26:24], RW, default = 0x7
    //
    UINTX tx_cc_drvsegen : 3;
    //
    // Reserved bits
    //
    // Bits[27:27], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved587 : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // Segment enable for CC buffer. Used for per leg testing in HVM
    //
    // Bits[30:28], RW, default = 0x7
    //
    UINTX dtx_cc_drvsegen : 3;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved586 : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} AFEMISC1_DQCCC_STRUCT;
#endif // ASM_INC

#define AFEMISC0_DQCCC_REG                                 0x00000088
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Static pull up code - ODT DQS/DQSB
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX pupodtstaticdqs : 1;
    //
    // Static pull up code - ODT DQ
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX pupodtstatic : 1;
    //
    // Static pull up code - DRV DQS/DQSB
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX pupdrvstaticdqs : 1;
    //
    // Static pull up code - DRV DQ
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX pupdrvstatic : 1;
    //
    // Static pull down code - ODT DQS/DQSB
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX pdnodtstaticdqs : 1;
    //
    // Static pull down code - ODT DQ
    //
    // Bits[5:5], RW, default = 0x1
    //
    UINTX pdnodtstatic : 1;
    //
    // Static pull down code - DRV DQS/DQSB
    //
    // Bits[6:6], RW, default = 0x1
    //
    UINTX pdndrvstaticdqs : 1;
    //
    // Static pull down code - DRV DQ
    //
    // Bits[7:7], RW, default = 0x1
    //
    UINTX pdndrvstatic : 1;
    //
    // changes the common mode of receiver from low common mode to vcc/2 based on lpddr3/
    // lpddr4.
    //
    // Bits[8:8], RW, default = 0x1
    //
    UINTX rx_bl_rxcommonmode : 1;
    //
    // changes the common mode of receiver from low common mode to vcc/2 based on lpddr3/
    // lpddr4.
    //
    // Bits[9:9], RW, default = 0x1
    //
    UINTX rx_cc_rxcommonmode : 1;
    //
    // changes the common mode of receiver from low common mode to vcc/2 based on lpddr3/
    // lpddr4.
    //
    // Bits[10:10], RW, default = 0x1
    //
    UINTX drx_bl_rxcommonmode : 1;
    //
    // changes the common mode of receiver from low common mode to vcc/2 based on lpddr3/
    // lpddr4.
    //
    // Bits[11:11], RW, default = 0x1
    //
    UINTX drx_cc_rxcommonmode : 1;
    //
    // Reserved bits
    //
    // Bits[15:12], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved593 : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // 00 = low power rx;[br]01 = high power rx (default)
    //
    // Bits[17:16], RW, default = 0x1
    //
    UINTX rx_bl_rxpwrmode : 2;
    //
    // 00 = low power rx;[br]01 = high power rx (default)
    //
    // Bits[19:18], RW, default = 0x1
    //
    UINTX drx_bl_rxpwrmode : 2;
    //
    // 00 = low power rx;[br]01 = high power rx (default)
    //
    // Bits[21:20], RW, default = 0x1
    //
    UINTX rx_cc_rxpwrmode : 2;
    //
    // 00 = low power rx;[br]01 = high power rx (default)
    //
    // Bits[23:22], RW, default = 0x1
    //
    UINTX drx_cc_rxpwrmode : 2;
    //
    // Streches rising edge of drivenable to relax data to enable skew.
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX tx_bl_drvenstretch : 2;
    //
    // Streches rising edge of drivenable to relax data to enable skew.
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX tx_cc_drvenstretch : 2;
    //
    // Streches rising edge of drivenable to relax data to enable skew.
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX dtx_bl_drvenstretch : 2;
    //
    // Streches rising edge of drivenable to relax data to enable skew.
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX dtx_cc_drvenstretch : 2;
  } Bits;
  UINTX Data;
} AFEMISC0_DQCCC_STRUCT;
#endif // ASM_INC

#define AFEBONUS_DQCCC_REG                                 0x0000008C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bonus bits - DQ Lane
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX lvl_bl_bonus : 4;
    //
    // Bonus bits - CC Lane
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX lvl_cc_bonus : 4;
    //
    // Digital Observation Control 0 - DQ Lane
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX mon_bl_digobs0sel : 4;
    //
    // Digital Observation Control 1 - DQ Lane
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX mon_bl_digobs1sel : 4;
    //
    // Digital Observation Control 0 - CC Lane
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX mon_cc_digobs0sel : 4;
    //
    // Digital Observation Control 1 - CC Lane
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX mon_cc_digobs1sel : 4;
    //
    // Analog Observation Control - DQ Lane
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX mon_bl_anaobssel : 2;
    //
    // Analog Observation Control - CC Lane
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX mon_cc_anaobssel : 2;
    //
    // Reserved bits
    //
    // Bits[31:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved594 : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} AFEBONUS_DQCCC_STRUCT;
#endif // ASM_INC

#define DIGOBSCTL1_DQCCC_REG                               0x00000090
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Digital observation select mux port 0
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rxdll_cc_digobs0sel : 4;
    //
    // Digital observation select mux port 1
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX rxdll_cc_digobs1sel : 4;
    //
    // Digital observation select mux port 0
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rxdll_bl_digobs0sel : 4;
    //
    // Digital observation select mux port 1
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rxdll_bl_digobs1sel : 4;
    //
    // Reserved bits
    //
    // Bits[17:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved596 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // digital buf obs enable (1=enable;0=disable)
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX dtx_bl_digobsen : 1;
    //
    // digital buf obs enable (1=enable;0=disable)
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX txdll_digobsen : 1;
    //
    // Reserved bits
    //
    // Bits[20:20], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved595 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // digital buf obs enable (1=enable;0=disable)
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX dtx_cc_digobsen : 1;
    //
    // digital buf obs enable (1=enable;0=disable)
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX rxdll_bl_digobsen : 1;
    //
    // digital buf obs enable (1=enable;0=disable)
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX rxdll_cc_digobsen : 1;
    //
    // Digital observation select mux port 0
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX txdll_digobs0sel : 4;
    //
    // Digital observation select mux port 1
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX txdll_digobs1sel : 4;
  } Bits;
  UINTX Data;
} DIGOBSCTL1_DQCCC_STRUCT;
#endif // ASM_INC

#define DIGOBSCTL0_DQCCC_REG                               0x00000094
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Digital observation select mux port 0
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX tx_bl_digobs0sel : 3;
    //
    // Reserved bits
    //
    // Bits[3:3], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved604 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Digital observation select mux port 1
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX tx_bl_digobs1sel : 3;
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved603 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Digital observation select mux port 0
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX tx_cc_digobs0sel : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved602 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Digital observation select mux port 1
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX tx_cc_digobs1sel : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved601 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // Digital observation select mux port 0
    //
    // Bits[18:16], RW, default = 0x0
    //
    UINTX dtx_bl_digobs0sel : 3;
    //
    // Reserved bits
    //
    // Bits[19:19], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved600 : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // Digital observation select mux port 1
    //
    // Bits[22:20], RW, default = 0x0
    //
    UINTX dtx_bl_digobs1sel : 3;
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved599 : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // Digital observation select mux port 0
    //
    // Bits[26:24], RW, default = 0x0
    //
    UINTX dtx_cc_digobs0sel : 3;
    //
    // Reserved bits
    //
    // Bits[27:27], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved598 : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // Digital observation select mux port 1
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX dtx_cc_digobs1sel : 3;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved597 : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DIGOBSCTL0_DQCCC_STRUCT;
#endif // ASM_INC

#define RXDLLCTL_DQBLDM_DQCCC_REG                          0x00000098
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[15:0], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved609 : 16;
#else
    UINTX reserved : 16;
#endif // MEM_SV_HOOKS
    //
    // Rx DLL enable
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX rxdll_bl_rxdllen : 1;
    //
    // enable data output from dq and dm pi's. for each byte
    //
    // Bits[17:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved608 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // enable strobe output from rx sdll.for each byte
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX rxdll_bl_dqsouten : 1;
    //
    // enable strobe output from rx sdll.for each byte
    //
    // Bits[19:19], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved607 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // RxDLL flop reset
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX rxdll_dllfloprstb : 1;
    //
    // TxDLL flop reset
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX txdll_dllfloprstb : 1;
    //
    // enable strobe output from rx sdll.for each byte
    //
    // Bits[23:22], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved606 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // enable strobe output from rx sdll.for each byte
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX rxdll_rxmuxsel : 5;
    //
    // Reserved bits
    //
    // Bits[31:29], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved605 : 3;
#else
    UINTX reserved_4 : 3;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} RXDLLCTL_DQBLDM_DQCCC_STRUCT;
#endif // ASM_INC

#define RXDLLCTL_CCBLDM_DQCCC_REG                          0x0000009C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // enable tx ref pi phase 0 enable
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX txdll_ref2xph0pien : 1;
    //
    // Reserved bits
    //
    // Bits[15:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved612 : 15;
#else
    UINTX reserved : 15;
#endif // MEM_SV_HOOKS
    //
    // Rx DLL enable
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX rxdll_cc_rxdllen : 1;
    //
    // enable data output from dq and dm pi's. for each byte
    //
    // Bits[17:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved611 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // enable strobe output from rx sdll.for each byte
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX rxdll_cc_dqsouten : 1;
    //
    // Reserved bits
    //
    // Bits[31:19], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved610 : 13;
#else
    UINTX reserved_2 : 13;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} RXDLLCTL_CCBLDM_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLCTL_DQCCC_REG                                 0x000000A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reseved bits
    //
    // Bits[0:0], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved617 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Not used in design.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX txdll_ref2xph90pien : 1;
    //
    // enable tx ref pi phase 180 enable
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX txdll_ref2xph180pien : 1;
    //
    // Not used in design.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX txdll_ref2xph270pien : 1;
    //
    // Reserved bits
    //
    // Bits[7:4], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved616 : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // PI enable for sig group 0[br]Note: sig group 0 maps to DQ
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX txdll_siggrp00pien : 1;
    //
    // PI enable for sig group 1[br]Note: sig group 1 maps to DQS
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX txdll_siggrp01pien : 1;
    //
    // PI enable for sig group 2[br]Note: sig group 2 maps to RCVEN
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX txdll_siggrp02pien : 1;
    //
    // PI enable for sig group 3[br]Note: sig group 3 maps to CA
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX txdll_siggrp03pien : 1;
    //
    // PI enable for sig group 4[br]Note: sig group 4 maps to CLK
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX txdll_siggrp04pien : 1;
    //
    // PI enable for sig group 5[br]Note: sig group 5 maps to CKE
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX txdll_siggrp05pien : 1;
    //
    // Reserved bits
    //
    // Bits[15:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved615 : 2;
#else
    UINTX reserved_2 : 2;
#endif // MEM_SV_HOOKS
    //
    // MDLL enable
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX txdll_mdllen : 1;
    //
    // Reserved bits
    //
    // Bits[17:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved614 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:18], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved613 : 14;
#else
    UINTX reserved_4 : 14;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLREF2XCTL_DQCCC_REG                            0x000000A4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Not used in design.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_ref2xph90picode : 8;
    //
    // pi code for ref pi phase 180 output
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX txdll_ref2xph180picode : 8;
    //
    // Not used in design.
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_ref2xph270picode : 8;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved618 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLREF2XCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define RXDLLDQSRK1CTL_DQCCC_REG                           0x000000A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[7:0], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved620 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[15:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved619 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // pi code for rx falling dqs edge - DQ Lane
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX rxdll_bl_rk1dqslopicode : 8;
    //
    // pi code for rx rising dqs edge - DQ Lane
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX rxdll_bl_rk1dqshipicode : 8;
  } Bits;
  UINTX Data;
} RXDLLDQSRK1CTL_DQCCC_STRUCT;
#endif // ASM_INC

#define RXDLLDQSRK0CTL_DQCCC_REG                           0x000000AC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // pi code for rx falling dqs edge  - CC Lane
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX rxdll_cc_rk0dqslopicode : 8;
    //
    // pi code for rx rising dqs edge  - CC Lane
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX rxdll_cc_rk0dqshipicode : 8;
    //
    // pi code for rx falling dqs edge - DQ Lane
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX rxdll_bl_rk0dqslopicode : 8;
    //
    // pi code for rx rising dqs edge - DQ Lane
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX rxdll_bl_rk0dqshipicode : 8;
  } Bits;
  UINTX Data;
} RXDLLDQSRK0CTL_DQCCC_STRUCT;
#endif // ASM_INC

#define VREFCTL1_DQCCC_REG                                 0x000000B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // enable signal for the tx vref unity gain buffer
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX txvref_cmn_vrefbufen : 1;
    //
    // Reserved bits
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved621 : 31;
#else
    UINTX reserved : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} VREFCTL1_DQCCC_STRUCT;
#endif // ASM_INC

#define VREFCTL0_DQCCC_REG                                 0x000000B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // vref decode signal for the cc0 rx vref
    //
    // Bits[7:0], RW, default = 0x20
    //
    UINTX vref_rxccvrefctrl : 8;
    //
    // vref decode signal for the b0 rx vref
    //
    // Bits[15:8], RW, default = 0x20
    //
    UINTX vref_rxblvrefctrl : 8;
    //
    // common mode select to choose between lpddr3;lpddr4
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX vref_vrefcmctrl : 1;
    //
    // Reserved bits
    //
    // Bits[19:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved623 : 3;
#else
    UINTX reserved : 3;
#endif // MEM_SV_HOOKS
    //
    // vrefiobufact - CC Lane
    //
    // Bits[20:20], RW, default = 0x1
    //
    UINTX lvl_cc_vrefiobufact : 1;
    //
    // vrefiobufact - DQ Lane
    //
    // Bits[21:21], RW, default = 0x1
    //
    UINTX lvl_bl_vrefiobufact : 1;
    //
    // Reserved bits
    //
    // Bits[23:22], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved622 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // vref decode signal for the lcomp
    //
    // Bits[31:24], RW, default = 0x20
    //
    UINTX vref_txlcompvrefctrl : 8;
  } Bits;
  UINTX Data;
} VREFCTL0_DQCCC_STRUCT;
#endif // ASM_INC

#define RXBL8PBDCTL_DQCCC_REG                              0x000000B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rx Per bit De-skew code for dq0 valid codes
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rxdll_bl_dq8rxpbdcode : 4;
    //
    // Reserved bits
    //
    // Bits[31:4], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved624 : 28;
#else
    UINTX reserved : 28;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} RXBL8PBDCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define RXPBDBLCTL_DQCCC_REG                               0x000000BC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rx Per bit De-skew code for dq0 valid codes
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rxdll_bl_dq0rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for dq0 valid codes
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX rxdll_bl_dq1rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for dq0 valid codes
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rxdll_bl_dq2rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for dq0 valid codes
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rxdll_bl_dq3rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for dq0 valid codes
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX rxdll_bl_dq4rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for dq0 valid codes
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX rxdll_bl_dq5rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for dq0 valid codes
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rxdll_bl_dq6rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for dq0 valid codes
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rxdll_bl_dq7rxpbdcode : 4;
  } Bits;
  UINTX Data;
} RXPBDBLCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define TXPBDCTL1_DQCCC_REG                                0x000000C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Per bit deskew enable - DTX - BL
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX dtx_bl_pbdstaticlegen : 1;
    //
    // Per bit deskew enable - DTX - CC
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX dtx_cc_pbdstaticlegen : 1;
    //
    // Per bit deskew enable - TX - BL
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX tx_bl_pbdstaticlegen : 1;
    //
    // Per bit deskew enable - TX - CC
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX tx_cc_pbdstaticlegen : 1;
    //
    // Reserved bits
    //
    // Bits[21:4], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved626 : 18;
#else
    UINTX reserved : 18;
#endif // MEM_SV_HOOKS
    //
    // Rx Per Bit De-skew enable (1=enable, 0=disable)
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX rxdll_bl_rxpbden : 1;
    //
    // Rx Per Bit De-skew enable (1=enable, 0=disable), 0 for cc always
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX rxdll_cc_rxpbden : 1;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved625 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXPBDCTL1_DQCCC_STRUCT;
#endif // ASM_INC

#define TXPBDRK0CTL1_DQCCC_REG                             0x000000C4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX tx_bldm_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[31:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved627 : 27;
#else
    UINTX reserved : 27;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXPBDRK0CTL1_DQCCC_STRUCT;
#endif // ASM_INC

#define TXPBDRK0CTL0_DQCCC_REG                             0x000000C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX dtx_bl_dqspbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved630 : 3;
#else
    UINTX reserved : 3;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[15:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved629 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX dtx_bl_dqsbpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[31:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved628 : 11;
#else
    UINTX reserved_2 : 11;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXPBDRK0CTL0_DQCCC_STRUCT;
#endif // ASM_INC

#define TXPBDBLCTL1_DQCCC_REG                              0x000000CC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX tx_bldq4_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved634 : 3;
#else
    UINTX reserved : 3;
#endif // MEM_SV_HOOKS
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX tx_bldq5_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved633 : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX tx_bldq6_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved632 : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX tx_bldq7_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[31:29], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved631 : 3;
#else
    UINTX reserved_3 : 3;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXPBDBLCTL1_DQCCC_STRUCT;
#endif // ASM_INC

#define TXPBDBLCTL0_DQCCC_REG                              0x000000D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX tx_bldq0_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved638 : 3;
#else
    UINTX reserved : 3;
#endif // MEM_SV_HOOKS
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX tx_bldq1_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved637 : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX tx_bldq2_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved636 : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // Tx Per Bit De-skew code for dq0 valid codes
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX tx_bldq3_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[31:29], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved635 : 3;
#else
    UINTX reserved_3 : 3;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXPBDBLCTL0_DQCCC_STRUCT;
#endif // ASM_INC

#define OFFSETCNCLCTRL1_DQCCC_REG                          0x000000D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Offset cancellation code (DM/DQ buffers)[br]1100 -4[br]1011 -3[br]1010 -2[br]1001
    // -1[br]0000 0[br]0001 +1[br]0010 +2[br]0011 +3[br]0100 +4
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rx_bldm_ampoffset : 4;
    //
    // Offset cancellation code (DQS buffers)[br]1100 -4[br]1011 -3[br]1010 -2[br]1001
    // -1[br]0000 0[br]0001 +1[br]0010 +2[br]0011 +3[br]0100 +4
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX drx_bl_ampoffset : 4;
    //
    // tuning bits for offset cancellation (can be tied off for CC)
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rx_cc_ampoffset : 4;
    //
    // tuning bits for offset cancellation (can be tied off for CC)
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX drx_ccck0_ampoffset : 4;
    //
    // DQ Offset cancellation enable for Rx (1=enable, 0=disable)
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX rx_bl_ampoffseten : 1;
    //
    // DQS Offset cancellation enable for Rx (1=enable, 0=disable)
    //
    // Bits[17:17], RW, default = 0x1
    //
    UINTX drx_bl_ampoffseten : 1;
    //
    // Offset cancellation enable for Rx (not used for cc)
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX rx_cc_ampoffseten : 1;
    //
    // Offset cancellation enable for Rx (not used for cc)
    //
    // Bits[19:19], RW, default = 0x1
    //
    UINTX drx_cc_ampoffseten : 1;
    //
    // Reserved bits
    //
    // Bits[31:20], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved639 : 12;
#else
    UINTX reserved : 12;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} OFFSETCNCLCTRL1_DQCCC_STRUCT;
#endif // ASM_INC

#define OFFSETCNCLCTRL0_DQCCC_REG                          0x000000D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Offset cancellation code (DM/DQ buffers)[br]1100 -4[br]1011 -3[br]1010 -2[br]1001
    // -1[br]0000 0[br]0001 +1[br]0010 +2[br]0011 +3[br]0100 +4
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rx_bldq7_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)[br]1100 -4[br]1011 -3[br]1010 -2[br]1001
    // -1[br]0000 0[br]0001 +1[br]0010 +2[br]0011 +3[br]0100 +4
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX rx_bldq6_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)[br]1100 -4[br]1011 -3[br]1010 -2[br]1001
    // -1[br]0000 0[br]0001 +1[br]0010 +2[br]0011 +3[br]0100 +4
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rx_bldq5_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)[br]1100 -4[br]1011 -3[br]1010 -2[br]1001
    // -1[br]0000 0[br]0001 +1[br]0010 +2[br]0011 +3[br]0100 +4
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rx_bldq4_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)[br]1100 -4[br]1011 -3[br]1010 -2[br]1001
    // -1[br]0000 0[br]0001 +1[br]0010 +2[br]0011 +3[br]0100 +4
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX rx_bldq3_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)[br]1100 -4[br]1011 -3[br]1010 -2[br]1001
    // -1[br]0000 0[br]0001 +1[br]0010 +2[br]0011 +3[br]0100 +4
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX rx_bldq2_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)[br]1100 -4[br]1011 -3[br]1010 -2[br]1001
    // -1[br]0000 0[br]0001 +1[br]0010 +2[br]0011 +3[br]0100 +4
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rx_bldq1_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)[br]1100 -4[br]1011 -3[br]1010 -2[br]1001
    // -1[br]0000 0[br]0001 +1[br]0010 +2[br]0011 +3[br]0100 +4
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rx_bldq0_ampoffset : 4;
  } Bits;
  UINTX Data;
} OFFSETCNCLCTRL0_DQCCC_STRUCT;
#endif // ASM_INC

#define CTLECTL2_DQCCC_REG                                 0x000000DC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DRX N Bias Control - BL
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX drx_bl_nbiasctrl : 2;
    //
    // DRX Bias Command Control - BL
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX drx_bl_casbiasctrl : 2;
    //
    // Reserved bits
    //
    // Bits[31:4], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved640 : 28;
#else
    UINTX reserved : 28;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CTLECTL2_DQCCC_STRUCT;
#endif // ASM_INC

#define CTLECTL1_DQCCC_REG                                 0x000000E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // cap tuning;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[1:0], RW, default = 0x1
    //
    UINTX rx_bldm_ctlecap : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX rx_bldm_ctleres : 2;
    //
    // bias control for ctle amp[br]00 2k&          0.25xnom[br]01 1k&          0.4xnom[br]10
    // 0.5k&     1xnom[br]11 0.25k&  1.7xnom
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX rx_bl_ctlebiasctrl : 2;
    //
    // Enable CTLE for DQ (1=enable, 0=disable)
    //
    // Bits[6:6], RW, default = 0x1
    //
    UINTX rx_bl_ctleen : 1;
    //
    // DRX Bias Enable - BL
    //
    // Bits[7:7], RW, default = 0x1
    //
    UINTX drx_bl_biasen : 1;
    //
    // cap tuning;00 = 0.5pf;01 = 1pf;10 = 1.5pf;11 = 2pf
    //
    // Bits[9:8], RW, default = 0x1
    //
    UINTX drx_bl_ctlecap : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX drx_bl_ctleres : 2;
    //
    // bias control for ctle amp[br]00 2k&          0.25xnom[br]01 1k&          0.4xnom[br]10
    // 0.5k&     1xnom[br]11 0.25k&  1.7xnom
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX drx_bl_ctlebiasctrl : 3;
    //
    // Enable CTLE for DQS (1=enable, 0=disable)
    //
    // Bits[15:15], RW, default = 0x1
    //
    UINTX drx_bl_ctleen : 1;
    //
    // cap tuning;00 = 0.5pf;01 = 1pf;10 = 1.5pf;11 = 2pf
    //
    // Bits[17:16], RW, default = 0x1
    //
    UINTX rx_cc_ctlecap : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[19:18], RW, default = 0x0
    //
    UINTX rx_cc_ctleres : 2;
    //
    // bias control for ctle amp[br]00 2k&          0.25xnom[br]01 1k&          0.4xnom[br]10
    // 0.5k&     1xnom[br]11 0.25k&  1.7xnom
    //
    // Bits[21:20], RW, default = 0x0
    //
    UINTX rx_cc_ctlebiasctrl : 2;
    //
    // Enable CTLE (not used for CC)
    //
    // Bits[22:22], RW, default = 0x1
    //
    UINTX rx_cc_ctleen : 1;
    //
    // DRX Bias Ctle Control - CC
    //
    // Bits[25:23], RW, default = 0x0
    //
    UINTX drx_cc_ctlebiasctrl : 3;
    //
    // DRX N Bias Control - CC
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX drx_cc_nbiasctrl : 2;
    //
    // DRX Bias Command Control - CC
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX drx_cc_casbiasctrl : 2;
    //
    // DRX Bias Enable - CC
    //
    // Bits[30:30], RW, default = 0x1
    //
    UINTX drx_cc_biasen : 1;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved641 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CTLECTL1_DQCCC_STRUCT;
#endif // ASM_INC

#define CTLECTL0_DQCCC_REG                                 0x000000E4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // cap tuning;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[1:0], RW, default = 0x1
    //
    UINTX rx_bldq7_ctlecap : 2;
    //
    // cap tuning;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[3:2], RW, default = 0x1
    //
    UINTX rx_bldq6_ctlecap : 2;
    //
    // cap tuning;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[5:4], RW, default = 0x1
    //
    UINTX rx_bldq5_ctlecap : 2;
    //
    // cap tuning;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[7:6], RW, default = 0x1
    //
    UINTX rx_bldq4_ctlecap : 2;
    //
    // cap tuning;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[9:8], RW, default = 0x1
    //
    UINTX rx_bldq3_ctlecap : 2;
    //
    // cap tuning;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[11:10], RW, default = 0x1
    //
    UINTX rx_bldq2_ctlecap : 2;
    //
    // cap tuning;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[13:12], RW, default = 0x1
    //
    UINTX rx_bldq1_ctlecap : 2;
    //
    // cap tuning;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[15:14], RW, default = 0x1
    //
    UINTX rx_bldq0_ctlecap : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX rx_bldq7_ctleres : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[19:18], RW, default = 0x0
    //
    UINTX rx_bldq6_ctleres : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[21:20], RW, default = 0x0
    //
    UINTX rx_bldq5_ctleres : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX rx_bldq4_ctleres : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX rx_bldq3_ctleres : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX rx_bldq2_ctleres : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX rx_bldq1_ctleres : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX rx_bldq0_ctleres : 2;
  } Bits;
  UINTX Data;
} CTLECTL0_DQCCC_STRUCT;
#endif // ASM_INC

#define TCOCTL_DQCC_DQCCC_REG                              0x000000E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQ TCO ddr401_comp rise code - CC Lane
    //
    // Bits[4:0], RW, default = 0x1F
    //
    UINTX tx_cc_tcorise : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved645 : 3;
#else
    UINTX reserved : 3;
#endif // MEM_SV_HOOKS
    //
    // DQ TCO ddr401_comp fall code - CC Lane
    //
    // Bits[12:8], RW, default = 0x1F
    //
    UINTX tx_cc_tcofall : 5;
    //
    // Reserved bits
    //
    // Bits[14:13], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved644 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // TX TCO enable - CC
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX tx_cc_tcostaticlegen : 1;
    //
    // DQ TCO ddr401_comp rise code - DQ Lane
    //
    // Bits[20:16], RW, default = 0x1F
    //
    UINTX tx_bl_tcorise : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved643 : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // DQ TCO ddr401_comp fall code - DQ Lane
    //
    // Bits[28:24], RW, default = 0x1F
    //
    UINTX tx_bl_tcofall : 5;
    //
    // Reserved bits
    //
    // Bits[30:29], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved642 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // TX TCO enable - BL
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX tx_bl_tcostaticlegen : 1;
  } Bits;
  UINTX Data;
} TCOCTL_DQCC_DQCCC_STRUCT;
#endif // ASM_INC

#define TCOCTL_DQ_DQCCC_REG                                0x000000EC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQS TCO ddr401_comp rise code - DQ Lane
    //
    // Bits[4:0], RW, default = 0x1F
    //
    UINTX dtx_bl_tcorisedqs : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved649 : 3;
#else
    UINTX reserved : 3;
#endif // MEM_SV_HOOKS
    //
    // DQSB TCO ddr401_comp rise code - DQ Lane
    //
    // Bits[12:8], RW, default = 0x1F
    //
    UINTX dtx_bl_tcofalldqs : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved648 : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // DQS TCO ddr401_comp fall code - DQ Lane
    //
    // Bits[20:16], RW, default = 0x1F
    //
    UINTX dtx_bl_tcorisedqsb : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved647 : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // DQSB TCO ddr401_comp fall code - DQ Lane
    //
    // Bits[28:24], RW, default = 0x1F
    //
    UINTX dtx_bl_tcofalldqsb : 5;
    //
    // DTX TCO enable - BL
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX dtx_bl_tcostaticlegen : 1;
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved646 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TCOCTL_DQ_DQCCC_STRUCT;
#endif // ASM_INC

#define TCOCTL_CC_DQCCC_REG                                0x000000F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQS TCO ddr401_comp rise code - CC Lane
    //
    // Bits[4:0], RW, default = 0x1F
    //
    UINTX dtx_cc_tcorisedqs : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved653 : 3;
#else
    UINTX reserved : 3;
#endif // MEM_SV_HOOKS
    //
    // DQS TCO ddr401_comp fall code - CC Lane
    //
    // Bits[12:8], RW, default = 0x1F
    //
    UINTX dtx_cc_tcofalldqs : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved652 : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // DQSB TCO ddr401_comp rise code - CC Lane
    //
    // Bits[20:16], RW, default = 0x1F
    //
    UINTX dtx_cc_tcorisedqsb : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved651 : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // DQSB TCO ddr401_comp fall code - CC Lane
    //
    // Bits[28:24], RW, default = 0x1F
    //
    UINTX dtx_cc_tcofalldqsb : 5;
    //
    // DTX TCO enable - CC
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX dtx_cc_tcostaticlegen : 1;
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved650 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TCOCTL_CC_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP6CTL_DQCCC_REG                          0x000000F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rank 0 2x Read pointer offset for dq/dm drive enable
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp06rdptroffset : 4;
    //
    // Rank 0 Dead band select for dq/dm drive enable
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp06dbsel : 2;
    //
    //
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp06dbsel_process : 1;
    //
    // Rank 1 2x Read pointer offset for dq/dm drive enable
    //
    // Bits[10:7], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp06rdptroffset : 4;
    //
    // Rank 1 Dead band select for dq/dm drive enable
    //
    // Bits[12:11], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp06dbsel : 2;
    //
    // 2x Read pointer offset control for CKE
    //
    // Bits[16:13], RW, default = 0x0
    //
    UINTX txdll_rk0ckesiggrp06rdptroffset : 4;
    //
    // Rank 0 2x Read pointer offset for dq/dm drive enable
    //
    // Bits[20:17], RW, default = 0x0
    //
    UINTX txdll_cc_rk0siggrp06rdptroffset : 4;
    //
    // Reserved bits
    //
    // Bits[31:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved654 : 11;
#else
    UINTX reserved : 11;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLSIGGRP6CTL_DQCCC_STRUCT;
#endif // ASM_INC

#define LDOCTL0_DQCCC_REG                                  0x000000F8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 2x Read pointer offset for CLK data to LDO
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX ckdrvsecondrdportref2xrdptroffset : 4;
    //
    // Rank 0 2x Read pointer offset for DQS drive enable to LDO
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX rk0dqsdrvsecondrdportref2xrdptroffset : 4;
    //
    // Rank 1 2x Read pointer offset for DQS drive enable to LDO
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rk1dqsdrvsecondrdportref2xrdptroffset : 4;
    //
    // Rank 0 2x Read pointer offset for  DQ/DM data to LDO
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rk0dqsecondrdportref2xrdptroffset : 4;
    //
    // Rank 1 2x Read pointer offset for DQ/DM data to LDO
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX rk1dqsecondrdportref2xrdptroffset : 4;
    //
    // Rank 0 2x Read pointer offset for DQ/DM drive enable to LDO
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX rk0dqdrvsecondrdportref2xrdptroffset : 4;
    //
    // Rank 1 2x Read pointer offset for DQ/DM drive enable to LDO
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rk1dqdrvsecondrdportref2xrdptroffset : 4;
    //
    // Reserved bits
    //
    // Bits[31:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved655 : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LDOCTL0_DQCCC_STRUCT;
#endif // ASM_INC

#define LDOCTL1_DQCCC_REG                                  0x000000FC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 2x Read pointer offset for CA data to LDO
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX cmddrvsecondrdportref2xrdptroffset : 4;
    //
    // 2x Read pointer offset for CS data to LDO
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX cssecondrdportref2xrdptroffset : 4;
    //
    // Reserved bits
    //
    // Bits[31:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved656 : 24;
#else
    UINTX reserved : 24;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LDOCTL1_DQCCC_STRUCT;
#endif // ASM_INC

#define PTDATAMUXSEL_DQCCC_REG                             0x00000100
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DRAM read data bit mux for DQ7.  [br]This needs to be programmed based on the
    // how DRAM data pins get swizzled at the DRAM package.[br]000:  Use DQ0[br]001:
    //  Use DQ1[br]010:  Use DQ2[br]011:  Use DQ3[br]100:  Use DQ4[br]101:  Use DQ5[br]110:
    //  Use DQ6[br]111:  Use DQ7
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX data7sel : 3;
    //
    // DRAM read data bit mux for DQ6. [br]This needs to be programmed based on the how
    // DRAM data pins get swizzled at the DRAM package.[br]000:  Use DQ0[br]001:  Use
    // DQ1[br]010:  Use DQ2[br]011:  Use DQ3[br]100:  Use DQ4[br]101:  Use DQ5[br]110:
    //  Use DQ6[br]111:  Use DQ7
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX data6sel : 3;
    //
    // DRAM read data bit mux for DQ5. [br]This needs to be programmed based on the how
    // DRAM data pins get swizzled at the DRAM package.[br]000:  Use DQ0[br]001:  Use
    // DQ1[br]010:  Use DQ2[br]011:  Use DQ3[br]100:  Use DQ4[br]101:  Use DQ5[br]110:
    //  Use DQ6[br]111:  Use DQ7
    //
    // Bits[8:6], RW, default = 0x0
    //
    UINTX data5sel : 3;
    //
    // DRAM read data bit mux for DQ4. [br]This needs to be programmed based on the how
    // DRAM data pins get swizzled at the DRAM package.[br]000:  Use DQ0[br]001:  Use
    // DQ1[br]010:  Use DQ2[br]011:  Use DQ3[br]100:  Use DQ4[br]101:  Use DQ5[br]110:
    //  Use DQ6[br]111:  Use DQ7
    //
    // Bits[11:9], RW, default = 0x0
    //
    UINTX data4sel : 3;
    //
    // DRAM read data bit mux for DQ3. [br]This needs to be programmed based on the how
    // DRAM data pins get swizzled at the DRAM package.[br]000:  Use DQ0[br]001:  Use
    // DQ1[br]010:  Use DQ2[br]011:  Use DQ3[br]100:  Use DQ4[br]101:  Use DQ5[br]110:
    //  Use DQ6[br]111:  Use DQ7
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX data3sel : 3;
    //
    // DRAM read data bit mux for DQ2. [br]This needs to be programmed based on the how
    // DRAM data pins get swizzled at the DRAM package.[br]000:  Use DQ0[br]001:  Use
    // DQ1[br]010:  Use DQ2[br]011:  Use DQ3[br]100:  Use DQ4[br]101:  Use DQ5[br]110:
    //  Use DQ6[br]111:  Use DQ7
    //
    // Bits[17:15], RW, default = 0x0
    //
    UINTX data2sel : 3;
    //
    // DRAM read data bit mux for DQ1. [br]This needs to be programmed based on the how
    // DRAM data pins get swizzled at the DRAM package.[br]000:  Use DQ0[br]001:  Use
    // DQ1[br]010:  Use DQ2[br]011:  Use DQ3[br]100:  Use DQ4[br]101:  Use DQ5[br]110:
    //  Use DQ6[br]111:  Use DQ7
    //
    // Bits[20:18], RW, default = 0x0
    //
    UINTX data1sel : 3;
    //
    // DRAM read data bit mux for DQ0. [br]This needs to be programmed based on the how
    // DRAM data pins get swizzled at the DRAM package.[br]000:  Use DQ0[br]001:  Use
    // DQ1[br]010:  Use DQ2[br]011:  Use DQ3[br]100:  Use DQ4[br]101:  Use DQ5[br]110:
    //  Use DQ6[br]111:  Use DQ7
    //
    // Bits[23:21], RW, default = 0x0
    //
    UINTX data0sel : 3;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved657 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} PTDATAMUXSEL_DQCCC_STRUCT;
#endif // ASM_INC

#define LPMODECTL0_DQCCC_REG                               0x00000104
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This indicates the delay in spidclk cycles for ref2xclk reset de-assertion, during
    // LP mode 2 exit
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX lpmode_dasrtref2xrstb_dly : 3;
    //
    // Reserved bits
    //
    // Bits[3:3], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved666 : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[6:4], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved665 : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved664 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // This indicates the delay in spidclk cycles for ref2xclk reset assertion, during
    // LP mode 2  entry
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX lpmode_asrtref2xrstb_dly : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved663 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // This indicates the delay in spidclk cycles for write pointer disable, during LP
    // mode  2 entry
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX lpmode_dasrtwrptren_dly : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved662 : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // This indicates the delay in spidclk cycles for IOBUFACT disable, during LP mode
    // 2  entry
    //
    // Bits[18:16], RW, default = 0x0
    //
    UINTX lpmode_dasrtiobufact_dly : 3;
    //
    // Reserved bits
    //
    // Bits[19:19], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved661 : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // This indicates the delay in spidclk cycles for DQ/DQS driver enable, during LP
    // mode  1 exit
    //
    // Bits[22:20], RW, default = 0x0
    //
    UINTX lpmode_asrtdqcmddrvenb_dly : 3;
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved660 : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // This indicates the delay in spidclk cycles for DQ/DQS/CMD PI disable/enable, during
    // LP mode 1 entry/exit
    //
    // Bits[26:24], RW, default = 0x0
    //
    UINTX lpmode_asrtdqcmdsigpien_dly : 3;
    //
    // Reserved bits
    //
    // Bits[27:27], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved659 : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
    //
    // This indicates the delay in spidclk cycles for DQ/DQS driver disable, during LP
    // mode 1 entry
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX lpmode_dasrtdqcmddrvenb_dly : 3;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved658 : 1;
#else
    UINTX reserved_8 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LPMODECTL0_DQCCC_STRUCT;
#endif // ASM_INC

#define LPMODECTL1_DQCCC_REG                               0x00000108
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This indicates the delay in spidclk cycles for DLL enable, during LP mode 2 exit
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX lpmode_asrtref2xsigpien_dly : 8;
    //
    // Reserved bits
    //
    // Bits[15:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved670 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // Override LP mode control for ref2xrstb
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX lpmode_ref2xrstbovrd : 1;
    //
    // Override LP mode control for write pointer enable
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX lpmode_wrptrenovrd : 1;
    //
    // Override LP mode control for signal PI enable
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX siggrpen_lpmode2or3ovrd : 1;
    //
    // Override LP mode control for signal PI enable
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX siggrpen_lpmode1ovrd : 1;
    //
    // Override LP mode control for ref2xclk enable
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX lpmode_ref2xclkenovrd : 1;
    //
    // Override LP mode control for IOBUFACT
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX lpmode_iobufactovrd : 1;
    //
    // Override LP mode control for DQ/DQS/CMD driver
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX lpmode_dqcmddrvenbovrd : 1;
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved669 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // This indicates the delay in spidclk cycles for IOBUFACT enable, during LP mode
    // 2 exit
    //
    // Bits[26:24], RW, default = 0x0
    //
    UINTX lpmode_asrtiobufact_dly : 3;
    //
    // Reserved bits
    //
    // Bits[27:27], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved668 : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // This indicates the delay in spidclk cycles for write pointer enable, during LP
    // mode 2 exit
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX lpmode_asrtwrptren_dly : 3;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved667 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LPMODECTL1_DQCCC_STRUCT;
#endif // ASM_INC

#define RXDLLRDCMDCTL0_DQCCC_REG                           0x0000010C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Length of read active indication. [br]This is in ref1xclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX rdactivelen : 6;
    //
    // Delay between spid rdcmd and read active indication[br]This is in terms of ref1xclks.
    //
    // Bits[11:6], RW, default = 0x0
    //
    UINTX rdcmd2rdactive : 6;
    //
    // Length of Rx DLL update indication. [br]This is in ref1xclks.
    //
    // Bits[17:12], RW, default = 0x0
    //
    UINTX rxdllupdtlen : 6;
    //
    // Delay between spid rdcmd and Rx dll update[br]This is in terms of ref1xclks.
    //
    // Bits[23:18], RW, default = 0x0
    //
    UINTX rdcmd2rxdllupdt : 6;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved671 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} RXDLLRDCMDCTL0_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_RESET_DQCCC_REG                            0x00000600
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Power-on or software reset.[br]0: reset state.[br]1: normal operation.[br]Set
    // to 1 to enter normal operation.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX dllcomprst_b : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 31;
#else
    UINTX reserved : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DLLCOMP_RESET_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_INIT_DQCCC_REG                             0x00000604
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Activates initialization training procedure.[br]0: initialization training procedure
    // not active.[br]1: initialization training procedure active.[br]Self-clearing after
    // successful initialization training procedure.
    //
    // Bits[0:0], RW/1S/V, default = 0x0
    //
    UINTX txdll_init : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 31;
#else
    UINTX reserved : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DLLCOMP_INIT_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_LPDDRTYPE_DQCCC_REG                        0x00000608
#ifndef ASM_INC
typedef union {
  struct {
    //
    // LPDDR speed target.[br]0: LPDDR3 - 1600 MHz (uses 2-stage Synchronization for
    // clock domain Crossing).[br]1: LPDDR4 -  3200 MHz (uses 4-stage Synchronization
    // for clock domain Crossing).
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lpddr_type : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 31;
#else
    UINTX reserved : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DLLCOMP_LPDDRTYPE_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_CLKUNGATE_DQCCC_REG                        0x0000060C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Internal clock control.[br]0: Allow clock gating for low power.[br]1: Allow clock
    // free running.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX clkungate : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 31;
#else
    UINTX reserved : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DLLCOMP_CLKUNGATE_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_ERROR_STATUS_DQCCC_REG                     0x00000610
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Set when Initialization training procedure is successful. [br]Clears upon starting
    // initialization training procedure.
    //
    // Bits[0:0], RO/V, default = 0x0
    //
    UINTX txdll_init_done : 1;
    //
    // Set when initialization or fine periodic training procedure passes locking training
    // sequence. [br]Valid only when scr_lockseq_en is set to 1.[br]Clears upon starting
    // lock training sequence.
    //
    // Bits[1:1], RO/V, default = 0x0
    //
    UINTX txdll_lock_flag : 1;
    //
    // Reserved
    //
    // Bits[3:2], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Set when Delaycell mux select count exceeds maximum limit value. [br]Clears upon
    // starting initialization training procedure.
    //
    // Bits[4:4], RO/V, default = 0x0
    //
    UINTX txdll_error : 1;
    //
    // Set when coarsecode underflow or overflow occurs. [br]Clears upon starting initialization
    // training procedure.
    //
    // Bits[5:5], RO/V, default = 0x0
    //
    UINTX txdll_coarsep_error : 1;
    //
    // Set when finecode underflow or overflow occurs as finecode exceeds finecode hard
    // limit during fine continuous or fine periodic training procedure (including lock
    // training sequence). [br]Clears upon starting initialization training procedure.
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX txdll_fine_error : 1;
    //
    // Set when initialization or fine periodic training procedure fails during lock
    // training sequence. [br]Valid only when scr_lockseq_en is set to 1. Clears upon
    // starting initialization training procedure.
    //
    // Bits[7:7], RO/V, default = 0x0
    //
    UINTX txdll_lock_error : 1;
    //
    // Reserved
    //
    // Bits[31:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 24;
#else
    UINTX reserved_1 : 24;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DLLCOMP_ERROR_STATUS_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_CODE_STATUS_DQCCC_REG                      0x00000614
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Instantaneous finecode.
    //
    // Bits[7:0], RO/V, default = 0x7F
    //
    UINTX txdll_stat_finecode : 8;
    //
    // Instantaneous coarsecode.
    //
    // Bits[11:8], RO/V, default = 0xF
    //
    UINTX txdll_stat_coarsecode : 4;
    //
    // Coarsecode (static) after successful initialization training procedure completion.
    // This will be the static coarse code used for Dummy Delay Cells and Pis.
    //
    // Bits[15:12], RO/V, default = 0xF
    //
    UINTX txdll_stat_coarseicode : 4;
    //
    // Delaycell mux select code (static) after successful initialization training procedure
    // completion.
    //
    // Bits[20:16], RO/V, default = 0x7
    //
    UINTX txdll_stat_fbmuxsel : 5;
    //
    // Reserved
    //
    // Bits[31:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 11;
#else
    UINTX reserved : 11;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DLLCOMP_CODE_STATUS_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_LOCKCTL_DQCCC_REG                          0x00000618
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Maximum samples to count for lock evaluation. The counter decrements until the
    // value reaches 0 yielding scr_lockcount_size + 1 samples.
    //
    // Bits[3:0], RW, default = 0x3
    //
    UINTX lockcount_size : 4;
    //
    // Reserved
    //
    // Bits[29:4], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 26;
#else
    UINTX reserved : 26;
#endif // MEM_SV_HOOKS
    //
    // Ignore lock error. Valid when scr_lockseq_en = 1.[br]0: Lock error suspends further
    // training procedures until starting a new initialization training procedure.[br]1:
    // ignore lock error and continue further with training procedures.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX lockerror_ignore : 1;
    //
    // Enable lock training sequence during initialization or fine periodic training
    // procedure.[br]0: disable lock training sequence.[br]1: enable lock training sequence.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX lock_seq_en : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_LOCKCTL_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FBMUXSEL_DQCCC_REG                         0x0000061C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delaycell mux select code minimum (Mmin) value. Default start code.
    //
    // Bits[4:0], RW, default = 0x9
    //
    UINTX muxcode_min : 5;
    //
    // Reserved
    //
    // Bits[7:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 3;
#else
    UINTX reserved : 3;
#endif // MEM_SV_HOOKS
    //
    // Delaycell mux select code maximum (Mmax) value. Used in overflow check.
    //
    // Bits[12:8], RW, default = 0x1B
    //
    UINTX muxcode_max : 5;
    //
    // Reserved
    //
    // Bits[15:13], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // Override value to drive on txdll_fbmuxsel[4:0], when scr_muxcode_ovr_sel is active
    // high.
    //
    // Bits[20:16], RW, default = 0xF
    //
    UINTX muxcode_ovr : 5;
    //
    // Reserved
    //
    // Bits[30:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_2 : 10;
#else
    UINTX reserved_2 : 10;
#endif // MEM_SV_HOOKS
    //
    // Override txdll_fbmuxsel[4:0] with scr_muxcode_ovr[4:0].[br]0: disable override.[br]1:
    // enable override.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX muxcode_ovr_sel : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_FBMUXSEL_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_COARSECODE_DQCCC_REG                       0x00000620
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Coarsecode minimum (Cmin) value. Used in underflow check.
    //
    // Bits[3:0], RW, default = 0x2
    //
    UINTX coarsecode_min : 4;
    //
    // Reserved
    //
    // Bits[7:4], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved2 : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // Coarsecode maximum (Cmax) value. Default start value. Used in overflow check.
    //
    // Bits[11:8], RW, default = 0xF
    //
    UINTX coarsecode_max : 4;
    //
    // Reserved
    //
    // Bits[15:12], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // Coarsecode override value.
    //
    // Bits[19:16], RW, default = 0x2
    //
    UINTX coarsecode_ovr : 4;
    //
    // Reserved
    //
    // Bits[23:20], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Static coarsecode override value.
    //
    // Bits[27:24], RW, default = 0x2
    //
    UINTX coarseicode_ovr : 4;
    //
    // Reserved
    //
    // Bits[29:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // Override txdll_coarsecode[3:0] with scr_coarsecode_ovr[3:0].[br]0: disable override.[br]1:
    // enable override.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX coarseicode_ovr_sel : 1;
    //
    // Override static txdll_coarseicode[3:0] with scr_coarseicode_ovr[3:0].[br]0: disable
    // override.[br]1: enable override.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX coarsecode_ovr_sel : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_COARSECODE_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FINECODE_DQCCC_REG                         0x00000624
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Fine code hard limit - minimum (FminH) value. Used for underflow check during
    // fine continuous or fine periodic training procedure (including lock training sequence).
    // [br]Asserts txdll_fine_error when the fine code is less than this value.
    //
    // Bits[7:0], RW, default = 0x20
    //
    UINTX finecode_min : 8;
    //
    // Fine code hard limit - maximum (FmaxH) value. Used for overflow check during fine
    // continuous or fine periodic training procedure (including lock training sequence).
    // [br]Asserts txdll_fine_error when the fine code is more than this value.
    //
    // Bits[15:8], RW, default = 0xFF
    //
    UINTX finecode_max : 8;
    //
    // Fine code soft limit - minimum (FminS)  value. When the finecode is less than
    // this value after 1st binary search training sequence, adjust coarse code downward
    // by 1 before starting 2nd binary search training sequence during initialization
    // training procedure or upon ddr401_PM mode exit. Also,  when the finecode is less
    // than this value during fine continuous or fine periodic training procedure (including
    // lock training sequence), adjust coarse code downward by 1 before starting fine
    // binary search training sequence upon coarse periodic training request. [br]Note:
    // Required FminH =< FminS - 4.
    //
    // Bits[23:16], RW, default = 0x34
    //
    UINTX finecodemin_limit : 8;
    //
    // Fine code soft limit - maximum (FmaxS)  value. When the finecode is more than
    // this value after 1st binary search training sequence, adjust coarse code upward
    // by 1 before starting 2nd binary search training sequence during initialization
    // training procedure or upon ddr401_PM mode exit. Also,  when the finecode is more
    // than this value during fine continuous or fine periodic training procedure (including
    // lock training sequence), adjust coarse code upward by 1 before starting fine binary
    // search training sequence upon coarse periodic training request. [br]Note: Required
    // FmaxH >= FmaxS + 4.
    //
    // Bits[31:24], RW, default = 0xCF
    //
    UINTX finecodemax_limit : 8;
  } Bits;
  UINTX Data;
} DLLCOMP_FINECODE_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FINEMUXSEL_DQCCC_REG                       0x00000628
#ifndef ASM_INC
typedef union {
  struct {
    //
    // afe_finecode_sel[2:0] selects one of 8 possible finecode during fine continuous
    // or fine periodic training procedures (including lock training sequence).  A proprietary
    // algorithm computes 8 possible values using 4 +ve and 4 -ve offset values. The
    // codes as computed with +ve offset values use 0-3 inputs and the codes as computed
    // with -ve offset values use 4-7 inputs of an 8:1 mux. Additionally, a 4:1 mux selects
    // one of 4 possible finecode values for each input using two bits. Any one of finecode
    // as computed with +ve offset values may be steered to any 0-3 inputs and  any one
    // of finecode as computed with -ve offset values may be steered to any 4-7 inputs.[br][1:0]:
    // Steers one of 4 finecode as computed with +ve offset values to input#0.  [br]
    //         Steers one of 4 finecode as computed with -ve offset values to input#4.[br][3:2]:
    // Steers one of 4 finecode as computed with +ve offset values to input#1. [br]
    //        Selects one of 4 finecode as computed with -ve offset values to input#5.
    // [br][5:4]: Steers one of 4 finecode as computed with +ve offset values to input#2.
    // [br]         Steers one of 4 finecode as computed with -ve offset values to input#6.[br][7:6]:
    // Steers one of 4 finecode as computed with +ve offset values to input#3. [br]
    //        Steers one of 4 finecode as computed with -ve offset values to input#7.[br]Exampe,
    // scr_finecode_muxsel[1:0] selects the finecode as computed with the following offset
    // values. Same table applies to other fields also.[br]00 - 1x offset value.[br]01
    // - 2x offset value.[br]10 - 4x offset value.[br]11 - 8x offset value.
    //
    // Bits[7:0], RW, default = 0xE8
    //
    UINTX finecode_muxsel : 8;
    //
    // Reserved
    //
    // Bits[31:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 24;
#else
    UINTX reserved : 24;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DLLCOMP_FINEMUXSEL_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FINECTL_DQCCC_REG                          0x0000062C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Finecode start (Fstart) value to apply during fine binary search training sequence.
    //
    // Bits[7:0], RW, default = 0x7F
    //
    UINTX finecode_start : 8;
    //
    // Reserved
    //
    // Bits[28:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 21;
#else
    UINTX reserved : 21;
#endif // MEM_SV_HOOKS
    //
    // Propriety search algorithm version to apply during fine continuous or fine periodic
    // training procedure (including lock training sequence).[br]0: Apply Low Jitter
    // Version. The search algorithm uses upper two bits of finecode.[br]1: Apply Fast
    // Correct Version. The search algorithm uses upper three bits of finecode.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX searchalgo_long : 1;
    //
    // Enable fine periodic training procedure after successfully completing initialization
    // training procedure.[br]0: Disable fine periodic training procedure (default).[br]1:
    // Enable fine periodic training procedure. Valid when scr_finec_mode = 0.[br]Note:
    // If scr_finec_mode = scr_finep_mode = 0 any time after initialization training
    // procedure completion, ddr401_DLLCOMP enters a special No Operation (NOP) mode.
    // In NOP mode, ddr401_DLLCOMP stays in the idle state until one of these conditions
    // occur, (a) start initialization training procedure, (b) coarsecode periodic request,
    // (c)  scr_finec_mode = 1, or (d) scr_finec_mode = 0 and scr_finep_mode = 1.  When
    // scr_finec_mode = scr_finep_mode = 1, ddr401_DLLCOMP defaults to fine continuous
    // mode.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX finep_mode : 1;
    //
    // Enable fine continuous training procedure after successfully completing initialization
    // training procedure.[br]0: Disable fine continuous training procedure.[br]1: Enable
    // fine continuous training procedure (default).
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX finec_mode : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_FINECTL_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FINECODEOVR_DQCCC_REG                      0x00000630
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Finecode to override with when scr_finecode_ovr_sel = 1.
    //
    // Bits[7:0], RW, default = 0x13
    //
    UINTX finecode_ovr : 8;
    //
    // Reserved
    //
    // Bits[29:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 22;
#else
    UINTX reserved : 22;
#endif // MEM_SV_HOOKS
    //
    // When scr_finecode_ovr_sel is 1, this bit drives txdll_dllupdateovr.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX finecode_updateovr_ovr : 1;
    //
    // Finecode override select.[br]0: Apply Pre-computed finecode (default).[br]1: Apply
    // scr_finecode_ovr[7:0].
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX finecode_ovr_sel : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_FINECODEOVR_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FPTIMER_DQCCC_REG                          0x00000634
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Fine periodic wait interval timer start value. Defines wait interval before sending
    // 1st sample request during fine periodic training procedure. Runs on 1x clock.[br]Note:
    // When scr_finepwait_interval[15:0] is set to 0, 1st sample request follows last
    // sample with 1-cycle gap when fine periodic training procedure is kept enabled.
    // The behavior is similar to fine continuous sequence.
    //
    // Bits[15:0], RW, default = 0x3FFF
    //
    UINTX finepwait_interval : 16;
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 16;
#else
    UINTX reserved : 16;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DLLCOMP_FPTIMER_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_SAMPLEWAIT_DQCCC_REG                       0x00000638
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Wait interval between code update and sample ready.[br]Applied during fine continuous
    // or fine periodic training procedure (including lock training sequence).
    //
    // Bits[4:0], RW, default = 0x2
    //
    UINTX samplewait_min : 5;
    //
    // Reserved
    //
    // Bits[7:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 3;
#else
    UINTX reserved : 3;
#endif // MEM_SV_HOOKS
    //
    // Wait interval between code update and sample ready.[br]Applied during fine continuous
    // or fine periodic training procedure (including lock training sequence).[br]Recommend
    // to use formula: samplewait_max = 3 + Mmax /4 (roundedup).
    //
    // Bits[12:8], RW, default = 0x6
    //
    UINTX samplewait_max : 5;
    //
    // Reserved
    //
    // Bits[31:13], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 19;
#else
    UINTX reserved_1 : 19;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DLLCOMP_SAMPLEWAIT_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_RXCOARSEOVR_DQCCC_REG                      0x0000063C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Coarsecode override value for rxdll_coarsecode[3:0].
    //
    // Bits[3:0], RW, default = 0x2
    //
    UINTX rxdll_coarsecode_ovr : 4;
    //
    // Reserved
    //
    // Bits[30:4], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 27;
#else
    UINTX reserved : 27;
#endif // MEM_SV_HOOKS
    //
    // Override rxdll_coarsecode[3:0] with scr_rxdll_coarsecode_ovr[3:0].[br]0: disable
    // override.[br]1: enable override.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX rxdll_coarsecode_ovr_sel : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_RXCOARSEOVR_DQCCC_STRUCT;
#endif // ASM_INC

#define DLLCOMP_RXFINEOVR_DQCCC_REG                        0x00000640
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Finecode override value for rxdll_finecode[7:0].
    //
    // Bits[7:0], RW, default = 0x13
    //
    UINTX rxdll_finecode_ovr : 8;
    //
    // Reserved
    //
    // Bits[29:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 22;
#else
    UINTX reserved : 22;
#endif // MEM_SV_HOOKS
    //
    // When scr_rxdll_finecode_ovr_sel = 1, this bit drives rxdll_rxdqsdllupdateovr.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX rxdll_finecode_updateovr_ovr : 1;
    //
    // Override rxdll_finecode[7:0] with scr_rxdll_finecode_ovr[7:0].[br]0: disable override.[br]1:
    // enable override.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX rxdll_finecode_ovr_sel : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_RXFINEOVR_DQCCC_STRUCT;
#endif // ASM_INC

#define LOWER_DFXVISAULM0_DQCCC_REG                        0x00000700
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Lower Level ULM0 Lane (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxlowervisaulm0_datasel : 8;
    //
    // VISA Lower Level ULM0 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxlowervisaulm0_clksel : 8;
    //
    // VISA Lower Level Bypass ULM0
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxlowervisaulm0_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved672 : 15;
#else
    UINTX reserved : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LOWER_DFXVISAULM0_DQCCC_STRUCT;
#endif // ASM_INC

#define LOWER_DFXVISAULM1_DQCCC_REG                        0x00000704
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Lower Level ULM1 Lane (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxlowervisaulm1_datasel : 8;
    //
    // VISA Lower Level ULM1 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxlowervisaulm1_clksel : 8;
    //
    // VISA Lower Level Bypass ULM1
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxlowervisaulm1_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved673 : 15;
#else
    UINTX reserved : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LOWER_DFXVISAULM1_DQCCC_STRUCT;
#endif // ASM_INC

#define LOWER_DFXVISAPATTGEN_DQCCC_REG                     0x00000708
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Lower Level ULM Pattern Generation
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX dfxlowervisapattgen_lsb : 4;
    //
    // VISA Lower Level ULM Pattern Generation
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX dfxlowervisapattgen_msb : 3;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved674 : 25;
#else
    UINTX reserved : 25;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LOWER_DFXVISAPATTGEN_DQCCC_STRUCT;
#endif // ASM_INC

#define TOP_DFXVISAULM0_DQCCC_REG                          0x0000070C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Top Level ULM0 Lane (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxtopvisaulm0_datasel : 8;
    //
    // VISA Top Level ULM0 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxtopvisaulm0_clksel : 8;
    //
    // VISA Top Level Bypass ULM0
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxtopvisaulm0_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved675 : 15;
#else
    UINTX reserved : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TOP_DFXVISAULM0_DQCCC_STRUCT;
#endif // ASM_INC

#define TOP_DFXVISAULM1_DQCCC_REG                          0x00000710
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Top Level ULM1 Lane (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxtopvisaulm1_datasel : 8;
    //
    // VISA Top Level ULM1 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxtopvisaulm1_clksel : 8;
    //
    // VISA Top Level Bypass ULM1
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxtopvisaulm1_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved676 : 15;
#else
    UINTX reserved : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TOP_DFXVISAULM1_DQCCC_STRUCT;
#endif // ASM_INC

#define TOP_DFXVISAPATTGEN_DQCCC_REG                       0x00000714
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Top Level ULM Pattern Generation
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX dfxtopvisapattgen_lsb : 4;
    //
    // VISA Top Level ULM Pattern Generation
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX dfxtopvisapattgen_msb : 3;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved677 : 25;
#else
    UINTX reserved : 25;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TOP_DFXVISAPATTGEN_DQCCC_STRUCT;
#endif // ASM_INC

#define DFXMRG_BL_DQCCC_REG                                0x00000718
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase3 Fall Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 3 Rise SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdfall_ph3 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase2 Fall Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 2 Fall SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdfall_ph2 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase1 Fall Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 1 Fall SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdfall_ph1 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase0 Fall Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 0 Fall SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdfall_ph0 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase1 Rise Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 3 Rise SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdrise_ph3 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase0 Rise Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 2 Rise SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdrise_ph2 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase1 Rise Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 1 Rise SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdrise_ph1 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase0 Rise Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 0 Rise SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdrise_ph0 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQS/B Fall Tx SubFIFO data load value. The value
    // loaded will apply to all DQ Bytelane DQS/B Fall SubFIFOs. Recommended setting
    // for HVM = 2'b00
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdqsfall : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQS/B Rise Tx SubFIFO data load value. The value
    // loaded will apply to all DQ Bytelane DQS/B Rise SubFIFOs. Recommended setting
    // for HVM = 2'b00
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdqsrise : 1;
    //
    // DQ Bytelane TxFIFO Margin Mode Latch enable override value used to make TxFIFO
    // latches transparent allowing the loading of all TxFIFO Latches with data programmed
    // in DFXMRGTXFIFO[23:0], if dfxmrgtxovren is asserted(1'b1)  1'b1 - All DQ/DM/DQS
    // Tx FIFO Latches Transparent  0'b0 - All DQ/DM/DQS TxFIFO Latches CLosed
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxwren : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode config override enable for Tx data path and Latch
    // enables via  DFXMRGTXFIFO[24:0]    1'b1  - Enable TxFIFO DFx overrides on Latch
    // enables and TxData  1'b0 - Functional Mode of operation
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxovren : 1;
    //
    // Reserved bits
    //
    // Bits[31:12], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved678 : 20;
#else
    UINTX reserved : 20;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DFXMRG_BL_DQCCC_STRUCT;
#endif // ASM_INC

#define DFXMRG_CC_DQCCC_REG                                0x0000071C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase3 SDR Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 3 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdsdr_ph3 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase2 SDR Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 2 SDR SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b11
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdsdr_ph2 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 SDR Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 1 SDR SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdsdr_ph1 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 SDR Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 0 SDR SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdsdr_ph0 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase3 Fall Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 3 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdfall_ph3 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase2 Fall Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 2 Fall SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdfall_ph2 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 Fall Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 1 Fall SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdfall_ph1 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 Fall Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 0 Fall SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdfall_ph0 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 Rise Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 3 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdrise_ph3 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 Rise Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 2 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdrise_ph2 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 Rise Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 1 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdrise_ph1 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 Rise Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 0 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdrise_ph0 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCCS/B Fall Tx SubFIFO data load value. The
    // value loaded will apply to all DQCCC Bytelane DQCCCS/B Fall SubFIFOs. Recommended
    // setting for HVM = 2'b00
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdqsfall : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCCS/B Rise Tx SubFIFO data load value. The
    // value loaded will apply to all DQCCC Bytelane DQCCCS/B Rise SubFIFOs. Recommended
    // setting for HVM = 2'b00
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdqsrise : 1;
    //
    // DQCCC Bytelane TxFIFO Margin Mode Latch enable override value used to make TxFIFO
    // latches transparent allowing the loading of all TxFIFO Latches with data programmed
    // in DFXMRGTXFIFO[23:0], if dfxmrgtxovren is asserted(1'b1)  1'b1 - All DQCCC/DM/DQCCCS
    // Tx FIFO Latches Transparent  0'b0 - All DQCCC/DM/DQCCCS TxFIFO Latches CLosed
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxwren : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode config override enable for Tx data path and
    // Latch enables via  DFXMRGTXFIFO[24:0]    1'b1  - Enable TxFIFO DFx overrides on
    // Latch enables and TxData  1'b0 - Functional Mode of operation
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxovren : 1;
    //
    // Reserved bits
    //
    // Bits[31:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved679 : 16;
#else
    UINTX reserved : 16;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DFXMRG_CC_DQCCC_STRUCT;
#endif // ASM_INC

#define DFXMRG_BLRX_DQCCC_REG                              0x00000720
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DFx Margin Mode DQ Bytelane Rx Compare value; Used to compare Actual RxFIFO value
    // vs Expected Rx FIFO value(TxFIFO Unloaded)
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX bl_dfxmrgrx_cmpval : 8;
    //
    // Reserved bits
    //
    // Bits[31:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved680 : 24;
#else
    UINTX reserved : 24;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DFXMRG_BLRX_DQCCC_STRUCT;
#endif // ASM_INC

#define DFXMRG_CCRX_DQCCC_REG                              0x00000724
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DFx Margin Mode CCC Bytelane Rx Compare value for SDR pins; Used to compare Actual
    // RxFIFO value vs Expected Rx FIFO value(TxFIFO Unloaded)
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX cc_dfxmrgrx_sdrcmpval : 8;
    //
    // DFx Margin Mode CCC Bytelane Rx Compare value for DDR pins; Used to compare Actual
    // RxFIFO value vs Expected Rx FIFO value(TxFIFO Unloaded)
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX cc_dfxmrgrx_ddrcmpval : 8;
    //
    // DFx Margin Mode SDR vs DDR Rx Compare Values
    //
    // Bits[24:16], RW, default = 0x0
    //
    UINTX cc_dfxmrgrx_sdrsel : 9;
    //
    // Reserved bits
    //
    // Bits[31:25], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved681 : 7;
#else
    UINTX reserved : 7;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DFXMRG_CCRX_DQCCC_STRUCT;
#endif // ASM_INC

#define TEST_DQCCC_REG                                     0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Test register to create LPPHY boxtype.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} TEST_DQCCC_STRUCT;
#endif // ASM_INC

#define WAKE_CHASIS_DQCCC_REG                              0x00000110
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Simulation requirement to wake dunit chassis
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX wake : 32;
  } Bits;
  UINTX Data;
} WAKE_CHASIS_DQCCC_STRUCT;
#endif // ASM_INC

#define DRAM_RESET_DQCCC_REG                               0x00000114
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Simulation requirement for resetting the DRAM
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX dram_reset_reg : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 31;
  } Bits;
  UINTX Data;
} DRAM_RESET_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP3CTLA_DQCCC_REG                         0x00000870
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 3 rank 0
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp03picode : 8;
    //
    // Read pointer offset for sig group 3 rank 0
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp03rdptroffset : 4;
    //
    // Deadband select for sig group 3 rank 0
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp03dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[15:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved576 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[23:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved575 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[27:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved574 : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[29:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved573 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved572 : 2;
#else
    UINTX reserved_4 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLSIGGRP3CTLA_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP5CTLA_DQCCC_REG                         0x00000868
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 5 rank 0
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp05picode : 8;
    //
    // Read pointer offset for sig group 5 rank 0
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp05rdptroffset : 4;
    //
    // Deadband select for sig group 5 rank 0
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp05dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[15:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved566 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[23:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved565 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[27:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved564 : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[29:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved563 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved562 : 2;
#else
    UINTX reserved_4 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLSIGGRP5CTLA_DQCCC_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP4CTLA_DQCCC_REG                         0x0000086C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 4 rank 0
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp04picode : 8;
    //
    // Read pointer offset for sig group 4 rank 0
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp04rdptroffset : 4;
    //
    // Deadband select for sig group 4 rank 0
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp04dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[15:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved571 : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[23:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved570 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[27:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved569 : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[29:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved568 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved567 : 2;
#else
    UINTX reserved_4 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} TXDLLSIGGRP4CTLA_DQCCC_STRUCT;
#endif // ASM_INC


#endif // _DQCCC_H_
