##########################################################################
# TPM 2.0 Sample Provisioning Script -- for development systems 
# Copyright Intel Corporation 2015
# Last update: Jan 4, 2017
##########################################################################
##########################################################################
# Usage:                                                                 #
#     ResetPlatformAuth.nsh <alg> <fileNamePrefix>                       #
#  Where:                                                                #
#      <alg> is a supported hash algorithm                               #
#         Such as SHA1, SHA256, SHA384, SHA512, SM3                      #
#         <alg> will be substituted for %1 in Tpm2ProvTool command lines #
#      <fileNamePrefix> is the file name prefix you used to create the   #
#         def files - typically a project name or platform name          #
#        (e.g., MyFirst; Example; Purley)                                #
#         <fileNamePrefix> will be substituted for %2 in command lines   #
#    For example %2PhSecretOR%1.iDef --> ExamplePhSecretORSha256.pDef    #
#                %2PhSecretOR%1.iDef --> MyFirstPhSecretORShaSha384.pDef #
##########################################################################

echo -OFF 
# Copyrights:
# You may copy, distribute, and make derivatives of this script under the 
# following provisions:
#  You must not remove or modify the Intel copyright notice nor these requirements
#  The script must only be used to provision a TPM for use with Intel Technologies
#    For any other use you must get written permission from Intel corporation
 
##########################################################################
# When PlatformAuth is not EMPTY, then the following code is an example of 
#    what is needed to satisfy the PlatformPolicy and set PlatformAuth to Empty
#    so you can use simple PW authorization for other provisioning operations 
#  NOTE: this script can only be used if BIOS sets a PlatformPolicy
##########################################################################
##########################################################################
# Here is a list of files that are needed
## //User Modified Files -----------[example for %1=SHA256, %2=MyFirst]
## %2PhSecretOR%1.pDef              MyFirstPhSecretOrSha256.pDef
## Intel Provided Files -----------------------------------------------------
## EmptyAuth.dat
## Policy%1.sDef                    PolicySha256.sDef
##########################################################################
# This script echoes progress markers to the screen and also to
#   a log file (SetPlatformAuth.log) which also captures provisioning details 
##########################################################################
#Check that Alg parameter is present
if ZZ%1  == ZZ   then
	echo Algorithm parameter missing
	echo Syntax: %0 <alg> <PlatformName>
	echo   Examples: 
	echo     %0 SHA256 Example 
	echo     %0 SHA384 MyFirst
	echo     %0 SHA512 Grantley
	goto EOF
endif
# Check if alg parameter supported
if NOT EXIST Policy%1.sDef then  
	echo Algorithm not supported - Policy%1.sDef not found
	goto EOF
endif
# Check if platform parameter supported
if NOT EXIST %2PhSecretOR%1.pDef then  
	echo Platform Name not valid (%2PhSecretOR%1.pDef not found)
	goto EOF
endif

:STARTLOG
echo %0 %1 %2 > SetPlatformAuth.log
###################################################################
echo **** Start Policy Session for PlatformPolicy
Tpm2ProvTool StartSession Policy%1.sDef 0 >> SetPlatformAuth.log

echo Attempting to satisfy PlatformPolicy and use it to change PlatformAuth
echo **** Policy OR (0, PhSecretSHA256)
Tpm2ProvTool AssertPolicy %2PhSecretOR%1.pDef 0 >> SetPlatformAuth.log

echo **** PH HierarchyChangeAuth  	
Tpm2ProvTool HierarchyChangeAuth PH EmptyAuth.dat 0 >> SetPlatformAuth.log
if NOT %lasterror% == 0  then
	echo Did not satisfy PlatformPolicy
	goto ERROR		
endif

:DONE
echo  ***************************************************
echo  **** Successfully set PlatformAuth to EMPTY *******
echo  ***************************************************

goto EOF

:ERROR
echo  ***************************************************
echo  *************** Provisioning FAILED ***************
echo  ****** Setting PlatformAuth to EMPTY failed *******
echo  ***************************************************
Tpm2ProvTool FlushSession 0 >> SetPlatformAuth.log

goto EOF

:EOF

