##########################################################################
# TPM 2.0 Index Provisioning Script  
# Copyright Intel Corporation 2019
##########################################################################
##########################################################################
# Usage:                                                                 #
#     MSFT_index_provision.nsh <index_definition> - to define            #
#     MSFT_index_provision.nsh <index_definition> -D - to delete         #
#  Where:                                                                #
#      <index_definition> is an iDef file with index data                #
#      
#  This script assumes platform auth is empty.                           #
##########################################################################
# Copyrights:
# You may copy, distribute, and make derivatives of this script under the 
# following provisions:
#  You must not remove or modify the Intel copyright notice nor these requirements
#  The script must only be used to provision a TPM for use with Intel Technologies
#  For any other use you must get written permission from Intel Corporation
 
##########################################################################
# This script will:
#
#   Create a custom index and authorize operations with the policy definition 
#   provided. This script will work for platform hierarchy indexes and assumes
#   that PlatformAuth is empty. All definition files must be in the same directory
#   as the Tpm2ProvTool
##########################################################################
# Required files:
#  Custom files:
#    index_definition.iDef - Index definition file, must use SHA256 as name alg
#
#  Intel files:
#    EmptyAuthPwSession.sDef - empty password session definition provided by Intel
#    EmptyAuth.dat - empty data file provided by Intel
#    Policy session and definition files provided by Intel:
#      UndefineSpecial.pDef
#      PolicySha256.sDef
#      ExampleSecretORSha256.pDef
#      ExamplePsFinalOrSha256.pDef
##########################################################################

echo -OFF

#Check that first parameter is present
if ZZ%1  == ZZ then
	echo Parameter missing
	goto EOF
endif

# Check if files are present in the working directory
if NOT EXIST %1 then
    echo Index definition file not found
    goto EOF
endif

goto START
##########################################################################
:START
echo ****** Starting session ******

#Use session 0 for AuthPolicy
#Use session 1 for empty authValue PW session

Tpm2ProvTool StartSession EmptyAuthPwSession.sdef 0 > MSFT_index_provision.log

#Checking is if PlatformAuth is empty
Tpm2ProvTool HierarchyChangeAuth PH EmptyAuth.dat 0 >> MSFT_index_provision.log
if not %lasterror% == 0 then
	echo PlatformAuth is not EMPTY
	echo First run ResetPlatformAuth.nsh SHA256 EXAMPLE
	goto ERROR
endif

# Check if index exists
echo ****** Checking if index exists ******
echo ****** Checking if index exists ****** >> MSFT_index_provision.log

Tpm2ProvTool NvReadPublic %1 >> MSFT_index_provision.log

if not %lasterror% == 0 then
    echo Index does not exists
    if ZZ%2 == ZZ then
        goto INDEXCREATE
    endif
else
    echo Index already exists.
        if %2 == -D then
            goto NVDELETE
        else
            goto EOF
        endif
endif
##########################################################################
:CHECKDATA
echo ****** Checking index data ******
echo ****** Checking index data ****** >> MSFT_index_provision.log

Tpm2ProvTool NvCompareData %1 0 >> MSFT_index_provision.log
if %lasterror% == 0 then
    echo ****** Data is correct ******
    echo ****** Data is correct ****** >> MSFT_index_provision.log
    goto DONE
else
    echo ****** Data is not correct ******
    echo ****** Data is not correct ****** >> MSFT_index_provision.log
    goto ERROR
endif
##########################################################################
:INDEXCREATE
echo ****** Creating Index ******
echo ****** NV_DefineSpace for Index ******
echo ****** NV_DefineSpace for Index ****** >> MSFT_index_provision.log
Tpm2ProvTool NvDefineSpace %1 0 >> MSFT_index_provision.log
if %lasterror% == 0 then
    echo Index space definition successful
    goto DONE
else
    echo Error defining space for index
    echo If PlatformAuth is not empty run ResetPlatformAuth.nsh SHA256 EXAMPLE
    goto ERROR
endif
##########################################################################
:INDEXWRITE
echo ****** Writing Index ******
echo ****** Start Policy Session ******
echo ****** Start Policy Session ****** >> MSFT_index_provision.log
Tpm2ProvTool StartSession PolicySha256.sDef 1 >> MSFT_index_provision.log
Tpm2ProvTool AssertPolicy ExampleSecretORSha256.pDef 1 >> MSFT_index_provision.log
Tpm2ProvTool AssertPolicy ExamplePsFinalOrSha256.pDef 1 >> MSFT_index_provision.log
Tpm2ProvTool NvWrite %1 1 >> MSFT_index_provision.log

if %lasterror% == 0 then
    echo Verifying data
    goto CHECKDATA
else
    echo Writing data failed
    goto ERROR
endif
##########################################################################
:NVDELETE
echo ****** Deleting Index ******
echo ****** Start Policy Session ******
echo ****** Start Policy Session ****** >> MSFT_index_provision.log
Tpm2ProvTool StartSession EmptyAuthPwSession.sDef 1 >> MSFT_index_provision.log
Tpm2ProvTool StartSession PolicySha256.sDef 0 >> MSFT_index_provision.log
echo ****** Issuing assertions ******
echo ****** Issuing assertions ****** >> MSFT_index_provision.log

Tpm2ProvTool AssertPolicy ExampleSecretORSha256.pDef 0 >> MSFT_index_provision
Tpm2ProvTool AssertPolicy UnDefineSpaceSpecial.pDef 0 >> MSFT_index_provision.log
Tpm2ProvTool AssertPolicy ExamplePsFinalOrSha256.pDef 0 >> MSFT_index_provision.log
echo *** Execute UndefineSpecial for Index
echo *** Execute UndefineSpecial for Index >> MSFT_index_provision.log
Tpm2ProvTool NvUndefineSpecial %1 0 1 >> MSFT_index_provision.log
if %lasterror% != 0 then
    goto ERROR
endif
goto DONE
##########################################################################
:DONE
echo  ***************************************************
echo  ******* Provisioning Completed Successfully *******
echo  ***************************************************
goto EOF
##########################################################################
:ERROR
echo  ***************************************************
echo  *************** Provisioning Failed ***************
echo  ***************************************************
Tpm2ProvTool FlushSession 0 >> MSFT_index_provision.log
goto EOF
##########################################################################
:EOF
