##########################################################################
# TPM 2.0 Sample AUX Provisioning Script  
# Copyright Intel Corporation 2019
# Last update: Oct 2, 2019
##########################################################################
# Usage:                                                                 #
#     Tpm2AuxtProv.nsh   <alg>                                           #
#  Where:                                                                #
#      <alg> is  a supported hash algorithm                              #
#         Such as SHA1, SHA256, SHA384, SHA512, SM3                      #
#         <alg> will be substituted for %1 in Tpm2ProvTool command lines #
##########################################################################
echo -OFF 
# Copyrights:
# You may copy, distribute, and make derivatives of this script under the 
# following provisions:
#  You must not remove or modify the Intel copyright notice nor these requirements
#  The script must only be used to provision a TPM for use with Intel Technologies
#    For any other use you must get written permission from Intel Corporation
##########################################################################
# This script will:
# Check if the AUX Index already exists
# - if AUX does not exist, creates the AUX Index

# Check syntax
if ZZ%1  == ZZ   then
	echo Algorithm parameter missing
	echo Syntax: %0 <alg>
goto EOF

# Check if Aux def is present
if NOT EXIST Aux%1.iDef then  
	echo Aux%1.iDef not found
	goto EOF
endif

:START
echo ****** Provisioning NV Indexes *****
# Uses Session 1 for Empty AuthValue PW session
# Note that session 0 uses "Don't Continue" so no need to flush on successful use
echo **** Checking AUX Index

echo **** Checking if AUX index exists
echo **** Checking if AUX index exists >> Tpm2AuxProv.log
Tpm2ProvTool NvReadPublic Aux%3%1.iDef >> Tpm2AuxProv.log
if not %lasterror% == 0 then
	echo Aux Index does not exist
	goto AUXCREATE		# Index does not exist 
endif

echo **** AUX already exists, check if provisioned correctly 
echo **** AUX already exists, check if provisioned correctly  >> Tpm2AuxProv.log
Tpm2ProvTool NvVerifyDef Aux%1.iDef >> Tpm2AuxProv.log
if %lasterror% == 0 then 
	echo Aux Index provisioned correctly
	goto DONE
endif
goto :AUXDELETE

:AUXCREATE
echo ******** Creating Aux Index ********
# This script requires that PlatformAuth be EMPTY in order to create NV Indexes
echo If PlatformAuth is not EMPTY, then first run ResetPlatformAuth.nsh %1 %2

# Start a PW Session to use for PhAuth and Index Read Auth
echo **** Start PW Session for PlatformAuth & Index Read Auth
echo **** Start PW Session for PlatformAuth & Index Read Auth >> Tpm2AuxProv.log
Tpm2ProvTool StartSession EmptyAuthPwSession.sDef 1 >> Tpm2AuxProv.log

# This script requires PlatformAuth be EMPTY to create or delete NV Indexes
# Lets check if PlatformAuth is EMPTY
Tpm2ProvTool HierarchyChangeAuth PH EmptyAuth.dat 1 >> Tpm2AuxProv.log
if not %lasterror% == 0 then
	echo PlatformAuth is not EMPTY
	echo First run ResetPlatformAuth.nsh
	goto ERROR
endif

echo **** AUX NV_DefineSpace
echo **** AUX NV_DefineSpace >> Tpm2AuxProv.log
Tpm2ProvTool NvDefineSpace Aux%1.iDef 1 >> Tpm2AuxProv.log
if not %lasterror% == 0 then
	echo Unable to create AUX Index
	goto ERROR		
endif
goto DONE

:DONE
echo  ***************************************************
echo  ******* Provisioning Completed Successfully *******
echo  ***************************************************

:ERROR
:ERROR
echo  ***************************************************
echo  *************** Provisioning FAILED ***************
echo  ***************************************************

:AUXDELETE
echo  ***************************************************
echo AUX index not correct. See Tpm2DeleteAux to delete and recreate the AUX index.
echo AUX index not correct. See Tpm2DeleteAux to delete and recreate the AUX index. >> Tpm2AuxProv.log
echo  ***************************************************

:EOF

