###############################################################
# TPM 2.0 Sample AUX Deletion Script for CBnT
# Copyright Intel Corporation 2018
# Last update: Oct 23, 2015
#   Mar 2018: converted from previous script
###############################################################
# NOTE: the AUX index cannot be deleted directy by these tools. 
#       Only the BIOS ACM can delete the AUX index
#       Deleting the AUX index requires a special BPM with the
#       AuxDeletionEnable bit set and then invoking the ACM's ResetAux function
##########################################################################
# Usage:                                                                 #
#     Tpm2DeleteAuxCBnT.nsh   <alg>                                      #
#  Where:                                                                #
#      <alg> is  a supported hash algorithm                              #
#         Such as SHA1, SHA256, SHA384, SHA512, SM3                      #
#         <alg> will be substituted for %1 in Tpm2ProvTool command lines #
##########################################################################

echo -OFF 
# Copyrights:
# You may copy, distribute, and make derivatives of this script under the 
# following provisions:
#  You must not remove or modify the Intel copyright notice nor these requirements
#  The script must only be used to provision a TPM for use with Intel Technologies
#    For any other use you must get written permission from Intel Corporation
 
##########################################################################
# This script will:
# Check if the AUX Index exists 
# If so: Deletes the AUX NV Index 
#
##########################################################################

##########################################################################
# Here is a list of files that are needed
## Intel Provided Files ------------[example for %1=SHA256]
## Aux%1.iDef                         AuxSha256.iDef
## AuxPolicyOR%1.pDef                 AuxPolicyORSha256.pDef
## EmptyAuthPwSession.sDef
## getsec64.efi               -- part of Intel TXT Toolkit  
## Locality3&4.pDef
## Policy%1.sDef                      PolicySha256.sDef
## UndefinespaceSpecial.pDef
##########################################################################
# This script echoes progress markers to the screen and also to
#   a log file (*.log) which also captures provisioning details 
#
#  Note that there are commands indicated by "For testing on NEX"  
#    These never get executed when the script is run in the EFI environment
#     - they are for ease of manually testing using the NSH Exerciser
#     - Those lines may be deleted  
##########################################################################

#Check that Alg parameter is present
if ZZ%1  == ZZ   then
	echo Algorithm parameter missing
	echo Syntax: %0 <alg> 
	echo   Examples: 
	echo     %0 SHA256  
	echo     %0 SHA384 
	echo     %0 SHA512 
	echo     %0 SM3 
	goto EOF
endif
# Check if alg parameter supported
if NOT EXIST Policy%1.sDef then 
	echo Algorithm not supported - Policy%1.sDef not found
	goto EOF
endif

# Now copy this file to the error log
# since batch file can be invoked with or without extension - try both forms
#echo TPM2 AUX Deletion Script %1 %2 %3 > Tpm2DeleteAux.log
#if EXIST %0     then
#	type %0     >> Tpm2DeleteAux.log
#endif
#if EXIST %0.nsh then 
#	type %0.nsh >> Tpm2DeleteAux.log
#endif

goto START
##########################################################################
# #####For testing on NEX #####
# The following commands do not need to be sent to a TPM on a 
#   target platform because BIOS starts the TPM  
#   -- rather they are here for testing on a simulator or TTV
#   --   using the NSH Exerciser
#
#  On Simulator start-up or after inserting a TPM in the TTV
Tpm2ProvTool  PowerUp      # for testing on NEX
Tpm2ProvTool  StartUpClear # for testing on NEX
#
# Before removing a TPM from the TTV
Tpm2ProvTool ShutdownClear # for testing on NEX
Tpm2ProvTool PowerDown     # for testing on NEX
##########################################################################

:START
echo ****** Deleting Aux Index *****
# Uses Session 0 for AuthPolicy
# Uses Session 1 for Empty AuthValue
# Note that session 0 uses "Don't Continue" so no need to flush on successful use

# Start a PW Session to use for PhAuth
echo **** Starting PW Session for PlatformAuth 
echo **** Starting PW Session for PlatformAuth >> Tpm2DeleteAux.log
Tpm2ProvTool StartSession EmptyAuthPwSession.sDef 1 >> Tpm2DeleteAux.log

# This script requires that PlatformAuth be EMPTY in order to delete NV Indexes
# Lets check if PlatformAuth is EMPTY by attemping to change it to EMPTY
Tpm2ProvTool HierarchyChangeAuth PH EmptyAuth.dat 1 >> Tpm2DeleteAux.log
if not %lasterror% == 0 then
	echo PlatformAuth is not EMPTY
	goto ERROR
endif

echo **** Checking if AUX index exists
echo **** Checking if AUX index exists >> Tpm2DeleteAux.log
Tpm2ProvTool NvReadPublic Aux%1.iDef >> Tpm2DeleteAux.log
if not %lasterror% == 0 then
	echo Aux Index does not exist - nothing to delete
	goto DONE
endif

echo Deleting the AUX Index
echo This requires a BPM with Aux-Delete-Enable flag set

:AUXDELETE
#echo ***** Deleting AUX Index *****
echo "ServerGetSec -l ent -fn res"
echo "ServerGetSec -l ent -fn res" >> Tpm2DeleteAux.log
getsec64.efi -l ent -fn res >> Tpm2DeleteAux.log
if not %lasterror% == 0 then
	echo Unable to delete Aux index
	goto ERROR		# Didn�t delete Index 
endif
goto PSREWRITE2
##########################################################################
# Delete AUX on Simulator or TTV
# **** Start Policy Session 
Tpm2ProvTool StartSession Policy%1.sDef 0  # For testing on NEX
# **** Locality3&4 Assertion 
Tpm2ProvTool AssertPolicy Locality3&4.pDef 0  # For testing on NEX
# **** CommandCode assertion
Tpm2ProvTool AssertPolicy UndefineSpaceSpecial.pDef 0  # For testing on NEX
# **** PolicyOR assertion
Tpm2ProvTool AssertPolicy AuxPolicyORSha256.pDef 0  # For testing on NEX
# **** change to locality 3 
Tpm2ProvTool SetActiveLocality 3 # For testing on NEX
# **** UndefineSpaceSpecial for AUX
Tpm2ProvTool NvUndefineSpecial Aux%1.iDef 0 1  # For testing on NEX
if not %lasterror% == 0 then
	echo Cannot delete AUX index
    Tpm2ProvTool SetActiveLocality 0
	set FAIL = TRUE
	goto ERROR		
endif
Tpm2ProvTool SetActiveLocality 0 # For testing on NEX

##########################################################################

# Need to check to make sure AUX Deletion was really successful
echo **** Checking if AUX index was deleted
echo **** Checking if AUX index was deleted >> Tpm2TxtProv.log
Tpm2ProvTool NvReadPublic Aux%1.iDef >> Tpm2TxtProv.log
if %lasterror% == 0 then
	echo Aux Index was not deleted
	goto ERROR		# Index still exists
endif

:DONE
echo  ***************************************************
echo  ***********   AUX Deleted Successfully  ***********
echo  ***************************************************

goto EOF

:ERROR
echo  ***************************************************
echo  *************** ERROR Deleting AUX  ***************
echo  ***************************************************
Tpm2ProvTool FlushSession 0 >> Tpm2DeleteAux.log

goto EOF

:EOF

