###############################################################
# TPM 2.0 Sample PS2 Index Deletion Script
# Copyright Intel Corporation 2015
# Last update: Aug 29, 2017
#   Dec 2014: added algorithm agility
#   Apr 2015: Added platform agility 
#	May 2015: Corrections
#	Aug 2015: Modified to work with PS2 style index
#   Aug 2017: Modified for additional PS Policy styles
# --- *** This will not work for an PS1 style index (i.e., tool provisioned) 
###############################################################
##########################################################################
# Usage:                                                                 #
#     Tpm2DeletePS2.nsh   <alg>   <fileNamePrefix>                       #
#  Where:                                                                #
#      <alg> is  a supported hash algorithm                              #
#         Such as SHA1, SHA256, SHA384, SHA512, SM3                      #
#         <alg> will be substituted for %1 in Tpm2ProvTool command lines #
#      <fileNamePrefix> is the file name prefix you used to create the   #
#         def files - typically a project name or platform name          #
#        (e.g., MyFirst; Example; Purley)                                #
#         <fileNamePrefix> will be substituted for %2 in command lines   #
#         For example %2Ps2%1.iDef --> ExamplePs2Sha256.iDef             #
#                     %2Ps2%1.iDef --> MyFirstPs2Sha384.iDef             #
##########################################################################

echo -OFF 


# Copyrights:
# You may copy, distribute, and make derivatives of this script under the 
# following provisions:
#  You must not remove or modify the Intel copyright notice nor these requirements
#  The script must only be used to provision a TPM for use with Intel Technologies
#    For any other use you must get written permission from Intel Corporation
 
##########################################################################
# This script will:
# Delete the specified PS NV Index if it exists (using PS2 template)
#
#	Note that a PS index created by provisioning tools use a different 
# authPolicy structure than a PS index created by BIOS (i.e., BIOS Based 
# Provisioning. Thus how you satisfy the authPolicy for deleting the index
# is slightly different. In our examples, we use *PS*.iDef for tool based 
# provisioning (i.e., uses the PS1 template) and *PS2*.iDef for BIOS Based 
# provisioning (i.e., uses the PS2 template).   
##########################################################################






##########################################################################
# Here is a list of files that are needed
## //User Modified Files -----------[example for %1=SHA256, %2=MyFirst]
## %2SecretOR%1.pDef                  MyFirstSecretOrSha256.pDef
## %2PsFinalOR%1.pDef  (optional)     MyFirstPsFinalORSha256.pDef
## %2Ps2%1.iDef                       MyFirstPs2Sha256.iDef
## Intel Provided Files -----------------------------------------------------
## EmptyAuth.dat
## EmptyAuthPwSession.sDef
## Policy%1.sDef                      PolicySha256.sDef
## UndefinespaceSpecial.pDef
##
#
##########################################################################


##########################################################################
# This script echoes progress markers to the screen and also to
#   a log file (*.log) which also captures provisioning details 
#
#  Note that there are commands indicated by "# For testing on NEX"  
#    These never get executed when the script is run in the EFI environment
#     - they are for ease of manually testing using the NSH Exerciser
#     - Those lines may be deleted  
##########################################################################

#Check that Alg parameter is present
if ZZ%1  == ZZ   then
	echo Algorithm parameter missing
	echo Syntax: %0 <alg> <PlatformName>
	echo   Examples: 
	echo     %0 SHA256 Example 
	echo     %0 SHA384 MyFirst
	echo     %0 SHA512 Grantley
	goto EOF
endif
# Check if alg parameter supported
if NOT EXIST Policy%1.sDef then  
	echo Algorithm not supported
	goto EOF
endif
# Check if platform parameter supported
if NOT EXIST %2Ps2%1.iDef then  
	echo PlatformName not found
	goto EOF
endif

# Now copy this file to the error log
echo TPM2 PS2 Deletion Script %1 %2 %3  > Tpm2DeletePS.log
if EXIST %0     then
	type %0     >> Tpm2DeletePS.log
endif
if EXIST %0.nsh then 
	type %0.nsh >> Tpm2DeletePS.log
endif

goto START
##########################################################################
# #####For testing on NEX #####
# The following commands do not need to be sent to a TPM on a 
#   target platform because BIOS starts the TPM  
#   -- rather they are here for testing on a simulator or TTV
#   --   using the NSH Exerciser
#
#  On Simulator start-up or after inserting a TPM in the TTV
Tpm2ProvTool  PowerUp      # for testing on NEX
Tpm2ProvTool  StartUpClear # for testing on NEX
#
# Before removing a TPM from the TTV
Tpm2ProvTool ShutdownClear # for testing on NEX
Tpm2ProvTool PowerDown     # for testing on NEX
#
##########################################################################


:START
echo ****** Deleting PS Index *****
# Uses Session 0 for AuthPolicy
# Uses Session 1 for Empty AuthValue
# Note that session 0 uses “Don’t Continue” so no need to flush on successful use

echo **** Checking if index exists
echo **** Checking if index exists >> Tpm2DeletePS.log
Tpm2ProvTool NvReadPublic %2Ps2%1.iDef >> Tpm2DeletePS.log
if not %lasterror% == 0 then
	echo Index does not exist - nothing to delete
	goto DONE
endif

# Start a PW Session to use for PhAuth
echo **** Starting PW Session for PlatformAuth 
echo **** Starting PW Session for PlatformAuth >> Tpm2DeletePS.log
Tpm2ProvTool StartSession EmptyAuthPwSession.sDef 1 >> Tpm2DeletePS.log

# This script requires that PlatformAuth be EMPTY in order to delete NV Indexes
# Lets check if PlatformAuth is EMPTY
Tpm2ProvTool HierarchyChangeAuth PH EmptyAuth.dat 1 >> Tpm2DeletePS.log
if not %lasterror% == 0 then
	echo PlatformAuth is not EMPTY
	echo First run ResetPlatformAuth.nsh %1 %2
	goto ERROR
endif


echo *** Satisfying PS2 authPolicy (Index Deletion)
echo *** Starting Policy Session for Index auth
echo *** Starting Policy Session for Index auth >> Tpm2DeletePS.log
Tpm2ProvTool StartSession Policy%1.sDef 0 >> Tpm2DeletePS.log
	
# Satisfy the PS2 authPolicy
# There are 4 possible policy styles
#	A. single branch with 1 assertion:    PolCommandCode(NV_UndefinespaceSpecial)
#	B. multiple branches with 1 of them:  PolCommandCode(NV_UndefinespaceSpecial)
#	C. single branch with 2 assertions:   PolOR(0,SecretValue) && PolCommandCode(NV_UndefinespaceSpecial)
#	D. multiple branches with 1 of them:  PolOR(0,SecretValue) && PolCommandCode(NV_UndefinespaceSpecial)

# Let's try A & B first
	
echo *** Policy Command Code (TPM_CC_NV_UndefineSpace)
echo *** Policy Command Code (TPM_CC_NV_UndefineSpace) >> Tpm2DeletePS.log
Tpm2ProvTool AssertPolicy UnDefineSpaceSpecial.pDef 0 >> Tpm2DeletePS.log
# Tpm2ProvTool StorePolDigest 0 6 >> Tpm2DeletePS.log

# this is all that is needed for Style A (PS2) - so let's try
echo *** Execute UndefineSpecial for PS Index
echo *** Execute UndefineSpecial for PS Index >> Tpm2DeletePS.log
Tpm2ProvTool NvUndefineSpecial %2Ps%1.iDef 0 1 >> Tpm2DeletePS.log
if %lasterror% == 0 then
    goto DONE
endif

# you get here if that did not work,  So lt's assume style B
#  so send the final PolicyOR assertion needed for PS1 and try again

echo *** Policy OR (Branch 1, Branch 2, Branch 3)
echo *** Policy OR (Branch 1, Branch 2, Branch 3) >> Tpm2DeletePS.log
Tpm2ProvTool AssertPolicy %2PsFinalOR%1.pDef 0 >> Tpm2DeletePS.log
# Tpm2ProvTool StorePolDigest 0 6 >> Tpm2DeletePS.log

echo *** Execute UndefineSpecial for PS Index (Style B)
echo *** Execute UndefineSpecial for PS Index (Style B) >> Tpm2DeletePS.log
Tpm2ProvTool NvUndefineSpecial %2Ps%1.iDef 0 1 >> Tpm2DeletePS.log
if %lasterror% == 0 then
    goto DONE
endif

# OK, Let's try style C	
# you get here if that did not work,  So lt's assume style C
# First we have to reset the Policy Session
echo **** Restart session
Tpm2ProvTool PolicyRestart 0 >> Tpm2DeletePS.log

echo *** Policy OR (0, %2PsSecret%1)
echo *** Policy OR (0, %2PsSecret%1) >> Tpm2DeletePS.log
Tpm2ProvTool AssertPolicy %2SecretOR%1.pDef 0 >> Tpm2DeletePS.log
#Tpm2ProvTool StorePolDigest 0 6 >> Tpm2DeletePS.log

echo *** Policy Command Code (TPM_CC_NV_UndefineSpace)
echo *** Policy Command Code (TPM_CC_NV_UndefineSpace) >> Tpm2DeletePS.log
Tpm2ProvTool AssertPolicy UnDefineSpaceSpecial.pDef 0 >> Tpm2DeletePS.log
# Tpm2ProvTool StorePolDigest 0 6 >> Tpm2DeletePS.log

# this is all that is needed for PS2 - so let's see
echo *** Execute UndefineSpecial for PS Index
Tpm2ProvTool NvUndefineSpecial %2Ps%1.iDef 0 1 >> Tpm2DeletePS.log
if %lasterror% == 0 then
    goto DONE
endif

# you get here if that did not work, 
#  so send the final PolicyOR assertion needed for PS1 and try again

echo *** Policy OR (Branch 1, Branch 2, Branch 3)
echo *** Policy OR (Branch 1, Branch 2, Branch 3) >> Tpm2DeletePS.log
Tpm2ProvTool AssertPolicy %2PsFinalOR%1.pDef 0 >> Tpm2DeletePS.log
Tpm2ProvTool StorePolDigest 0 6 >> Tpm2DeletePS.log

echo *** Execute UndefineSpecial for PS Index
echo **** UndefineSpecial PS Index >> Tpm2DeletePS.log
Tpm2ProvTool NvUndefineSpecial %2Ps%1.iDef 0 1 >> Tpm2DeletePS.log
if not %lasterror% == 0 then
    echo Requires PlatformAuth be EMPTY and Satisfying index authPolicy
	echo If PlatformAuth is not EMPTY, then first run ResetPlatformAuth.nsh %1 %2
	goto ERROR		# Didn't satisfy Index authPolicy
endif

:DONE
echo  ***************************************************
echo  *******    PS Index Deleted Successfully    *******
echo  ***************************************************

goto EOF

:ERROR
echo  ***************************************************
echo  ************ PS Index Deletion FAILED *************
echo  ***************************************************
Tpm2ProvTool FlushSession 0 >> Tpm2DeletePS.log

goto EOF

:EOF

