// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module GSX_Slave #(parameter TOTAL_OUTPUT_MODULES = 3)
(
	input 			iClk,			//% 2MHz Reference Clock
	input 		    iReset,			//%	Input reset.
	input 			i1mSCE,			//An input for reset detect

	input           iSClock,		//%	Input clock.
	input			iSLoad,			//%	Input Last clock of a bit stream; begin a new bit stream on the next clock
	input 			iSDataOut,		//%	Input serial data bit stream.
	output reg 		oSDataIn, 		//%	Output serial data bit stream.
	output  		oSGPIOReset, 	//% SGPIO Reset

	output reg		[(TOTAL_OUTPUT_MODULES*8)-1:0]  ovDataOut, 		//% Data receive vector.  Slave receives using DataOut.
	input 			[(TOTAL_OUTPUT_MODULES*8)-1:0]  ivDataIn 		//% Data transmit vector. Slave transmits using DataIn.
);
//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
reg [7:0] rCounter_Out;
reg  riSLoad_q;
wire wReset;
wire wSClock;
wire wSLoad;
wire wSDout;
wire wCountDoneSClock;
wire wCountDoneSLoad;
wire wCountDoneSDout;


//////////////////////////////////////////////////////////////////////////////////
// Continuous assignments
//////////////////////////////////////////////////////////////////////////////////
assign wReset 		= wCountDoneSClock && wCountDoneSLoad && wCountDoneSDout; //SGPIO is idle during 64mS is equal to reset!
assign oSGPIOReset 	= wReset;


//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
always @ (negedge iSClock) 	
begin 
	if(!iReset || wReset) 
	begin
		rCounter_Out  	<= 8'd0;
		ovDataOut 		<= {(TOTAL_OUTPUT_MODULES*8){1'b0}};
		riSLoad_q 		<= 1'b1;
	end
	else			
	begin
		riSLoad_q 				<= iSLoad;

		ovDataOut[rCounter_Out]	<= iSDataOut;

		if( rCounter_Out == ((TOTAL_OUTPUT_MODULES*8) - 1) || (iSLoad && !riSLoad_q) )
		begin
			rCounter_Out 	<= 8'd0; 
		end
		else
		begin
			rCounter_Out 	<= rCounter_Out + 1'b1; 
		end
	end 
end

always @ (posedge iSClock) 	
begin 
	if(!iReset || wReset) 
	begin
		oSDataIn 		<= ivDataIn[0];
	end
	else			
	begin
		if( rCounter_Out == ((TOTAL_OUTPUT_MODULES*8) - 1) || (iSLoad && !riSLoad_q) )
		begin
			oSDataIn 		<= ivDataIn[0];
		end
		else
		begin
			oSDataIn 		<= ivDataIn[rCounter_Out + 1];
		end
	end 
end

//////////////////////////////////////////////////////////////////////////////////
// GPIO Idle Detect
//////////////////////////////////////////////////////////////////////////////////
EdgeDetector # //%Parameterizable Edge Detector
(	//% Defines Positive Edge (1) or Negative Edge (0)
    .EDGE(1'b0)
) mSClock (  
    .iRst(iReset), //%Reset Input
	.iClk(iClk),   //% Clock Input  
    .iSignal(iSClock),//% Signal to Detect  input     
    .oEdgeDetected(wSClock) //%Output EdgeDetected
);

EdgeDetector # //%Parameterizable Edge Detector
(	//% Defines Positive Edge (1) or Negative Edge (0)
    .EDGE(1'b0)
) mSLoad (  
    .iRst(iReset), //%Reset Input
	.iClk(iClk),   //% Clock Input  
    .iSignal(iSLoad),//% Signal to Detect  input     
    .oEdgeDetected(wSLoad) //%Output EdgeDetected
);

EdgeDetector # //%Parameterizable Edge Detector
(	//% Defines Positive Edge (1) or Negative Edge (0)
    .EDGE(1'b0)
) mSDout (  
    .iRst(iReset), //%Reset Input
	.iClk(iClk),   //% Clock Input  
    .iSignal(iSDataOut),//% Signal to Detect  input     
    .oEdgeDetected(wSDout) //%Output EdgeDetected
);

 counter2 #
 (                      			// ================= Parameters ==============
	.MAX_COUNT(7'd64)				// maximum number of clock cycles to count;
 ) mCountSClock						// iSetCnt should be smaller than this one.   
 (
	// ================= Inputs =================
	.iClk(i1mSCE),					// clock signal
	.iRst_n( ~(iReset || wSClock) ), 	// reset

	.iCntRst_n(1'b1),  				// synchronous reset
	.iCntEn(iSClock),     			// counter iCntEn 
	.iLoad(1'b1),  					// iLoad MAX_COUNT internal register. Not used	  
    .iSetCnt(7'd64),    			// Not used

	// ================= Outputs =================   
	.oDone(wCountDoneSClock)		// It is high when max count has been reached
 );

 counter2 #
 (                      			// ================= Parameters ==============
	.MAX_COUNT(7'd64)				// maximum number of clock cycles to count;
 ) mCountSLoad						// iSetCnt should be smaller than this one.   
 (
	// ================= Inputs =================
	.iClk(i1mSCE),					// clock signal
	.iRst_n( ~(iReset || wSLoad) ), 	// reset

	.iCntRst_n(1'b1),  				// synchronous reset
	.iCntEn(iSLoad),     			// counter iCntEn 
	.iLoad(1'b1),  					// iLoad MAX_COUNT internal register. Not used	  
    .iSetCnt(7'd64),    			// Not used

	// ================= Outputs =================   
	.oDone(wCountDoneSLoad)		// It is high when max count has been reached
 );

  counter2 #
 (                      			// ================= Parameters ==============
	.MAX_COUNT(7'd64)				// maximum number of clock cycles to count;
 ) mCountSDout						// iSetCnt should be smaller than this one.   
 (
	// ================= Inputs =================
	.iClk(i1mSCE),					// clock signal
	.iRst_n( ~(iReset || wSDout) ), // reset

	.iCntRst_n(1'b1),  				// synchronous reset
	.iCntEn(iSDataOut),     		// counter iCntEn 
	.iLoad(1'b1),  					// iLoad MAX_COUNT internal register. Not used	  
    .iSetCnt(7'd64),    			// Not used

	// ================= Outputs =================   
	.oDone(wCountDoneSDout)		// It is high when max count has been reached
 );

endmodule
