// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1ns / 1ps

module IICSlave_8Devices  
(
                    //%Clock Input
    input           iClk,
                    //%Asynchronous Reset Input 
    input           iRst,
                    //%IIC Serial Data
    input           iSDA,
                    //%IIC Serial Clock
    input           iSCL,
                    //%Tx Data Input port
    input   [7:0]   ivTxData,
					//%SMBus Address Input
	input   [6:0]	iModule_Address,
                    //%Tx Acknowledge Flag
    input           iTxAck,
                    //%IIC SDA Output Enable
    output          onSDAOE,
                    //%Address Match Flag Output
    output          oAddressMatch,
                    //%Start Ok Flag Output
    output          oStartOk,
                    //%Stop Ok Flag Output
    output          oStopOk,
                    
    output          oRnW,
    output  [7:0]   ovRxData,
                    //%Rx Acknowledge Flag
    output          oRxAck,
                    //% Transmition Ok Flag
    output          oTxOk,
                    //% Reception Ok Flag
    output          oRxOk
);

//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////
                //%Wait Start State
//localparam      WAIT_START_STATE         =    4'd1;
                //%Address Capture State
//localparam      ADDRESS_CAPTURE_STATE    =    4'd2;
                //%Transmition Data State
//localparam      TX_DATA_STATE            =    4'd4;
                //%Reciving Data State
//localparam      RX_DATA_STATE            =    4'd8;
                //%Idle State
//localparam      IDLE_STATE               =    4'd0;

//localparam       iModule_Address = 7'h40;//
//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
                //%Shifter Register DataIn
reg    [7:0]    rvShifter_d;
                //%Shifter Register DataOut
reg    [7:0]    rvShifter_q;
                //%Address Match Register DataIn
reg             rAddressMatch_d;
                //%Address Match Register DataOut
reg             rAddressMatch_q;
                //%Actual State Register DataIn
reg    [3:0]    rvState_d;
                //%Actual State Register DataOut
reg    [3:0]    rvState_q;
                //%Bits Counter Register DataIn
reg    [3:0]    rvBitsCounter_d;
                //%Bits Counter Register DataOut
reg    [3:0]    rvBitsCounter_q;
                //%Serial Clock Line Register DataIn
reg             rSCL_d;    
                //%Serial Clock Line Register DataOut
reg             rSCL_q;     
                //%Serial Data Line Register DataIn
reg             rSDA_d;     
                //%Serial Data Line Register DataOut
reg             rSDA_q;     
                //%Start Ok Flag Register DataIn
reg             rStartOk_d;
                //%Start Ok Flag Register DataOut
reg             rStartOk_q;
                //%Stop Ok Flag Register DataIn
reg             rStopOk_d;
                //%Stop Ok Flag Register DataOut
reg             rStopOk_q;
                //%Read and Write Register DataIn
reg             rRnW_d;
                //%Read and Write Register DataOut
reg             rRnW_q;
                //%Rx Ok Flag Register DataIn
reg             rRxOk_d;
                //%Rx Ok Flag Register DataOut
reg             rRxOk_q;
                //%Tx Ok Flag Register DataIn
reg             rTxOk_d;
                //%Tx Ok Flag Register DataOut
reg             rTxOk_q;
                //%Rx Acknowledge Register DataIn
reg             rRxAck_d;
                //%Rx Acknowledge Register DataOut
reg             rRxAck_q;
                //%Serial Data Line Output Enable Register DataIn
reg             rnSDAOE_d;
                //%Serial Data Line Output Enable Register DataOut
reg             rnSDAOE_q;


reg            rOutputAddressMatch_d;
reg            rOutputAddressMatch_q;
//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign      oAddressMatch   =    rOutputAddressMatch_q;
assign      oStopOk         =    rStopOk_q;
assign      oStartOk        =    rStartOk_q;
assign      oRnW            =    rRnW_q;
assign      ovRxData        =    rvShifter_q;
assign      oRxAck          =    rRxAck_q;
assign      onSDAOE         =    rnSDAOE_q;
assign      oRxOk           =   rRxOk_q;
assign      oTxOk           =   rTxOk_q;
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
always @(posedge iClk or posedge iRst)
begin
    if(iRst)
    begin
        rSCL_q              <=  1'b0;//iSCL;
        rSDA_q              <=  1'b0;//iSDA;
        rvShifter_q         <=  8'hff;
        rvBitsCounter_q     <=  4'd0;
        rvState_q           <=  4'd0;
        rRxOk_q             <=  1'b0;
        rTxOk_q             <=  1'b0;
        rRxAck_q            <=  1'b1;
        rRnW_q              <=  1'b0;
        rStopOk_q           <=  1'b0;
        rAddressMatch_q     <=  1'b0;
        rStartOk_q          <=  1'b0;
        rnSDAOE_q           <=  1'b1;
        rOutputAddressMatch_q    <=    1'b0;
    end
    else
    begin
        rSCL_q                  <=  rSCL_d;
        rSDA_q                  <=  rSDA_d;
        rvShifter_q             <=  rvShifter_d;
        rvBitsCounter_q         <=  rvBitsCounter_d;
        rvState_q               <=  rvState_d;
        rRxOk_q                 <=  rRxOk_d;
        rTxOk_q                 <=  rTxOk_d;
        rRxAck_q                <=  rRxAck_d;
        rRnW_q                  <=  rRnW_d;
        rStopOk_q               <=  rStopOk_d;
        rAddressMatch_q         <=  rAddressMatch_d;
        rStartOk_q              <=  rStartOk_d;
        rnSDAOE_q               <=  rnSDAOE_d;
        
        rOutputAddressMatch_q   <=  rOutputAddressMatch_d;
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
always @*
begin
    rSCL_d                  =   iSCL;
    rSDA_d                  =   iSDA;
    rvShifter_d             =   rvShifter_q;
    rvBitsCounter_d         =   rvBitsCounter_q;
    rvState_d               =   rvState_q;
    rAddressMatch_d         =   rAddressMatch_q;
    rStartOk_d              =   rStartOk_q;
    rStopOk_d               =   rStopOk_q;
    rRxOk_d                 =   rRxOk_q;
    rTxOk_d                 =   rTxOk_q;
    rRxAck_d                =   rRxAck_q;
    rRnW_d                  =   rRnW_q;
    rOutputAddressMatch_d   =   rOutputAddressMatch_q;
    rnSDAOE_d               =   rnSDAOE_q;
    case(rvState_q)
        4'd1:                       //%Waits for the start bit
        begin
            rRxOk_d                 =   1'b0;
            rTxOk_d                 =   1'b0;
            rvState_d               =   4'd1;
            rAddressMatch_d         =   1'b0;
            rOutputAddressMatch_d   =   1'b0;
            rStartOk_d              =   1'b0;
            rStopOk_d               =   1'b0;
            rvBitsCounter_d         =   1'b0;
            rnSDAOE_d               =   1'b1;
        end
        4'd2,
        4'd8:        
        begin                                                       //The Start Ok Flag is set Low
           rStartOk_d  =   1'b0;                                    //Added by MM 5/8/2012
                                                                    //Low to high transition?
            if({rSCL_q,iSCL} == 2'b01)
            begin
                
                rvBitsCounter_d     =   rvBitsCounter_q + 1'b1;
                if(rvBitsCounter_q < 4'd8)
                begin
                                                                    //Yes, Capture the 7 bits
                    rvShifter_d     =   {rvShifter_q[6:0],iSDA};
                                       
                end
                if(rvState_q == 4'd2)              //Address Capture?
                begin                                                               
                    if(rvBitsCounter_q == 4'd7)                 
                    begin
                        if(rvShifter_q[6:0] == iModule_Address[6:0])  
                        begin
                            rAddressMatch_d =    1'b1;
                            
                        end
                        else
                        begin
                            rvState_d    =    4'd1;
                        end
                    end
                    if(rvBitsCounter_q == 4'd8) 
                    begin                                
                        rRnW_d  =   rvShifter_q[0];
                        rOutputAddressMatch_d    =    rAddressMatch_q;                        
                        
                    end                                    
                end
            end
            //High to low transition
            if({rSCL_q,iSCL}    ==    2'b10)
            begin
                
                rnSDAOE_d   =   1'b1;
                rRxOk_d     =   1'b0;
                if(rvBitsCounter_q == 4'd8)
                begin
                    //Ack
                    rnSDAOE_d   = (rvState_q == 4'd2) ? ~rAddressMatch_q : ~iTxAck;
                end
                if(rvBitsCounter_q == 4'd9)
                begin
                    rvBitsCounter_d =   4'd0;
                    if(rvState_q == 4'd2)
                    begin
                        rvState_d    =    4'd8;
                        if(rRnW_q)
                        begin
                            rvState_d       =   4'd4;
                            rvShifter_d     =   {ivTxData[6:0],1'b1};
                            rnSDAOE_d       =   ivTxData[7];
                        end
                        
                    end
                    else
                    begin
                        rRxOk_d     =   1'b1;
                    end
                end
            end
        end

        4'd4:
        begin
            
        
            //Low to high transition
            if({rSCL_q,iSCL} == 2'b01)
            begin
               
                if(rvBitsCounter_q == 4'd8)
                begin
                    rRxAck_d    =   iSDA;
                    if(iSDA)
                    begin
                        rvState_d   =   4'd1;
                    end
                end
            end
            //High to low transition
            if({rSCL_q,iSCL}    ==    2'b10)
            begin
                
                rTxOk_d = 1'b0;
                rvBitsCounter_d =   rvBitsCounter_q + 1'b1;
                if(rvBitsCounter_q == 4'd7)                
                begin
                    rTxOk_d     =   1'b1;   //Added by MM 5/14/2012
                end    
                if(rvBitsCounter_q < 4'd8)
                begin
                    rvShifter_d =   {rvShifter_q[6:0],1'b1};
                    rnSDAOE_d   =   rvShifter_q[7];
                end
                if(rvBitsCounter_q == 4'd8)
                begin
                    rvShifter_d     =   {ivTxData[6:0],1'b1};
                    rnSDAOE_d       =   ivTxData[7];
                    rvBitsCounter_d =   0;
                end
            end
        end

        default:
        begin
            rvState_d    =    4'd1;
        end
    endcase
    //Stop?
    if({rSDA_q,iSDA,rSCL_q,iSCL} == 4'b0111)
    begin
        rvState_d               =   4'd1;
        rStopOk_d               =   1'b1;
        rvShifter_d[7]          =   1'b1;
        rAddressMatch_d         =   1'b0; //Added by MM  4/20/2012
        rOutputAddressMatch_d   =   1'b0;
    end

    //Start?
    if({rSDA_q,iSDA,rSCL_q,iSCL} == 4'b1011)
    begin
        rvState_d               =   4'd2;
        rStartOk_d              =   1'b1;
        //Added by Mario M  4/20/2012
        rRxOk_d                 =   1'b0;
        rTxOk_d                 =   1'b0;            
        rAddressMatch_d         =   1'b0;
        rOutputAddressMatch_d   =   1'b0;
        rStopOk_d               =   1'b0;
        rvBitsCounter_d         =   1'b0;
        rnSDAOE_d               =   1'b1;
        //////////////////////////////////
          
    end    
end
//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
endmodule