// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
//                  PCA9555
//////////////////////////////////////////////////////////////////////////////////


module PCA9555_8Devices //%PCA9555 Implementation  
(
                    //%Clock Input
    input           iClk,
                    //%Asynchronous Reset Input
    input           iRst,
					//%SMBus Address Input
    input   [6:0] 	iModule_Address, 
					//%Port 0 Input
    input   [7:0]   ivIO0,
                    //%Port 0 Output
    output  [7:0]   ovIO0, 
                    //%Port 0 Output Enable Flag
    output  [7:0]   onvOE0,
                    //%Serial Clock Line
    input           iSCL,
                    //%Serial Data Line
    input           iSDA,
                    //%Serial Data Line Output Enable Flag
    output          onSDAOE,
    
    
                     //%Port 1 Input 
	input       [7:0]   ivIO1,     
						//%Port 1 Output 
	output      [7:0]   ovIO1,  
						//%Port 1 Output Enable Flag
	output      [7:0]   onvOE1,
    
                    //%Interrupt Output Enable 
    output          onIntOE   //Modified by MM 5/9/2012
   
    
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////
        //%PCA9555 is implemented
//localparam     MODULE_ADDRESS = 7'h40;

                //%Input Port 0 Register 
//localparam  PCA9554_INPUT_PORT_REG_0      =   3'd0;
			//%Output Port 0 Register
//localparam  PCA9554_OUTPUT_PORT_REG_0     =   3'd2;
			//%Polarity Inversor Register Port 0
//localparam  PCA9554_POLARITY_INV_REG_0    =   3'd4;
			//%Configuration Register Port 0
//localparam  PCA9554_CONFIG_REG_0          =   3'd6;
			//%Input Port 1 Register
//localparam  PCA9554_INPUT_PORT_REG_1      =   3'd1;
			//%Output Port 1 Register
//localparam  PCA9554_OUTPUT_PORT_REG_1     =   3'd3;
			//%Polarity Inversor Register Port 1
//localparam  PCA9554_POLARITY_INV_REG_1    =   3'd5;
			//%Configuration Register Port 1
//localparam  PCA9554_CONFIG_REG_1          =   3'd7;

    
//State machine
                //% Idle State
//localparam      PCA9554_IDLE_STATE          =   5'd1;
                //% CMD State
//localparam      PCA9554_CMD_STATE           =   5'd2;
                //% Rx Data State
//localparam      PCA9554_RX_DATA_STATE       =   5'd4;
                //% Tx Data State
//localparam      PCA9554_TX_DATA_STATE       =   5'd8;
//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
                //%
wire            wnSDAOE;
                //%
wire            wRnW;
                //%
wire            wAddressMatch;
                //%
wire            wStartOk;
                //%
wire            wStopOk;
                //%
wire    [7:0]   wvRxData;
                //%
wire            wRxOk;
                //%
wire            wTxOk;
                //%Output Enable Register DataIn
reg     [7:0]   rnvOE0_d;
                //%Output Enable Register DataOut
reg     [7:0]   rnvOE0_q;
                //%Output Data 0 Register DataIn
reg     [7:0]   rvOut0Data_d;
                //%Output Data 0 Register DataOut
reg     [7:0]   rvOut0Data_q;
                //%Input Polarity 0 Register DataIn
reg     [7:0]   rvInput0Pol_d;
                //%Input Polarity 0 Register DataOut
reg     [7:0]   rvInput0Pol_q;
                //%Interrupt Register DataIn
reg             rnInt_d;
                //%Interrupt Register DataOut
reg             rnInt_q;
                //%Last Input Register DataIn
reg     [7:0]   rvLastInput0_d;
                //%Last Input Register DataOut
reg     [7:0]   rvLastInput0_q;
        //%PCA9555 is implemented

				//%Output Port 1 Register DataIn
reg     [7:0]   rvOut1Data_d;
				//%Output Port 1 Register DataOut
reg     [7:0]   rvOut1Data_q;
				//%Output Enable Register DataIn
reg     [7:0]   rnvOE1_d;
				//%Output Enable Register DataOut
reg     [7:0]   rnvOE1_q;
				//%Input Port 1 Polarity Register DataIn
reg     [7:0]   rvInput1Pol_d;
				//%Input Port 1 Polarity Register DataOut
reg     [7:0]   rvInput1Pol_q;
				//%Last Input Port 1 Register DataIn
reg     [7:0]   rvLastInput1_d; 
				//%Last Input Port 1 Register DataOut
reg     [7:0]   rvLastInput1_q;
				//%Tx Ok Flag Register DataIn
reg             rTxOk_d;
				//%Tx Ok Flag Register DataOut
reg             rTxOk_q;
                //%State Register DataIn
reg     [3:0]   rvState_d;
                //%State Register DataOut
reg     [3:0]   rvState_q;    
                //%Edge Signal Register DataIn
reg             rEdge_d;
                //%Edge Signal Register DataOut
reg             rEdge_q;
                //%Command Signal Register DataIn
reg     [2:0]   rvCmd_d;
                //%Command Signal Register DataOut
reg     [2:0]   rvCmd_q;
                //%Tx Data Register DataIn
reg     [7:0]   rvTxData_d;
                //%Tx Data Register DataOut
reg     [7:0]   rvTxData_q;
                //%General Acknowledge Register DataIn
reg             rGenAck_d;
                //%General Acknowledge Register DataOut
reg             rGenAck_q;

//////////////////////////////////////////////////////////////////////////////////
// Continous Assigments
//////////////////////////////////////////////////////////////////////////////////
assign  onIntOE     =       rnInt_q;
assign  ovIO0       =       rvOut0Data_q;
assign  onvOE0      =       rnvOE0_q;


assign  ovIO1   =       rvOut1Data_q;
assign  onvOE1  =       rnvOE1_q;
  
assign  onSDAOE     =       wnSDAOE;
//////////////////////////////////////////////////////////////////////////////////
// Sequential Logic
//////////////////////////////////////////////////////////////////////////////////
//% Sequential Logic
always @(posedge iClk or posedge iRst)
begin
    if(iRst)
    begin
        rvLastInput0_q       <=  ivIO0;                     
        rnvOE0_q             <=  8'hff; //Added by MM 5/9/2012          
        rvOut0Data_q         <=  8'hff; //Added by MM 5/9/2012 //Modified by JUANPO 4/13/2015         
        rvInput0Pol_q        <=  8'b0;
                       
		rvOut1Data_q         <=  8'hff;
		rnvOE1_q             <=  8'hff;
		rvInput1Pol_q        <=  8'b0;                    
		rvLastInput1_q       <= ivIO1;
		rTxOk_q               <= 1'b0;              
                         
        rnInt_q             <=  1'b1;
        rvState_q           <=  5'd1;
        rEdge_q             <=  1'b0;
        rvCmd_q             <=  3'b0;
        rvTxData_q          <=  8'b0;
        rGenAck_q           <=  1'b0;
    end
    else
    begin
        rvLastInput0_q        <=  rvLastInput0_d;          
        rnvOE0_q              <=  rnvOE0_d;          
        rvOut0Data_q          <=  rvOut0Data_d;          
        rvInput0Pol_q         <=  rvInput0Pol_d;
         
		rvLastInput1_q      <=  rvLastInput1_d;
		rnvOE1_q            <=  rnvOE1_d;
		rvOut1Data_q        <=  rvOut1Data_d;
		rvInput1Pol_q       <=  rvInput1Pol_d;
		rTxOk_q             <=  rTxOk_d;
		rnInt_q             <=  rnInt_d;
        rvState_q           <=  rvState_d;
        rEdge_q             <=  rEdge_d;
        rvCmd_q             <=  rvCmd_d;
        rvTxData_q          <=  rvTxData_d;
        rGenAck_q           <=  rGenAck_d;
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational Logic
//////////////////////////////////////////////////////////////////////////////////
//%Combinational Logic
always @*
begin
    rvLastInput0_d      =   rvLastInput0_q;     
    rvState_d           =   rvState_q;
    rEdge_d             =   wRxOk;
    rvCmd_d             =   rvCmd_q;
    rvTxData_d          =   rvTxData_q;
    rvInput0Pol_d       =   rvInput0Pol_q;     
    rnvOE0_d            =   rnvOE0_q;     
    rvOut0Data_d        =   rvOut0Data_q;
    rGenAck_d           =   (rvState_q != 5'd1);

    
	rvLastInput1_d      =   rvLastInput1_q;
	rvInput1Pol_d       =   rvInput1Pol_q;
	rnvOE1_d            =   rnvOE1_q;
	rvOut1Data_d        =   rvOut1Data_q;
	rTxOk_d             =   wTxOk;
    
    case(rvState_q)
        5'd2:
        begin
            if({rEdge_q,wRxOk} == 2'b01)
            begin
                //Capture Cmd
                rvCmd_d             =   wvRxData[2:0];
                rvState_d           =   5'd4;
            end
        end
        5'd8:
        begin
            //Set data
            
			if ({rTxOk_q,wTxOk} == 2'b01)
			begin
				rvCmd_d[0] = ~rvCmd_q[0];
				rTxOk_d = 1'b1;
			end
            
            case(rvCmd_q)                
                3'd2:
                begin
                    rvTxData_d  =   rvOut0Data_q;
                end
                3'd4:
                begin
                    rvTxData_d  =   rvInput0Pol_q;
                end
                3'd6:
                begin
                    rvTxData_d  =   rnvOE0_q;
                end                
                
				3'd3:
				begin
					rvTxData_d  =   rvOut1Data_q;
				end                
				3'd5:
				begin
					rvTxData_d  =   rvInput1Pol_q;
				end                
				3'd7:
				begin
					rvTxData_d  =   rnvOE1_q;
				end
				3'd1:
				begin
					rvTxData_d      =   (ivIO1 ^ rvInput1Pol_q);   //Added by MM 5/9/2012                        
					rvLastInput1_d  =  ivIO1; //Added by MM 5/9/2012
				end 
                       
                default:   //PCA9554_INPUT_PORT_REG_0:
                begin
                    rvTxData_d      =   (ivIO0 ^ rvInput0Pol_q);   //Added by MM 5/9/2012                        
                    rvLastInput0_d  =   ivIO0; //Added by MM 5/9/2012
                end                     
            endcase
        end
        5'd4:
        begin
            if({rEdge_q,wRxOk} == 2'b01)
            begin
                //Set data
                
                rvCmd_d[0] = ~rvCmd_q[0];
               
                
                case(rvCmd_q)
                   3'd6: 
                    begin
                        rnvOE0_d     =   wvRxData;  
                    end                    
                    3'd2:
                    begin
                        rvOut0Data_d        =   wvRxData;
                    end
                    3'd4:
                    begin
                        rvInput0Pol_d    =   wvRxData;
                    end        
                    
					3'd1:
					begin
						rvTxData_d  =   wvRxData;
					end 
					3'd3:
					begin
						rvOut1Data_d        =   wvRxData;
					end                
					3'd5:
					begin
						rvInput1Pol_d    =   wvRxData;
					end        
					3'd7: 
					begin
						rnvOE1_d     =   wvRxData;  
					end                    
                    
                    default: //PCA9554_INPUT_PORT_REG_0:
                    begin
                        rvTxData_d  =   wvRxData;
                    end 
                endcase
            end
        end
        default:
        begin
            rvState_d        =   5'd1;
            if(wAddressMatch)
            begin
                rvState_d       =   5'd2;            
                if(wRnW)
                begin
                    rvState_d    =    5'd8;
                end
            end
        end
    endcase

    rnInt_d         =   1'b1;
    
    if(((ivIO0 ^ rvLastInput0_q) & rnvOE0_q) || ((ivIO1 ^ rvLastInput1_q) & rnvOE1_q)) //Added by MM 5/9/2012
        begin
            rnInt_d     =   1'b0;
        end
    if((wStopOk)
        ||(wStartOk))
    begin
        rvState_d    =   5'd1;
    end
end

//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////
IICSlave_8Devices mIICSlave //% IIC Slave Module
(
    .iClk           (iClk), 
    .iRst           (iRst), 
    .iSDA           (iSDA), 
    .iSCL           (iSCL), 
    .ivTxData       (rvTxData_q), 
    .iTxAck         (rGenAck_q), 
    .onSDAOE        (wnSDAOE), 
    .oAddressMatch  (wAddressMatch), 
    .oStartOk       (wStartOk), 
    .oStopOk        (wStopOk), 
    .oRnW           (wRnW), 
    .ovRxData       (wvRxData), 
    .oRxAck         (),
    .oTxOk          (wTxOk), 
    .oRxOk          (wRxOk),
	.iModule_Address (iModule_Address)
);


//////////////////////////////////////////////////////////////////////////////////
endmodule