// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

`timescale 1ns/1ns  
//define//undef
`undef simul 

module Wilson_City_RP_Debug_PLD (

    // Input CLK
    input       CLK_25M_CKMNG_DEBUG_PLD,

    //GSX Interface with Mitibug
    output      SGPIO_PLD2_CLK_R, 
    output      SGPIO_PLD2_DOUT_R,
    output      SGPIO_PLD2_LD_N_R,
    input       SGPIO_PLD2_DIN_R,   // Not used since only dataout is active

    // Thermtrip DLY LED
    input       FM_THERMTRIP_DLY_R_DPLD, 
    output      LED_THERMTRIP_DLY, 

    // eSPI Latch control
    input       FM_ESPI_EN, 
    output      FM_ESPI_PLD_EN, 

    //Hot-Plug Support 
    input       FM_DISABLE_HOTPLUG,
    input       HP_LVC3_SLOTD_ATTN_OUT_SW_N, 
    output      HP_LVC3_SLOTD_EMIL, 
    output      HP_LVC3_SLOTD_EN, 
    input       HP_LVC3_SLOTD_FAULT_N, 
    input       HP_LVC3_SLOTD_MRL_SW_N,//
    input       HP_LVC3_SLOTD_PRSNT2_N, 
    output      LED_HP_SLOTD_ATTN, 
    output      LED_HP_SLOTD_PWR,

    input       SMB_PEHPCPU2_LVC3_SCL, 
    inout       SMB_PEHPCPU2_LVC3_SDA, 
	output      FM_SMB_CPU2_ALERT_N,

    // Power Sequence 
    input       FM_CPU_CATERR_DLY_LVT3_N_DPLD, 
    input       FM_DPLD_CLKS_OE_N, 
    input       FM_DPLD_DEV_EN, 
    input       FM_BMC_ONCTL_N_DPLD, 
    input       FM_PS_EN_DPLD, 
    input       PWRGD_CPUPWRGD_PLD_R_DPLD, 
    input       PWRGD_DRAMPWRGD_DPLD, 
    input       PWRGD_PCH_PWROK_R_DPLD, 
    input       PWRGD_PS_PWROK_PLD_R_DPLD, 
    input       PWRGD_SYS_PWROK_R_DPLD, 
    input       PWRGD_P3V3_AUX_PLD_R_DPLD, 
    input       RST_PLTRST_PLD_N_DPLD, 
    input       RST_RSMRST_N_DPLD, 
    input       RST_SRST_BMC_PLD_N_DPLD, 
    input       FM_SLP_SUS_PLD_N_DPLD, 
    input       FM_SLPS3_PLD_N_DPLD, 
    input       FM_SLPS4_PLD_N_DPLD,

    // SGPIO Debug Port
    input       SGPIO_DEBUG_PLD_CLK_R,
    input       SGPIO_DEBUG_PLD_DOUT_R,
    input       SGPIO_DEBUG_PLD_LD_N_R,
    output      SGPIO_DEBUG_PLD_DIN_R,

    // Backup SMBus Port - SML2 (No logic for this, HIZ SDA)
    input       SMB_PLD_SCL_DPLD,
    inout       SMB_PLD_SDA_DPLD
);

//////////////////////////////////////////////////////////////////////////////////
// Parameters
//////////////////////////////////////////////////////////////////////////////////
parameter  LOW =1'b0;
parameter  HIGH=1'b1;  
parameter  Z=1'bz;
parameter  FPGA_REV = 8'd00;
parameter  FPGA_REV_TEST = 8'd00;


//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
wire wClk_2M,wClk_3M;
wire wnSDAOE;
wire wRst_n;
wire w5uSCE;
wire w500uSCE;
wire w1mSCE;
wire wFM_ESPI_PLD_EN;
wire wFM_SMB_CPU2_ALERT_N;


////////////////////////////////////////////////////////////////////////////////// //
// Continuous assignments                                                          //
////////////////////////////////////////////////////////////////////////////////// //
assign wFM_ESPI_PLD_EN      = !RST_RSMRST_N_DPLD        ? FM_ESPI_EN    : wFM_ESPI_PLD_EN;
assign FM_ESPI_PLD_EN       = (wFM_ESPI_PLD_EN)         ? Z 	        : LOW;
assign FM_SMB_CPU2_ALERT_N  = (wFM_SMB_CPU2_ALERT_N)    ? Z 	        : LOW;
assign SMB_PLD_SDA_DPLD     = Z;


//////////////////////////////////////////////////////////////////////////////////
// Instances HW Dedicated 
//////////////////////////////////////////////////////////////////////////////////
`ifdef simul
assign wClk_2M = CLK_25M_CKMNG_DEBUG_PLD;
assign wClk_3M = CLK_25M_CKMNG_DEBUG_PLD;
`else
PLL_CLK PLL_CLK_inst (
    .inclk0 ( CLK_25M_CKMNG_DEBUG_PLD ),
    .c1 ( wClk_3M ),//3M
    .c2 ( wClk_2M )	//2M
);
`endif


//////////////////////////////////////////////////////////////////////////////////
// Global Reset
//////////////////////////////////////////////////////////////////////////////////
reset mReset (
	.PWRGD_P3V3_AUX(PWRGD_P3V3_AUX_PLD_R_DPLD),
	.iClk_2M(wClk_2M),
	.oRst_n(wRst_n)
);


//////////////////////////////////////////////////////////////////////////////////
// Clock generation and CE
//////////////////////////////////////////////////////////////////////////////////
//% Clock divider three - Generates the following synchronous clock enables: 5uS, 500uS and 1mS
ClkDivTree mClkDivTree
(
    .iClk       ( wClk_2M  ),
    .iRst       ( ~wRst_n  ),
    .o5uSCE     ( w5uSCE   ),
    .o500uSCE   ( w500uSCE ),
    .o1mSCE     ( w1mSCE   )
);  


/***************************************************************************
*                         HOT PLUG LOGIC FOR CPU2                          *
****************************************************************************
*           All CPU2 HP addresses Port0: Slot D                            *
*           All CPU2 HP addresses Port1: Virtualized Port                  *
****************************************************************************/
//Signals for input/output register of PCA9555 instance
wire[7:0]   ioExpanderOutput0;
wire[7:0]   ioExpanderInput0;
wire[7:0]   ioExpanderOutput1;
wire[7:0]   ioExpanderInput1;
wire wPwrEnCPU2Port0;
wire wnQnegCPU2Port0;

//This signal is an output from the PCA9555. Will be used to toggle SDA when sending information and will be left as 'Z' when receiving information
wire    sda_oe_n;
wire    wSDA_Filter;
wire    wSCL_Filter;

//Byte 1 of PCA9555 won't be used, but it will be initialized within the module.
assign  ioExpanderInput1[7] = ioExpanderOutput1[7];
assign  ioExpanderInput1[6] = 1'b1;
assign  ioExpanderInput1[5] = 1'b1;
assign  ioExpanderInput1[4] = 1'b1;
assign  ioExpanderInput1[3] = 1'b1;
assign  ioExpanderInput1[2] = ioExpanderOutput1[2];
assign  ioExpanderInput1[1] = ioExpanderOutput1[1];
assign  ioExpanderInput1[0] = ioExpanderOutput1[0];

//Input register assignment. Byte 0 used for Slot D Hot Plug
assign  ioExpanderInput0[7] = ioExpanderOutput0[7];
assign  ioExpanderInput0[6] = ( (wnQnegCPU2Port0 | ~wPwrEnCPU2Port0) && HP_LVC3_SLOTD_MRL_SW_N );
assign  ioExpanderInput0[5] = HP_LVC3_SLOTD_FAULT_N;
assign  ioExpanderInput0[4] = HP_LVC3_SLOTD_PRSNT2_N;
assign  ioExpanderInput0[3] = HP_LVC3_SLOTD_ATTN_OUT_SW_N;
assign  ioExpanderInput0[2] = ioExpanderOutput0[2];
assign  ioExpanderInput0[1] = ioExpanderOutput0[1];
assign  ioExpanderInput0[0] = ioExpanderOutput0[0];

//Output signal assignment
assign  HP_LVC3_SLOTD_EMIL  = ioExpanderOutput0[7];
assign  wPwrEnCPU2Port0     = ioExpanderOutput0[2];
assign  LED_HP_SLOTD_PWR    = ioExpanderOutput0[1];
assign  LED_HP_SLOTD_ATTN   = ioExpanderOutput0[0];

//SDA Output Logic
assign 	HP_LVC3_SLOTD_EN = wPwrEnCPU2Port0 & ~HP_LVC3_SLOTD_PRSNT2_N;
assign  SMB_PEHPCPU2_LVC3_SDA = (!sda_oe_n) ? 1'b0 : 1'bz;

InvertedDFF invertedDFFCPU2Port0(.CLK(HP_LVC3_SLOTD_EMIL), .RST_N(wRst_n), .D(wnQnegCPU2Port0), .QNEG(wnQnegCPU2Port0));

//PCA9555 Instantiation
PCA9555_8Devices  IOExpander
(
    .iModule_Address(7'b0100101),//SMBus: 0x4A, I2C: 0x25
    .iClk(wClk_3M),
    .iRst( ~(wRst_n & !FM_DISABLE_HOTPLUG) ),
    .ivIO0(ioExpanderInput0),
    .ovIO0(ioExpanderOutput0),
    .onvOE0(),
    .iSCL(wSCL_Filter),
    .iSDA(wSDA_Filter),
    .onSDAOE(sda_oe_n),
    .ivIO1(ioExpanderInput1),
    .ovIO1(ioExpanderOutput1),
    .onvOE1(),
    .onIntOE( wFM_SMB_CPU2_ALERT_N )
);

GlitchFilter #(.TOTAL_STAGES(3)) mGlitchFilterSDA
(               
    .iClk   ( wClk_3M ),
    .iRst   ( ~wRst_n ),
    .iCE    ( 1'b1 ),
    .iSignal (SMB_PEHPCPU2_LVC3_SDA),
    .oGlitchlessSignal ( wSDA_Filter )
);

GlitchFilter #(.TOTAL_STAGES(3)) mGlitchFilterSCL
(               
    .iClk   ( wClk_3M ),
    .iRst   ( ~wRst_n ),
    .iCE    ( 1'b1 ),
    .iSignal (SMB_PEHPCPU2_LVC3_SCL),
    .oGlitchlessSignal ( wSCL_Filter )
);

//////////////////////////////////////////////////////////////////////////////////
// THERMTRIP Latcher
//////////////////////////////////////////////////////////////////////////////////
wire wCPUPwrGd_Dly;

//% CPUPWRGD 1.5ms delay
SignalValidationDelay#
(
    .VALUE                  ( 1'd1 ),
    .TOTAL_BITS             ( 4'd4 ),
    .POL                    ( 1'd1 )
)mThermTripDly            
(           
    .iClk                   ( wClk_2M ),
    .iRst                   ( ~wRst_n ),
    .iCE                    ( w500uSCE ),
    .ivMaxCnt               ( 3'd4 ),    // 500us * 3 = 1.5ms this because thermtrip condition is only valid after 1.5 ms
    .iStart                 ( PWRGD_CPUPWRGD_PLD_R_DPLD ),
    .oDone                  ( wCPUPwrGd_Dly )
);

SingleLatcher#
(
    .EDGELATCH         ( 1'b1 ) 
)mLatchThermTrip_N_CPU1
(
    .iClk                   ( wClk_2M  ),
    .iRst_n                 ( wRst_n   ),

    .iEnableLatch           ( wCPUPwrGd_Dly && RST_PLTRST_PLD_N_DPLD    ),//Enable latch /
    .iSignalLatch           ( wCPUPwrGd_Dly && FM_THERMTRIP_DLY_R_DPLD  ),

    .oSignalLatched         ( LED_THERMTRIP_DLY )
);


//////////////////////////////////////////////////////////////////////////////////
// Serial for Mitibug 
//////////////////////////////////////////////////////////////////////////////////
wire [23:0] wGSX_Master_Mitibug;
GSX_Master #
(
    .TOTAL_OUTPUT_MODULES( 2'd3 )
) mGSX_Master_Mitibug
(
    .iClk(wClk_2M),                 //% 2MHz Reference Clock
    .iCE(w5uSCE),                   //% Chip enable to generate oSClock. 10uS to generate 100KHz SClock
    .iReset(wRst_n),                //% Input reset.

    .oSClock(SGPIO_PLD2_CLK_R),     //% Output clock.
    .oSLoad(SGPIO_PLD2_LD_N_R),     //% Output Last clock of a bit stream; begin a new bit stream on the next clock.
    .oSDataOut(SGPIO_PLD2_DOUT_R),  //% Input serial data bit stream.
    .iSDataIn(SGPIO_PLD2_DIN_R),    //% Output serial data bit stream.

    .ovDataIn( wGSX_Master_Mitibug ),                   //% Data receive vector. Master receives using DataIn. At Modular PPO baseboard, no data is pretended to be received from Global PLD
    .ivDataOut( {
                    // Third Byte 
                    FM_SLPS4_PLD_N_DPLD,                //7
                    FM_SLPS3_PLD_N_DPLD,                //6
                    FM_SLP_SUS_PLD_N_DPLD,              //5
                    RST_SRST_BMC_PLD_N_DPLD,            //4
                    RST_RSMRST_N_DPLD,                  //3
                    RST_PLTRST_PLD_N_DPLD,              //2
                    PWRGD_P3V3_AUX_PLD_R_DPLD,          //1
                    PWRGD_SYS_PWROK_R_DPLD,             //0
                    
                    // Second Byte
                    PWRGD_PS_PWROK_PLD_R_DPLD,          //7
                    PWRGD_PCH_PWROK_R_DPLD,             //6
                    PWRGD_DRAMPWRGD_DPLD,               //5
                    PWRGD_CPUPWRGD_PLD_R_DPLD,          //4
                    FM_PS_EN_DPLD,                      //3
                    FM_BMC_ONCTL_N_DPLD,                //2
                    FM_DPLD_DEV_EN,                     //1
                    FM_DPLD_CLKS_OE_N,                  //0

                    // First Byte
                    FM_CPU_CATERR_DLY_LVT3_N_DPLD,      //7
                    wFM_ESPI_PLD_EN,                    //6
                    FM_THERMTRIP_DLY_R_DPLD,            //5
                    5'b00000                            //4:0
               } )     //% Data transmit vector. Master transmits using DataOut
);


//////////////////////////////////////////////////////////////////////////////////
// DEBUG GSX PORT - Debug PLD Slave
//////////////////////////////////////////////////////////////////////////////////
wire [23:0] wGSX_Master_From_MainPLD;
GSX_Slave #
(
  .TOTAL_OUTPUT_MODULES( 2'd3 )
) mGSX_Slave_Node1
(
    .iClk(wClk_2M),                       //% 2MHz Reference Clock
    .iReset(wRst_n),                      //% Input reset.
    .i1mSCE(w1mSCE),                      //An input for reset detect

    .iSClock(SGPIO_DEBUG_PLD_CLK_R),        //% Input clock.
    .iSLoad(SGPIO_DEBUG_PLD_LD_N_R),        //% Input Last clock of a bit stream; begin a new bit stream on the next clock
    .iSDataOut(SGPIO_DEBUG_PLD_DOUT_R),     //% Input serial data bit stream.
    .oSDataIn(SGPIO_DEBUG_PLD_DIN_R),       //% Output serial data bit stream.
    
    //% Data receive vector.  Slave receives using DataOut.
    .ovDataOut  ({
                    //Third Byte
                    wGSX_Master_From_MainPLD[23:16],    // 8    23-16

                    // Second Byte
                    wGSX_Master_From_MainPLD[15:8],     // 8    15-8

                    // First Byte 
                    wGSX_Master_From_MainPLD[7:0]       // 8    0-7
                }),
    //% Data transmit vector. Slave transmits using DataIn.
    .ivDataIn   ({     
                    8'hAA,          // SGPIO [23:16]      - Third byte
                    FPGA_REV_TEST,  // SGPIO [15:8]       - Second Byte
                    FPGA_REV        // SGPIO [7:0]        - First Byte
                })
);

endmodule // Wilson_City_RP_Debug_PLD

