`timescale 1ns / 1ps
// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module GSX_Master_TB;

	reg 	  iReset;
	reg       iSClock;
	reg [23:0] ivTxData;

	
	wire		oSDataOut;
	wire		oSLoad;


GSX_Master uut(
	.iReset(iReset),
	.iSClock(iSClock),
	.ivTxData(ivTxData),
	
	.oSDataOut(oSDataOut),
	.oSLoad(oSLoad)
);
	initial 
		begin		
		iReset = 1;	
		ivTxData =24'd00;	
		#100
		iReset = 0; 
		ivTxData =24'b00001111_00001111_01010101;
		#1000
		ivTxData =24'b11111111_10000001_01010101;
		#1000		
		$stop;
		end

	initial 
		begin
			iSClock =0;
			forever #0.5 iSClock = ! iSClock;  //2.08MHz Clk
		end

endmodule