#//START_MODULE_HEADER/////////////////////////////////////////////////////////
#
# Description: This makefile fragment support coverity scan on firmware code base
#
# Authors:     Alex Teoh
#
#              Copyright (c)  Intel Corporation 2019
#              All rights reserved.
#
#//END_MODULE_HEADER///////////////////////////////////////////////////////////

BCOMMON_COVERITY_MK_ABSPATH := $(abspath $(lastword $(MAKEFILE_LIST)))
BCOMMON_COVERITY_MK_DIR := $(notdir $(patsubst %/,%,$(dir $(BCOMMON_COVERITY_MK_ABSPATH))))

SHELL := /bin/bash

# Enable second expansion
.SECONDEXPANSION:
# Clear all built in suffixes
.SUFFIXES:
.DELETE_ON_ERROR:

##############################################################################
# Coverity Configurations
##############################################################################
FW_SRC_DIR := $(BCOMMON_COVERITY_MK_DIR)/../code/hw/wilson_city_fab2

COV_RAW_OUTPUT_DIR := $(BCOMMON_COVERITY_MK_DIR)/../coverity_raw_results
COV_BASIC_OUTPUT_DIR := $(BCOMMON_COVERITY_MK_DIR)/../coverity_basic_rules_results
COV_MISRA_OUTPUT_DIR := $(BCOMMON_COVERITY_MK_DIR)/../coverity_misra_c_rules_results

ifeq ($(ARC_PICE), 1)
COV_CONFIG_DIR := $(PSG_EDA_TOOLS)/synopsys/coverity/current/linux64/config/
COV_DC_CONFIG := $(PSG_EDA_TOOLS)/synopsys/coverity/current/linux64/custom-checker/intel_banned_functions.json
else
COV_CONFIG_DIR := $(ARC_TOOLS)/coverity/current/linux64/config/
COV_DC_CONFIG := $(ARC_TOOLS)/coverity/current/linux64/custom-checker/intel_banned_functions.json
endif
COV_CONFIG := $(COV_CONFIG_DIR)/coverity_nios2elfgcc_config.xml
COV_RULESET := $(BCOMMON_COVERITY_MK_DIR)/coverity_misra_c_rules.config

COV_BASIC_RULES := --security --enable BAD_COMPARE --enable BAD_SIZEOF --enable BUFFER_SIZE --enable CHROOT --enable DC.STREAM_BUFFER --enable DC.STRING_BUFFER --enable DC.WEAK_CRYPTO --enable OPEN_ARGS --enable OVERRUN --enable READLINK --enable SECURE_TEMP --enable STRING_NULL --enable STRING_OVERFLOW --enable STRING_SIZE --enable TAINTED_SCALAR --enable TAINTED_STRING --enable UNINIT --enable USE_AFTER_FREE --enable USER_POINTER --enable BAD_ALLOC_STRLEN --enable ORDER_REVERSAL --dc-config $(COV_DC_CONFIG) --enable DC.CUSTOM_STRCPY_VARIANTS --enable DC.CUSTOM_STRCAT_VARIANTS --enable DC.CUSTOM__SNWPRINTF_VARIANTS --enable DC.CUSTOM_WVSPRINTF_VARIANTS --enable DC.CUSTOM__MAKEPATH_VARIANTS --enable DC.CUSTOM__SPLITPATH_VARIANTS --enable DC.CUSTOM_SNSCANF_VARIANTS --enable DC.CUSTOM_GETS_VARIANTS --enable DC.CUSTOM_STRLEN_VARIANTS --enable DC.CUSTOM_MEMCPY_VARIANTS --enable DC.CUSTOM_ISBADWRITEPTR_VARIANTS --enable DC.CUSTOM_CHARTOOEM_VARIANTS --enable DC.CUSTOM_ALLOCA_VARIANTS --enable DC.CUSTOM_VSPRINTF_VARIANTS --enable DC.CUSTOM__ITOA_VARIANTS --enable CTOR_DTOR_LEAK --enable OVERFLOW_BEFORE_WIDEN --enable REVERSE_NEGATIVE --enable WRAPPER_ESCAPE

##############################################################################
# Targets
##############################################################################

.PHONY: cov-pass
cov-pass: 
	$(MAKE) coverity-build 
	$(MAKE) coverity-misra-analyze
	$(MAKE) coverity-basic-analyze | tee coverity_analysis_with_basic_rules.txt
	@echo "INFO: This target fails if there is any defect(s) found in coverity scan with basic ruleset."
	grep 'Detected 0 defect occurrences' coverity_analysis_with_basic_rules.txt

.PHONY: coverity-build
coverity-build: 
	cov-run-desktop --config $(COV_CONFIG) --dir $(COV_RAW_OUTPUT_DIR) --disconnected --record-with-source --build $(MAKE) -C $(FW_SRC_DIR) COMPILER=nios2elfgcc

.PHONY: coverity-basic-analyze
coverity-basic-analyze: 
	cov-run-desktop --disconnected --whole-program --analyze-captured-source --config $(COV_CONFIG) --dir $(COV_RAW_OUTPUT_DIR) $(COV_BASIC_RULES)
	cov-format-errors --dir $(COV_RAW_OUTPUT_DIR) --html-output $(COV_BASIC_OUTPUT_DIR)
	cov-manage-emit --dir $(COV_RAW_OUTPUT_DIR) list

.PHONY: coverity-misra-analyze
coverity-misra-analyze:
# Using the same options as PSG Firmware build
	cov-run-desktop --disconnected --whole-program --analyze-captured-source --config $(COV_CONFIG) --dir $(COV_RAW_OUTPUT_DIR) --aggressiveness-level low --security --misra-config $(COV_RULESET)
	cov-format-errors --dir $(COV_RAW_OUTPUT_DIR) --html-output $(COV_MISRA_OUTPUT_DIR)
	cov-manage-emit --dir $(COV_RAW_OUTPUT_DIR) list

