// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

/**
 * @file pbc_utils.h
 * @brief This header file contains functions to work with PBC structure.
 */

#ifndef WHITLEY_INC_PBC_UTILS_H_
#define WHITLEY_INC_PBC_UTILS_H_

// Always include pfr_sys.h first
#include "pfr_sys.h"

#include "pbc.h"
#include "pfr_pointers.h"

/**
 * @brief Return the size of the bitmap in bytes. 
 * 
 * @param pbc pointer to the start of a PBC_HEADER structure
 * @return alt_u32 the size of the bitmap in bytes
 */
static PFR_ALT_INLINE alt_u32 PFR_ALT_ALWAYS_INLINE get_bitmap_size(PBC_HEADER* pbc)
{
    return pbc->bitmap_nbit / 8;
}

/**
 * @brief Return the pointer to the active bitmap in PBC. 
 * 
 * @param pbc pointer to the start of a PBC_HEADER structure
 * @return alt_u32* the pointer to the active bitmap in PBC
 */
static PFR_ALT_INLINE alt_u32* PFR_ALT_ALWAYS_INLINE get_active_bitmap(PBC_HEADER* pbc)
{
    return (alt_u32*) (pbc + 1);
}

/**
 * @brief Return the pointer to the compression bitmap in PBC. 
 * 
 * @param pbc pointer to the start of a PBC_HEADER structure
 * @return alt_u32* the pointer to the compression bitmap in PBC
 */
static alt_u32* get_compression_bitmap(PBC_HEADER* pbc)
{
    alt_u32* active_bitmap_addr = get_active_bitmap(pbc);
    return incr_alt_u32_ptr(active_bitmap_addr, get_bitmap_size(pbc));
}

/**
 * @brief Return the pointer to the compressed payload in PBC. 
 * 
 * @param pbc pointer to the start of a PBC_HEADER structure
 * @return alt_u32* the pointer to the compressed payload in PBC
 */
static alt_u32* get_compressed_payload(PBC_HEADER* pbc)
{
    alt_u32* compression_bitmap_addr = get_compression_bitmap(pbc);
    return incr_alt_u32_ptr(compression_bitmap_addr, get_bitmap_size(pbc));
}

#endif /* WHITLEY_INC_PBC_UTILS_H_ */
