// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

/**
 * @file rfnvram.h
 * @brief Define macros and structs that eases RFNVRAM IP access.
 */

#ifndef WHITLEY_INC_RFNVRAM_H_
#define WHITLEY_INC_RFNVRAM_H_

// Always include pfr_sys.h first
#include "pfr_sys.h"


#define U_RFNVRAM_SMBUS_MASTER_ADDR __IO_CALC_ADDRESS_NATIVE_ALT_U32(U_RFNVRAM_SMBUS_MASTER_BASE, 0)
#define RFNVRAM_RX_FIFO U_RFNVRAM_SMBUS_MASTER_ADDR + 1
#define RFNVRAM_TX_FIFO_BYTES_LEFT U_RFNVRAM_SMBUS_MASTER_ADDR + 6
#define RFNVRAM_RX_FIFO_BYTES_LEFT U_RFNVRAM_SMBUS_MASTER_ADDR + 7
#define RFNVRAM_SMBUS_ADDR 0xDC
#define RFNVRAM_INTERNAL_SIZE 1088
#define RFNVRAM_IDLE_MASK 0x100

// The PIT password stored in the external RFNVRAM is written at offset 0x0160:0x0167 inside the RFID component.
#define RFNVRAM_PIT_PASSWORD_OFFSET 0x0160
#define RFNVRAM_PIT_PASSWORD_MSB_OFFSET ((RFNVRAM_PIT_PASSWORD_OFFSET & 0xff00) >> 8)
#define RFNVRAM_PIT_PASSWORD_LSB_OFFSET (RFNVRAM_PIT_PASSWORD_OFFSET & 0xff)
#define RFNVRAM_PIT_PASSWORD_LENGTH 8

#endif /* WHITLEY_INC_RFNVRAM_H_ */
