// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

/**
 * @file spi_flash_state.h
 * @brief Track the state of SPI flash devices.
 */

#ifndef WHITLEY_INC_SPI_FLASH_STATE_H_
#define WHITLEY_INC_SPI_FLASH_STATE_H_

// Always include pfr_sys.h first
#include "pfr_sys.h"

#include "spi_common.h"

/**
 * Define the state that BMC/PCH flash may be in
 */
typedef enum
{
    SPI_FLASH_STATE_ACTIVE_FAILED_AUTH_MASK           = 0b1,
    SPI_FLASH_STATE_RECOVERY_FAILED_AUTH_MASK         = 0b10,
    SPI_FLASH_STATE_ACTIVE_UPDATE_IN_PROGRESS_MASK    = 0b100,
    SPI_FLASH_STATE_RECOVERY_UPDATE_IN_PROGRESS_MASK  = 0b1000,
    SPI_FLASH_STATE_REQUIRE_WDT_RECOVERY_MASK         = 0b10000,
    // Combination of the above
    SPI_FLASH_STATE_ALL_REGIONS_FAILED_AUTH_MASK      = 0b11,
} SPI_FLASH_STATE_MASK_ENUM;

// Static variables to track the state of flash devices
static alt_u8 bmc_flash_state = 0;
static alt_u8 pch_flash_state = 0;

/******************************************************
 *
 * Helper functions to work with the static variables
 *
 ******************************************************/

/**************************
 * State settings
 **************************/
static void clear_spi_flash_state(SPI_FLASH_TYPE_ENUM spi_flash_type, SPI_FLASH_STATE_MASK_ENUM state)
{
    if (spi_flash_type == SPI_FLASH_BMC)
    {
        bmc_flash_state &= ~((alt_u32) state);
    }
    else // spi_flash_type == SPI_FLASH_PCH
    {
        pch_flash_state &= ~((alt_u32) state);
    }
}

static alt_u32 check_spi_flash_state(SPI_FLASH_TYPE_ENUM spi_flash_type, SPI_FLASH_STATE_MASK_ENUM state)
{
    if (spi_flash_type == SPI_FLASH_BMC)
    {
        return (bmc_flash_state & state) == state;
    }
    // spi_flash_type == SPI_FLASH_PCH
    return (pch_flash_state & state) == state;
}

static void set_spi_flash_state(SPI_FLASH_TYPE_ENUM spi_flash_type, SPI_FLASH_STATE_MASK_ENUM state)
{
    if (spi_flash_type == SPI_FLASH_BMC)
    {
        bmc_flash_state |= state;
    }
    else // spi_flash_type == SPI_FLASH_PCH
    {
        pch_flash_state |= state;
    }
}

#endif /* WHITLEY_INC_SPI_FLASH_STATE_H_ */
