// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

/**
 * @file test_global_state.h
 * @brief Helper functions that deal with global state registers for the simulations
 */


#ifndef INC_TEST_GLOBAL_STATE_H_
#define INC_TEST_GLOBAL_STATE_H_

// Always include pfr_sys.h first
#include "pfr_sys.h"

#include "global_state.h"

#define PFR_GLOBAL_STATE_TEST_DONE_BIT 31
#define PFR_GLOBAL_STATE_TEST_PASSED_BIT 30

/**
 * @brief Return the value in the global state register
 *
 * @return alt_u32 global state
 */
static PFR_ALT_INLINE alt_u32 PFR_ALT_ALWAYS_INLINE get_global_state()
{
    return IORD_32DIRECT(U_GLOBAL_STATE_REG_ADDR, 0);
}

/**
 * @brief Clear the global state register. This has the effect of also clearing
 * the testing only state bits
 *
 */
static PFR_ALT_INLINE void PFR_ALT_ALWAYS_INLINE clear_global_state()
{
    IOWR(U_GLOBAL_STATE_REG_BASE, 0, (alt_u32) 0);
}

/**
 * @brief Set the global state test-only bits to indicate test passed
 *
 */
static PFR_ALT_INLINE void PFR_ALT_ALWAYS_INLINE set_global_state_test_passed()
{
    set_bit(U_GLOBAL_STATE_REG_ADDR, PFR_GLOBAL_STATE_TEST_PASSED_BIT);
}

/**
 * @brief Set the global state test-only bits to indicate test done
 *
 */
static PFR_ALT_INLINE void PFR_ALT_ALWAYS_INLINE set_global_state_test_done()
{
    set_bit(U_GLOBAL_STATE_REG_ADDR, PFR_GLOBAL_STATE_TEST_DONE_BIT);
}

#endif /* INC_TEST_GLOBAL_STATE_H_ */
