// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

/**
 *
 * @file test_main.h
 * @brief mainline for simulation tests
 */

// Always include pfr_sys.h first
#include "pfr_sys.h"

#include "gen_gpo_controls.h"
#include "utils.h"

#include "test_global_state.h"


// Test framework for toplevel simulation tests benches

// Forward declare test_main. This needs to be implemented by the actual test main.c
int test_main();

// DONT MODIFY THIS. COMMON FOR ALL TESTS
int main()
{
    // Clear global state
    clear_global_state();

    set_global_state(PLATFORM_STATE_CPLD_NIOS_STARTED);

    ////////////////////////////////////////////////////
    // Signaling for the testbench
    ////////////////////////////////////////////////////
    // Wait for ready from common core
    while (!check_bit((alt_u32*) U_GPI_1_BASE, 0)){}

    // Release reset on BMC
    set_bit((alt_u32*) U_GPO_1_BASE, GPO_1_RST_SRST_BMC_PLD_R_N);

    // Release reset on PCH
    set_bit((alt_u32*) U_GPO_1_BASE, GPO_1_RST_RSMRST_PLD_R_N);
    ////////////////////////////////////////////////////
    ////////////////////////////////////////////////////

    // Call the test function
    if (test_main())
    {
        // Set test passed
        set_global_state_test_passed();
    }

    // Set test done
    set_global_state_test_done();

    //////////////////////////////////////////////////////////
    // Terminal state
    never_exit_loop();

    return 0;
}
