// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"

#include "gen_gpo_controls.h"
#include "crypto.h"

#include "test_main.h"

// ###################################################################################################################################
// Generating pattern 0 of 128 bytes (1024 bits)
// Test Data block 0:
// 1024'h44BD5317988365A3924CD72EE0C8EC394024F6236D173B3BE4F3EFCB510B34CA9EF2F3BFF6C48E2AD772580FB27D4160AB8F26B1B61D876C6C73F75A1F789CFFE4D3DB20751AF87E9172E9A75BDC99FD964108B7E7B7D2F43F065AA5FEEEDE899CE34E4C4B136CB8F8ADF8B3538731231CA87A01425299B7DC7B7E0522C859EC
// Digest : 256'hA37C4FD5F1F46D462091B9E92D22C6E9CE3097EFE9CD4B25E8F23A2DDD36DDFC
// Generating curve
// Using curve prime256v1
// Generating private key
// Private Key:
//		256'hA07DF98A6BE1EA1E6B9C132E4E04A5AB652AEB7A660BC447943B56E7B8B62F19
// Pubkey:
//	CX : 256'hCD021AE9F1D8D74B4B11ABF9667CCE94
//	CY : 256'h8F09B8B0EB68B4D9D447A39EDD1F3A0A

// echo
// "44BD5317988365A3924CD72EE0C8EC394024F6236D173B3BE4F3EFCB510B34CA9EF2F3BFF6C48E2AD772580FB27D4160AB8F26B1B61D876C6C73F75A1F789CFFE4D3DB20751AF87E9172E9A75BDC99FD964108B7E7B7D2F43F065AA5FEEEDE899CE34E4C4B136CB8F8ADF8B3538731231CA87A01425299B7DC7B7E0522C859EC"
// | xxd -r -p | openssl dgst -sha256 (stdin)=
// a37c4fd5f1f46d462091b9e92d22c6e9ce3097efe9cd4b25e8f23a2ddd36ddfc

// Generate for C:
// echo
// "44BD5317988365A3924CD72EE0C8EC394024F6236D173B3BE4F3EFCB510B34CA9EF2F3BFF6C48E2AD772580FB27D4160AB8F26B1B61D876C6C73F75A1F789CFFE4D3DB20751AF87E9172E9A75BDC99FD964108B7E7B7D2F43F065AA5FEEEDE899CE34E4C4B136CB8F8ADF8B3538731231CA87A01425299B7DC7B7E0522C859EC"
// | xxd -r -p | xxd -i echo "A37C4FD5F1F46D462091B9E92D22C6E9CE3097EFE9CD4B25E8F23A2DDD36DDFC" |
// xxd -r -p | xxd -i

// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    alt_u32 td_sha_data_len = 128;
    alt_u8 td_crypto_data[128] = {
    0x44, 0xbd, 0x53, 0x17, 0x98, 0x83, 0x65, 0xa3, 0x92, 0x4c, 0xd7, 0x2e, 0xe0, 0xc8, 0xec, 0x39,
    0x40, 0x24, 0xf6, 0x23, 0x6d, 0x17, 0x3b, 0x3b, 0xe4, 0xf3, 0xef, 0xcb, 0x51, 0x0b, 0x34, 0xca,
    0x9e, 0xf2, 0xf3, 0xbf, 0xf6, 0xc4, 0x8e, 0x2a, 0xd7, 0x72, 0x58, 0x0f, 0xb2, 0x7d, 0x41, 0x60,
    0xab, 0x8f, 0x26, 0xb1, 0xb6, 0x1d, 0x87, 0x6c, 0x6c, 0x73, 0xf7, 0x5a, 0x1f, 0x78, 0x9c, 0xff,
    0xe4, 0xd3, 0xdb, 0x20, 0x75, 0x1a, 0xf8, 0x7e, 0x91, 0x72, 0xe9, 0xa7, 0x5b, 0xdc, 0x99, 0xfd,
    0x96, 0x41, 0x08, 0xb7, 0xe7, 0xb7, 0xd2, 0xf4, 0x3f, 0x06, 0x5a, 0xa5, 0xfe, 0xee, 0xde, 0x89,
    0x9c, 0xe3, 0x4e, 0x4c, 0x4b, 0x13, 0x6c, 0xb8, 0xf8, 0xad, 0xf8, 0xb3, 0x53, 0x87, 0x31, 0x23,
    0x1c, 0xa8, 0x7a, 0x01, 0x42, 0x52, 0x99, 0xb7, 0xdc, 0x7b, 0x7e, 0x05, 0x22, 0xc8, 0x59, 0xec};

    alt_u8 td_expected_hash[PFR_CRYPTO_LENGTH] = {
    0xa3, 0x7c, 0x4f, 0xd5, 0xf1, 0xf4, 0x6d, 0x46, 0x20, 0x91, 0xb9, 0xe9, 0x2d, 0x22, 0xc6, 0xe9,
    0xce, 0x30, 0x97, 0xef, 0xe9, 0xcd, 0x4b, 0x25, 0xe8, 0xf2, 0x3a, 0x2d, 0xdd, 0x36, 0xdd, 0xfc};

    return verify_sha((alt_u32*) td_expected_hash, (alt_u32*) td_crypto_data, td_sha_data_len);
}
