// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"

#include "gen_gpo_controls.h"
#include "dual_config_utils.h"
#include "test_main.h"

static PFR_ALT_INLINE alt_u32 PFR_ALT_ALWAYS_INLINE test_basic_dual_config()
{
    // At first Dual Config IP busy bit should be 0
    if (IORD(U_DUAL_CONFIG_BASE, 3) != 0x0)
    {
        return 0;
    }

    // request all available information on the current and previous configuration state
    IOWR(U_DUAL_CONFIG_BASE, 2, 0xf);

    if (IORD(U_DUAL_CONFIG_BASE, 3) != 0x1)
    {
        return 0;
    }

    // Wait till IP complete it's operation
    poll_on_dual_config_ip_busy_bit();

    if (IORD(U_DUAL_CONFIG_BASE, 3) != 0x0)
    {
        return 0;
    }

    return 1;
}

// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    return test_basic_dual_config();
}