// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"

#include "gen_gpo_controls.h"
#include "mailbox_utils.h"

#include "test_main.h"

int test_mailbox_rw(alt_u32 word_offset, alt_u32 write_val)
{
    write_to_mailbox(word_offset, write_val);
    alt_u32 read_val = read_from_mailbox(word_offset);
    if (read_val != write_val)
        return 0;

    return 1;
}

// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    // Make sure we can read from/write to all address in the register file

    if (!test_mailbox_rw(MB_CPLD_STATIC_ID, 0xDE))
        return 0;
    if (!test_mailbox_rw(MB_CPLD_RELEASE_VERSION, 0x03))
        return 0;
    if (!test_mailbox_rw(MB_CPLD_SVN, 0x02))
        return 0;
    if (!test_mailbox_rw(MB_PLATFORM_STATE, 0x0A))
        return 0;
    if (!test_mailbox_rw(MB_RECOVERY_COUNT, 0x04))
        return 0;
    if (!test_mailbox_rw(MB_LAST_RECOVERY_REASON, 0x01))
        return 0;
    if (!test_mailbox_rw(MB_PANIC_EVENT_COUNT, 0x06))
        return 0;
    if (!test_mailbox_rw(MB_LAST_PANIC_REASON, 0x00))
        return 0;
    if (!test_mailbox_rw(MB_PROVISION_STATUS, 0x01))
        return 0;
    if (!test_mailbox_rw(MB_PROVISION_CMD, 0x01))
        return 0;
    if (!test_mailbox_rw(MB_UFM_CMD_TRIGGER, 0x00))
        return 0;
    if (!test_mailbox_rw(MB_ACM_CHECKPOINT, 0xAC))
        return 0;
    if (!test_mailbox_rw(MB_BIOS_CHECKPOINT, 0xDC))
        return 0;
    if (!test_mailbox_rw(MB_BMC_CHECKPOINT, 0xB8))
        return 0;
    if (!test_mailbox_rw(MB_PCH_UPDATE_INTENT, 0x1A))
        return 0;
    if (!test_mailbox_rw(MB_BMC_UPDATE_INTENT, 0x2B))
        return 0;
    if (!test_mailbox_rw(MB_PCH_PFM_ACTIVE_SVN, 0x09))
        return 0;
    if (!test_mailbox_rw(MB_PCH_PFM_ACTIVE_MAJOR_VER, 0x02))
        return 0;
    if (!test_mailbox_rw(MB_PCH_PFM_ACTIVE_MINOR_VER, 0x01))
        return 0;
    if (!test_mailbox_rw(MB_BMC_PFM_ACTIVE_MAJOR_VER, 0x02))
        return 0;
    if (!test_mailbox_rw(MB_BMC_PFM_ACTIVE_MINOR_VER, 0x02))
        return 0;
    if (!test_mailbox_rw(MB_PCH_PFM_RECOVERY_SVN, 0x12))
        return 0;
    if (!test_mailbox_rw(MB_PCH_PFM_RECOVERY_MAJOR_VER, 0x03))
        return 0;
    if (!test_mailbox_rw(MB_PCH_PFM_RECOVERY_MINOR_VER, 0x01))
        return 0;
    if (!test_mailbox_rw(MB_BMC_PFM_RECOVERY_MAJOR_VER, 0x03))
        return 0;
    if (!test_mailbox_rw(MB_BMC_PFM_RECOVERY_MINOR_VER, 0x03))
        return 0;
    if (!test_mailbox_rw(MB_CPLD_HASH, 0xBD))
        return 0;

    return 1;
}
