// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"

#include "gen_gpo_controls.h"
#include "mailbox_utils.h"
#include "rfnvram_utils.h"
#include "ufm_rw_utils.h"
#include "ufm_utils.h"
#include "test_main.h"

/**
 * @brief This function test write and readback PIT password from RFNVRAM.
 *
 * @return 1 if successful; 0, otherwise
 */
static PFR_ALT_INLINE alt_u32 PFR_ALT_ALWAYS_INLINE test_basic_rw()
{
    alt_u32* ufm_pit_password = get_ufm_pfr_data()->pit_password;
    alt_u8 example_pit_password[RFNVRAM_PIT_PASSWORD_LENGTH] = {0x71, 0xb9, 0xef, 0xa8, 0x11, 0x54, 0x80, 0x33};
    alt_u8 read_pit_password[RFNVRAM_PIT_PASSWORD_LENGTH] = {};

    // Commit write data to UFM
    ufm_enable_write();
    alt_u32_memcpy(ufm_pit_password, (alt_u32*) example_pit_password, RFNVRAM_PIT_PASSWORD_LENGTH);

    // Write PIT password from UFM to RFNVRAM
    write_ufm_pit_password_to_rfnvram();

    read_pit_password_from_rfnvram(read_pit_password);

    // Check results
    for (alt_u32 byte_i = 0; byte_i < RFNVRAM_PIT_PASSWORD_LENGTH; byte_i++)
    {
        if (example_pit_password[byte_i] != read_pit_password[byte_i])
            return 0;
    }

    return 1;
}

// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    return test_basic_rw();
}