// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"
#include "mailbox_utils.h"
#include "ufm_utils.h"
#include "ufm_rw_utils.h"
#include "test_main.h"


// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    alt_u32 data = 0xdeadbeef;
    alt_u32 data2 = 0x89abcdef;
    // while ( (IORD(UFM_CSR_STATUS_REG, 0) & 3) != 0) {};

	// Write enable the UFM
    ufm_enable_write();

    // Get pointer to the start of UFM memory space and increment it with the input address
    alt_u32* ufm_ptr = get_ufm_ptr_with_offset(0x0);

    // Write data to UFM
    ufm_ptr[0] = data;
    ufm_ptr[1] = data2;

	// read from UFM
    if (!(IORD(ufm_ptr, 0) == (alt_u32)(0xdeadbeef)))
    {
        return 0;
	}

    return IORD(ufm_ptr+1, 0) == (alt_u32)(0x89abcdef);
}
