// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"
#include "spi_ctrl_utils.h"
#include "spi_rw_utils.h"
#include "test_main.h"

/**
 * @brief This function test copy flash content from one to another.
 *
 * @return 1 if successful; 0, otherwise
 */
static PFR_ALT_INLINE alt_u32 PFR_ALT_ALWAYS_INLINE test_copy_between_flash()
{
	configure_spi_master_csr();

	// Configure GPIO to enable CPLD access to flash
    takeover_spi_ctrl(SPI_FLASH_BMC);
    poll_status_reg_done();
    takeover_spi_ctrl(SPI_FLASH_PCH);

    alt_u32 write_word1 = 0xDEADBEEF;
    alt_u32 write_word2 = 0x12345678;
    alt_u32 write_word3 = 0xFEDCBA98;
    alt_u32 write_word4 = 0x89ABCDEF;

    alt_u32 test_offset = 0x1B000;
    alt_u32* spi_pch_flash_ptr = get_spi_flash_ptr_with_offset(test_offset);

	// Write to Flash
    spi_pch_flash_ptr[0] = write_word1;
    spi_pch_flash_ptr[1] = write_word2;
    spi_pch_flash_ptr[2] = write_word3;
    spi_pch_flash_ptr[3] = write_word4;

	// Copy the CPLD update capsule over to the PCH flash
    copy_between_flashes(test_offset, test_offset, SPI_FLASH_BMC, SPI_FLASH_PCH, 16);

    // switch to BMC
    switch_spi_flash(SPI_FLASH_BMC);
    alt_u32* spi_bmc_flash_ptr = get_spi_flash_ptr_with_offset(test_offset);
	
	// Check the BMC Flash content is correctly updated
    if (spi_bmc_flash_ptr[0] != (alt_u32)(0xDEADBEEF))
    {
       return 0;
    }

	if (spi_bmc_flash_ptr[1] != (alt_u32)(0x12345678))
    {
       return 0;
    }

	if (spi_bmc_flash_ptr[2] != (alt_u32)(0xFEDCBA98))
    {
        return 0;
    }

    return spi_bmc_flash_ptr[3] == (alt_u32)(0x89ABCDEF);
}

// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    return test_copy_between_flash();
}