// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"

#include "gen_gpo_controls.h"
#include "crypto.h"

#include "test_main.h"
/*
 * Test Data block :
 1024'h863A608FDC3B3965A80A8227439BA56CA04B0E7ECE832B29A58880CF8D08275AEFB121D3B7EC96C3CE5C1B63D198D3397206D7A08185148DE4468D113EC8D938F2EB8EB6056F99CA325012E3BCC5AF27082BECD8B63DAF37412F941BAC089930E4C0D901DFC6B3DA87029FDA4D3B258DCCB80B962E0350ECBD517F28DAB6DD09
 * Digest : 256'hFB62DED71EE9009AD54A9885DE6EE6CB5C7D261DB13320DC919FAA1DCEAD89AF
 * Generating curve
 * Using curve prime256v1
 * Private Key:
     256'hC51E4753AFDEC1E6B6C6A5B992F43F8DD0C7A8933072708B6522468B2FFB06FD
 * Pubkey:
 *   CX : 256'h942C9F408EAD9D82D34A1B9A6A827EBE3E2DDF782B448D23BE1B6143988CCEF4
 *   CY : 256'h8C9EAF6C0D14D992FC63BAD3E2496BE2EEE61CB5B97F65F428CA94A5D0EE19A1
 * Hash:
 *   E :  256'hFB62DED71EE9009AD54A9885DE6EE6CB5C7D261DB13320DC919FAA1DCEAD89AF
 * Signature:
 *   R :  256'h6BD9606BFF8142C667531604E15AA03911474514DFDFDF84EBEB2DA857C83377
 *   S :  256'h4FD46C71183C2BB7CA47030CEE81E2EEC9E317B912243325F273855A66C76D5E
 *
 * Generate for C:
 * % echo "4FD46C71183C2BB7CA47030CEE81E2EEC9E317B912243325F273855A66C76D5E" | xxd -r -p | xxd -i
 */
const alt_u32 test_data_size = 128;
const alt_u32 test_hash_size = 32;

const alt_u8 test_data[128] = {
    0x86, 0x3a, 0x60, 0x8f, 0xdc, 0x3b, 0x39, 0x65, 0xa8, 0x0a, 0x82, 0x27, 0x43, 0x9b, 0xa5, 0x6c,
    0xa0, 0x4b, 0x0e, 0x7e, 0xce, 0x83, 0x2b, 0x29, 0xa5, 0x88, 0x80, 0xcf, 0x8d, 0x08, 0x27, 0x5a,
    0xef, 0xb1, 0x21, 0xd3, 0xb7, 0xec, 0x96, 0xc3, 0xce, 0x5c, 0x1b, 0x63, 0xd1, 0x98, 0xd3, 0x39,
    0x72, 0x06, 0xd7, 0xa0, 0x81, 0x85, 0x14, 0x8d, 0xe4, 0x46, 0x8d, 0x11, 0x3e, 0xc8, 0xd9, 0x38,
    0xf2, 0xeb, 0x8e, 0xb6, 0x05, 0x6f, 0x99, 0xca, 0x32, 0x50, 0x12, 0xe3, 0xbc, 0xc5, 0xaf, 0x27,
    0x08, 0x2b, 0xec, 0xd8, 0xb6, 0x3d, 0xaf, 0x37, 0x41, 0x2f, 0x94, 0x1b, 0xac, 0x08, 0x99, 0x30,
    0xe4, 0xc0, 0xd9, 0x01, 0xdf, 0xc6, 0xb3, 0xda, 0x87, 0x02, 0x9f, 0xda, 0x4d, 0x3b, 0x25, 0x8d,
    0xcc, 0xb8, 0x0b, 0x96, 0x2e, 0x03, 0x50, 0xec, 0xbd, 0x51, 0x7f, 0x28, 0xda, 0xb6, 0xdd, 0x09};

const alt_u8 test_data_expected_hash[PFR_CRYPTO_LENGTH] = {
    0xfb, 0x62, 0xde, 0xd7, 0x1e, 0xe9, 0x00, 0x9a, 0xd5, 0x4a, 0x98, 0x85, 0xde, 0x6e, 0xe6, 0xcb,
    0x5c, 0x7d, 0x26, 0x1d, 0xb1, 0x33, 0x20, 0xdc, 0x91, 0x9f, 0xaa, 0x1d, 0xce, 0xad, 0x89, 0xaf};

const alt_u8 test_pubkey_cx[PFR_CRYPTO_LENGTH] = {
    0x94, 0x2c, 0x9f, 0x40, 0x8e, 0xad, 0x9d, 0x82, 0xd3, 0x4a, 0x1b, 0x9a, 0x6a, 0x82, 0x7e, 0xbe,
    0x3e, 0x2d, 0xdf, 0x78, 0x2b, 0x44, 0x8d, 0x23, 0xbe, 0x1b, 0x61, 0x43, 0x98, 0x8c, 0xce, 0xf4};

const alt_u8 test_pubkey_cy[PFR_CRYPTO_LENGTH] = {
    0x8c, 0x9e, 0xaf, 0x6c, 0x0d, 0x14, 0xd9, 0x92, 0xfc, 0x63, 0xba, 0xd3, 0xe2, 0x49, 0x6b, 0xe2,
    0xee, 0xe6, 0x1c, 0xb5, 0xb9, 0x7f, 0x65, 0xf4, 0x28, 0xca, 0x94, 0xa5, 0xd0, 0xee, 0x19, 0xa1};

const alt_u8 test_sig_r[PFR_CRYPTO_LENGTH] = {
    0x6b, 0xd9, 0x60, 0x6b, 0xff, 0x81, 0x42, 0xc6, 0x67, 0x53, 0x16, 0x04, 0xe1, 0x5a, 0xa0, 0x39,
    0x11, 0x47, 0x45, 0x14, 0xdf, 0xdf, 0xdf, 0x84, 0xeb, 0xeb, 0x2d, 0xa8, 0x57, 0xc8, 0x33, 0x77};

const alt_u8 test_sig_s[PFR_CRYPTO_LENGTH] = {
    0x4f, 0xd4, 0x6c, 0x71, 0x18, 0x3c, 0x2b, 0xb7, 0xca, 0x47, 0x03, 0x0c, 0xee, 0x81, 0xe2, 0xee,
    0xc9, 0xe3, 0x17, 0xb9, 0x12, 0x24, 0x33, 0x25, 0xf2, 0x73, 0x85, 0x5a, 0x66, 0xc7, 0x6d, 0x5e};

// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    return verify_ecdsa_and_sha((alt_u32*) test_pubkey_cx,
            (alt_u32*) test_pubkey_cy,
            (alt_u32*) test_sig_r,
            (alt_u32*) test_sig_s,
            (alt_u32*) test_data,
            test_data_size);
}
