// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"

#include "gen_gpo_controls.h"
#include "mailbox_utils.h"

#include "test_main.h"

/**
 * @brief This function test read and write on Host Mailbox FIFO.
 *
 * @return 1 if successful; 0, otherwise
 */
static PFR_ALT_INLINE alt_u32 PFR_ALT_ALWAYS_INLINE test_mailbox_fifo()
{
    alt_u32 write_val = 0x3D;
    write_to_mailbox(MB_UFM_WRITE_FIFO, write_val);
    alt_u32 read_val = read_from_mailbox(MB_UFM_READ_FIFO);
    return read_val == write_val;
}

static PFR_ALT_INLINE alt_u32 PFR_ALT_ALWAYS_INLINE test_mailbox_fifo_flushing()
{
    alt_u32 write_val = 0xAB;
    write_to_mailbox(MB_UFM_WRITE_FIFO, write_val);

    // Flush write FIFO
    set_bit(U_MAILBOX_AVMM_BRIDGE_ADDR + MB_UFM_CMD_TRIGGER, 1);

    // Ensure the write FIFO is flushed
    alt_u32 read_val = read_from_mailbox(MB_UFM_READ_FIFO);
    if (read_val != 0)
        return 0;

    write_to_mailbox(MB_UFM_WRITE_FIFO, write_val);

    // Flush read FIFO
    set_bit(U_MAILBOX_AVMM_BRIDGE_ADDR + MB_UFM_CMD_TRIGGER, 2);

    // Ensure the read FIFO is flushed
    read_val = read_from_mailbox(MB_UFM_READ_FIFO);
    if (read_val != 0)
        return 0;

    write_to_mailbox(MB_UFM_WRITE_FIFO, write_val);
    read_val = read_from_mailbox(MB_UFM_READ_FIFO);

    return read_val == write_val;
}

// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    if (!test_mailbox_fifo())
        return 0;
    if (!test_mailbox_fifo_flushing())
        return 0;

    return 1;
}
