// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"
// Include the PFR headers
#include "authentication.h"
#include "capsule_validation.h"
#include "cpld_update.h"
#include "cpld_reconfig.h"
#include "cpld_recovery.h"
#include "crypto.h"
#include "decompression.h"
#include "firmware_recovery.h"
#include "firmware_update.h"
#include "flash_validation.h"
#include "gen_gpi_signals.h"
#include "gen_gpo_controls.h"
#include "gen_smbus_relay_config.h"
#include "global_state.h"
#include "keychain.h"
#include "keychain_utils.h"
#include "mailbox_enums.h"
#include "mailbox_utils.h"
#include "platform_log.h"

#include "t0_update.h"
#include "test_main.h"

static PFR_ALT_INLINE alt_u32 PFR_ALT_ALWAYS_INLINE test_pch_update_max_failed_attempt()
{
    if (num_failed_bmc_update_attempts != 0)
    {
        return 0;
    }
    if (num_failed_pch_update_attempts != 0)
    {
        return 0;
    }
    if (num_failed_cpld_update_attempts != 0)
    {
        return 0;
    }

    // run firmware update twice
    write_to_mailbox(MB_PCH_UPDATE_INTENT, MB_UPDATE_INTENT_PCH_ACTIVE_MASK);
    act_on_update_intent(SPI_FLASH_PCH, MB_PCH_UPDATE_INTENT);
    write_to_mailbox(MB_PCH_UPDATE_INTENT, MB_UPDATE_INTENT_PCH_ACTIVE_MASK);
    act_on_update_intent(SPI_FLASH_PCH, MB_PCH_UPDATE_INTENT);

    // first two update is not blocked
    if (block_fw_update_attempt(SPI_FLASH_PCH))
    {
        return 0;
    }

    // run third firmware update
    write_to_mailbox(MB_PCH_UPDATE_INTENT, MB_UPDATE_INTENT_PCH_ACTIVE_MASK);
    act_on_update_intent(SPI_FLASH_PCH, MB_PCH_UPDATE_INTENT);

    // should block the third update
    if (!block_fw_update_attempt(SPI_FLASH_PCH))
    {
        return 0;
    }

    // run failed max attempt handling related codes
    write_to_mailbox(MB_PCH_UPDATE_INTENT, MB_UPDATE_INTENT_PCH_ACTIVE_MASK);
    mb_update_intent_handler_for(SPI_FLASH_PCH);

    // check error message logging
    if (read_from_mailbox(MB_MAJOR_ERROR_CODE) != (alt_u32) MAJOR_ERROR_UPDATE_FROM_PCH_FAILED)
    {
        return 0;
    }

    if (read_from_mailbox(MB_MINOR_ERROR_CODE) !=
        (alt_u32) MINOR_ERROR_FW_UPDATE_EXCEEDED_MAX_FAILED_ATTEMPTS)
    {
        return 0;
    }

    return 1;
}

// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    return test_pch_update_max_failed_attempt();
}